/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.event;

import apollo.dataadapter.Region;
import apollo.datamodel.SeqFeatureI;
import java.util.EventObject;

public class BaseFocusEvent
extends EventObject {
    private int focusPosition;
    private SeqFeatureI feature;
    private boolean isPosition = true;
    private int rangeStart;
    private int rangeEnd;

    public BaseFocusEvent(Object source, int focus, SeqFeatureI feature) {
        super(source);
        this.focusPosition = focus;
        this.feature = feature;
        this.isPosition = true;
    }

    public BaseFocusEvent(Object source, Region region) {
        super(source);
        this.rangeStart = region.getStart();
        this.rangeEnd = region.getEnd();
        this.isPosition = false;
    }

    public int getFocus() {
        return this.focusPosition;
    }

    public SeqFeatureI getFeature() {
        return this.feature;
    }

    public boolean isPosition() {
        return this.isPosition;
    }

    public int getRangeStart() {
        return this.rangeStart;
    }

    public int getRangeEnd() {
        return this.rangeEnd;
    }

    public int[] getRangeLimits() {
        return new int[]{this.rangeStart, this.rangeEnd};
    }
}

