/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.detailviewers.seqexport;

import apollo.config.Config;
import apollo.dataadapter.DataLoadEvent;
import apollo.dataadapter.DataLoadListener;
import apollo.datamodel.FeaturePairI;
import apollo.datamodel.RangeI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceI;
import apollo.datamodel.Transcript;
import apollo.datamodel.TranslationI;
import apollo.editor.AnnotationChangeEvent;
import apollo.editor.AnnotationChangeListener;
import apollo.gui.ControlledObjectI;
import apollo.gui.Controller;
import apollo.gui.Selection;
import apollo.gui.event.FeatureSelectionEvent;
import apollo.gui.event.FeatureSelectionListener;
import apollo.seq.io.FastaFile;
import apollo.util.FeatureList;
import apollo.util.NumericKeyFilter;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class SeqExport
extends JFrame
implements DataLoadListener {
    private static int panelWidth = 440;
    private static final Dimension windowSize = new Dimension(panelWidth, 580);
    private static final Font seqFont = new Font("Courier", 0, 12);
    private FeatureList features;
    private JScrollPane seqScrollPane;
    private JTextArea seqTextArea;
    private JRadioButton currentlySelectedButton;
    private JRadioButton resultSequenceButton;
    private JRadioButton cdsButton;
    private JRadioButton aminoAcidsButton;
    private JRadioButton cdnaButton;
    private JRadioButton genomicButton;
    private JRadioButton genomicPlusMinusButton;
    private JTextField genomicPlusMinusField;
    private static final int defaultGenomicPlusMinus = 500;
    private int genomicPlusMinus = 500;
    protected static Color bgColor = new Color(255, 255, 204);
    private JCheckBox followSelectionCheckBox;
    private Selection selection;
    private Controller controller;
    private int offset = 0;

    public SeqExport(Selection selection, Controller controller) {
        this(selection, controller, 0);
    }

    public SeqExport(Selection selection, Controller controller, int offset) {
        this.selection = selection;
        this.controller = controller;
        this.offset = offset;
        FeatureList consolidatedFeatures = selection.getConsolidatedFeatures();
        this.init(consolidatedFeatures, controller);
    }

    public SeqExport(SeqFeatureI feat, Controller controller) {
        FeatureList f = new FeatureList(1);
        f.addFeature(feat);
        this.init(f, controller);
    }

    private void init(FeatureList features, Controller controller) {
        this.initGui();
        this.setLocation(this.offset, 0);
        this.processFeatures(features);
        new SeqExportFeatureListener(controller);
        this.setVisible(true);
    }

    private void processFeatures(FeatureList all_features) {
        this.resultSequenceButton.setEnabled(false);
        this.cdsButton.setEnabled(false);
        this.aminoAcidsButton.setEnabled(false);
        this.cdnaButton.setEnabled(false);
        this.features = new FeatureList();
        for (int i = 0; i < all_features.size(); ++i) {
            SeqFeatureI feat = all_features.getFeature(i);
            if (feat.isAnnotTop() && feat.hasKids()) {
                Vector transcripts = feat.getFeatures();
                this.features.addAll(transcripts);
            } else if (feat.getResidues().length() > 0) {
                this.features.addFeature(feat);
            }
            if (!this.cdsButton.isEnabled() && feat.isProteinCodingGene()) {
                this.cdsButton.setEnabled(true);
                this.aminoAcidsButton.setEnabled(true);
            }
            if (!this.cdsButton.isEnabled()) {
                TranslationI translation = null;
                if (feat.hasKids() && feat.hasTranslation()) {
                    translation = feat.getTranslation();
                } else if (feat.getParent() != null && feat.getParent().hasTranslation()) {
                    translation = feat.getParent().getTranslation();
                }
                if (translation != null && translation.hasTranslationStart() && translation.hasTranslationEnd()) {
                    this.cdsButton.setEnabled(true);
                    this.aminoAcidsButton.setEnabled(true);
                }
            }
            if (!this.cdnaButton.isEnabled() && !this.isOneLevelAnnot(feat)) {
                this.cdnaButton.setEnabled(true);
            }
            if (this.resultSequenceButton.isEnabled() || !this.hasResultSequence(feat)) continue;
            this.resultSequenceButton.setEnabled(true);
        }
        this.currentlySelectedButton.setSelected(true);
        if (this.isSelectedAndDisabled(this.cdsButton) || this.isSelectedAndDisabled(this.aminoAcidsButton)) {
            this.currentlySelectedButton = this.resultSequenceButton;
            this.currentlySelectedButton.setSelected(true);
        }
        if (this.isSelectedAndDisabled(this.resultSequenceButton)) {
            this.currentlySelectedButton = this.genomicButton;
        }
        this.displaySequences();
    }

    private boolean isOneLevelAnnot(SeqFeatureI feat) {
        return feat.isAnnot() && feat.isAnnotTop() && !feat.hasKids();
    }

    private boolean isSelectedAndDisabled(JRadioButton but) {
        return but.isSelected() && !but.isEnabled();
    }

    public String getTitle() {
        if (this.features.size() == 1) {
            SeqFeatureI feature = this.features.getFeature(0);
            return Config.getDisplayPrefs().getHeader(feature);
        }
        return this.features.size() + " sequences";
    }

    private void initGui() {
        this.getContentPane().setBackground(bgColor);
        this.seqTextArea = new JTextArea();
        this.seqTextArea.setFont(seqFont);
        this.seqScrollPane = new JScrollPane(this.seqTextArea);
        this.seqScrollPane.setMinimumSize(new Dimension(panelWidth, 300));
        this.seqScrollPane.setPreferredSize(new Dimension(panelWidth, 300));
        this.aminoAcidsButton = new JRadioButton("Peptide sequence");
        this.aminoAcidsButton.setBackground(bgColor);
        this.aminoAcidsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SeqExport.this.displayAASequence();
                SeqExport.this.currentlySelectedButton = SeqExport.this.aminoAcidsButton;
            }
        });
        this.aminoAcidsButton.setSelected(true);
        this.currentlySelectedButton = this.aminoAcidsButton;
        this.cdnaButton = new JRadioButton("cDNA sequence");
        this.cdnaButton.setBackground(bgColor);
        this.cdnaButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SeqExport.this.displayCDNASequence();
                SeqExport.this.currentlySelectedButton = SeqExport.this.cdnaButton;
            }
        });
        this.cdsButton = new JRadioButton("CDS sequence");
        this.cdsButton.setBackground(bgColor);
        this.cdsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SeqExport.this.displayCodingSequence();
                SeqExport.this.currentlySelectedButton = SeqExport.this.cdsButton;
            }
        });
        this.genomicButton = new JRadioButton("Corresponding genomic sequence");
        this.genomicButton.setBackground(bgColor);
        this.genomicButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SeqExport.this.displayGenomicSequence();
                SeqExport.this.currentlySelectedButton = SeqExport.this.genomicButton;
            }
        });
        this.genomicPlusMinusButton = new JRadioButton("Corresponding genomic sequence +/-");
        this.genomicPlusMinusButton.setBackground(bgColor);
        GenomicPlusMinusListener plusMinusListener = new GenomicPlusMinusListener();
        this.genomicPlusMinusButton.addActionListener(plusMinusListener);
        this.resultSequenceButton = new JRadioButton("Result sequence");
        this.resultSequenceButton.setBackground(bgColor);
        this.resultSequenceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SeqExport.this.displayResultSequence();
                SeqExport.this.currentlySelectedButton = SeqExport.this.resultSequenceButton;
            }
        });
        ButtonGroup radioButtonGroup = new ButtonGroup();
        radioButtonGroup.add(this.aminoAcidsButton);
        radioButtonGroup.add(this.cdnaButton);
        radioButtonGroup.add(this.cdsButton);
        radioButtonGroup.add(this.genomicButton);
        radioButtonGroup.add(this.genomicPlusMinusButton);
        radioButtonGroup.add(this.resultSequenceButton);
        this.genomicPlusMinusField = new JTextField(Integer.toString(this.genomicPlusMinus), 12);
        Dimension fieldDim = new Dimension(90, 20);
        this.genomicPlusMinusField.setMinimumSize(fieldDim);
        this.genomicPlusMinusField.setMaximumSize(fieldDim);
        this.genomicPlusMinusField.addKeyListener(NumericKeyFilter.getFilter());
        this.genomicPlusMinusField.addActionListener(plusMinusListener);
        JLabel bases = new JLabel("bases");
        Box genomicPlusMinusBox = new Box(0);
        genomicPlusMinusBox.add(this.genomicPlusMinusButton);
        genomicPlusMinusBox.add(this.genomicPlusMinusField);
        genomicPlusMinusBox.add(bases);
        Box seqButtonsBox = new Box(1);
        seqButtonsBox.add(this.aminoAcidsButton);
        this.aminoAcidsButton.setAlignmentX(0.0f);
        seqButtonsBox.add(this.cdnaButton);
        this.cdnaButton.setAlignmentX(0.0f);
        seqButtonsBox.add(this.cdsButton);
        this.cdsButton.setAlignmentX(0.0f);
        this.genomicButton.setAlignmentX(0.0f);
        seqButtonsBox.add(this.genomicButton);
        genomicPlusMinusBox.setAlignmentX(0.0f);
        seqButtonsBox.add(genomicPlusMinusBox);
        seqButtonsBox.add(this.resultSequenceButton);
        this.resultSequenceButton.setAlignmentX(0.0f);
        Box seqButtonsHorizontalBox = new Box(0);
        seqButtonsHorizontalBox.add(Box.createHorizontalGlue());
        seqButtonsHorizontalBox.add(seqButtonsBox);
        seqButtonsHorizontalBox.add(Box.createHorizontalStrut(150));
        JButton save = new JButton("Save as...");
        save.setBackground(Color.white);
        save.addActionListener(new SaveListener());
        JButton close = new JButton("Close");
        close.setBackground(Color.white);
        close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SeqExport.this.dispose();
            }
        });
        JButton newSeqWindow = new JButton("New sequence window...");
        newSeqWindow.setBackground(Color.white);
        newSeqWindow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new SeqExport(SeqExport.this.selection, SeqExport.this.controller, SeqExport.this.offset + 20);
            }
        });
        Box saveCloseBox = new Box(0);
        saveCloseBox.add(Box.createHorizontalGlue());
        saveCloseBox.add(save);
        saveCloseBox.add(Box.createHorizontalStrut(10));
        saveCloseBox.add(close);
        saveCloseBox.add(Box.createHorizontalStrut(10));
        saveCloseBox.add(newSeqWindow);
        saveCloseBox.add(Box.createHorizontalGlue());
        this.followSelectionCheckBox = new JCheckBox("Follow external selection", false);
        this.followSelectionCheckBox.setBackground(bgColor);
        Box followHorizontalBox = new Box(0);
        followHorizontalBox.add(Box.createHorizontalGlue());
        followHorizontalBox.add(this.followSelectionCheckBox);
        followHorizontalBox.add(Box.createHorizontalStrut(206));
        Container content = this.getContentPane();
        content.setLayout(new BoxLayout(content, 1));
        content.add(this.seqScrollPane);
        content.add(Box.createVerticalStrut(10));
        content.add(seqButtonsHorizontalBox);
        content.add(Box.createVerticalStrut(10));
        content.add(saveCloseBox);
        content.add(Box.createVerticalStrut(15));
        content.add(followHorizontalBox);
        content.add(Box.createVerticalStrut(10));
        this.setSize(windowSize);
    }

    private void displaySequences() {
        this.currentlySelectedButton.doClick();
        this.setTitle(this.getTitle());
    }

    private void displayGenomicSequence() {
        String fastas = "";
        int feat_count = this.features.size();
        for (int i = 0; i < feat_count; ++i) {
            SeqFeatureI feat = this.features.getFeature(i);
            fastas = fastas + this.featureFastaString(feat.getResidues(), feat, "genomic");
        }
        this.seqTextArea.setText(fastas);
        this.seqTextArea.setCaretPosition(0);
    }

    private void displayGenomicPlusMinus() {
        String fastas = "";
        int feat_count = this.features.size();
        for (int i = 0; i < feat_count; ++i) {
            SeqFeatureI feat = this.features.getFeature(i);
            SequenceI refSeq = feat.getRefSequence();
            if (feat == null || refSeq == null) continue;
            int minus = this.genomicPlusMinus * feat.getStrand();
            int plus = this.genomicPlusMinus * feat.getStrand();
            String seq = refSeq.getResidues(feat.getStart() - minus, feat.getEnd() + plus);
            fastas = fastas + this.featureFastaString(seq, feat, "genomic +/-" + this.genomicPlusMinus + " bases");
        }
        this.seqTextArea.setText(fastas);
        this.seqTextArea.setCaretPosition(0);
    }

    private void displayAASequence() {
        String fastas = "";
        int feat_count = this.features.size();
        for (int i = 0; i < feat_count; ++i) {
            SeqFeatureI feat = this.features.getFeature(i);
            String peptideSeq = feat.isTranscript() ? ((Transcript)feat).getPeptideSequence().getResidues() : feat.translate();
            fastas = fastas + this.featureFastaString(peptideSeq, feat, "amino acid");
        }
        this.seqTextArea.setText(fastas);
        this.seqTextArea.setCaretPosition(0);
    }

    private void displayCDNASequence() {
        String fastas = "";
        int feat_count = this.features.size();
        for (int i = 0; i < feat_count; ++i) {
            SeqFeatureI feat = this.features.getFeature(i);
            fastas = fastas + this.featureFastaString(feat.get_cDNA(), feat, "cDNA");
        }
        this.seqTextArea.setText(fastas);
        this.seqTextArea.setCaretPosition(0);
    }

    private void displayCodingSequence() {
        String fastas = "";
        int feat_count = this.features.size();
        for (int i = 0; i < feat_count; ++i) {
            SeqFeatureI feat = this.features.getFeature(i);
            fastas = fastas + this.featureFastaString(feat.getCodingDNA(), feat, "coding");
        }
        this.seqTextArea.setText(fastas);
        this.seqTextArea.setCaretPosition(0);
    }

    private void displayResultSequence() {
        String fastas = "";
        int feat_count = this.features.size();
        for (int i = 0; i < feat_count; ++i) {
            SeqFeatureI feat = this.features.getFeature(i);
            String seq = this.getResultSequence(feat);
            if (seq == null) continue;
            fastas = fastas + this.featureFastaString(seq, feat, "result");
        }
        this.seqTextArea.setText(fastas);
        this.seqTextArea.setCaretPosition(0);
    }

    private boolean hasResultSequence(SeqFeatureI feat) {
        if (feat instanceof FeaturePairI) {
            FeaturePairI fpair = (FeaturePairI)feat;
            String seq = fpair.getHitFeature().getFeatureSequence().getResidues();
            if (seq != null && !seq.equals("")) {
                return true;
            }
        } else if (feat.canHaveChildren()) {
            Vector kids = feat.getFeatures();
            for (int i = 0; i < kids.size(); ++i) {
                if (!this.hasResultSequence((SeqFeatureI)kids.elementAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    private String getResultSequence(SeqFeatureI feat) {
        String seq = "";
        if (feat instanceof FeaturePairI) {
            FeaturePairI fpair = (FeaturePairI)feat;
            return fpair.getHitFeature().getFeatureSequence().getResidues();
        }
        if (feat.canHaveChildren()) {
            Vector kids = feat.getFeatures();
            for (int i = 0; i < kids.size(); ++i) {
                String s = this.getResultSequence((SeqFeatureI)kids.elementAt(i));
                if (s == null) continue;
                seq = seq + s;
            }
        }
        if (seq.equals("")) {
            return null;
        }
        return seq;
    }

    private String featureFastaString(String seq, RangeI feat, String type) {
        String header = ">" + Config.getDisplayPrefs().getHeader(feat) + " (" + type + " sequence): " + seq.length() + " residues";
        header = header + "\n";
        return FastaFile.format(header, seq, 50);
    }

    public boolean handleDataLoadEvent(DataLoadEvent e) {
        this.hide();
        this.dispose();
        this.controller.removeListener(this);
        return true;
    }

    private class SeqExportFeatureListener
    implements FeatureSelectionListener,
    AnnotationChangeListener,
    ControlledObjectI {
        private Controller controller;

        private SeqExportFeatureListener(Controller controller) {
            this.setController(controller);
            controller.addListener(this);
        }

        public void setController(Controller controller) {
            this.controller = controller;
        }

        public Controller getController() {
            return this.controller;
        }

        public Object getControllerWindow() {
            return SeqExport.this;
        }

        public boolean needsAutoRemoval() {
            return true;
        }

        public boolean handleFeatureSelectionEvent(FeatureSelectionEvent e) {
            if (!SeqExport.this.followSelectionCheckBox.isSelected() && !e.forceSelection()) {
                return false;
            }
            FeatureList consolidatedFeatures = e.getSelection().getConsolidatedFeatures();
            SeqExport.this.processFeatures(consolidatedFeatures);
            return true;
        }

        public boolean handleAnnotationChangeEvent(AnnotationChangeEvent evt) {
            if (evt.isEndOfEditSession()) {
                SeqExport.this.processFeatures(SeqExport.this.features);
            } else if (evt.isDelete()) {
                SeqFeatureI gone = evt.getChangedFeature();
                boolean handled = false;
                for (int i = SeqExport.this.features.size() - 1; i >= 0 && !handled; --i) {
                    handled = SeqExport.this.features.remove(gone);
                }
            }
            return true;
        }
    }

    private class SaveListener
    implements ActionListener {
        private SaveListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            int returnVal = chooser.showSaveDialog(null);
            if (returnVal == 0) {
                File file = chooser.getSelectedFile();
                if (file == null) {
                    JOptionPane.showMessageDialog(null, "No file selected");
                    return;
                }
                try {
                    BufferedWriter writer = new BufferedWriter(new FileWriter(file));
                    writer.write(SeqExport.this.seqTextArea.getText());
                    writer.close();
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(null, "Couldn't write file to " + file);
                }
            }
        }
    }

    private class GenomicPlusMinusListener
    implements ActionListener {
        private GenomicPlusMinusListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String txt = SeqExport.this.genomicPlusMinusField.getText();
            try {
                SeqExport.this.genomicPlusMinus = Integer.parseInt(txt);
            }
            catch (NumberFormatException nfe) {
                SeqExport.this.genomicPlusMinus = 500;
                SeqExport.this.genomicPlusMinusField.setText(Integer.toString(500));
                String msg = "Could not convert " + txt + "\nto an integer, using " + 500 + " instead";
                JOptionPane.showMessageDialog(SeqExport.this, msg, "Error", 0);
            }
            if (SeqExport.this.currentlySelectedButton != SeqExport.this.genomicPlusMinusButton) {
                SeqExport.this.currentlySelectedButton = SeqExport.this.genomicPlusMinusButton;
                SeqExport.this.genomicPlusMinusButton.setSelected(true);
            }
            SeqExport.this.displayGenomicPlusMinus();
        }
    }
}

