/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.detailviewers.exonviewer;

import apollo.config.Config;
import apollo.datamodel.ExonI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceEdit;
import apollo.datamodel.Transcript;
import apollo.gui.detailviewers.exonviewer.BaseEditorPanel;
import apollo.gui.drawable.DrawableUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;
import org.bdgp.util.RangeHash;

class TranslationViewer
extends JComponent {
    Color[][] colorList;
    Transcript transcript;
    int tier;
    BaseEditorPanel editorPanel;
    int margin = 20;
    int barHeight = 20;
    RangeHash rh = new RangeHash();
    int translationStart = -1;
    int translationEnd = -1;
    boolean drawIntrons = true;
    Color shiftColor = Config.getStyle().getSeqErrorColor();

    public TranslationViewer(BaseEditorPanel editorPanel) {
        this.editorPanel = editorPanel;
        this.colorList = editorPanel.getColorArray();
        this.setPreferredSize(new Dimension(300, this.barHeight + this.margin * 2));
        this.setForeground(Color.white);
        NavClickListener listener = new NavClickListener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    public void setDrawIntrons(boolean drawIntrons) {
        this.drawIntrons = drawIntrons;
        this.repaint();
    }

    public boolean getDrawIntrons() {
        return this.drawIntrons;
    }

    void setTranscript(Transcript transcript, int tier) {
        this.transcript = transcript;
        this.tier = tier;
    }

    public void paint(Graphics g) {
        int featureWidth;
        super.paint(g);
        g.setFont(this.getFont());
        if (this.transcript == null) {
            return;
        }
        this.rh.removeAll();
        this.translationStart = this.transcript.getTranslationStart();
        int laststart_base = this.transcript.getPositionFrom(this.translationStart, 2);
        this.translationEnd = this.transcript.getTranslationEnd();
        int laststop_base = this.transcript.getLastBaseOfStopCodon();
        int readthrough_pos = this.transcript.readThroughStopPosition();
        int lastreadon_base = this.transcript.getPositionFrom(readthrough_pos, 2);
        int topDistance = (this.getSize().height - this.barHeight) / 2;
        Vector exons = this.transcript.getExons();
        int exon_count = exons.size();
        if (this.drawIntrons) {
            featureWidth = this.transcript.length();
            int lowPos = this.editorPanel.basePairToPos(this.transcript.getLow());
            int highPos = this.editorPanel.basePairToPos(this.transcript.getHigh());
            int lineColorIndex = this.editorPanel.getRangeIndex(this.tier, lowPos, highPos) % this.colorList.length;
            g.setColor(this.colorList[lineColorIndex][0]);
            g.fillRect(this.margin, (this.getSize().height - 2) / 2, this.getSize().width - this.margin * 2 - 1, 3);
        } else {
            featureWidth = 0;
            for (int i = 0; i < exon_count; ++i) {
                SeqFeatureI feature = (SeqFeatureI)exons.elementAt(i);
                featureWidth += feature.length();
            }
        }
        double scaling_factor = (double)featureWidth / (double)(this.getSize().width - this.margin * 2);
        int x = this.margin;
        for (int i = 0; i < exon_count; ++i) {
            ExonI exon = this.transcript.getExonAt(i);
            int low = exon.getLow();
            int high = exon.getHigh();
            int lowPos = this.editorPanel.basePairToPos(low);
            int highPos = this.editorPanel.basePairToPos(high);
            int width = (int)Math.floor((double)exon.length() / scaling_factor);
            if (width < 1) {
                width = 1;
            }
            int transcriptColorIndex = this.editorPanel.getRangeIndex(this.tier, lowPos, highPos) % this.colorList.length;
            int exonColorIndex = this.editorPanel.getExonRangeIndex(this.tier, lowPos, highPos) % this.colorList[transcriptColorIndex].length;
            g.setColor(this.colorList[transcriptColorIndex][exonColorIndex]);
            int drawX = x;
            this.rh.put(drawX, drawX + width - 1, (Object)exon);
            g.fillRect(drawX, topDistance, width, this.barHeight + 1);
            this.paintCodon(g, exon, this.translationStart, laststart_base, low, high, DrawableUtil.getStartCodonColor(this.transcript), x, topDistance, scaling_factor);
            this.paintCodon(g, exon, this.translationEnd, laststop_base, low, high, Color.red, x, topDistance, scaling_factor);
            this.paintCodon(g, exon, readthrough_pos, lastreadon_base, low, high, Color.pink, x, topDistance, scaling_factor);
            this.paintFrame(g, exon, low, high, this.translationStart, laststop_base, x, topDistance, scaling_factor);
            x += width;
            if (!this.drawIntrons || i + 1 >= exon_count) continue;
            ExonI nextExon = this.transcript.getExonAt(i + 1);
            int intron_len = exon.getStrand() == 1 ? nextExon.getLow() - high + 1 : low - nextExon.getHigh() + 1;
            x = (int)((double)x + (double)intron_len / scaling_factor);
        }
        int baseStart = this.editorPanel.getVisibleBase();
        int baseCount = this.editorPanel.getVisibleBaseCount();
        int baseOffset = baseStart - this.transcript.getStart();
        if (this.editorPanel.getReverseStrand()) {
            baseOffset = this.transcript.getStart() - baseStart;
        }
        int pixelOffset = (int)((double)baseOffset / scaling_factor);
        int basePixelStart = this.margin + pixelOffset;
        int basePixelCount = (int)((double)baseCount / scaling_factor);
        g.setColor(this.editorPanel.getSelectionBoxColor());
        g.drawRect(basePixelStart, topDistance - 4, basePixelCount, this.barHeight + 8);
        g.drawRect(basePixelStart - 1, topDistance - 5, basePixelCount + 2, this.barHeight + 10);
    }

    private void paintCodon(Graphics g, ExonI exon, int first_base, int last_base, int low, int high, Color codon_color, int x, int topDistance, double scaling_factor) {
        int expected_last = first_base + 2 * exon.getStrand();
        if (first_base > 0) {
            int codon_width;
            if (first_base >= low && first_base <= high) {
                g.setColor(codon_color);
                codon_width = last_base != expected_last ? Math.abs(exon.getEnd() - first_base) + 1 : 3;
                int offset = (int)((double)Math.abs(exon.getStart() - first_base) / scaling_factor);
                int rect_width = (int)((double)codon_width / scaling_factor);
                if (rect_width < 1) {
                    rect_width = 1;
                }
                g.fillRect(x + offset, topDistance, rect_width, this.barHeight + 1);
            }
            if (last_base != expected_last && last_base >= low && last_base <= high) {
                g.setColor(codon_color);
                codon_width = Math.abs(last_base - exon.getStart()) + 1;
                int rect_width = (int)((double)codon_width / scaling_factor);
                if (rect_width < 1) {
                    rect_width = 1;
                }
                g.fillRect(x, topDistance, rect_width, this.barHeight + 1);
            }
        }
    }

    private void paintBase(Graphics g, ExonI exon, int base_pos, int low, int high, Color base_color, int x, int topDistance, double scaling_factor) {
        if (base_pos > 0 && base_pos >= low && base_pos <= high) {
            g.setColor(base_color);
            int offset = (int)((double)Math.abs(exon.getStart() - base_pos) / scaling_factor);
            int rect_width = (int)(1.0 / scaling_factor);
            if (rect_width < 1) {
                rect_width = 1;
            }
            g.fillRect(x + offset, topDistance, rect_width, this.barHeight + 1);
        }
    }

    private void paintFrame(Graphics g, ExonI exon, int low, int high, int translationStart, int laststop_base, int exon_x, int topDistance, double scaling_factor) {
        int prev_pos;
        boolean coding = exon.containsCoding();
        int frame = exon.getFrame();
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        SequenceEdit[] edit_list = exon.buildEditList();
        int edits = edit_list != null ? edit_list.length : 0;
        int x = exon_x;
        if (exon.contains(translationStart)) {
            prev_pos = translationStart;
            int length = Math.abs(exon.getStart() - prev_pos) + 1;
            int width = (int)Math.floor((double)length / scaling_factor);
            if (width < 1) {
                width = 1;
            }
            x += width;
        } else {
            prev_pos = exon.getStart();
            x = exon_x;
        }
        int last_pos = exon.contains(laststop_base) ? laststop_base : exon.getEnd();
        for (int i = 0; i < edits; ++i) {
            SequenceEdit edit = edit_list[i];
            int pos = edit.getPosition();
            this.paintBase(g, exon, pos, low, high, this.shiftColor, exon_x, topDistance, scaling_factor);
            if (!coding) continue;
            g.setColor(this.getForeground());
            String drawMe = "" + frame;
            int strWidth = metrics.stringWidth(drawMe);
            int length = Math.abs(pos - prev_pos) + 1;
            int width = (int)Math.floor((double)length / scaling_factor);
            if (width < 1) {
                width = 1;
            }
            int fontx = x + width / 2 - strWidth / 2;
            int fonty = topDistance + this.barHeight / 2 + this.getFont().getSize() / 2;
            g.drawString(drawMe, fontx, fonty);
            x += width;
            prev_pos = pos;
            if (edit.getEditType().equals("nucleotide_deletion")) {
                int n = frame = frame == 3 ? 1 : frame - 1;
            }
            if (!edit.getEditType().equals("nucleotide_insertion")) continue;
            frame = frame == 1 ? 3 : frame + 1;
        }
        if (coding) {
            g.setColor(this.getForeground());
            String drawMe = "" + frame;
            int strWidth = metrics.stringWidth(drawMe);
            int length = Math.abs(last_pos - prev_pos) + 1;
            int width = (int)Math.floor((double)length / scaling_factor);
            if (width < 1) {
                width = 1;
            }
            int fontx = x + width / 2 - strWidth / 2;
            int fonty = topDistance + this.barHeight / 2 + this.getFont().getSize() / 2;
            g.drawString(drawMe, fontx, fonty);
            x += width;
        }
    }

    class NavClickListener
    extends MouseInputAdapter {
        NavClickListener() {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
            if (TranslationViewer.this.transcript != null) {
                int basepair;
                double[] range = TranslationViewer.this.rh.getInterval(e.getX());
                SeqFeatureI feature = (SeqFeatureI)TranslationViewer.this.rh.get(e.getX());
                if (range == null || feature == null) {
                    double offset = e.getX() - TranslationViewer.this.margin;
                    double scale = (double)TranslationViewer.this.transcript.length() / ((double)TranslationViewer.this.getSize().width - (double)(TranslationViewer.this.margin * 2));
                    basepair = (int)((double)TranslationViewer.this.transcript.getStart() + (double)TranslationViewer.this.transcript.getStrand() * offset * scale);
                } else {
                    double offset = (double)e.getX() - range[0];
                    double rangeWidth = range[1] - range[0];
                    double scale = (double)feature.getStrand() * offset / rangeWidth;
                    double baseWidth = feature.getHigh() - feature.getLow();
                    int baseOffset = (int)(baseWidth * scale);
                    basepair = feature.getStart() + baseOffset;
                }
                TranslationViewer.this.editorPanel.scrollToBase(basepair);
            }
        }
    }
}

