/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.annotinfo;

import apollo.config.ApolloNameAdapterI;
import apollo.config.Config;
import apollo.config.Style;
import apollo.dataadapter.DataLoadEvent;
import apollo.dataadapter.DataLoadListener;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.StrandedFeatureSetI;
import apollo.datamodel.Transcript;
import apollo.editor.AnnotationChangeEvent;
import apollo.editor.AnnotationChangeListener;
import apollo.gui.ControlledObjectI;
import apollo.gui.Controller;
import apollo.gui.FeatureNavigationI;
import apollo.gui.SelectionManager;
import apollo.gui.annotinfo.GeneEditPanel;
import apollo.gui.event.BaseFocusEvent;
import apollo.gui.event.FeatureSelectionEvent;
import apollo.gui.event.FeatureSelectionListener;
import apollo.gui.featuretree.FeatureTreePanel;
import apollo.gui.synteny.CurationManager;
import apollo.gui.synteny.GuiCurationState;
import apollo.util.GuiUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import junit.framework.TestCase;

public class FeatureEditorDialog
extends JFrame
implements ControlledObjectI,
AnnotationChangeListener,
FeatureSelectionListener,
DataLoadListener,
FeatureNavigationI {
    private static boolean isReadOnly = !Config.isEditingEnabled();
    private static final String warn_message = " extends beyond the current sequence region,\nso any changes you make to it may not get saved in the database.\nAre you sure you want to save your changes?";
    Controller controller;
    private SelectionManager selectionManager;
    private boolean selectIsFromTree = false;
    private Box buttonPanel;
    private JButton cancelButton;
    private JButton undoButton;
    private JCheckBox followSelectionCheckBox;
    private GeneEditPanel genePanel;
    private FeatureTreePanel treePanel;
    private StrandedFeatureSetI annots;
    private SeqFeatureI orig_feature = null;
    private AnnotatedFeatureI orig_annot;
    protected static Color bgColor;
    private GuiCurationState curationState;
    private boolean isUndoing = false;
    private static ArrayList feds;
    private static final int textEdHeight = 665;
    private static final Dimension textEdDimForEditing;
    private static final Dimension textEdDimReadOnly;

    public static void showTextEditor(SeqFeatureI sf, GuiCurationState s) {
        FeatureEditorDialog fed = new FeatureEditorDialog(sf, s);
        feds.add(fed);
    }

    private FeatureEditorDialog(SeqFeatureI sf, GuiCurationState s) {
        this.curationState = s;
        this.setController(this.curationState.getController());
        this.setSelectionManager(this.curationState.getSelectionManager());
        isReadOnly = !Config.isEditingEnabled();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                e.getWindow().setVisible(false);
            }
        });
        this.jbInit();
        this.attachListeners();
        this.setFeature(sf);
        this.show();
        this.setVisible(true);
        if (this.getState() == 1) {
            this.setState(0);
        }
    }

    GuiCurationState getCurationState() {
        return this.curationState;
    }

    private void updateAnnotList() {
        this.annots = this.curationState.getCurationSet().getAnnots();
        this.treePanel.setFeatureSet(this.annots);
    }

    private void setFeature(SeqFeatureI feature) {
        this.setFeature(feature, true);
    }

    private void setFeature(SeqFeatureI feature, boolean clear) {
        this.orig_feature = feature;
        if (clear) {
            this.updateAnnotList();
        }
        if (feature == null && this.annots != null && this.annots.size() > 0) {
            feature = this.annots.getFeatureAt(0);
        }
        if (feature != null) {
            this.orig_annot = this.getAnnot(feature);
            if (this.orig_annot != null) {
                this.setTitle(this.orig_annot.getName() + " Annotation Information");
                this.genePanel.loadAnnotation(this.orig_annot);
                if (!this.selectIsFromTree) {
                    if (this.getTranscript() == null) {
                        this.treePanel.findObject(this.orig_annot);
                    } else {
                        this.treePanel.findObject(this.getTranscript());
                    }
                }
                if (this.getTranscript() != null) {
                    System.out.println("Annotation Info Editor: looking at " + this.getTranscript().getName() + " (type " + this.orig_annot.getFeatureType() + ")");
                }
            }
        }
    }

    public void featureSelected(SeqFeatureI sf) {
        this.selectIsFromTree = true;
        if (this.selectIfChanged(sf)) {
            this.fireFeatureSelectionEvent(sf);
        }
        this.selectIsFromTree = false;
    }

    private boolean selectIfChanged(SeqFeatureI sf) {
        boolean update;
        AnnotatedFeatureI newAnnot = this.getAnnot(sf);
        boolean bl = update = newAnnot != null;
        if (update) {
            boolean bl2 = update = newAnnot != this.orig_annot;
            if (!update) {
                Transcript currentTrans;
                Transcript newTrans = this.getTranscript(this.orig_annot, sf);
                boolean bl3 = update = newTrans != (currentTrans = this.getTranscript());
            }
        }
        if (update) {
            this.setFeature(sf, false);
        }
        return update;
    }

    private void fireFeatureSelectionEvent(SeqFeatureI sf) {
        if (this.allowExternalSelection()) {
            BaseFocusEvent evt = new BaseFocusEvent(this, sf.getStart(), sf);
            this.controller.handleBaseFocusEvent(evt);
            this.selectionManager.select(sf, (Object)this);
        }
    }

    protected Transcript getTranscript() {
        return this.getTranscript(this.orig_annot, this.orig_feature);
    }

    private Transcript getTranscript(AnnotatedFeatureI gene, SeqFeatureI sf) {
        Vector transcripts = gene.getFeatures();
        AnnotatedFeatureI annot = this.getTopAnnot(transcripts, sf);
        if (annot != null && annot instanceof Transcript) {
            return (Transcript)annot;
        }
        return (Transcript)gene.getFeatureAt(0);
    }

    private AnnotatedFeatureI getTopAnnot(Vector list, SeqFeatureI sf) {
        while (sf != null && !list.contains(sf)) {
            sf = sf.getParent();
        }
        if (sf != null && sf.hasAnnotatedFeature()) {
            return sf.getAnnotatedFeature();
        }
        return null;
    }

    private void jbInit() {
        this.genePanel = new GeneEditPanel(this, isReadOnly);
        bgColor = this.genePanel.getBackgroundColor();
        if (!isReadOnly) {
            this.undoButton = new JButton("Undo");
            this.undoButton.setBackground(Color.white);
        }
        this.cancelButton = new JButton("Close");
        this.cancelButton.setBackground(Color.white);
        this.followSelectionCheckBox = new JCheckBox("Follow selection", false);
        this.followSelectionCheckBox.setBackground(bgColor);
        this.buttonPanel = new Box(0);
        this.buttonPanel.setBackground(bgColor);
        this.buttonPanel.add(Box.createHorizontalStrut(5));
        this.buttonPanel.add(this.followSelectionCheckBox);
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.buttonPanel.add(Box.createHorizontalStrut(10));
        if (!isReadOnly) {
            this.buttonPanel.add(this.undoButton);
            this.buttonPanel.add(Box.createHorizontalStrut(300));
        }
        this.buttonPanel.add(this.cancelButton);
        Box navBox = new Box(0);
        this.treePanel = new FeatureTreePanel(this, this.getCurationState());
        navBox.add(Box.createHorizontalStrut(12));
        navBox.add(this.treePanel);
        navBox.add(Box.createHorizontalStrut(8));
        navBox.add(this.genePanel);
        navBox.add(Box.createHorizontalStrut(12));
        Dimension treeDim = new Dimension(200, 565);
        this.treePanel.setPreferredSize(treeDim);
        this.treePanel.setMinimumSize(treeDim);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().setBackground(bgColor);
        this.getContentPane().setForeground(Color.black);
        this.getContentPane().add(Box.createVerticalStrut(12));
        this.getContentPane().add(navBox);
        this.getContentPane().add(Box.createVerticalStrut(12));
        this.getContentPane().add(this.buttonPanel);
        Dimension sz = Config.isEditingEnabled() ? textEdDimForEditing : textEdDimReadOnly;
        this.setSize(GuiUtil.fitToScreen(sz));
    }

    public void dispose() {
        this.genePanel.disposeCommentator();
        super.dispose();
    }

    public void windowClosed(WindowEvent e) {
    }

    public static void disposeAllEditors() {
        Iterator it = feds.iterator();
        while (it.hasNext()) {
            FeatureEditorDialog fed = (FeatureEditorDialog)it.next();
            fed.dispose();
            Object var1_1 = null;
        }
        feds.clear();
    }

    void refreshCommentField() {
        this.genePanel.refreshCommentField();
    }

    void attachListeners() {
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FeatureEditorDialog.this.dispose();
            }
        });
        if (!isReadOnly) {
            this.undoButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FeatureEditorDialog.this.undo();
                }
            });
        }
    }

    void undo() {
        if (this.curationState.getTransactionManager().numberOfTransactions() == 0) {
            System.err.println("Nothing to undo!");
        }
        this.isUndoing = true;
        this.curationState.getTransactionManager().undo(this);
        this.isUndoing = false;
    }

    boolean isUndoing() {
        return this.isUndoing;
    }

    protected AnnotatedFeatureI getAnnot(SeqFeatureI sf) {
        return this.getTopAnnot(this.annots.getFeatures(), sf);
    }

    private JLabel initLabel(String text) {
        JLabel label = new JLabel(text);
        label.setFont(new Font("Dialog", 0, 12));
        label.setBackground(Config.getAnnotationBackground());
        label.setForeground(Color.black);
        return label;
    }

    public void setController(Controller c) {
        this.controller = c;
        this.controller.addListener(this);
    }

    public Controller getController() {
        return this.controller;
    }

    public void setSelectionManager(SelectionManager sm) {
        this.selectionManager = sm;
    }

    public void addNotify() {
        super.addNotify();
    }

    public Object getControllerWindow() {
        return this;
    }

    public boolean needsAutoRemoval() {
        return true;
    }

    public boolean handleAnnotationChangeEvent(AnnotationChangeEvent evt) {
        if (evt.getSource() == this) {
            return false;
        }
        if (evt.isCompound() || evt.isEndOfEditSession()) {
            this.setFeature(evt.getAnnotTop(), true);
            return true;
        }
        return false;
    }

    public boolean handleFeatureSelectionEvent(FeatureSelectionEvent evt) {
        if (this.allowExternalSelection() && this.isVisible() && evt.getSource() != this && evt.getFeatures().size() > 0) {
            this.selectIfChanged(evt.getFeatures().getFeature(0));
            return true;
        }
        return false;
    }

    public boolean handleDataLoadEvent(DataLoadEvent e) {
        FeatureEditorDialog.disposeAllEditors();
        return true;
    }

    private boolean allowExternalSelection() {
        return this.followSelectionCheckBox.isSelected();
    }

    protected void fireAnnotEvent(AnnotationChangeEvent ace) {
        this.getController().handleAnnotationChangeEvent(ace);
    }

    protected ApolloNameAdapterI getNameAdapter(AnnotatedFeatureI annot) {
        return this.curationState.getNameAdapter(annot);
    }

    Style getStyle() {
        return this.curationState.getStyle();
    }

    public static void testNameUndo(TestCase testCase) {
        GuiCurationState cs = CurationManager.getCurationManager().getActiveCurState();
        TestCase.assertNotNull((Object)cs.getCurationSet());
        SeqFeatureI annot = cs.getCurationSet().getAnnots().getFeatureAt(0);
        FeatureEditorDialog fed = new FeatureEditorDialog(annot, cs);
        fed.genePanel.testNameUndo(testCase);
    }

    static {
        feds = new ArrayList(5);
        textEdDimForEditing = new Dimension(1100, 725);
        textEdDimReadOnly = new Dimension(550, 665);
    }
}

