/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.annotinfo;

import apollo.config.Config;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.Comment;
import apollo.editor.AnnotationAddEvent;
import apollo.editor.AnnotationChangeEvent;
import apollo.editor.AnnotationChangeListener;
import apollo.editor.AnnotationDeleteEvent;
import apollo.editor.AnnotationUpdateEvent;
import apollo.editor.TransactionSubpart;
import apollo.editor.UserName;
import apollo.gui.annotinfo.FeatureEditorDialog;
import apollo.util.IOUtil;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class Commentator
extends JFrame {
    private static int panelWidth = 560;
    public static int ANNOTATION = 1;
    public static int TRANSCRIPT = 2;
    private Vector cannedComments;
    private JButton addButton = new JButton("Add");
    JButton delButton = new JButton("Delete");
    JButton closeButton = new JButton("Close");
    private JList userCommentListGui = new JList();
    private JTextArea commentText = new JTextArea();
    private JCheckBox isInternalCheckBox = new JCheckBox("For internal viewing only");
    private JComboBox cannedCommentListGui;
    protected static Color bgColor = new Color(255, 240, 210);
    private CommentDocumentListener commentDocumentListener = new CommentDocumentListener();
    private FeatureEditorDialog featureEditorDialog;
    private AnnotatedFeatureI annot;
    private Vector no_comment = new Vector();
    private boolean currentCommentIsNew = false;
    private boolean commentEdited = false;
    private CommentChangeListener commentChangeListener;

    Commentator(FeatureEditorDialog featureEditorDialog) {
        this.featureEditorDialog = featureEditorDialog;
        this.initGui();
        this.attachListeners();
        this.validate();
        this.repaint();
    }

    private Vector synchCommentListWithAnnot() {
        Vector<Comment> listed_comments;
        if (this.annot == null) {
            String m = "Prog error: Commentator has no annot but synchWithAnnot has been called";
            throw new NullPointerException(m);
        }
        Vector<Comment> all_comments = this.annot.getComments();
        if (!Config.internalMode()) {
            listed_comments = new Vector<Comment>();
            for (int i = 0; i < all_comments.size(); ++i) {
                Comment c = (Comment)all_comments.elementAt(i);
                if (c.isInternal()) continue;
                listed_comments.addElement(c);
            }
        } else {
            listed_comments = all_comments;
        }
        this.userCommentListGui.setListData(listed_comments);
        return listed_comments;
    }

    private void attachListeners() {
        this.isInternalCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!Commentator.this.currentCommentIsNew) {
                    Commentator.this.commentEdited = true;
                    Commentator.this.commitCurrentComment();
                }
            }
        });
        this.commentText.getDocument().addDocumentListener(this.commentDocumentListener);
        this.commentText.addFocusListener(new CommentTextFocusListener());
        this.userCommentListGui.addListSelectionListener(new UserCommentListSelListener());
        this.commentChangeListener = new CommentChangeListener();
        this.featureEditorDialog.getController().addListener(this.commentChangeListener);
    }

    public void dispose() {
        this.featureEditorDialog.getController().removeListener(this.commentChangeListener);
        super.dispose();
    }

    private void initButton(JButton button) {
        button.setBackground(Color.white);
        button.setMaximumSize(new Dimension(80, 20));
        button.setMinimumSize(new Dimension(80, 20));
        button.setPreferredSize(new Dimension(80, 20));
    }

    private void initGui() {
        this.initButton(this.addButton);
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Commentator.this.addComment();
            }
        });
        this.initButton(this.delButton);
        this.delButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Commentator.this.deleteComment();
            }
        });
        this.initButton(this.closeButton);
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Commentator.this.removeEmptyComments();
                Commentator.this.commitCurrentComment();
                Commentator.this.commentEdited = false;
                Commentator.this.userCommentListGui.clearSelection();
                Commentator.this.setVisible(false);
            }
        });
        Box buttonBox = new Box(0);
        buttonBox.add(Box.createHorizontalGlue());
        buttonBox.add(this.addButton);
        buttonBox.add(Box.createHorizontalStrut(10));
        buttonBox.add(this.delButton);
        buttonBox.add(Box.createHorizontalStrut(10));
        buttonBox.add(this.closeButton);
        buttonBox.add(Box.createHorizontalGlue());
        this.userCommentListGui.setSelectionMode(0);
        JScrollPane listScroll = new JScrollPane(this.userCommentListGui);
        Dimension listDim = new Dimension(panelWidth / 2, 120);
        listScroll.setMaximumSize(listDim);
        listScroll.setMinimumSize(listDim);
        listScroll.setPreferredSize(listDim);
        JLabel help_text = new JLabel();
        help_text.setForeground(Color.black);
        help_text.setFont(new Font("Dialog", 1, 12));
        String font = "<FONT FACE=Dialog color=black>";
        help_text.setText("<html>" + font + "Select an author/date pair to edit an existing " + "comment, or click 'Add' to create a new comment." + "</font></html>");
        Box helpBox = new Box(1);
        helpBox.add(Box.createVerticalGlue());
        helpBox.add(Box.createVerticalStrut(20));
        helpBox.add(help_text);
        helpBox.add(Box.createVerticalStrut(10));
        helpBox.add(Box.createVerticalGlue());
        Box selBox = new Box(0);
        selBox.add(listScroll);
        selBox.add(Box.createHorizontalStrut(20));
        selBox.add(helpBox);
        selBox.add(Box.createHorizontalStrut(10));
        selBox.add(Box.createHorizontalGlue());
        this.cannedComments = new Vector();
        this.cannedComments.add("No canned comments defined yet");
        this.cannedCommentListGui = new JComboBox(this.cannedComments);
        this.cannedCommentListGui.setFont(new Font("Dialog", 0, 10));
        this.cannedCommentListGui.setBackground(bgColor);
        this.cannedCommentListGui.setForeground(Color.black);
        this.cannedCommentListGui.setMaximumSize(new Dimension(panelWidth, 20));
        this.cannedCommentListGui.setEnabled(false);
        this.cannedCommentListGui.addItemListener(new CannedListItemListener());
        this.commentText.setLineWrap(true);
        this.commentText.setWrapStyleWord(true);
        this.commentText.setBorder(null);
        this.commentText.setEditable(false);
        JScrollPane textScroll = new JScrollPane(this.commentText);
        textScroll.setHorizontalScrollBarPolicy(31);
        textScroll.setVerticalScrollBarPolicy(22);
        textScroll.setMinimumSize(new Dimension(panelWidth / 2, 200));
        textScroll.setPreferredSize(new Dimension(panelWidth, 200));
        textScroll.setMaximumSize(new Dimension(panelWidth, 200));
        Container content = this.getContentPane();
        content.setLayout(new BoxLayout(content, 1));
        content.add(Box.createVerticalStrut(10));
        content.add(selBox);
        content.add(Box.createVerticalStrut(20));
        content.add(this.cannedCommentListGui);
        content.add(Box.createVerticalStrut(10));
        content.add(textScroll);
        content.add(Box.createVerticalStrut(10));
        this.isInternalCheckBox.setFont(new Font("Dialog", 1, 12));
        this.isInternalCheckBox.setBackground(bgColor);
        this.isInternalCheckBox.setSelected(false);
        this.isInternalCheckBox.setEnabled(false);
        this.isInternalCheckBox.setPreferredSize(new Dimension(panelWidth, 15));
        this.isInternalCheckBox.setMinimumSize(new Dimension(panelWidth, 15));
        if (Config.internalMode()) {
            content.add(this.isInternalCheckBox);
            content.add(Box.createVerticalStrut(20));
        }
        content.add(buttonBox);
        content.add(Box.createVerticalStrut(10));
        content.setBackground(bgColor);
        this.setSize(new Dimension(panelWidth + 24, 500));
    }

    private void clearFields() {
        this.commentText.getDocument().removeDocumentListener(this.commentDocumentListener);
        this.commentText.setText("");
        this.commentText.getDocument().addDocumentListener(this.commentDocumentListener);
        if (this.annot == null) {
            this.userCommentListGui.setListData(this.no_comment);
        }
        this.userCommentListGui.clearSelection();
        this.addButton.setEnabled(false);
        this.delButton.setEnabled(false);
    }

    private void deleteComment() {
        int index;
        Comment c = null;
        try {
            c = this.getCurrentComment();
        }
        catch (CommentSelectionOutOfSynchException e) {
            System.out.println("Comment list out of synch. comment not deleted");
            if (Config.DEBUG) {
                System.out.println("DEBUG StackTrace:");
                new Throwable().printStackTrace();
            }
            return;
        }
        if (c == null) {
            return;
        }
        this.annot.deleteComment(c);
        FeatureEditorDialog source = this.featureEditorDialog;
        TransactionSubpart sp = TransactionSubpart.COMMENT;
        AnnotationDeleteEvent ade = new AnnotationDeleteEvent((Object)source, this.annot, sp);
        ade.setOldComment(c);
        ade.setSubpartRank(index);
        this.featureEditorDialog.fireAnnotEvent(ade);
        Vector listed_comments = this.synchCommentListWithAnnot();
        for (index = this.getCurrentCommentIndex(); index >= listed_comments.size(); --index) {
        }
        if (listed_comments.size() > 0) {
            this.userCommentListGui.setSelectedIndex(index);
            this.selectComment((Comment)this.userCommentListGui.getSelectedValue());
        } else {
            this.userCommentListGui.clearSelection();
        }
        this.featureEditorDialog.refreshCommentField();
    }

    private void removeEmptyComments() {
        Comment selectedComment = null;
        try {
            selectedComment = this.getCurrentComment();
        }
        catch (CommentSelectionOutOfSynchException e) {
            // empty catch block
        }
        Vector all_comments = this.annot.getComments();
        for (int i = all_comments.size() - 1; i >= 0; --i) {
            Comment c = (Comment)all_comments.elementAt(i);
            if (!c.getText().trim().equals("")) continue;
            this.annot.deleteComment(c);
            if (c != selectedComment) continue;
            this.commentEdited = false;
            this.userCommentListGui.clearSelection();
        }
    }

    private void addComment() {
        if (this.annot == null) {
            return;
        }
        Comment newComment = this.createNewComment();
        this.synchCommentListWithAnnot();
        this.userCommentListGui.setSelectedValue(newComment, true);
        this.selectComment(newComment);
        this.featureEditorDialog.refreshCommentField();
    }

    private Comment createNewComment() {
        Comment newComment = null;
        Vector all_comments = this.annot.getComments();
        for (int i = 0; i < all_comments.size() && newComment == null; ++i) {
            Comment c = (Comment)all_comments.elementAt(i);
            newComment = c.getText().trim().equals("") ? c : null;
        }
        if (newComment == null) {
            String name = UserName.getUserName();
            newComment = new Comment(this.annot.getId(), "", name, System.currentTimeMillis());
            this.annot.addComment(newComment);
            if (this.cannedCommentListGui.getItemCount() > 0) {
                this.cannedCommentListGui.setSelectedIndex(0);
            }
        }
        this.currentCommentIsNew = true;
        return newComment;
    }

    protected void selectComment(Comment c) {
        this.commentText.getDocument().removeDocumentListener(this.commentDocumentListener);
        if (c != null) {
            this.commentText.setText(c.getText());
            this.commentText.setEditable(true);
            this.cannedCommentListGui.setEnabled(true);
            this.delButton.setEnabled(true);
            this.isInternalCheckBox.setSelected(c.isInternal());
            this.isInternalCheckBox.setEnabled(true);
        } else {
            this.commentText.setText("");
            this.commentText.setEditable(false);
            this.cannedCommentListGui.setEnabled(false);
            this.delButton.setEnabled(false);
            this.isInternalCheckBox.setSelected(false);
            this.isInternalCheckBox.setEnabled(false);
        }
        this.commentText.getDocument().addDocumentListener(this.commentDocumentListener);
    }

    public void setType(int type) {
        this.cannedComments = type == ANNOTATION ? Config.getAnnotationComments() : Config.getTranscriptComments();
        this.cannedCommentListGui.removeAllItems();
        if (this.cannedComments == null) {
            return;
        }
        for (int i = 0; i < this.cannedComments.size(); ++i) {
            this.cannedCommentListGui.addItem(this.cannedComments.elementAt(i));
        }
        this.cannedCommentListGui.setMaximumRowCount(Math.min(this.cannedComments.size(), 16));
    }

    private void setColor(Color bgColor) {
        Commentator.bgColor = bgColor;
        this.isInternalCheckBox.setBackground(bgColor);
        this.cannedCommentListGui.setBackground(bgColor);
        this.getContentPane().setBackground(bgColor);
    }

    private Comment getCurrentComment() throws CommentSelectionOutOfSynchException {
        if (this.getCurrentCommentIndex() >= this.userCommentListGui.getModel().getSize()) {
            throw new CommentSelectionOutOfSynchException();
        }
        return (Comment)this.userCommentListGui.getSelectedValue();
    }

    private int getCurrentCommentIndex() {
        return this.userCommentListGui.getSelectedIndex();
    }

    void commitCurrentComment() {
        try {
            Comment com = this.getCurrentComment();
            this.commitEditedComment(com);
        }
        catch (CommentSelectionOutOfSynchException e) {
            System.out.println("Comment list out of synch. comment not committed");
            if (Config.DEBUG) {
                System.out.println("DEBUG StackTrace:");
                new Throwable().printStackTrace();
            }
            return;
        }
    }

    private void commitEditedComment(Comment c) {
        if (this.commentEdited) {
            this.commitComment(c);
        }
        this.commentEdited = false;
    }

    private void commitComment(Comment comment) {
        if (comment == null) {
            return;
        }
        TransactionSubpart sp = TransactionSubpart.COMMENT;
        FeatureEditorDialog source = this.featureEditorDialog;
        Comment oldComment = comment.cloneComment();
        this.setCommentGuiToModel(comment);
        int commentIndex = this.getCommentIndex(comment);
        if (this.currentCommentIsNew) {
            AnnotationAddEvent aae = new AnnotationAddEvent((Object)source, this.annot, sp);
            aae.setSubpartRank(commentIndex);
            this.currentCommentIsNew = false;
            this.featureEditorDialog.fireAnnotEvent(aae);
        } else {
            AnnotationUpdateEvent aue = new AnnotationUpdateEvent((Object)source, this.annot, sp);
            aue.setSubpartRank(commentIndex);
            aue.setOldComment(oldComment);
            this.featureEditorDialog.fireAnnotEvent(aue);
        }
        this.featureEditorDialog.refreshCommentField();
    }

    private int getCommentIndex(Comment comment) {
        return this.annot.getCommentIndex(comment);
    }

    private void setCommentGuiToModel(Comment comment) {
        comment.setText(IOUtil.stripControlChars(this.commentText.getText()));
        comment.setIsInternal(this.isInternalCheckBox.isSelected());
    }

    public void setFeature(AnnotatedFeatureI cf, Color bgColor) {
        this.annot = cf;
        if (this.annot != null) {
            this.setTitle(cf.getName() + " comments");
            System.err.println("Editing comments for " + cf.getName());
            this.addButton.setEnabled(true);
            this.synchCommentListWithAnnot();
            this.setColor(bgColor);
        } else {
            this.setTitle("Comments");
            this.clearFields();
        }
    }

    private class CommentDocumentListener
    implements DocumentListener {
        private CommentDocumentListener() {
        }

        public void changedUpdate(DocumentEvent e) {
            this.processCommentEdit();
        }

        public void insertUpdate(DocumentEvent e) {
            this.processCommentEdit();
        }

        public void removeUpdate(DocumentEvent e) {
            this.processCommentEdit();
        }

        private void processCommentEdit() {
            Commentator.this.commentEdited = true;
        }
    }

    private class CommentTextFocusListener
    implements FocusListener {
        private CommentTextFocusListener() {
        }

        public void focusLost(FocusEvent e) {
            Commentator.this.commitCurrentComment();
        }

        public void focusGained(FocusEvent e) {
        }
    }

    private class CannedListItemListener
    implements ItemListener {
        private CannedListItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 2) {
                return;
            }
            int row = Commentator.this.cannedCommentListGui.getSelectedIndex();
            if (row == 0) {
                return;
            }
            Commentator.this.commentText.setText((String)Commentator.this.cannedCommentListGui.getSelectedItem());
            Commentator.this.commentEdited = true;
            Commentator.this.commitCurrentComment();
        }
    }

    private class UserCommentListSelListener
    implements ListSelectionListener {
        private UserCommentListSelListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                this.checkForEditedComment(e);
            }
            Commentator.this.selectComment((Comment)Commentator.this.userCommentListGui.getSelectedValue());
        }

        private void checkForEditedComment(ListSelectionEvent e) {
            block2: {
                try {
                    Comment c = this.getPreviouslySelectedComment(e);
                    Commentator.this.commitEditedComment(c);
                }
                catch (CommentSelectionOutOfSynchException ex) {
                    if (!Config.DEBUG) break block2;
                    System.out.println("\nDEBUG: Cant get prev sel comment.");
                }
            }
        }

        private Comment getPreviouslySelectedComment(ListSelectionEvent e) throws CommentSelectionOutOfSynchException {
            int lastIndex;
            int i = Commentator.this.getCurrentCommentIndex();
            int n = lastIndex = i == e.getFirstIndex() ? e.getLastIndex() : e.getFirstIndex();
            if (lastIndex >= Commentator.this.userCommentListGui.getModel().getSize()) {
                throw new CommentSelectionOutOfSynchException();
            }
            return (Comment)Commentator.this.userCommentListGui.getModel().getElementAt(lastIndex);
        }
    }

    private class CommentSelectionOutOfSynchException
    extends Exception {
        private CommentSelectionOutOfSynchException() {
        }
    }

    private class CommentChangeListener
    implements AnnotationChangeListener {
        private CommentChangeListener() {
        }

        public boolean handleAnnotationChangeEvent(AnnotationChangeEvent e) {
            if (!e.isCommentChange() || e.getSource() == Commentator.this.featureEditorDialog) {
                return false;
            }
            if (Commentator.this.annot == null) {
                return false;
            }
            Commentator.this.synchCommentListWithAnnot();
            return true;
        }
    }
}

