/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui;

import apollo.gui.Controller;
import apollo.gui.Tier;
import apollo.gui.TierManagerI;
import apollo.gui.event.TierManagerEvent;
import apollo.gui.event.TierManagerListener;
import apollo.gui.genomemap.ViewI;
import apollo.util.SwingMissingUtil;
import java.util.Vector;

public abstract class TierManager
implements TierManagerI {
    protected Vector tiers = new Vector();
    protected int[] visibleLimits = new int[2];
    protected int viewHeight = -1;
    protected int offsetPixelHeight = 0;
    protected int aggregateSizeChange = 0;
    protected int charHeight = 17;
    protected ViewI view;
    protected Controller controller;
    protected Vector tierManagerListeners = new Vector();
    private boolean ignoreScoreThresholds = false;

    public void doLayoutTiers() {
        this.fillTiers();
        int tiersSize = this.tiers.size();
        for (int i = 0; i < tiersSize; ++i) {
            Tier tier = (Tier)this.tiers.elementAt(i);
            tier.setup(this.aggregateSizeChange, this.charHeight);
        }
        this.updateUserCoordBoundaries();
        this.fireTierManagerEvent(1);
    }

    public void setCharHeight(int height) {
        this.charHeight = height;
        int tiersSize = this.tiers.size();
        for (int i = 0; i < tiersSize; ++i) {
            Tier tier = (Tier)this.tiers.elementAt(i);
            tier.setCharHeight(this.charHeight);
        }
    }

    public void updateUserCoordBoundaries() {
        int tiersSize = this.tiers.size();
        int lowBound = 0;
        for (int i = 0; i < tiersSize; ++i) {
            Tier tier = (Tier)this.tiers.elementAt(i);
            tier.updateUserCoordBoundaries(lowBound);
            lowBound += (int)((long)tier.getTotalSpace() * 10L);
        }
    }

    public abstract void fillTiers();

    public abstract void setTierData(Object var1);

    public Vector getTiers() {
        return this.tiers;
    }

    public Tier getTier(int i) {
        if (i >= this.tiers.size()) {
            return (Tier)this.tiers.elementAt(this.getMaxVisibleTierNumber() - 1);
        }
        return (Tier)this.tiers.elementAt(i);
    }

    public int getNumTiers() {
        return this.tiers.size();
    }

    public int getLowestVisible() {
        return this.visibleLimits[0];
    }

    public void setLowestVisible(int lowest) {
        this.visibleLimits[0] = lowest;
        this.visibleLimits[1] = lowest + this.getNumVisible();
    }

    public int getNumVisible() {
        return this.getNumVisible(false);
    }

    public int getNumVisible(boolean debug) {
        int availablePixels = this.viewHeight - this.offsetPixelHeight;
        int numVisible = 0;
        int nTier = this.tiers.size();
        if (debug) {
            System.out.println("TierManager: viewHeight=" + this.viewHeight + " offsetPixelHeight=" + this.offsetPixelHeight + " nTiers=" + nTier + " visibleLimits[0]=" + this.visibleLimits[0]);
        }
        for (int i = this.visibleLimits[0]; i < nTier && availablePixels > 0; ++i) {
            availablePixels -= ((Tier)this.tiers.elementAt(i)).getTotalSpace();
            if (debug) {
                System.out.println("TierManager: totalSpace=" + ((Tier)this.tiers.elementAt(i)).getTotalSpace() + " down to " + availablePixels + " pixels");
            }
            ++numVisible;
        }
        return numVisible;
    }

    public int getMaxVisibleTierNumber() {
        int n = this.getLowestVisible() + this.getNumVisible();
        if (n > this.getTiers().size()) {
            System.err.println("getMaxVisibleTierNumber: lowest visible tier: " + this.getLowestVisible() + " Number Visible: " + this.getNumVisible(true) + ", is more than total number of tiers " + this.getTiers().size());
            return this.getTiers().size();
        }
        return n;
    }

    public int getMaximumVisibleTransformCoord(int min) {
        int availablePixels = this.viewHeight - this.offsetPixelHeight;
        int coord = min;
        coord = (int)((long)coord + (long)availablePixels * 10L);
        return coord;
    }

    public int getMinimumVisibleTransformCoord() {
        int coord = 0;
        for (int i = 0; i < this.visibleLimits[0] && i < this.tiers.size(); ++i) {
            coord = (int)((long)coord + (long)((Tier)this.tiers.elementAt(i)).getTotalSpace() * 10L);
        }
        return coord;
    }

    public void incrementTierHeight() {
        int tiersSize = this.tiers.size();
        for (int i = 0; i < tiersSize; ++i) {
            Tier tier = (Tier)this.tiers.elementAt(i);
            tier.setDrawSpace(tier.getDrawSpace() + 1);
        }
        ++this.aggregateSizeChange;
    }

    public void decrementTierHeight() {
        if (this.getMinimumDrawSpace() == 3) {
            System.out.println("Minimum tier size reached");
            System.out.println("\u0007");
        } else {
            int tiersSize = this.tiers.size();
            for (int i = 0; i < tiersSize; ++i) {
                Tier tier = (Tier)this.tiers.elementAt(i);
                tier.setDrawSpace(tier.getDrawSpace() - 1);
            }
            --this.aggregateSizeChange;
        }
    }

    public void setAggregateSizeChange(int change) {
        this.aggregateSizeChange = change;
    }

    public int getAggregateSizeChange() {
        return this.aggregateSizeChange;
    }

    private int getMinimumDrawSpace() {
        int minSize = 1000000;
        int tiersSize = this.tiers.size();
        for (int i = 0; i < tiersSize; ++i) {
            Tier tier = (Tier)this.tiers.elementAt(i);
            if (tier.getDrawSpace() >= minSize) continue;
            minSize = tier.getDrawSpace();
        }
        return minSize;
    }

    public void setOffsetHeight(int height) {
        this.offsetPixelHeight = height;
    }

    public void setViewHeight(int height) {
        this.viewHeight = height;
    }

    public int getViewHeight() {
        System.out.println("TierManager: viewHeight=" + this.viewHeight + " offsetPixelHeight=" + this.offsetPixelHeight);
        return this.viewHeight - this.offsetPixelHeight;
    }

    public long toTier(long userCoord) {
        long tierNum;
        long lastEnd = 0L;
        if (userCoord >= 0L) {
            int tiersSize = this.tiers.size();
            tierNum = tiersSize;
            for (int i = 0; i < tiersSize; ++i) {
                Tier tier = (Tier)this.tiers.elementAt(i);
                long thisEnd = (long)tier.getTotalSpace() * 10L + lastEnd;
                if (userCoord >= lastEnd && userCoord < thisEnd) {
                    tierNum = i;
                    break;
                }
                lastEnd = thisEnd;
            }
        } else {
            tierNum = -1L;
        }
        return tierNum;
    }

    public int getTotalHeight() {
        int height = 0;
        int tiersSize = this.tiers.size();
        for (int i = 0; i < tiersSize; ++i) {
            Tier tier = (Tier)this.tiers.elementAt(i);
            height += tier.getTotalSpace();
        }
        return height;
    }

    public long getMaxTierUserHeight() {
        int maxHeight = 0;
        int tiersSize = this.tiers.size();
        for (int i = 0; i < tiersSize; ++i) {
            Tier tier = (Tier)this.tiers.elementAt(i);
            if (tier.getTotalSpace() <= maxHeight) continue;
            maxHeight = tier.getTotalSpace();
        }
        return (long)maxHeight * 10L;
    }

    public long getMaxUserCoord() {
        return (long)this.getTotalHeight() * 10L;
    }

    public long getVisibleUserCoord() {
        return (long)(this.viewHeight - this.offsetPixelHeight) * 10L;
    }

    public int toUser(int tierNum) {
        int tiersSize = this.tiers.size();
        if (tierNum > tiersSize) {
            System.err.println("Asked for toUser on tier greater than tiersSize");
            return 0;
        }
        int userCoord = 0;
        for (int i = 0; i < tierNum; ++i) {
            Tier tier = (Tier)this.tiers.elementAt(i);
            userCoord = (int)((long)userCoord + (long)tier.getTotalSpace() * 10L);
        }
        return userCoord;
    }

    public void addTierManagerListener(TierManagerListener l) {
        this.tierManagerListeners.addElement(l);
    }

    public void fireTierManagerEvent(TierManagerEvent evt) {
        for (int i = 0; i < this.tierManagerListeners.size(); ++i) {
            TierManagerListener l = (TierManagerListener)this.tierManagerListeners.elementAt(i);
            l.handleTierManagerEvent(evt);
        }
    }

    public void fireTierManagerEvent(int type) {
        TierManagerEvent evt = new TierManagerEvent(this, this, type);
        this.fireTierManagerEvent(evt);
    }

    public void setController(Controller c) {
        this.controller = c;
    }

    public Controller getController() {
        return this.controller;
    }

    public Object getControllerWindow() {
        if (this.getView() != null) {
            return SwingMissingUtil.getWindowAncestor(this.getView().getComponent());
        }
        return null;
    }

    public boolean needsAutoRemoval() {
        return true;
    }

    public void setView(ViewI v) {
        this.view = v;
    }

    public ViewI getView() {
        return this.view;
    }

    public int[] getYRange() {
        int min = this.getMinimumVisibleTransformCoord();
        int max = this.getMaximumVisibleTransformCoord(min);
        return new int[]{min, max};
    }

    public void setIgnoreScoreThresholds(boolean ignore) {
        this.ignoreScoreThresholds = ignore;
    }

    public boolean ignoreScoreThresholds() {
        return this.ignoreScoreThresholds;
    }

    public String getTierLabel(int tierNum) {
        if (tierNum >= 0 && tierNum < this.tiers.size()) {
            Tier tier = (Tier)this.tiers.elementAt(tierNum);
            return tier.getTierLabel();
        }
        if (tierNum != this.tiers.size()) {
            System.out.println("ERROR: Invalid tier in getTierLabel()");
        }
        return null;
    }
}

