/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui;

import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.SeqFeatureI;
import apollo.editor.AnnotationChangeEvent;
import apollo.editor.AnnotationChangeListener;
import apollo.gui.ControlledObjectI;
import apollo.gui.Controller;
import apollo.gui.Selection;
import apollo.gui.event.FeatureSelectionEvent;
import apollo.util.FeatureList;
import java.util.Vector;

public class SelectionManager
implements ControlledObjectI {
    Selection currentlySelected = new Selection();
    private Controller controller;

    public void select(FeatureList feats, boolean exclusiveSelection, boolean selectParents, Object source) {
        if (exclusiveSelection) {
            this.clearSelections();
        }
        if (selectParents) {
            feats = feats.getParents();
        }
        this.currentlySelected.add(feats, source, !exclusiveSelection);
        this.fireFeatureSelectionEvent(this.currentlySelected, source, false);
    }

    public void select(Selection newSelection, boolean exclusiveSelection, Object source) {
        if (exclusiveSelection) {
            this.clearSelections();
        }
        newSelection.select();
        this.currentlySelected.add(newSelection, !exclusiveSelection);
        this.fireFeatureSelectionEvent(this.currentlySelected, source, false);
    }

    public void select(SeqFeatureI feat, Object source) {
        FeatureList fl = new FeatureList();
        fl.addFeature(feat);
        this.select(fl, true, false, source);
    }

    public void select(Vector features, Object source) {
        FeatureList list = new FeatureList();
        list.addVector(features);
        this.select(list, true, false, source);
    }

    public void addToCurrentSelection(Selection newSelection) {
        newSelection.select();
        this.currentlySelected.add(newSelection);
    }

    public Selection getSelection() {
        return this.currentlySelected;
    }

    public void clearSelections() {
        this.currentlySelected.clear();
    }

    public void setController(Controller c) {
        this.controller = c;
        this.controller.addListener(new SelectionAnnotationChangeListener());
    }

    public Controller getController() {
        return this.controller;
    }

    public Object getControllerWindow() {
        return null;
    }

    public boolean needsAutoRemoval() {
        return true;
    }

    private void fireFeatureSelectionEvent(Selection sel, Object source, boolean force_selection) {
        FeatureSelectionEvent e = new FeatureSelectionEvent(source, sel, force_selection);
        this.controller.handleFeatureSelectionEvent(e);
    }

    private class SelectionAnnotationChangeListener
    implements AnnotationChangeListener {
        private SelectionAnnotationChangeListener() {
        }

        public boolean handleAnnotationChangeEvent(AnnotationChangeEvent evt) {
            if (evt.isDelete()) {
                AnnotatedFeatureI changedAnnot = evt.getChangedAnnot();
                if (!SelectionManager.this.currentlySelected.containsFeature(changedAnnot)) {
                    return false;
                }
                SelectionManager.this.currentlySelected.removeFeature(changedAnnot);
            } else if (evt.isAdd()) {
                SelectionManager.this.select(evt.getAddedFeature(), evt.getSource());
            }
            return true;
        }
    }
}

