/*
 * Decompiled with CFR 0.152.
 */
package apollo.external;

import apollo.config.Config;
import apollo.dataadapter.Region;
import apollo.datamodel.CurationSet;
import apollo.gui.event.BaseFocusEvent;
import apollo.gui.synteny.CurationManager;
import apollo.gui.synteny.GuiCurationState;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ApolloControlServlet
extends HttpServlet {
    public void service(HttpServletRequest request, HttpServletResponse response) {
        System.out.println("ApolloControlServlet received request");
        response.setStatus(204);
        if (request.getParameter("ping") != null) {
            System.out.println("received ping request");
            return;
        }
        Map map = request.getParameterMap();
        this.loadFromRequestMap(map);
    }

    private void loadFromRequestMap(Map requestMap) {
        try {
            Region region = this.getHttpRegion(requestMap);
            this.debugPrint("got request for " + region);
            this.checkRegion(region);
            this.selectRegionInApollo(region);
        }
        catch (ParameterException e) {
            System.out.println("Selecting http request failed. " + e.getMessage());
        }
    }

    private String getChromosome(Map requestMap) throws ParameterException {
        String chromosome = this.getStringParameter(requestMap, "seqId");
        if (chromosome == null) {
            throw new ParameterException("No chromosome specified");
        }
        if (chromosome.startsWith("chr")) {
            chromosome = chromosome.substring(3);
        }
        return chromosome;
    }

    private void checkChromosome(String httpChrom) throws ParameterException {
        String chr = this.getCurSet().getChromosome();
        if (!httpChrom.equals(chr)) {
            throw new ParameterException("Requested chromosome " + httpChrom + " is not " + "currently active(" + chr + ")");
        }
    }

    private void checkRegion(Region region) throws ParameterException {
        this.checkChromosome(region.getChromosome());
        int curStart = this.getCurSet().getStart();
        int curEnd = this.getCurSet().getEnd();
        if (region.getEnd() < curStart || region.getStart() > curEnd) {
            throw new ParameterException("Region " + region + " outside of current region");
        }
        if (region.getStart() < curStart) {
            region.setStart(curStart);
        }
        if (region.getEnd() > curEnd) {
            region.setEnd(curEnd);
        }
    }

    private Region getHttpRegion(Map requestMap) throws ParameterException {
        String chrom = this.getChromosome(requestMap);
        int start = this.getStart(requestMap);
        int end = this.getEnd(requestMap);
        return new Region(chrom, start, end);
    }

    private int getStart(Map requestMap) throws ParameterException {
        return this.getNumber(requestMap, "start");
    }

    private int getEnd(Map requestMap) throws ParameterException {
        return this.getNumber(requestMap, "end");
    }

    private int getNumber(Map requestMap, String key) throws ParameterException {
        String numString = this.getStringParameter(requestMap, key);
        if (numString == null) {
            throw new ParameterException("No " + key + " specified");
        }
        this.debugPrint("got " + key + " with value " + numString);
        try {
            return Integer.parseInt(numString);
        }
        catch (NumberFormatException e) {
            throw new ParameterException(key + " is not a number");
        }
    }

    private String getStringParameter(Map map, String key) {
        Object o = map.get(key);
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof String[]) {
            return ((String[])o)[0];
        }
        return o.toString();
    }

    private void selectRegionInApollo(Region region) {
        BaseFocusEvent bfe = new BaseFocusEvent((Object)this, region);
        this.getCurState().getController().handleBaseFocusEvent(bfe);
    }

    private GuiCurationState getCurState() {
        return CurationManager.getActiveCurationState();
    }

    private CurationSet getCurSet() {
        return this.getCurState().getCurationSet();
    }

    private void debugPrint(String m) {
        if (Config.DEBUG) {
            System.out.println(m);
        }
    }

    private class ParameterException
    extends Exception {
        private ParameterException(String m) {
            super(m);
        }
    }
}

