/*
 * Decompiled with CFR 0.152.
 */
package apollo.editor;

import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.RangeI;
import apollo.datamodel.SeqFeatureI;
import apollo.editor.AnnotationChangeEvent;
import apollo.editor.AnnotationEditor;
import apollo.editor.CompoundTransaction;
import apollo.editor.Transaction;
import apollo.editor.TransactionSubpart;
import apollo.editor.UpdateTransaction;
import apollo.gui.ControlledObjectI;
import apollo.gui.Controller;
import apollo.util.FeatureList;
import java.util.Vector;

public class ChangeList
implements ControlledObjectI {
    private Vector changes = new Vector();
    private Controller controller;
    private AnnotationEditor annotEditor;

    public ChangeList(Controller c) {
        this.setController(c);
    }

    ChangeList(AnnotationEditor editor, Controller c) {
        this.annotEditor = editor;
        this.setController(c);
    }

    public Controller getController() {
        return this.controller;
    }

    public void setController(Controller c) {
        this.controller = c;
    }

    public Object getControllerWindow() {
        return null;
    }

    public boolean needsAutoRemoval() {
        return true;
    }

    boolean hasChanges() {
        return this.changes.size() > 0;
    }

    public void addChange(AnnotationChangeEvent evt) {
        if (evt == null) {
            return;
        }
        this.changes.addElement(evt);
    }

    void addTransaction(Transaction trans) {
        trans.setSource(this.annotEditor);
        this.addChange(trans.generateAnnotationChangeEvent());
    }

    public void addChangeList(ChangeList changeList) {
        if (changeList == null) {
            return;
        }
        for (int i = 0; i < changeList.size(); ++i) {
            this.addChange(changeList.getChange(i));
        }
    }

    private int size() {
        return this.changes.size();
    }

    private AnnotationChangeEvent getChange(int i) {
        return (AnnotationChangeEvent)this.changes.get(i);
    }

    void insertChange(int position, AnnotationChangeEvent evt) {
        this.changes.add(position, evt);
    }

    private void addTranscriptAndGeneRangeChanges() {
        CompoundTransaction annotRanges;
        if (this.annotEditor == null) {
            return;
        }
        CompoundTransaction ranges = new CompoundTransaction(this.annotEditor);
        CompoundTransaction transRanges = this.addAnnotRangeChanges(this.annotEditor.getOldTranscripts(), this.annotEditor.getNewTranscripts());
        if (transRanges != null && transRanges.hasKids()) {
            ranges.addTransaction(transRanges);
        }
        if ((annotRanges = this.addAnnotRangeChanges(this.annotEditor.getOldTopAnnots(), this.annotEditor.getNewTopAnnots())) != null && annotRanges.hasKids()) {
            ranges.addTransaction(annotRanges);
        }
        if (ranges.hasKids()) {
            if (this.haveOnlyOneCompoundChange()) {
                this.getChange(0).addTransaction(ranges);
            } else {
                this.addChange(ranges.generateAnnotationChangeEvent());
            }
        }
        this.annotEditor.synchOldAnnots();
    }

    private boolean haveOnlyOneCompoundChange() {
        return this.size() == 1 && this.getChange(0).isCompound();
    }

    private CompoundTransaction addAnnotRangeChanges(FeatureList oldAnnots, FeatureList newAnnots) {
        if (oldAnnots == null || newAnnots == null) {
            return null;
        }
        CompoundTransaction compTrans = new CompoundTransaction(this.annotEditor);
        TransactionSubpart ts = TransactionSubpart.LIMITS;
        for (int i = 0; i < oldAnnots.size(); ++i) {
            SeqFeatureI oldAnnot = oldAnnots.getFeature(i);
            SeqFeatureI newAnnot = newAnnots.getFeatWithName(oldAnnot.getName());
            if (newAnnot == null || this.hasBeenDeleted(newAnnot)) continue;
            AnnotatedFeatureI af = newAnnot.getAnnotatedFeature();
            if (!oldAnnot.sameRange(newAnnot)) {
                UpdateTransaction ut = new UpdateTransaction(af, ts);
                ut.setOldSubpartValue(oldAnnot);
                compTrans.addTransaction(ut);
            }
            if (!newAnnot.isTranscript() || this.translationRangeEqual(oldAnnot, newAnnot)) continue;
            RangeI oldRange = oldAnnot.getTranslation().getTranslationRange();
            Transaction t = this.annotEditor.updatePeptideRange(newAnnot, oldRange);
            compTrans.addTransaction(t);
        }
        if (!compTrans.hasKids()) {
            return null;
        }
        return compTrans;
    }

    private boolean hasBeenDeleted(SeqFeatureI sf) {
        return sf.getRefFeature().getFeatureIndex(sf) == -1;
    }

    private boolean translationRangeEqual(SeqFeatureI oldAnnot, SeqFeatureI newAnnot) {
        RangeI r = oldAnnot.getTranslation().getTranslationRange();
        return r.sameRange(newAnnot.getTranslation().getTranslationRange());
    }

    private void coalesceChanges(SeqFeatureI root) {
        for (int i = 0; i < this.size(); ++i) {
            AnnotationChangeEvent parent_evt = this.getChange(i);
            if (!parent_evt.isDelete()) continue;
            SeqFeatureI parent = parent_evt.getAnnotTop().getRefFeature();
            for (int j = i + 1; j < this.size(); ++j) {
                AnnotationChangeEvent child_evt = this.getChange(j);
                if (child_evt.getAnnotTop() != parent || !child_evt.isDelete()) continue;
                System.out.println("FCC: Redundant delete of " + parent.getName());
                this.changes.removeElementAt(j);
            }
        }
    }

    public void executeChanges() {
        this.addTranscriptAndGeneRangeChanges();
        this.coalesceChanges(null);
        AnnotationChangeEvent ace = null;
        for (int i = 0; i < this.size(); ++i) {
            AnnotationChangeEvent evt = this.getChange(i);
            if (evt.getOperation() == 5) {
                ace = evt;
                continue;
            }
            this.fireAnnotationChangeEvent(evt);
        }
        this.changes.clear();
        if (ace != null) {
            this.fireAnnotationChangeEvent(ace);
        }
    }

    private void fireAnnotationChangeEvent(AnnotationChangeEvent evt) {
        this.getController().handleAnnotationChangeEvent(evt);
    }
}

