/*
 * Decompiled with CFR 0.152.
 */
package apollo.editor;

import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.Comment;
import apollo.datamodel.RangeI;
import apollo.datamodel.SeqFeatureI;
import apollo.editor.AnnotationChangeEvent;
import apollo.editor.TransactionSubpart;
import apollo.editor.UpdateDetailsI;
import apollo.editor.UpdateTransaction;

public class AnnotationUpdateEvent
extends AnnotationChangeEvent
implements UpdateDetailsI {
    private SeqFeatureI oldParent;
    private RangeI oldRange;
    private boolean isIntUpdate = false;
    private int oldInt;
    private Comment oldComment;
    private int newSequencingErrorPosition;

    public AnnotationUpdateEvent(UpdateTransaction trans) {
        this(trans.getSource(), trans.getSeqFeature().getAnnotatedFeature(), trans.getSubpart(), true);
        this.setTransaction(trans);
    }

    public AnnotationUpdateEvent(Object source, AnnotatedFeatureI updateFeat, TransactionSubpart subpart) {
        super(source, updateFeat, subpart);
    }

    public AnnotationUpdateEvent(Object source, AnnotatedFeatureI updateFeat, TransactionSubpart subpart, boolean singularEvent) {
        this(source, updateFeat, subpart);
        this.setSingularEventState(singularEvent);
    }

    public boolean isUpdate() {
        return true;
    }

    public boolean isMove() {
        return this.getSubpart() == TransactionSubpart.PARENT;
    }

    protected String getOperationAsString() {
        return "UPDATE";
    }

    public UpdateDetailsI getUpdateDetails() {
        return this;
    }

    public boolean isStringUpdate() {
        return super.isStringChange();
    }

    void setOldParent(SeqFeatureI oldParent) {
        this.oldParent = oldParent;
    }

    public SeqFeatureI getOldParent() {
        if (this.oldParent == null && this.isMove() && this.hasTransaction() && this.getTransaction().getOldSubpartValue() instanceof SeqFeatureI) {
            this.oldParent = (SeqFeatureI)this.getTransaction().getOldSubpartValue();
        }
        return this.oldParent;
    }

    void setOldRange(RangeI oldRange) {
        this.oldRange = oldRange;
    }

    public boolean isRangeUpdate() {
        return this.getSubpart().isLimits();
    }

    public RangeI getOldRange() {
        return this.oldRange;
    }

    void setNewSequencingErrorPosition(int pos) {
        this.newSequencingErrorPosition = pos;
    }

    public int getNewSequencingErrorPosition() {
        return this.newSequencingErrorPosition;
    }

    void setOldInt(int oldInt) {
        this.oldInt = oldInt;
        this.isIntUpdate = true;
    }

    public int getOldInt() {
        return this.oldInt;
    }

    public boolean isIntUpdate() {
        return this.isIntUpdate;
    }

    public boolean isBooleanUpdate() {
        return this.getSubpart().isBoolean();
    }

    public void setOldComment(Comment oldComment) {
        this.oldComment = oldComment;
    }

    public Comment getOldComment() {
        return this.oldComment;
    }

    public boolean isCommentUpdate() {
        return this.oldComment != null;
    }
}

