/*
 * Decompiled with CFR 0.152.
 */
package apollo.datamodel.seq;

import apollo.datamodel.Sequence;
import apollo.datamodel.SequenceI;
import apollo.datamodel.seq.AbstractLazySequence;
import apollo.datamodel.seq.LazySequenceI;
import apollo.gui.Controller;
import apollo.gui.ControllerDebugListener;

public class DebugLazySequence
extends AbstractLazySequence
implements LazySequenceI {
    String residues;

    public DebugLazySequence(String id, Controller c, String res) {
        super(id, c);
        this.setResidues(res);
        this.cacher.setMinChunkSize(20);
    }

    public void setResidues(String seq) {
        this.residues = seq;
        this.setLength(this.residues.length());
    }

    public int getLength() {
        return this.residues.length();
    }

    public SequenceI getSubSequence(int start, int end) {
        return new Sequence(this.getName(), this.getResidues(start, end));
    }

    protected String getResiduesFromSourceImpl(int low, int high) {
        Sequence tmpSeq = new Sequence("tmp", this.residues);
        String seq = "";
        seq = tmpSeq.getResidues(low + 1, high + 1);
        return seq;
    }

    public static void main(String[] argv) {
        Controller c = new Controller();
        DebugLazySequence seq = new DebugLazySequence("Dummy", c, "AAAAAAAAAACCCCCCCCCCGGGGGGGGGGTTTTTTTTTTAAAAAAAAAA");
        DebugLazySequence seq2 = new DebugLazySequence("Dummy", c, "ABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZ");
        ControllerDebugListener dl = new ControllerDebugListener(c);
        System.out.println("Sequence first 10 = " + seq.getResidues(1, 10));
        System.out.println("Sequence 30-40 = " + seq.getResidues(30, 40));
        System.out.println("Sequence 24-40 = " + seq.getResidues(24, 40));
        System.out.println("Sequence 2-40 = " + seq.getResidues(2, 40));
        System.out.println("Sequence 40-2 = " + seq.getResidues(40, 2));
        System.out.println("Alphabetic Sequence first 10 = " + seq2.getResidues(1, 10));
        System.out.println("Alphabetic Sequence 40-50 = " + seq2.getResidues(40, 50));
        System.out.println("Alphabetic Sequence 34-52 = " + seq2.getResidues(34, 52));
        System.out.println("Alphabetic Sequence 2-80 = " + seq2.getResidues(2, 80));
    }
}

