/*
 * Decompiled with CFR 0.152.
 */
package apollo.datamodel.seq;

import apollo.datamodel.seq.LazySequenceI;
import java.util.Vector;
import org.bdgp.util.Range;
import org.bdgp.util.RangeHash;

public class CacheSequenceLoader {
    LazySequenceI parent;
    int minChunkSize = 50000;
    RangeHash sequenceRanges = new RangeHash();
    int currentSize = 0;
    int maxSize = 500000;

    public CacheSequenceLoader(LazySequenceI parent) {
        this.parent = parent;
    }

    public void setMinChunkSize(int size) {
        this.minChunkSize = size;
    }

    public void setMaxSize(int size) {
        this.maxSize = size;
    }

    public String getResidues(int low, int high) {
        boolean gotCompleteMatch = false;
        if (this.currentSize > this.maxSize) {
            this.clearCache();
        }
        if (this.parent.getLength() == 0) {
            return null;
        }
        int chunkedLow = low / this.minChunkSize * this.minChunkSize;
        int chunkedHigh = (high + this.minChunkSize) / this.minChunkSize * this.minChunkSize - 1;
        chunkedHigh = chunkedHigh > this.parent.getRange().getHigh() ? this.parent.getRange().getHigh() : chunkedHigh;
        chunkedLow = chunkedLow < this.parent.getRange().getLow() ? this.parent.getRange().getLow() : chunkedLow;
        Vector existingRanges = this.sequenceRanges.get(chunkedLow, chunkedHigh);
        String seqStr = null;
        StringBuffer seqBuff = new StringBuffer(this.minChunkSize);
        if (existingRanges.size() > 0) {
            SequenceRange range = (SequenceRange)existingRanges.elementAt(0);
            if (existingRanges.size() == 1 && range.getLow() <= chunkedLow && range.getHigh() > chunkedHigh - 1) {
                chunkedLow = range.getLow();
                chunkedHigh = range.getHigh();
                seqStr = range.getSeqString();
                gotCompleteMatch = true;
            } else {
                if (range.getLow() > chunkedLow) {
                    seqBuff.append(this.parent.getResiduesFromSource(chunkedLow, range.getLow() - 1));
                    this.currentSize += range.getLow() - chunkedLow - 1;
                } else if (range.getLow() <= chunkedLow) {
                    chunkedLow = range.getLow();
                }
                seqBuff.append(range.getSeqString());
                for (int i = 0; i < existingRanges.size() - 1; ++i) {
                    SequenceRange range2;
                    int end;
                    range = (SequenceRange)existingRanges.elementAt(i);
                    int start = range.getHigh() + 1;
                    if (start < (end = (range2 = (SequenceRange)existingRanges.elementAt(i + 1)).getLow() - 1)) {
                        seqBuff.append(this.parent.getResiduesFromSource(start, end));
                        this.currentSize += end - start + 1;
                    }
                    seqBuff.append(range2.getSeqString());
                }
                range = (SequenceRange)existingRanges.lastElement();
                if (range.getHigh() < chunkedHigh) {
                    seqBuff.append(this.parent.getResiduesFromSource(range.getHigh() + 1, chunkedHigh));
                    this.currentSize += chunkedHigh - range.getHigh();
                } else {
                    chunkedHigh = range.getHigh();
                }
                seqStr = seqBuff.toString();
            }
        } else {
            seqStr = this.parent.getResiduesFromSource(chunkedLow, chunkedHigh);
        }
        if (seqStr == null) {
            return null;
        }
        if (existingRanges.size() != 1 || !gotCompleteMatch) {
            SequenceRange newRange = new SequenceRange(seqStr, chunkedLow, chunkedHigh);
            this.sequenceRanges.put((Range)newRange, (Object)newRange);
        }
        return seqStr.substring(low - chunkedLow, high - chunkedLow + 1);
    }

    public void clearCache() {
        this.sequenceRanges = new RangeHash();
        this.currentSize = 0;
    }

    protected class SequenceRange
    implements Range {
        String seqString;
        int low;
        int high;

        public SequenceRange(String seqString, int low, int high) {
            this.seqString = seqString;
            this.low = low;
            this.high = high;
            if (seqString.length() != high - low + 1) {
                System.err.println("ERROR: seqString length inconsistent with range for:");
                System.err.println("       seqString = " + seqString);
                System.err.println("       low = " + low + " high = " + high);
                System.err.println("       seqString length = " + seqString.length() + " high-low+1 = " + (high - low + 1));
                new Throwable().printStackTrace();
            }
        }

        public int getLow() {
            return this.low;
        }

        public int getHigh() {
            return this.high;
        }

        public int getLength() {
            return this.seqString.length();
        }

        public String getSeqString() {
            return this.seqString;
        }

        public String toString() {
            return "(" + this.getLow() + "," + this.getHigh() + ") = " + this.seqString;
        }
    }
}

