/*
 * Decompiled with CFR 0.152.
 */
package apollo.datamodel;

import apollo.config.Config;
import apollo.datamodel.AnnotatedFeature;
import apollo.datamodel.CurationSet;
import apollo.datamodel.SequenceI;
import java.io.Serializable;

public class SequenceEdit
extends AnnotatedFeature
implements Serializable {
    SequenceI refSeq;
    String residue;

    public SequenceEdit(SequenceI refSeq, String edit_type, int position, String residue) {
        this(edit_type, position, residue);
        if (Config.DEBUG) {
            System.out.println("seq edit from jalview");
        }
        this.refSeq = refSeq;
        refSeq.addSequenceEdit(this);
    }

    public SequenceEdit(String edit_type, int position, String residue) {
        this.setLow(position);
        this.setHigh(position);
        this.setFeatureType(edit_type);
        if (edit_type.equals("substitution") || edit_type.equals("nucleotide_insertion")) {
            if (residue != null) {
                this.residue = residue;
            } else {
                System.err.println("Substition/Insertion genomic sequence error but no base provided");
                this.residue = "N";
            }
        }
    }

    public SequenceEdit(String res) {
        this.residue = res;
    }

    public int getPosition() {
        return this.getLow();
    }

    public String getResidue() {
        return this.residue;
    }

    public SequenceI getRefSequence() {
        return this.refSeq;
    }

    public void setRefSequence(SequenceI refSeq) {
        if (refSeq == null) {
            if (CurationSet.DEBUG) {
                System.out.println("Error: seq edit getting null ref seq");
            }
            return;
        }
        this.refSeq = refSeq;
        refSeq.addSequenceEdit(this);
    }

    public String getEditType() {
        return this.getFeatureType();
    }

    public static boolean typeIsSeqError(String type) {
        return type.equals("nucleotide_insertion") || type.equals("nucleotide_deletion") || type.equals("substitution");
    }

    String getHashKey() {
        return this.getPosition() + "";
    }
}

