/*
 * Decompiled with CFR 0.152.
 */
package apollo.datamodel;

import apollo.datamodel.ApolloDataI;
import apollo.datamodel.CompositeDataHolder;
import apollo.datamodel.FeatureSet;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.GenomicRange;
import apollo.datamodel.RangeI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceI;
import apollo.datamodel.StrandedFeatureSet;
import apollo.datamodel.StrandedFeatureSetI;
import apollo.editor.TransactionManager;
import apollo.util.FeatureList;
import apollo.util.Visitor;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class CurationSet
extends GenomicRange
implements Serializable,
ApolloDataI {
    public static boolean DEBUG = false;
    private HashMap childCurationSets = new HashMap();
    private Vector childSetOrderedNames = new Vector();
    private StrandedFeatureSetI results;
    private StrandedFeatureSetI annots;
    protected Vector sequence_vect = new Vector();
    protected Hashtable sequence_hash = new Hashtable();
    private String assemblyType = null;
    private TransactionManager tranManager;
    private String inputFile = null;

    public CurationSet() {
    }

    public CurationSet(StrandedFeatureSetI strandedFeatureSetI, StrandedFeatureSetI strandedFeatureSetI2, String string) {
        this.setName(string);
        this.results = strandedFeatureSetI;
        this.annots = strandedFeatureSetI2;
    }

    public HashMap getChildCurationSets() {
        return this.childCurationSets;
    }

    public void setChildSetOrderedNames(Vector vector) {
        this.childSetOrderedNames = vector;
    }

    public Vector getChildSetOrderedNames() {
        return this.childSetOrderedNames;
    }

    public void addCurationSet(Object object, CurationSet curationSet) {
        this.getChildCurationSets().put(object, curationSet);
    }

    public CurationSet getCurationSet(Object object) {
        return (CurationSet)this.getChildCurationSets().get(object);
    }

    private void throwExceptionIfTrueComposite() {
        if (this.getChildCurationSets().size() > 0) {
            throw new IllegalStateException("Attempt to access a true composite curation set as if it were a leaf");
        }
    }

    public void setRefSequence(SequenceI sequenceI) {
        this.throwExceptionIfTrueComposite();
        if (sequenceI == null) {
            System.err.println("setRefSequence: ref seq is null!");
            return;
        }
        super.setRefSequence(sequenceI);
        sequenceI.setRange(this);
    }

    public StrandedFeatureSetI getAnnots() {
        this.throwExceptionIfTrueComposite();
        return this.annots;
    }

    public StrandedFeatureSetI getResults() {
        this.throwExceptionIfTrueComposite();
        return this.results;
    }

    public void setResults(StrandedFeatureSetI strandedFeatureSetI) {
        this.throwExceptionIfTrueComposite();
        if (strandedFeatureSetI == null) {
            System.out.println("CurationSet.setResults: results was null--creating new results set.");
            strandedFeatureSetI = new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet());
        }
        this.results = strandedFeatureSetI;
        if (this.getRefSequence() != null && strandedFeatureSetI.getRefSequence() == null) {
            strandedFeatureSetI.setRefSequence(this.getRefSequence());
        }
    }

    public String getAssemblyType() {
        this.throwExceptionIfTrueComposite();
        return this.assemblyType;
    }

    public void setAssemblyType(String string) {
        this.throwExceptionIfTrueComposite();
        this.assemblyType = string;
    }

    public String getInputFilename() {
        return this.inputFile;
    }

    public void setInputFilename(String string) {
        this.inputFile = string;
    }

    public void setAnnots(StrandedFeatureSetI strandedFeatureSetI) {
        this.throwExceptionIfTrueComposite();
        this.annots = strandedFeatureSetI;
        if (this.getRefSequence() != null && strandedFeatureSetI.getRefSequence() == null) {
            strandedFeatureSetI.setRefSequence(this.getRefSequence());
        }
    }

    public SequenceI addSequence(SequenceI sequenceI) {
        this.throwExceptionIfTrueComposite();
        if (!this.sequence_vect.contains(sequenceI) && this.sequence_hash.get(sequenceI.getName()) == null) {
            this.sequence_vect.addElement(sequenceI);
            this.sequence_hash.put(sequenceI.getName(), sequenceI);
        }
        return (SequenceI)this.sequence_hash.get(sequenceI.getName());
    }

    public Vector getSequences() {
        this.throwExceptionIfTrueComposite();
        return this.sequence_vect;
    }

    public SequenceI getSequence(String string) {
        this.throwExceptionIfTrueComposite();
        if (this.sequence_hash == null || string == null) {
            return null;
        }
        return (SequenceI)this.sequence_hash.get(string);
    }

    public void removeSequence(SequenceI sequenceI) {
        this.throwExceptionIfTrueComposite();
        this.sequence_vect.removeElement(sequenceI);
        this.sequence_hash.remove(sequenceI.getName());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getChildCurationSets().size() > 0) {
            Set set = this.getChildCurationSets().keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(this.getCurationSet(iterator.next().toString()));
            }
        } else {
            String string;
            String string2 = this.getName();
            if (this.getStart() > 0 && this.getRefSequence() != null && !this.getRefSequence().getName().equals(this.getName()) && !(string = this.getRefSequence().getName() + ":" + this.getStart() + "-" + this.getEnd()).equals(string2)) {
                string2 = string2 + " from " + string;
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public boolean contains(RangeI rangeI) {
        return this.overlaps(rangeI) && this.getLeftOverlap(rangeI) <= 0 && this.getRightOverlap(rangeI) <= 0;
    }

    public boolean overlaps(RangeI rangeI) {
        return this.getLow() <= rangeI.getHigh() && this.getHigh() >= rangeI.getLow();
    }

    public boolean isCurationSet() {
        return true;
    }

    public CurationSet getCurationSet() {
        return this;
    }

    public boolean isCompositeDataHolder() {
        return false;
    }

    public CompositeDataHolder getCompositeDataHolder() {
        if (this.isMultiSpecies()) {
            return new CompositeDataHolder(this);
        }
        return null;
    }

    public boolean isMultiSpecies() {
        return this.getChildCurationSets().size() > 0;
    }

    public FeatureList getAnalysisFeatureList(String string) {
        SeqFeatureI seqFeatureI;
        SeqFeatureI seqFeatureI2 = this.getAnalysisFeatureSet(this.getResults().getForwardSet(), string);
        if (seqFeatureI2 == null) {
            seqFeatureI2 = this.getAnalysisFeatureSet(this.getAnnots().getForwardSet(), string);
        }
        if ((seqFeatureI = this.getAnalysisFeatureSet(this.getResults().getReverseSet(), string)) == null) {
            seqFeatureI = this.getAnalysisFeatureSet(this.getAnnots().getReverseSet(), string);
        }
        FeatureList featureList = new FeatureList();
        featureList.addFeature(seqFeatureI2);
        featureList.addFeature(seqFeatureI);
        return featureList;
    }

    private SeqFeatureI getAnalysisFeatureSet(SeqFeatureI seqFeatureI, String string) {
        for (int i = 0; i < seqFeatureI.getNumberOfChildren(); ++i) {
            SeqFeatureI seqFeatureI2 = seqFeatureI.getFeatureAt(i);
            if (seqFeatureI2.getTopLevelType() == "no_type") {
                SeqFeatureI seqFeatureI3 = this.getAnalysisFeatureSet(seqFeatureI2, string);
                if (seqFeatureI3 == null) continue;
                return seqFeatureI3;
            }
            if (!seqFeatureI2.getTopLevelType().equals(string)) continue;
            if (DEBUG) {
                System.out.println("#### found feat with type " + string + " child " + seqFeatureI2 + " chil top lev type " + seqFeatureI2.getTopLevelType());
            }
            return seqFeatureI2;
        }
        return null;
    }

    public boolean hasTransactions() {
        return this.tranManager != null && this.tranManager.hasTransactions();
    }

    public boolean hasTransactionManager() {
        return this.tranManager != null;
    }

    public TransactionManager getTransactionManager() {
        return this.tranManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.tranManager = transactionManager;
    }

    public boolean isChromosomeArmUsed() {
        SequenceI sequenceI = this.getRefSequence();
        return sequenceI != null && sequenceI.getName() != null && !this.getName().equals(sequenceI.getName());
    }
}

