/*
 * Decompiled with CFR 0.152.
 */
package apollo.datamodel;

import apollo.datamodel.ChromosomeBand;
import java.util.Vector;

public class Chromosome {
    private String display_id;
    private int length;
    private int plength;
    private int qlength;
    private int centrolength;
    private Vector bands;
    private String species_name;
    private String coord_system;

    public Chromosome(String species_name, String id, Vector bands) {
        this.display_id = id;
        this.species_name = species_name;
        this.parse_bands(bands);
    }

    public Chromosome(String species_name, String id, int length) {
        this.display_id = id;
        this.length = length;
        this.species_name = species_name;
    }

    public Chromosome(String species_name, String id, int plength, int centrolength, int qlength) {
        this(species_name, id, plength + qlength + centrolength);
        this.plength = plength;
        this.qlength = qlength;
        this.centrolength = centrolength;
    }

    public String getSpeciesName() {
        return this.species_name;
    }

    private void parse_bands(Vector tmpbands) {
        int qstart = 1000000000;
        int qend = 0;
        int pstart = 1000000000;
        int pend = 0;
        int cstart = 1000000000;
        int cend = 0;
        for (int i = 0; i < tmpbands.size(); ++i) {
            ChromosomeBand band = (ChromosomeBand)tmpbands.elementAt(i);
            if (band.getStain().equals("acen")) {
                if (band.getChrEnd() > cend) {
                    cend = band.getChrEnd();
                }
                if (band.getChrStart() >= cstart) continue;
                cstart = band.getChrStart();
                continue;
            }
            if (band.getDisplayId().indexOf("p") == 0) {
                if (band.getChrEnd() > pend) {
                    pend = band.getChrEnd();
                }
                if (band.getChrStart() >= pstart) continue;
                pstart = band.getChrStart();
                continue;
            }
            if (band.getDisplayId().indexOf("q") == 0) {
                if (band.getChrEnd() > qend) {
                    qend = band.getChrEnd();
                }
                if (band.getChrStart() >= qstart) continue;
                qstart = band.getChrStart();
                continue;
            }
            if (band.getChrEnd() > qend) {
                qend = band.getChrEnd();
            }
            if (band.getChrStart() >= qstart) continue;
            qstart = band.getChrStart();
        }
        if (qend > 0) {
            if (pend <= qstart) {
                cstart = pend + 1;
                cend = qstart - 1;
            }
        } else {
            pstart = cstart - 1;
            pend = cstart - 1;
        }
        this.bands = tmpbands;
        this.plength = pend;
        this.centrolength = cend - cstart + 1;
        this.qlength = qend - qstart + 1;
        this.length = this.plength + this.centrolength + this.qlength;
    }

    public String getDisplayId() {
        return this.display_id;
    }

    public int getLength() {
        return this.length;
    }

    public int getPlength() {
        return this.plength;
    }

    public int getQlength() {
        return this.qlength;
    }

    public int getCentroLength() {
        return this.centrolength;
    }

    public Vector getBands() {
        return this.bands;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setPLength(int length) {
        this.plength = length;
    }

    public void setQLength(int length) {
        this.qlength = length;
    }

    public void setCentroLength(int length) {
        this.centrolength = length;
    }

    public void setCoordSystem(String coordSys) {
        this.coord_system = coordSys;
    }

    public String getCoordSystem() {
        return this.coord_system;
    }
}

