/*
 * Decompiled with CFR 0.152.
 */
package apollo.datamodel;

import apollo.config.Config;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.Comment;
import apollo.datamodel.Evidence;
import apollo.datamodel.EvidenceFinder;
import apollo.datamodel.EvidenceSet;
import apollo.datamodel.FeatureSet;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.Identifier;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceI;
import apollo.datamodel.Synonym;
import apollo.util.Visitor;
import java.util.Vector;

public class AnnotatedFeature
extends FeatureSet
implements AnnotatedFeatureI {
    private EvidenceSet evidenceSet = new EvidenceSet();
    private EvidenceFinder finder;
    private Vector comment_list;
    private boolean isProblematic = false;
    protected boolean annotationRoot = true;
    protected String owner = null;

    public AnnotatedFeature() {
        this.init();
    }

    public AnnotatedFeature(SeqFeatureI sf) {
        super(sf);
        this.init();
    }

    public AnnotatedFeature(FeatureSetI fs, String class_name) {
        super(fs, class_name);
        this.init();
    }

    private void init() {
        if (this.getFeatureType() == null || this.getFeatureType().equals("no_type")) {
            this.setFeatureType("gene");
        }
        this.evidenceSet = new EvidenceSet();
    }

    public AnnotatedFeatureI cloneAnnot() {
        return (AnnotatedFeatureI)this.cloneFeature();
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return new String(this.getName());
    }

    public Vector getEvidence() {
        return this.evidenceSet.getEvidence();
    }

    public void addEvidence(String evidenceId, String setId, int type) {
        this.evidenceSet.addEvidence(new Evidence(evidenceId, setId, type));
    }

    public void addEvidence(String evidenceId) {
        this.evidenceSet.addEvidence(new Evidence(evidenceId));
    }

    public void addEvidence(String evidenceId, int type) {
        this.evidenceSet.addEvidence(new Evidence(evidenceId, type));
    }

    public void addEvidence(Evidence evidence) {
        this.evidenceSet.addEvidence(evidence);
    }

    public int deleteEvidence(String evidenceId) {
        return this.evidenceSet.deleteEvidence(evidenceId);
    }

    public void setEvidenceFinder(EvidenceFinder ef) {
        this.finder = ef;
        int feat_count = this.size();
        for (int i = 0; i < feat_count; ++i) {
            SeqFeatureI sf = this.getFeatureAt(i);
            if (!(sf instanceof AnnotatedFeatureI)) continue;
            ((AnnotatedFeatureI)sf).setEvidenceFinder(ef);
        }
    }

    public EvidenceFinder getEvidenceFinder() {
        return this.finder;
    }

    public Vector getComments() {
        if (this.comment_list == null) {
            this.comment_list = new Vector(1);
        }
        return this.comment_list;
    }

    public int getCommentIndex(Comment comm) {
        return this.getComments().indexOf(comm);
    }

    public void addComment(Comment comm) {
        this.addComment(this.getComments().size(), comm);
    }

    public void addComment(int index, Comment comm) {
        if (comm != null && comm.getText() != null) {
            this.getComments().add(index, comm);
        } else if (Config.DEBUG) {
            System.err.println("Error AnnFeat.addComment comment or comment text is null\ncomment: " + comm);
        }
    }

    public void deleteComment(Comment comm) {
        if (comm != null && comm.getText() != null) {
            if (this.comment_list == null) {
                this.comment_list = new Vector(1);
            }
            this.comment_list.remove(comm);
        }
    }

    public void deleteComment(int i) {
        if (i >= this.comment_list.size()) {
            System.err.println("Deleting comment out of range " + i);
            return;
        }
        this.comment_list.remove(i);
    }

    public void clearComments() {
        this.comment_list = null;
    }

    public Object clone() {
        AnnotatedFeatureI clone = (AnnotatedFeatureI)super.clone();
        if (clone != null) {
            clone.clearComments();
            for (int i = 0; i < this.getComments().size(); ++i) {
                Comment comm = (Comment)((Comment)this.getComments().elementAt(i)).clone();
                clone.addComment(comm);
            }
            clone.setIdentifier((Identifier)this.getIdentifier().clone());
        }
        return clone;
    }

    public boolean isProblematic() {
        return this.isProblematic;
    }

    public void setIsProblematic(boolean isProblematic) {
        this.isProblematic = isProblematic;
    }

    public void addSynonym(String syn) {
        this.getIdentifier().addSynonym(syn);
    }

    public void addSynonym(int index, String syn) {
        this.getIdentifier().addSynonym(index, syn);
    }

    public void addSynonym(Synonym syn) {
        this.getIdentifier().addSynonym(syn);
    }

    public Vector getSynonyms() {
        return this.getIdentifier().getSynonyms();
    }

    public Vector getSynonyms(boolean excludeInternalSynonyms) {
        return this.getIdentifier().getSynonyms(excludeInternalSynonyms);
    }

    public void deleteSynonym(String syn) {
        this.getIdentifier().deleteSynonym(syn);
    }

    public void deleteSynonym(Synonym syn) {
        this.getIdentifier().deleteSynonym(syn);
    }

    public void clearSynonyms() {
        this.getIdentifier().clearSynonyms();
    }

    public int getSynonymSize() {
        return this.getSynonyms().size();
    }

    public Synonym getSynonym(int i) {
        return (Synonym)this.getSynonyms().get(i);
    }

    public boolean hasSynonym(String name) {
        return this.getIdentifier().hasSynonym(name);
    }

    public boolean isProteinCodingGene() {
        return this.getFeatureType().equalsIgnoreCase("gene") || this.getFeatureType().equalsIgnoreCase("pseudogene");
    }

    public void setDescription(String desc) {
        this.getIdentifier().setDescription(desc);
    }

    public String getDescription() {
        return this.getIdentifier().getDescription();
    }

    public boolean isAnnotTop() {
        return this.annotationRoot;
    }

    public boolean hasAnnotatedFeature() {
        return true;
    }

    public AnnotatedFeatureI getAnnotatedFeature() {
        return this;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOwner() {
        return this.owner;
    }

    public int getNonConsensusAcceptorNum() {
        return -1;
    }

    public int getNonConsensusDonorNum() {
        return -1;
    }

    public boolean nonConsensusSplicingOkay() {
        return false;
    }

    public void nonConsensusSplicingOkay(boolean okay) {
    }

    public SequenceI get_cDNASequence() {
        return null;
    }

    public AnnotatedFeatureI getAnnotChild(int i) {
        return (AnnotatedFeatureI)this.getFeatureAt(i);
    }
}

