/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.synteny.builder;

import apollo.dataadapter.AbstractApolloAdapter;
import apollo.dataadapter.ApolloDataAdapterGUI;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.NonFatalDataAdapterException;
import apollo.dataadapter.ensj.EnsJAdapterGUI;
import apollo.dataadapter.synteny.builder.AdapterModel;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.bdgp.io.DataAdapter;
import org.bdgp.swing.AbstractDataAdapterUI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Model {
    private List allowedAdapterClasses;
    private List allowedAdapterTypes;
    private HashMap adapterSets;
    private List adapterModels;
    private AdapterModel selectedAdapterModel;
    public static String MODEL = "model";
    public static String ADAPTER_CLASSES = "adapter_classes";
    public static String CLASS = "class";
    public static String ADAPTER_TYPES = "adapter_types";
    public static String ADAPTER = "adapter";
    public static String ADAPTER_SET = "adapter_set";
    public static String NAME = "name";
    public static String TYPE = "type";
    public static String PROPERTY = "property";
    public static String KEY = "key";
    public static String VALUE = "value";
    public static String DEFAULT = "default";
    public static String SELECTED_SET = "selected_set";
    public static String SELECTED_NODE = "selected_node";
    private HashMap adapterMap = new HashMap();
    private HashMap adapterGUIMap = new HashMap();
    private boolean reloadTree = true;
    private boolean reloadAdapterPanel = true;
    private boolean reloadGUIs = true;
    private String message;
    private TreePath _treePath;
    private String _selectedAdapterSet;

    public Model() {
        this.adapterModels = new ArrayList();
        this.allowedAdapterClasses = new ArrayList();
        this.allowedAdapterTypes = new ArrayList();
        this.adapterSets = new HashMap();
    }

    public List getAdapterModels(String setName) {
        List adapterModels = (List)this.getAdapterSets().get(setName);
        return adapterModels;
    }

    public void addAdapterModel(String setName, AdapterModel model) {
        ArrayList<AdapterModel> set = (ArrayList<AdapterModel>)this.getAdapterSets().get(setName);
        if (set == null) {
            set = new ArrayList<AdapterModel>();
            this.getAdapterSets().put(setName, set);
        }
        set.add(model);
    }

    public void addAdapterSet(String setName) {
        ArrayList set = new ArrayList();
        this.getAdapterSets().put(setName, set);
    }

    public static Model fromXML() {
        String fileName = System.getProperty("APOLLO_ROOT");
        fileName = fileName + "/conf/adapterbuilder.conf";
        Model returnModel = new Model();
        Object name = null;
        Object textOfInterest = null;
        Object className = null;
        Object type = null;
        Object key = null;
        Object value = null;
        Object adapterKeySet = null;
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                throw new NonFatalDataAdapterException("The file: <APOLLO_ROOT>/conf/adapterbuilder.conf doesn't exist - can't create a Model");
            }
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(new File(fileName));
            Element root = document.getDocumentElement();
            if (!root.getTagName().equals(MODEL)) {
                throw new NonFatalDataAdapterException("I was expecting a config document with '<model>' root - I found a root of " + root.getTagName());
            }
            returnModel.populateAllowedAdapterClasses(root);
            returnModel.populateAllowedAdapterTypes(root);
            returnModel.populateAdapterSetsAndModels(root);
            returnModel.populateNodeSelections(root);
            return returnModel;
        }
        catch (SAXException exception) {
            throw new NonFatalDataAdapterException(exception.getMessage());
        }
        catch (IOException exception) {
            throw new NonFatalDataAdapterException(exception.getMessage());
        }
        catch (ParserConfigurationException exception) {
            throw new NonFatalDataAdapterException(exception.getMessage());
        }
    }

    private void populateNodeSelections(Element root) {
        NodeList selectedNodes = root.getElementsByTagName(SELECTED_SET);
        if (selectedNodes.getLength() > 0) {
            Element selectedNode = (Element)selectedNodes.item(0);
            Node textNode = selectedNode.getFirstChild();
            String setName = textNode.getNodeValue();
            this.setSelectedAdapterSet(setName);
            selectedNodes = root.getElementsByTagName(SELECTED_NODE);
            if (selectedNodes.getLength() > 0) {
                selectedNode = (Element)selectedNodes.item(0);
                textNode = selectedNode.getFirstChild();
                String name = textNode.getNodeValue();
                this.setSelectedAdapterName(setName, name);
            }
        }
    }

    private void populateAllowedAdapterClasses(Element root) {
        String textOfInterest = null;
        NodeList nodeList = root.getElementsByTagName(ADAPTER_CLASSES);
        if (nodeList.getLength() > 0) {
            NodeList childNodeList = nodeList.item(0).getChildNodes();
            for (int j = 0; j < childNodeList.getLength(); ++j) {
                if (!childNodeList.item(j).getNodeName().equals(CLASS)) continue;
                textOfInterest = childNodeList.item(j).getFirstChild().getNodeValue();
                this.getAllowedAdapterClasses().add(textOfInterest);
            }
        }
        this.getAllowedAdapterClasses().add("");
    }

    private void populateAllowedAdapterTypes(Element root) {
        String textOfInterest = null;
        this.getAllowedAdapterTypes().add("");
        NodeList nodeList = root.getElementsByTagName(ADAPTER_TYPES);
        if (nodeList.getLength() > 0) {
            NodeList childNodeList = nodeList.item(0).getChildNodes();
            for (int j = 0; j < childNodeList.getLength(); ++j) {
                if (!childNodeList.item(j).getNodeName().equals(TYPE)) continue;
                textOfInterest = childNodeList.item(j).getFirstChild().getNodeValue();
                this.getAllowedAdapterTypes().add(textOfInterest);
            }
        }
    }

    private void populateAdapterSetsAndModels(Element root) {
        String name = null;
        Object textOfInterest = null;
        NodeList nodeList = root.getElementsByTagName(ADAPTER_SET);
        if (nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element setNode = (Element)nodeList.item(i);
                NodeList nameNodeList = setNode.getElementsByTagName(NAME);
                Element nameNode = (Element)nameNodeList.item(0);
                Node textNode = nameNode.getFirstChild();
                name = textNode.getNodeValue();
                this.addAdapterSet(name);
                NodeList adapterModelsNodeList = setNode.getElementsByTagName(ADAPTER);
                this.addAdapterModelsForSet(name, adapterModelsNodeList);
            }
        } else {
            NodeList adapterModelsNodeList = root.getElementsByTagName(ADAPTER);
            this.addAdapterModelsForSet(DEFAULT, adapterModelsNodeList);
        }
    }

    private void addAdapterModelsForSet(String setName, NodeList nodeList) {
        String name = null;
        Object textOfInterest = null;
        String className = null;
        String type = null;
        AdapterModel adapterModel = null;
        String key = null;
        String value = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            name = "dummy_name";
            className = "dummy_class";
            type = "dummy_type";
            Properties adapterProperties = new Properties();
            NodeList adapterNodeList = nodeList.item(i).getChildNodes();
            for (int j = 0; j < adapterNodeList.getLength(); ++j) {
                Node textNode;
                if (adapterNodeList.item(j).getNodeName().equals(NAME) && (textNode = adapterNodeList.item(j).getFirstChild()) != null) {
                    name = textNode.getNodeValue();
                }
                if (adapterNodeList.item(j).getNodeName().equals(TYPE) && (textNode = adapterNodeList.item(j).getFirstChild()) != null) {
                    type = textNode.getNodeValue();
                }
                if (adapterNodeList.item(j).getNodeName().equals(CLASS) && (textNode = adapterNodeList.item(j).getFirstChild()) != null) {
                    className = textNode.getNodeValue();
                }
                if (!adapterNodeList.item(j).getNodeName().equals(PROPERTY)) continue;
                key = null;
                value = null;
                NodeList propertyNodeList = adapterNodeList.item(j).getChildNodes();
                for (int k = 0; k < propertyNodeList.getLength(); ++k) {
                    if (propertyNodeList.item(k).getNodeName().equals(KEY) && (textNode = propertyNodeList.item(k).getFirstChild()) != null) {
                        key = textNode.getNodeValue();
                    }
                    if (!propertyNodeList.item(k).getNodeName().equals(VALUE) || (textNode = propertyNodeList.item(k).getFirstChild()) == null) continue;
                    value = textNode.getNodeValue();
                }
                if (key == null || value == null) continue;
                adapterProperties.setProperty(key, value);
            }
            if (name == null || name.trim().length() < 0 || type == null || type.trim().length() < 0) {
                throw new NonFatalDataAdapterException("Found an adapter model with a null/missing name or type");
            }
            adapterModel = new AdapterModel(name, className, type);
            adapterModel.setProperties(adapterProperties);
            this.addAdapterModel(setName, adapterModel);
        }
    }

    public void createAdaptersAndGUIs(String setName) {
        Object adapterKeySet = null;
        this.getAdapterMap().clear();
        this.getAdapterGUIMap().clear();
        String className = null;
        if (setName == null) {
            return;
        }
        try {
            for (int i = 0; i < this.getAdapterModels(setName).size(); ++i) {
                Properties propertiesFromAdapterModel;
                AdapterModel model = (AdapterModel)this.getAdapterModels(setName).get(i);
                String key = model.getName();
                className = model.getAdapterClassName();
                Class<?> adapterClass = Class.forName(className);
                AbstractApolloAdapter adapter = (AbstractApolloAdapter)adapterClass.newInstance();
                AbstractDataAdapterUI gui = (AbstractDataAdapterUI)adapter.getUI(ApolloDataAdapterI.OP_READ_DATA);
                gui.setDataAdapter((DataAdapter)adapter);
                this.getAdapterMap().put(key, adapter);
                this.getAdapterGUIMap().put(key, gui);
                if (model.getType().equals(AdapterModel.CHILD_TYPE) && gui instanceof EnsJAdapterGUI) {
                    EnsJAdapterGUI egui = (EnsJAdapterGUI)gui;
                    egui.getController().handleEventForKey("HIDE_OR_SHOW_DATABASE");
                    egui.getController().handleEventForKey("HIDE_OR_SHOW_TYPES");
                    egui.getController().handleEventForKey("HIDE_OR_SHOW_LOCATION");
                }
                if ((propertiesFromAdapterModel = model.getProperties()).size() <= 0) continue;
                gui.setProperties(propertiesFromAdapterModel);
            }
        }
        catch (IllegalAccessException exception) {
            throw new NonFatalDataAdapterException("Couldn't access adapter class: " + className);
        }
        catch (InstantiationException exception) {
            throw new NonFatalDataAdapterException("Couldn't instantiate adapter class: " + className);
        }
        catch (ClassNotFoundException exception) {
            throw new NonFatalDataAdapterException("Couldn't find adapter class: " + className);
        }
    }

    public List getAllowedAdapterClasses() {
        return this.allowedAdapterClasses;
    }

    public List getAllowedAdapterTypes() {
        return this.allowedAdapterTypes;
    }

    private void setAllowedAdapterClasses(List newValue) {
        this.allowedAdapterClasses = newValue;
    }

    private void setAllowedAdapterTypes(List newValue) {
        this.allowedAdapterTypes = newValue;
    }

    public HashMap getAdapterMap() {
        return this.adapterMap;
    }

    public HashMap getAdapterGUIMap() {
        return this.adapterGUIMap;
    }

    public void toXML() {
        String fileName = System.getProperty("APOLLO_ROOT");
        fileName = fileName + "/conf/adapterbuilder.conf";
        StringBuffer buffer = new StringBuffer();
        try {
            int i;
            boolean result;
            File file = new File(fileName);
            if (!file.exists() && !(result = file.createNewFile())) {
                throw new NonFatalDataAdapterException("Failed to create builder config file: " + fileName);
            }
            buffer.append("<model>\n");
            buffer.append("\t<").append(ADAPTER_CLASSES).append(">\n");
            for (i = 0; i < this.getAllowedAdapterClasses().size(); ++i) {
                if (this.getAllowedAdapterClasses().get(i) == null || ((String)this.getAllowedAdapterClasses().get(i)).trim().length() <= 0) continue;
                buffer.append("\t\t<").append(CLASS).append(">").append(this.getAllowedAdapterClasses().get(i)).append("</").append(CLASS).append(">\n");
            }
            buffer.append("\t</" + ADAPTER_CLASSES + ">\n");
            buffer.append("\t<").append(ADAPTER_TYPES).append(">\n");
            for (i = 0; i < this.getAllowedAdapterTypes().size(); ++i) {
                if (this.getAllowedAdapterTypes().get(i) == null || ((String)this.getAllowedAdapterTypes().get(i)).trim().length() <= 0) continue;
                buffer.append("\t\t<").append(TYPE).append(">").append(this.getAllowedAdapterTypes().get(i)).append("</").append(TYPE).append(">\n");
            }
            buffer.append("\t</" + ADAPTER_TYPES + ">\n");
            if (this.getSelectedAdapterSet() != null) {
                buffer.append("\t<").append(SELECTED_SET).append(">").append(this.getSelectedAdapterSet()).append("</").append(SELECTED_SET).append(">\n");
                if (this.getSelectedAdapterModel() != null) {
                    buffer.append("\t<").append(SELECTED_NODE).append(">").append(this.getSelectedAdapterModel().getName()).append("</").append(SELECTED_NODE).append(">\n");
                }
            }
            Iterator adapterSets = this.getAdapterSets().keySet().iterator();
            while (adapterSets.hasNext()) {
                String setName = (String)adapterSets.next();
                buffer.append("\t<" + ADAPTER_SET + ">\n");
                buffer.append("\t\t<").append(NAME).append(">").append(setName).append("</").append(NAME).append(">\n");
                List adapterModels = (List)this.getAdapterSets().get(setName);
                for (i = 0; i < adapterModels.size(); ++i) {
                    AdapterModel adapterModel = (AdapterModel)adapterModels.get(i);
                    buffer.append(adapterModel.toXML("\t\t"));
                }
                buffer.append("\t</" + ADAPTER_SET + ">\n");
            }
            buffer.append("</" + MODEL + ">\n");
            FileWriter writer = new FileWriter(file);
            writer.write(buffer.toString());
            writer.flush();
            writer.close();
        }
        catch (IOException exception) {
            throw new NonFatalDataAdapterException("Problem writing to configuration file: " + fileName);
        }
    }

    public void setSelectedAdapterName(String setName, String name) {
        if (setName != null) {
            List adapterModels = this.getAdapterModels(setName);
            for (int i = 0; i < adapterModels.size(); ++i) {
                if (!((AdapterModel)adapterModels.get(i)).getName().equals(name)) continue;
                this.selectedAdapterModel = (AdapterModel)adapterModels.get(i);
            }
        } else {
            this.selectedAdapterModel = null;
        }
    }

    public void updateSelectedModelFromAdapter() {
        try {
            ApolloDataAdapterGUI adag;
            if (this.selectedAdapterModel != null && (adag = (ApolloDataAdapterGUI)this.getAdapterGUIMap().get(this.selectedAdapterModel.getName())) != null) {
                this.selectedAdapterModel.setProperties(adag.createStateInformation());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List getChildAdapterModels(String setName) {
        Iterator adapterModels = this.getAdapterModels(setName).iterator();
        ArrayList<AdapterModel> returnList = new ArrayList<AdapterModel>();
        while (adapterModels.hasNext()) {
            AdapterModel adapterModel = (AdapterModel)adapterModels.next();
            if (!adapterModel.getType().equals(AdapterModel.CHILD_TYPE)) continue;
            returnList.add(adapterModel);
        }
        return returnList;
    }

    public AdapterModel getMainAdapterModel(String setName) {
        Iterator adapterModels = this.getAdapterModels(setName).iterator();
        while (adapterModels.hasNext()) {
            AdapterModel adapterModel = (AdapterModel)adapterModels.next();
            if (!adapterModel.getType().equals(AdapterModel.MAIN_TYPE)) continue;
            return adapterModel;
        }
        return null;
    }

    public AbstractDataAdapterUI getMainAdapterGUI(String setName) {
        String key = this.getMainAdapterModel(setName).getName();
        return (AbstractDataAdapterUI)this.getAdapterGUIMap().get(key);
    }

    public List getChildAdapterGUIs(String setName) {
        List list = this.getChildAdapterModels(setName);
        ArrayList returnList = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            String key = ((AdapterModel)list.get(i)).getName();
            returnList.add(this.getAdapterGUIMap().get(key));
        }
        return returnList;
    }

    public AdapterModel getModelWithName(String setName, String name) {
        Iterator adapterModels = this.getAdapterModels(setName).iterator();
        while (adapterModels.hasNext()) {
            AdapterModel adapterModel = (AdapterModel)adapterModels.next();
            if (!adapterModel.getName().equals(name)) continue;
            return adapterModel;
        }
        return null;
    }

    public AdapterModel getSelectedAdapterModel() {
        return this.selectedAdapterModel;
    }

    public int getSelectedAdapterIndex(String setName) {
        return this.getAdapterModels(setName).indexOf(this.getSelectedAdapterModel());
    }

    public String getSelectedAdapterSet() {
        return this._selectedAdapterSet;
    }

    public boolean reloadTree() {
        return this.reloadTree;
    }

    public void setReloadTree(boolean newValue) {
        this.reloadTree = newValue;
    }

    public boolean reloadAdapterPanel() {
        return this.reloadAdapterPanel;
    }

    public void setReloadAdapterPanel(boolean newValue) {
        this.reloadAdapterPanel = newValue;
    }

    public boolean reloadGUIs() {
        return this.reloadGUIs;
    }

    public void setReloadGUIs(boolean newValue) {
        this.reloadGUIs = newValue;
    }

    public void setReloadAll() {
        this.setReloadTree(true);
        this.setReloadAdapterPanel(true);
        this.setReloadGUIs(true);
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public void setSelectedAdapterSet(String set) {
        this._selectedAdapterSet = set;
    }

    private void setAdapterSets(HashMap adapterSets) {
        this.adapterSets = adapterSets;
    }

    public HashMap getAdapterSets() {
        return this.adapterSets;
    }
}

