/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.otter.parser;

import apollo.dataadapter.otter.parser.OtterContentHandler;
import apollo.dataadapter.otter.parser.TagHandler;
import apollo.datamodel.Exon;
import apollo.datamodel.Transcript;
import org.xml.sax.Attributes;

public class ExonTagHandler
extends TagHandler {
    public void handleStartElement(OtterContentHandler theContentHandler, String namespaceURI, String localName, String qualifiedName, Attributes attributes) {
        super.handleStartElement(theContentHandler, namespaceURI, localName, qualifiedName, attributes);
        Exon exon = new Exon();
        theContentHandler.pushStackObject(exon);
    }

    public void handleEndElement(OtterContentHandler theContentHandler, String namespaceURI, String localName, String qualifiedName) {
        super.handleEndElement(theContentHandler, namespaceURI, localName, qualifiedName);
        Exon exon = (Exon)theContentHandler.popStackObject();
        Transcript parentTranscript = (Transcript)theContentHandler.getStackObject();
        parentTranscript.addExon(exon);
        exon.setRefFeature(parentTranscript);
        exon.getTranscript().setStrand(exon.getStrand());
        exon.setFeatureType("otter");
    }

    public String getFullName() {
        return "otter:sequence_set:locus:transcript:exon";
    }

    public String getLeafName() {
        return "exon";
    }
}

