/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.ensj19;

import apollo.config.Config;
import apollo.dataadapter.AbstractApolloAdapter;
import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterGUI;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.NonFatalDataAdapterException;
import apollo.dataadapter.StateInformation;
import apollo.dataadapter.URLDiagnosticTool;
import apollo.dataadapter.ensj19.AnnotationEnsJAdapter;
import apollo.dataadapter.ensj19.AnnotationSourceChooser;
import apollo.dataadapter.ensj19.CompositeDataSourceConfigurationPanel;
import apollo.dataadapter.ensj19.DataSourceConfigurationPanel;
import apollo.dataadapter.ensj19.EnsJAdapterGUI;
import apollo.dataadapter.ensj19.OtterAnnotationSourceChooser;
import apollo.dataadapter.synteny.SyntenyAdapterGUI;
import apollo.datamodel.ApolloDataI;
import apollo.datamodel.CompositeDataHolder;
import apollo.datamodel.CurationSet;
import apollo.util.GuiUtil;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import org.bdgp.io.DataAdapterException;
import org.bdgp.io.IOOperation;
import org.ensembl19.util.PropertiesUtil;

public class AnnotationEnsJAdapterGUI
extends EnsJAdapterGUI
implements ApolloDataAdapterGUI {
    private JButton testButton;
    private JButton showTypes;
    private JButton showDataSourceConfiguration;
    private JButton showAnnotation;
    private JPanel typesPanel;
    private JPanel dataSourceConfigurationPanel;
    private JPanel annotationPanel;
    private AnnotationSourceChooser annotationSourceChooser;
    private JPanel includePanel;
    private CompositeDataSourceConfigurationPanel dataConfigChooser;
    private boolean dbInitialised = false;
    private String logicalSpeciesName = null;
    static /* synthetic */ Class class$javax$swing$JDialog;

    public AnnotationEnsJAdapterGUI(IOOperation op) {
        super(op);
    }

    protected void buildGUI() {
        int row = 0;
        this.setLayout(new GridBagLayout());
        this.add(this.buildLocationPanel(), GuiUtil.makeConstraintAt(0, row, 1));
        this.buildTypesPanel();
        this.add(this.getTypesPanel(), GuiUtil.makeConstraintAt(0, ++row, 1));
        this.buildDataSourceConfigurationPanel();
        this.add(this.getDataSourceConfigurationPanel(), GuiUtil.makeConstraintAt(0, ++row, 1));
        if (Config.isEditingEnabled("apollo.dataadapter.ensj.AnnotationEnsJAdapter")) {
            this.buildAnnotationConfigurationPanel();
            this.add(this.getAnnotationConfigurationPanel(), GuiUtil.makeConstraintAt(0, ++row, 1));
        }
    }

    public Properties createStateInformation() throws ApolloAdapterException {
        String apolloRoot;
        File logFile;
        StateInformation stateInfo = new StateInformation();
        String filepath = this.findFile("conf/ensj_defaults.conf");
        Properties input = new Properties();
        if (filepath != null) {
            Properties initialSettings = PropertiesUtil.createProperties((String)filepath);
            stateInfo.putAll((Map<?, ?>)initialSettings);
        }
        if (this.getChrButton().isSelected()) {
            String region = this.getSelectedChrStartEnd();
            if (region != null) {
                stateInfo.put("region", region);
            }
        } else if (this.getCloneFragmentButton().isSelected()) {
            stateInfo.put("region", this.getSelectedCloneFragment());
        } else if (this.getStableIdButton().isSelected()) {
            stateInfo.put("region", this.getSelectedStableID());
        }
        if (!(logFile = new File((apolloRoot = System.getProperty("APOLLO_ROOT")) + "/conf/logging_info_level.conf")).exists()) {
            throw new ApolloAdapterException("The following file must be provided to support ensj - conf/logging_info_level.conf");
        }
        stateInfo.put("loggingFile", apolloRoot + "/conf/logging_info_level.conf");
        for (int i = 0; i < this.getDataTypeButtons().length; ++i) {
            stateInfo.put(this.getDataTypeButtons()[i].propertyName, AnnotationEnsJAdapterGUI.booleanToString(this.getDataTypeButtons()[i].isSelected()));
        }
        Properties databaseProperties = this.getDataConfigChooser().getPrefixedProperties();
        stateInfo.putAll((Map<?, ?>)databaseProperties);
        return stateInfo;
    }

    private String breakMessageIntoLines(String message) {
        boolean useLineBrokenMessage = false;
        String remainingMessage = message;
        String lineBrokenMessage = "";
        while (remainingMessage.length() > 80 || remainingMessage.indexOf("\n") > 81) {
            useLineBrokenMessage = true;
            String lineSubString = remainingMessage.substring(0, 81);
            remainingMessage = remainingMessage.substring(81);
            lineBrokenMessage = lineBrokenMessage + lineSubString + "\n";
        }
        if (useLineBrokenMessage) {
            lineBrokenMessage = lineBrokenMessage + remainingMessage;
            return lineBrokenMessage;
        }
        return message;
    }

    private void populateAnnotationStateInformation(Properties stateInfo) {
        if (this.getAnnotationSourceChooser() != null) {
            if (this.getAnnotationSourceChooser().getSelectedInputFileName() != null && this.getAnnotationSourceChooser().getSelectedInputFileName().trim().length() > 0) {
                stateInfo.setProperty("AnnotationInputFile", this.getAnnotationSourceChooser().getSelectedInputFileName().trim());
            }
            if (this.getAnnotationSourceChooser().getSelectedOutputFileName() != null && this.getAnnotationSourceChooser().getSelectedOutputFileName().trim().length() > 0) {
                stateInfo.setProperty("AnnotationOutputFile", this.getAnnotationSourceChooser().getSelectedOutputFileName().trim());
            }
            if (this.getAnnotationSourceChooser().getSelectedInputServerName() != null) {
                stateInfo.setProperty("AnnotationInputServer", this.getAnnotationSourceChooser().getSelectedInputServerName().trim());
            }
            if (this.getAnnotationSourceChooser().getSelectedServerPort() != null) {
                stateInfo.setProperty("AnnotationServerPort", this.getAnnotationSourceChooser().getSelectedServerPort().trim());
            }
            if (this.getAnnotationSourceChooser().getSelectedInputServerName() != null) {
                stateInfo.setProperty("AnnotationOutputServer", this.getAnnotationSourceChooser().getSelectedInputServerName().trim());
            }
            if (this.getAnnotationSourceChooser().getSelectedInputDataSetName() != null) {
                stateInfo.setProperty("AnnotationInputDataSet", this.getAnnotationSourceChooser().getSelectedInputDataSetName().trim());
            }
            if (this.getAnnotationSourceChooser().getSelectedOutputDataSetName() != null) {
                stateInfo.setProperty("AnnotationOutputDataSet", this.getAnnotationSourceChooser().getSelectedInputDataSetName().trim());
            }
            if (this.getAnnotationSourceChooser().getAnnotationUser() != null) {
                stateInfo.setProperty("AnnotationAuthor", this.getAnnotationSourceChooser().getAnnotationUser().trim());
            }
            if (this.getAnnotationSourceChooser().getAnnotationUserEmail() != null) {
                stateInfo.setProperty("AnnotationAuthorEmail", this.getAnnotationSourceChooser().getAnnotationUserEmail().trim());
            }
            stateInfo.setProperty("AnnotationLock", new Boolean(this.getAnnotationSourceChooser().isEditingEnabled()).toString());
        }
    }

    public Object doOperation(Object values) throws DataAdapterException {
        Properties stateInformation = null;
        try {
            if (this.getOperation().equals((Object)ApolloDataAdapterI.OP_READ_DATA) || this.getOperation().equals((Object)ApolloDataAdapterI.OP_APPEND_DATA)) {
                stateInformation = this.createStateInformation();
                this.populateAnnotationStateInformation(stateInformation);
                ((AbstractApolloAdapter)this.getDataAdapter()).clearStateInformation();
                ((ApolloDataAdapterI)this.getDataAdapter()).setStateInformation(stateInformation);
                if (this.getOperation().equals((Object)ApolloDataAdapterI.OP_READ_DATA)) {
                    return ((ApolloDataAdapterI)this.getDataAdapter()).getCurationSet();
                }
                return ((ApolloDataAdapterI)this.getDataAdapter()).addToCurationSet();
            }
            if (this.getOperation().equals((Object)ApolloDataAdapterI.OP_WRITE_DATA)) {
                stateInformation = new Properties();
                this.populateAnnotationStateInformation(stateInformation);
                ((AnnotationEnsJAdapter)this.getDataAdapter()).setWritingStateInformation(stateInformation);
                ApolloDataI apolloData = (ApolloDataI)values;
                CurationSet curSet = null;
                if (apolloData.isCurationSet()) {
                    curSet = apolloData.getCurationSet();
                } else if (apolloData.isCompositeDataHolder()) {
                    CompositeDataHolder cdh = apolloData.getCompositeDataHolder();
                    curSet = cdh.getCurationSet(0);
                }
                ((AnnotationEnsJAdapter)this.getDataAdapter()).commitChanges(curSet);
                return null;
            }
            stateInformation = new Properties();
            this.populateAnnotationStateInformation(stateInformation);
            throw new ApolloAdapterException("I cannot run the exception: " + this.getOperation().getName());
        }
        catch (NonFatalDataAdapterException exception) {
            String lineBrokenMessage = this.breakMessageIntoLines(exception.getMessage());
            throw new ApolloAdapterException("Problem loading data:" + lineBrokenMessage, exception);
        }
    }

    public void setInput(Object input) {
        SyntenyAdapterGUI parentAdapterUI = null;
        if (input instanceof HashMap) {
            this.getChrButton().setSelected(true);
            HashMap theInput = (HashMap)input;
            String text = (String)theInput.get("chr");
            if (!this.isChromosomeListInitialised()) {
                this.initialiseChromosomeDropdown();
            }
            this.getChrDropdown().setSelectedItem(text);
            text = (String)theInput.get("start");
            this.getStartTextBox().setText(text);
            text = (String)theInput.get("end");
            this.getEndTextBox().setText(text);
        } else if (input instanceof String) {
            this.setLogicalSpeciesName((String)input);
        } else if (input instanceof SyntenyAdapterGUI) {
            if (this.getLogicalSpeciesName() != null) {
                parentAdapterUI = (SyntenyAdapterGUI)((Object)input);
                parentAdapterUI.getSharedData().put(this.getLogicalSpeciesName(), this);
            }
            this.getLocationPanel().remove(this.getCloneFragmentPanel());
        }
    }

    public Properties getProperties() {
        Properties properties = super.getProperties();
        properties.putAll((Map<?, ?>)this.getDataConfigChooser().getPrefixedProperties());
        if (Config.isEditingEnabled("apollo.dataadapter.ensj.AnnotationEnsJAdapter")) {
            String authorEmail;
            String author;
            boolean lock;
            String name = this.getAnnotationSourceChooser().getSelectedInputFileName();
            Vector history = this.getAnnotationSourceChooser().getInputFileHistory();
            if (name != null) {
                history.add(0, name);
                properties.put("AnnotationInputFileName", name);
            }
            this.putPrefixedProperties(properties, history, "AnnotationInputFileHistory");
            name = this.getAnnotationSourceChooser().getSelectedOutputFileName();
            history = this.getAnnotationSourceChooser().getOutputFileHistory();
            if (name != null) {
                history.add(0, name);
                properties.put("AnnotationInputFileName", name);
            }
            this.putPrefixedProperties(properties, history, "AnnotationOutputFileHistory");
            name = this.getAnnotationSourceChooser().getSelectedInputServerName();
            history = this.getAnnotationSourceChooser().getInputServerHistory();
            if (history.size() > 0 && (history.elementAt(0) == null || ((String)history.elementAt(0)).trim().length() <= 0)) {
                history.remove(0);
            }
            if (name != null) {
                history.add(0, name);
                properties.put("AnnotationInputServerName", name);
            }
            this.putPrefixedProperties(properties, history, "AnnotationInputServerHistory");
            name = this.getAnnotationSourceChooser().getSelectedServerPort();
            if (name != null) {
                properties.put("AnnotationServerPort", name);
            }
            if ((name = this.getAnnotationSourceChooser().getSelectedInputDataSetName()) != null) {
                properties.put("AnnotationInputDataSetName", name);
            }
            if (lock = this.getAnnotationSourceChooser().isEditingEnabled()) {
                properties.put("AnnotationLock", "true");
            }
            if ((author = this.getAnnotationSourceChooser().getAnnotationUser()) != null) {
                properties.put("AnnotationAuthor", author);
            }
            if ((authorEmail = this.getAnnotationSourceChooser().getAnnotationUserEmail()) != null) {
                properties.put("AnnotationAuthorEmail", authorEmail);
            }
        }
        return properties;
    }

    public void setProperties(Properties inputPassedIn) {
        String filepath = this.findFile("conf/ensj_defaults.conf");
        Properties input = new Properties();
        if (filepath != null) {
            Properties initialSettings = PropertiesUtil.createProperties((String)filepath);
            input.putAll((Map<?, ?>)initialSettings);
        }
        input.putAll((Map<?, ?>)inputPassedIn);
        super.setProperties(input);
        boolean setDefaultEnsemblDatabaseName = false;
        if (input.getProperty("jdbc_driver") == null || input.getProperty("jdbc_driver").trim().length() <= 0) {
            input.setProperty("jdbc_driver", this.getInitialSettings().getProperty("jdbc_driver"));
        }
        if (input.getProperty("host") == null || input.getProperty("host").trim().length() <= 0) {
            input.setProperty("host", this.getInitialSettings().getProperty("host"));
        }
        if (input.getProperty("port") == null || input.getProperty("port").trim().length() <= 0) {
            input.setProperty("port", this.getInitialSettings().getProperty("port"));
        }
        if (input.getProperty("user") == null || input.getProperty("user").trim().length() <= 0) {
            input.setProperty("user", "anonymous");
        }
        if (input.getProperty("ensembl_driver") == null || input.getProperty("ensembl_driver").trim().length() <= 0) {
            input.setProperty("ensembl_driver", this.getInitialSettings().getProperty("ensembl_driver"));
        }
        if (input.getProperty("database") == null || input.getProperty("database").trim().length() <= 0) {
            setDefaultEnsemblDatabaseName = true;
            input.setProperty("database", this.getInitialSettings().getProperty("database"));
        }
        if (input.getProperty("signature") == null || input.getProperty("signature").trim().length() <= 0) {
            input.setProperty("signature", this.getInitialSettings().getProperty("signature"));
        }
        if (input.getProperty("variation.signature") == null || input.getProperty("variation.signature").trim().length() <= 0) {
            input.setProperty("variation.signature", this.getInitialSettings().getProperty("variation.signature"));
        }
        if (input.getProperty("sequence.signature") == null || input.getProperty("sequence.signature").trim().length() <= 0) {
            input.setProperty("sequence.signature", this.getInitialSettings().getProperty("sequence.signature"));
        }
        if (!this.isDbInitialised()) {
            this.getDataConfigChooser().setProperties(input);
            this.getDataConfigChooser().populateEnsemblDatabases();
            if (this.getDataConfigChooser().getChooser("default").getEnsemblDatabaseDropdown().getModel().getSize() > 1) {
                this.getDataConfigChooser().getChooser("default").setSelectedEnsemblDatabase(input.getProperty("database"));
            }
            this.setDbInitialised(true);
        }
        if (Config.isEditingEnabled("apollo.dataadapter.ensj.AnnotationEnsJAdapter")) {
            String name = input.getProperty("AnnotationInputFileName");
            Vector fileVector = this.filterHistory(this.getPrefixedProperties(input, "AnnotationInputFileHistory", true));
            if (fileVector.size() > 0 && fileVector.elementAt(0) != null && ((String)fileVector.elementAt(0)).trim().length() > 0) {
                fileVector.add(0, "");
            }
            this.getAnnotationSourceChooser().setInputFileHistory(fileVector);
            this.getAnnotationSourceChooser().setSelectedInputFileName(name);
            fileVector = this.filterHistory(this.getPrefixedProperties(input, "AnnotationOutputFileHistory", true));
            if (fileVector.size() > 0 && fileVector.elementAt(0) != null && ((String)fileVector.elementAt(0)).trim().length() > 0) {
                fileVector.add(0, "");
            }
            this.getAnnotationSourceChooser().setOutputFileHistory(fileVector);
            name = input.getProperty("AnnotationOutputFileName");
            this.getAnnotationSourceChooser().setSelectedOutputFileName(name);
            fileVector = this.filterHistory(this.getPrefixedProperties(input, "AnnotationInputServerHistory", false));
            if (fileVector.size() > 0 && fileVector.elementAt(0) != null && ((String)fileVector.elementAt(0)).trim().length() > 0) {
                fileVector.add(0, "");
            }
            this.getAnnotationSourceChooser().setInputServerHistory(fileVector);
            name = input.getProperty("AnnotationInputServerName");
            this.getAnnotationSourceChooser().setSelectedInputServerName(name);
            name = input.getProperty("AnnotationServerPort");
            this.getAnnotationSourceChooser().setSelectedServerPort(name);
            if (this.getAnnotationSourceChooser().getSelectedInputServerName() != null && this.getAnnotationSourceChooser().getSelectedServerPort() != null) {
                this.getAnnotationSourceChooser().getFindButton().doClick();
            }
            name = input.getProperty("AnnotationInputDataSetName");
            this.getAnnotationSourceChooser().setSelectedInputDataSetName(name);
            String lock = input.getProperty("AnnotationLock");
            if (lock != null) {
                this.getAnnotationSourceChooser().isEditingEnabled();
            }
            String author = input.getProperty("AnnotationAuthor");
            this.getAnnotationSourceChooser().setAnnotationUser(author);
            String authorEmail = input.getProperty("AnnotationAuthorEmail");
            this.getAnnotationSourceChooser().setAnnotationUserEmail(authorEmail);
        }
    }

    private Vector filterHistory(Vector history) {
        Vector uniqueHistory = new Vector();
        Object element = null;
        for (int i = 0; i < history.size(); ++i) {
            element = history.get(i);
            if (element == null || element.toString().trim().length() <= 0 || uniqueHistory.contains(history.get(i))) continue;
            uniqueHistory.add(history.get(i));
        }
        return uniqueHistory;
    }

    private AnnotationSourceChooser getAnnotationSourceChooser() {
        return this.annotationSourceChooser;
    }

    private void setAnnotationSourceChooser(AnnotationSourceChooser newValue) {
        this.annotationSourceChooser = newValue;
    }

    private JButton getTestButton() {
        return this.testButton;
    }

    private void setTestButton(JButton button) {
        this.testButton = button;
    }

    private JButton getShowTypesButton() {
        return this.showTypes;
    }

    private JButton getShowDataSourceConfigurationButton() {
        return this.showDataSourceConfiguration;
    }

    private JButton getShowAnnotationButton() {
        return this.showAnnotation;
    }

    private JPanel buildTypesPanel() {
        this.typesPanel = new JPanel();
        this.typesPanel.setLayout(new GridBagLayout());
        this.typesPanel.setBorder(new TitledBorder("Tracks"));
        this.includePanel = this.buildIncludePanel();
        this.showTypes = new JButton("Show Tracks");
        this.showTypes.addActionListener(new ShowTypesActionListener());
        this.typesPanel.add((Component)this.getShowTypesButton(), GuiUtil.makeConstraintAt(0, 0, 1));
        this.includePanel.setVisible(false);
        this.typesPanel.add((Component)this.includePanel, GuiUtil.makeConstraintAt(0, 1, 1));
        return this.typesPanel;
    }

    private JPanel getTypesPanel() {
        return this.typesPanel;
    }

    private JPanel getIncludePanel() {
        return this.includePanel;
    }

    private JPanel buildDataSourceConfigurationPanel() {
        this.dataSourceConfigurationPanel = new JPanel();
        this.dataSourceConfigurationPanel.setLayout(new GridBagLayout());
        this.dataSourceConfigurationPanel.setBorder(BorderFactory.createTitledBorder("Data Source"));
        this.showDataSourceConfiguration = new JButton("Show Data Source Configuration");
        this.showDataSourceConfiguration.addActionListener(new ShowDataSourceConfigurationActionListener());
        this.dataSourceConfigurationPanel.add((Component)this.getShowDataSourceConfigurationButton(), GuiUtil.makeConstraintAt(0, 0, 1));
        this.dataConfigChooser = new CompositeDataSourceConfigurationPanel();
        this.dataConfigChooser.setInteractionListener(new DataSourceConfigInteractionListener());
        this.dataConfigChooser.setVisible(false);
        this.dataSourceConfigurationPanel.add((Component)this.dataConfigChooser, GuiUtil.makeConstraintAt(0, 1, 1));
        this.addDataChangeListenerToDataSourceConfigPanels();
        return this.dataSourceConfigurationPanel;
    }

    public CompositeDataSourceConfigurationPanel getDataConfigChooser() {
        return this.dataConfigChooser;
    }

    private JPanel getDataSourceConfigurationPanel() {
        return this.dataSourceConfigurationPanel;
    }

    private JPanel getAnnotationConfigurationPanel() {
        return this.annotationPanel;
    }

    private JPanel buildAnnotationConfigurationPanel() {
        this.annotationPanel = new JPanel();
        this.annotationPanel.setLayout(new GridBagLayout());
        this.annotationPanel.setBorder(BorderFactory.createTitledBorder("Annotation Source"));
        this.showAnnotation = new JButton("Show Annotations");
        this.showAnnotation.addActionListener(new ShowAnnotationConfigurationActionListener());
        this.annotationSourceChooser = new OtterAnnotationSourceChooser();
        this.annotationSourceChooser.setVisible(false);
        this.annotationPanel.add((Component)this.getShowAnnotationButton(), GuiUtil.makeConstraintAt(0, 0, 1));
        this.annotationPanel.add((Component)this.annotationSourceChooser, GuiUtil.makeConstraintAt(0, 1, 1));
        return this.annotationPanel;
    }

    private boolean isDbInitialised() {
        return this.dbInitialised;
    }

    private void setDbInitialised(boolean initialised) {
        this.dbInitialised = initialised;
    }

    private String getLogicalSpeciesName() {
        return this.logicalSpeciesName;
    }

    private void setLogicalSpeciesName(String speciesName) {
        this.logicalSpeciesName = speciesName;
        System.out.println("Species is " + speciesName);
    }

    protected void addDataChangeListenerToDataSourceConfigPanels() {
        EnsJAdapterGUI.DataSourceChangeListener listener = new EnsJAdapterGUI.DataSourceChangeListener(this);
        this.getDataConfigChooser().addExternalDataSourceChangeListener(listener);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class DataSourceConfigInteractionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            String ensemblDatabaseName;
            if (AnnotationEnsJAdapterGUI.this.getDataConfigChooser().getSelectedChooser().equals("default") && (ensemblDatabaseName = event.getActionCommand()) != null) {
                int coreIndex = ensemblDatabaseName.indexOf("core");
                Properties properties = AnnotationEnsJAdapterGUI.this.getDataConfigChooser().getChooser("default").getProperties();
                if (coreIndex > 0) {
                    String preCoreSegment = ensemblDatabaseName.substring(0, coreIndex);
                    String postCoreSegment = ensemblDatabaseName.substring(coreIndex + 4);
                    String variationDatabaseName = preCoreSegment + "snp" + postCoreSegment;
                    DataSourceConfigurationPanel sequencePanel = AnnotationEnsJAdapterGUI.this.getDataConfigChooser().getChooser("sequence");
                    sequencePanel.setProperties(properties);
                    DataSourceConfigurationPanel variationPanel = AnnotationEnsJAdapterGUI.this.getDataConfigChooser().getChooser("variation");
                    properties.setProperty("database", variationDatabaseName);
                    variationPanel.setProperties(properties);
                } else {
                    DataSourceConfigurationPanel variationPanel = AnnotationEnsJAdapterGUI.this.getDataConfigChooser().getChooser("variation");
                    variationPanel.setProperties(properties);
                    DataSourceConfigurationPanel sequencePanel = AnnotationEnsJAdapterGUI.this.getDataConfigChooser().getChooser("sequence");
                    sequencePanel.setProperties(properties);
                }
            }
        }
    }

    public class ShowAnnotationConfigurationActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            JDialog dialog = (JDialog)SwingUtilities.getAncestorOfClass(class$javax$swing$JDialog == null ? (class$javax$swing$JDialog = AnnotationEnsJAdapterGUI.class$("javax.swing.JDialog")) : class$javax$swing$JDialog, (Component)((Object)AnnotationEnsJAdapterGUI.this));
            if (AnnotationEnsJAdapterGUI.this.getShowAnnotationButton().getLabel().equals("Show Annotations")) {
                AnnotationEnsJAdapterGUI.this.getAnnotationSourceChooser().setVisible(true);
                AnnotationEnsJAdapterGUI.this.getShowAnnotationButton().setLabel("Hide Annotations");
                dialog.pack();
            } else {
                AnnotationEnsJAdapterGUI.this.getAnnotationSourceChooser().setVisible(false);
                AnnotationEnsJAdapterGUI.this.getShowAnnotationButton().setLabel("Show Annotations");
                dialog.pack();
            }
        }
    }

    public class ShowDataSourceConfigurationActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            JDialog dialog = (JDialog)SwingUtilities.getAncestorOfClass(class$javax$swing$JDialog == null ? (class$javax$swing$JDialog = AnnotationEnsJAdapterGUI.class$("javax.swing.JDialog")) : class$javax$swing$JDialog, (Component)((Object)AnnotationEnsJAdapterGUI.this));
            if (AnnotationEnsJAdapterGUI.this.getShowDataSourceConfigurationButton().getLabel().equals("Show Data Source Configuration")) {
                AnnotationEnsJAdapterGUI.this.getDataConfigChooser().setVisible(true);
                AnnotationEnsJAdapterGUI.this.getShowDataSourceConfigurationButton().setLabel("Hide Data Source Configuration");
                dialog.pack();
            } else {
                AnnotationEnsJAdapterGUI.this.getDataConfigChooser().setVisible(false);
                AnnotationEnsJAdapterGUI.this.getShowDataSourceConfigurationButton().setLabel("Show Data Source Configuration");
                dialog.pack();
            }
        }
    }

    public class ShowTypesActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            JDialog dialog = (JDialog)SwingUtilities.getAncestorOfClass(class$javax$swing$JDialog == null ? (class$javax$swing$JDialog = AnnotationEnsJAdapterGUI.class$("javax.swing.JDialog")) : class$javax$swing$JDialog, (Component)((Object)AnnotationEnsJAdapterGUI.this));
            if (AnnotationEnsJAdapterGUI.this.getShowTypesButton().getLabel().equals("Show Tracks")) {
                AnnotationEnsJAdapterGUI.this.getIncludePanel().setVisible(true);
                AnnotationEnsJAdapterGUI.this.getShowTypesButton().setLabel("Hide Tracks");
                dialog.pack();
            } else {
                AnnotationEnsJAdapterGUI.this.getIncludePanel().setVisible(false);
                AnnotationEnsJAdapterGUI.this.getShowTypesButton().setLabel("Show Tracks");
                dialog.pack();
            }
        }
    }

    private class TestActionListener
    implements ActionListener {
        private TestActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            String inputServerName = AnnotationEnsJAdapterGUI.this.getAnnotationSourceChooser().getSelectedInputServerName();
            String inputDataSet = AnnotationEnsJAdapterGUI.this.getAnnotationSourceChooser().getSelectedInputDataSetName();
            String serverQueryString = "http://" + inputServerName + ":19332/perl/get_region?chr=" + AnnotationEnsJAdapterGUI.this.getSelectedChr() + "&" + "chrstart=" + AnnotationEnsJAdapterGUI.this.getSelectedStart() + "&" + "chrend=" + AnnotationEnsJAdapterGUI.this.getSelectedEnd() + "&" + "dataset=" + inputDataSet;
            if (AnnotationEnsJAdapterGUI.this.getAnnotationSourceChooser().getAnnotationUser() != null) {
                serverQueryString = serverQueryString + "&author=" + AnnotationEnsJAdapterGUI.this.getAnnotationSourceChooser().getAnnotationUser() + "&email=" + AnnotationEnsJAdapterGUI.this.getAnnotationSourceChooser().getAnnotationUserEmail();
            }
            if (AnnotationEnsJAdapterGUI.this.getAnnotationSourceChooser().isEditingEnabled()) {
                serverQueryString = serverQueryString + "&lock=true";
            }
            URLDiagnosticTool tool = new URLDiagnosticTool(serverQueryString);
        }
    }
}

