/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.ensj19;

import apollo.config.Config;
import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.CGI;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.NonFatalDataAdapterException;
import apollo.dataadapter.NotImplementedException;
import apollo.dataadapter.ensj19.AlternateEnsJSequence;
import apollo.dataadapter.ensj19.AnnotationEnsJAdapterGUI;
import apollo.dataadapter.ensj19.EnsJAdapter;
import apollo.dataadapter.otter.parser.OtterContentHandler;
import apollo.dataadapter.otter.parser.OtterXMLRenderingVisitor;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.AssemblyFeatureI;
import apollo.datamodel.CurationSet;
import apollo.datamodel.DbXref;
import apollo.datamodel.FeatureSet;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceI;
import apollo.datamodel.StrandedFeatureSet;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringBufferInputStream;
import java.net.URL;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.JOptionPane;
import org.bdgp.io.DataAdapterUI;
import org.bdgp.io.IOOperation;
import org.ensembl19.datamodel.AssemblyLocation;
import org.ensembl19.datamodel.LinearLocation;
import org.ensembl19.datamodel.Location;
import org.ensembl19.driver.AdaptorException;
import org.ensembl19.driver.ConfigurationException;
import org.ensembl19.driver.LocationConverter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class AnnotationEnsJAdapter
extends EnsJAdapter {
    private InputStream inputStream;
    private OutputStream outputStream;
    private String inputFileName;
    private String outputFileName;
    private String inputServerName;
    private String serverPort;
    private String outputServerName;
    private String inputDataSet;
    private String outputDataSet;
    private String author;
    private String authorEmail;
    private String lock;
    private static boolean DEBUG = false;
    IOOperation[] supportedOperations = new IOOperation[]{ApolloDataAdapterI.OP_READ_DATA, ApolloDataAdapterI.OP_READ_SEQUENCE, ApolloDataAdapterI.OP_APPEND_DATA, ApolloDataAdapterI.OP_WRITE_DATA};

    public IOOperation[] getSupportedOperations() {
        return this.supportedOperations;
    }

    public DataInputType getInputType() {
        return DataInputType.FILE;
    }

    public String getName() {
        return "Ensembl/Otter - direct database access for multiple species";
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream newValue) {
        this.inputStream = newValue;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream newValue) {
        this.outputStream = newValue;
    }

    public SequenceI getSequence(DbXref dbxref) throws ApolloAdapterException {
        Properties sequenceProperties = new Properties();
        Iterator<Object> names = this.getStateInformation().keySet().iterator();
        while (names.hasNext()) {
            String name = (String)names.next();
            if (!name.startsWith("sequence.")) continue;
            String value = this.getStateInformation().getProperty(name);
            name = name.substring(9);
            sequenceProperties.put(name, value);
        }
        if (dbxref.getIdValue().equals(this.getRegion())) {
            try {
                System.out.println("Getting sequence");
                System.out.println("Region " + this.getRegion());
                System.out.println("Location " + this.getLocation());
                AlternateEnsJSequence ejs = new AlternateEnsJSequence(this.getRegion().toString(), Config.getController(), this.getLocation(), sequenceProperties);
                ejs.getCacher().setMaxSize(1000000);
                return ejs;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ApolloAdapterException(e.getMessage());
            }
        }
        throw new NotImplementedException();
    }

    private AnnotatedFeatureI getXMLAndParse(CurationSet curationSet) throws ApolloAdapterException {
        OtterContentHandler handler;
        LinearLocation location = null;
        AssemblyLocation assemblyLocation = null;
        if (this.getInputServerName() != null && this.getInputDataSet() != null && this.getServerPort() != null) {
            try {
                location = this.getLocation();
            }
            catch (ConfigurationException exception) {
                throw new ApolloAdapterException("Location not valid " + location);
            }
            catch (AdaptorException exception) {
                throw new ApolloAdapterException("Location not valid " + location);
            }
            try {
                if (this.getMode() == 0 || this.getMode() == 2) {
                    assemblyLocation = (AssemblyLocation)this.getLocation();
                } else if (this.getMode() == 1) {
                    LocationConverter locationConverter = (LocationConverter)this.getDriver().getAdaptor("location_converter");
                    assemblyLocation = (AssemblyLocation)locationConverter.convert((Location)this.getLocation(), "DEFAULT_ASSEMBLY", false, false);
                }
            }
            catch (ConfigurationException exception) {
                throw new ApolloAdapterException("Couldn't find an assembly location for input clone ", (Exception)((Object)exception));
            }
            catch (AdaptorException exception) {
                throw new ApolloAdapterException("Couldn't find an assembly location for input clone ", (Exception)((Object)exception));
            }
            String serverQueryString = "http://" + this.getInputServerName() + ":" + this.getServerPort() + "/perl/get_region?chr=" + assemblyLocation.getChromosome() + "&" + "chrstart=" + assemblyLocation.getStart() + "&" + "chrend=" + assemblyLocation.getEnd() + "&" + "dataset=" + this.inputDataSet;
            if (this.getAuthor() != null) {
                serverQueryString = serverQueryString + "&author=" + this.getAuthor();
            }
            if (this.getAuthorEmail() != null) {
                serverQueryString = serverQueryString + "&email=" + this.getAuthorEmail();
            }
            if (this.getLock() != null && this.getLock().equals("true")) {
                serverQueryString = serverQueryString + "&lock=true";
            }
            try {
                URL inputURL = new URL(serverQueryString);
                if (!DEBUG) {
                    this.setInputStream(inputURL.openStream());
                }
                DataInputStream inputStream = new DataInputStream(inputURL.openStream());
                String line = inputStream.readLine();
                String outputString = "";
                while (line != null) {
                    outputString = outputString + line + "\n";
                    line = inputStream.readLine();
                }
                System.out.println(serverQueryString);
                System.out.println(outputString);
                this.setInputStream(new StringBufferInputStream(outputString));
            }
            catch (IOException exception) {
                throw new NonFatalDataAdapterException("Unable to open input URL " + serverQueryString);
            }
        } else if (this.getInputFileName() != null) {
            try {
                this.setInputStream(new FileInputStream(this.getInputFileName()));
            }
            catch (FileNotFoundException theException) {
                throw new NonFatalDataAdapterException("File " + this.getInputFileName() + " not found");
            }
        } else {
            throw new ApolloAdapterException("Attempt to fetch annotations without specifying input server URL or file name");
        }
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader();
            handler = new OtterContentHandler();
            handler.setCurationSet(curationSet);
            InputSource theFileReader = new InputSource(this.getInputStream());
            parser.setContentHandler(handler);
            parser.parse(theFileReader);
        }
        catch (IOException theException) {
            theException.printStackTrace();
            throw new ApolloAdapterException("IO Error parsing input xml-stream", theException);
        }
        catch (SAXException theException) {
            theException.printStackTrace();
            throw new ApolloAdapterException("SAX Error parsing input xml-stream", theException);
        }
        Iterator returnedObjects = handler.getReturnedObjects().iterator();
        AnnotatedFeatureI set = null;
        while (returnedObjects.hasNext()) {
            Object returnedObject = returnedObjects.next();
            if (returnedObject instanceof String) {
                String message = (String)returnedObject;
                throw new NonFatalDataAdapterException(message);
            }
            if (!(returnedObject instanceof AnnotatedFeatureI)) continue;
            set = (AnnotatedFeatureI)returnedObject;
        }
        return set;
    }

    private FeatureSetI convertCurationSetToApolloFeatureSet(AnnotatedFeatureI theSet) throws ApolloAdapterException {
        int low = -1;
        int high = -1;
        FeatureSet theForwardFakeSet = new FeatureSet();
        FeatureSet theReverseFakeSet = new FeatureSet();
        StrandedFeatureSet returnSet = new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet());
        if (theSet != null && theSet.getFeatures() != null) {
            Iterator featureIterator = theSet.getFeatures().iterator();
            while (featureIterator.hasNext()) {
                SeqFeatureI theResultFeature = (SeqFeatureI)featureIterator.next();
                if (low > theResultFeature.getLow() || low < 0) {
                    low = theResultFeature.getLow();
                }
                if (high < theResultFeature.getHigh() || high < 0) {
                    high = theResultFeature.getHigh();
                }
                if (theResultFeature instanceof AssemblyFeatureI) {
                    theResultFeature.setFeatureType("otter_assembly");
                    if (theResultFeature.getStrand() == 1) {
                        theForwardFakeSet.addFeature(theResultFeature);
                        theForwardFakeSet.setStrand(theResultFeature.getStrand());
                    } else {
                        theReverseFakeSet.addFeature(theResultFeature);
                        theReverseFakeSet.setStrand(theResultFeature.getStrand());
                    }
                } else {
                    theResultFeature.setFeatureType("otter");
                    returnSet.addFeature(theResultFeature);
                }
                returnSet.addFeature(theForwardFakeSet);
                returnSet.addFeature(theReverseFakeSet);
            }
            returnSet.setLow(low);
            returnSet.setHigh(high);
        }
        return returnSet;
    }

    public DataAdapterUI getUI(IOOperation op) {
        if (!super.operationIsSupported(op)) {
            return null;
        }
        Object ui = super.getCachedUI(op);
        if (ui == null) {
            ui = new AnnotationEnsJAdapterGUI(op);
            super.cacheUI(op, (DataAdapterUI)ui);
        }
        return ui;
    }

    public void commitChanges(CurationSet curationSet) throws ApolloAdapterException {
        block15: {
            BufferedOutputStream buffer = new BufferedOutputStream(this.getOutputStream());
            OutputStreamWriter writer = new OutputStreamWriter(buffer);
            OtterXMLRenderingVisitor visitor = new OtterXMLRenderingVisitor();
            StrandedFeatureSet theSet = (StrandedFeatureSet)curationSet.getAnnots();
            curationSet.accept(visitor);
            String outputString = visitor.getReturnBuffer().toString();
            Hashtable<String, String> inputParameters = new Hashtable<String, String>();
            String serverResponse = "";
            try {
                int port;
                File outputFile;
                if (this.getOutputFileName() != null) {
                    outputFile = new File(this.outputFileName);
                } else {
                    String apolloRoot = System.getProperty("APOLLO_ROOT");
                    String timestamp = new Timestamp(System.currentTimeMillis()).toString();
                    String fileName = apolloRoot + "/data/apollo_annotations_" + timestamp + "+.xml";
                    outputFile = new File(fileName);
                }
                if (outputFile.exists()) {
                    outputFile.delete();
                }
                try {
                    outputFile.createNewFile();
                    this.setOutputStream(new FileOutputStream(outputFile));
                }
                catch (IOException theException) {
                    throw new ApolloAdapterException("Unable to create output file " + this.outputFileName);
                }
                buffer = new BufferedOutputStream(this.getOutputStream());
                writer = new OutputStreamWriter(buffer);
                writer.write(outputString);
                writer.flush();
                if (this.getOutputServerName() == null) break block15;
                String host = this.getOutputServerName();
                inputParameters.put("data", outputString);
                inputParameters.put("author", this.getAuthor());
                inputParameters.put("email", this.getAuthorEmail());
                inputParameters.put("unlock", "true");
                inputParameters.put("dataset", this.getOutputDataSet());
                if (DEBUG) {
                    System.out.println(outputString);
                }
                try {
                    port = Integer.valueOf(this.getServerPort());
                }
                catch (NumberFormatException exception) {
                    throw new ApolloAdapterException("Port :" + this.getServerPort() + " is not a valid integer");
                }
                CGI cgi = new CGI(host, port, "perl/write_region", inputParameters, System.out, "POST");
                cgi.run();
                DataInputStream inputStream = cgi.getInput();
                if (inputStream != null) {
                    String line;
                    while ((line = inputStream.readLine()) != null) {
                        serverResponse = serverResponse + line + "\n";
                    }
                    if (serverResponse.length() > 0) {
                        this.processResponse(serverResponse, outputString);
                        if (serverResponse.indexOf("ERROR") <= 0) {
                            this.setLock("false");
                        }
                    }
                } else {
                    this.writeBackupFileIfNecessary("There has been a Server Error", outputString);
                }
            }
            catch (IOException theException) {
                this.writeBackupFileIfNecessary(theException.getMessage(), outputString);
                throw new ApolloAdapterException("Error writing annotations", theException);
            }
        }
    }

    private void processResponse(String response, String annotations) throws ApolloAdapterException {
        int isErrorPresent = response.indexOf("ERROR");
        if (isErrorPresent > 0) {
            this.writeBackupFileIfNecessary(response, annotations);
        } else {
            JOptionPane.showMessageDialog(null, response);
        }
    }

    private void writeBackupFileIfNecessary(String response, String annotations) throws ApolloAdapterException {
        String apolloRoot = System.getProperty("APOLLO_ROOT");
        String timestamp = new Timestamp(System.currentTimeMillis()).toString();
        String fileName = apolloRoot + "/data/apollo_annotations_" + timestamp + "+.xml";
        this.writeBackupFile(fileName, annotations);
        if (this.getOutputFileName() == null) {
            JOptionPane.showMessageDialog(null, "The following error occurred: \n" + response + "\n But you have not been writing output to a file. \n" + "Your annotations have been written to " + fileName);
        } else {
            JOptionPane.showMessageDialog(null, "The following error occurred: \n" + response + "\n Your output was written to the file: " + this.getOutputFileName());
        }
    }

    public void setStateInformation(Properties stateInformation) {
        super.setStateInformation(stateInformation);
        this.setWritingStateInformation(stateInformation);
    }

    public void setWritingStateInformation(Properties stateInformation) {
        String inputFileName = this.trim(stateInformation.getProperty("AnnotationInputFile"));
        String outputFileName = this.trim(stateInformation.getProperty("AnnotationOutputFile"));
        String inputServerName = this.trim(stateInformation.getProperty("AnnotationInputServer"));
        String serverPort = this.trim(stateInformation.getProperty("port"));
        String outputServerName = this.trim(stateInformation.getProperty("AnnotationOutputServer"));
        String inputDataSet = this.trim(stateInformation.getProperty("AnnotationInputDataSet"));
        String outputDataSet = this.trim(stateInformation.getProperty("AnnotationOutputDataSet"));
        String author = this.trim(stateInformation.getProperty("AnnotationAuthor"));
        String authorEmail = this.trim(stateInformation.getProperty("AnnotationAuthorEmail"));
        String lock = this.trim(stateInformation.getProperty("AnnotationLock"));
        if (Config.isEditingEnabled(this.getClass().getName())) {
            block14: {
                try {
                    int serverPortNumber = Integer.valueOf(serverPort);
                }
                catch (NumberFormatException exception) {
                    if (inputServerName == null || inputDataSet == null) break block14;
                    throw new NonFatalDataAdapterException("Server port: " + serverPort + " is not a valid number");
                }
            }
            if (inputServerName != null) {
                this.setInputServerName(inputServerName);
            }
            if (author != null) {
                this.setAuthor(author);
            }
            if (authorEmail != null) {
                this.setAuthorEmail(authorEmail);
            }
            if (lock != null) {
                this.setLock(lock);
            }
            if (outputDataSet != null) {
                this.setOutputDataSet(outputDataSet);
            }
            if (outputServerName != null) {
                this.setOutputServerName(outputServerName);
            }
            if (inputFileName != null) {
                this.setInputFileName(inputFileName);
            }
            if (outputFileName != null) {
                this.setOutputFileName(outputFileName);
            }
            if (inputDataSet != null) {
                this.setInputDataSet(inputDataSet);
            }
            if (outputDataSet != null) {
                this.setOutputDataSet(outputDataSet);
            }
            if (serverPort != null) {
                this.setServerPort(serverPort);
            }
        }
    }

    public void clearStateInformation() {
        super.clearStateInformation();
        this.setInputServerName(null);
        this.setAuthor(null);
        this.setAuthorEmail(null);
        this.setLock(null);
        this.setOutputDataSet(null);
        this.setOutputServerName(null);
        this.setInputFileName(null);
        this.setOutputFileName(null);
        this.setInputDataSet(null);
        this.setOutputDataSet(null);
        this.setServerPort(null);
    }

    private String trim(String input) {
        if (input != null && input.trim().length() > 0) {
            return input;
        }
        return null;
    }

    private void setAuthor(String newValue) {
        this.author = newValue;
    }

    private void setAuthorEmail(String newValue) {
        this.authorEmail = newValue;
    }

    private void setLock(String newValue) {
        this.lock = newValue;
    }

    private void setOutputServerName(String newValue) {
        this.outputServerName = newValue;
    }

    private String getOutputServerName() {
        return this.outputServerName;
    }

    private String getAuthor() {
        return this.author;
    }

    private String getAuthorEmail() {
        return this.authorEmail;
    }

    private String getLock() {
        return this.lock;
    }

    private String getInputServerName() {
        return this.inputServerName;
    }

    private void setInputServerName(String newValue) {
        this.inputServerName = newValue;
    }

    private String getServerPort() {
        return this.serverPort;
    }

    private void setServerPort(String port) {
        this.serverPort = port;
    }

    private String getInputFileName() {
        return this.inputFileName;
    }

    private void setInputFileName(String newValue) {
        this.inputFileName = newValue;
    }

    private String getOutputFileName() {
        return this.outputFileName;
    }

    private void setOutputFileName(String newValue) {
        this.outputFileName = newValue;
    }

    private String getInputDataSet() {
        return this.inputDataSet;
    }

    private void setInputDataSet(String newValue) {
        this.inputDataSet = newValue;
    }

    private String getOutputDataSet() {
        return this.outputDataSet;
    }

    private void setOutputDataSet(String newValue) {
        this.outputDataSet = newValue;
    }

    private void writeBackupFile(String fileName, String outputString) throws ApolloAdapterException {
        File outputFile = new File(fileName);
        if (outputFile.exists()) {
            outputFile.delete();
        }
        try {
            outputFile.createNewFile();
            BufferedOutputStream buffer = new BufferedOutputStream(new FileOutputStream(outputFile));
            OutputStreamWriter writer = new OutputStreamWriter(buffer);
            writer.write(outputString);
            writer.flush();
        }
        catch (IOException theException) {
            throw new ApolloAdapterException("Attempt to write annotations to a file failed:\n" + theException.getMessage());
        }
    }

    protected boolean rollbackAnnotations(CurationSet curationSet) {
        block10: {
            BufferedOutputStream buffer = new BufferedOutputStream(this.getOutputStream());
            OtterXMLRenderingVisitor visitor = new OtterXMLRenderingVisitor();
            StrandedFeatureSet theSet = (StrandedFeatureSet)curationSet.getAnnots();
            theSet.accept(visitor);
            String outputString = visitor.getReturnBuffer().toString();
            Hashtable<String, String> inputParameters = new Hashtable<String, String>();
            String serverResponse = "";
            boolean success = true;
            try {
                int port;
                if (this.getOutputServerName() == null || !this.getLock().equals("true")) break block10;
                String host = this.getOutputServerName();
                inputParameters.put("data", outputString);
                inputParameters.put("author", this.getAuthor());
                inputParameters.put("email", this.getAuthorEmail());
                inputParameters.put("unlock", "true");
                inputParameters.put("dataset", this.getOutputDataSet());
                if (DEBUG) {
                    System.out.println(outputString);
                }
                try {
                    port = Integer.valueOf(this.getServerPort());
                }
                catch (NumberFormatException exception) {
                    throw new ApolloAdapterException("Port :" + this.getServerPort() + " is not a valid integer");
                }
                CGI cgi = new CGI(host, port, "perl/unlock_region", inputParameters, System.out, "POST");
                cgi.run();
                DataInputStream inputStream = cgi.getInput();
                if (inputStream != null) {
                    String line;
                    while ((line = inputStream.readLine()) != null) {
                        serverResponse = serverResponse + line + "\n";
                    }
                    if (serverResponse.indexOf("ERROR") > 0) {
                        success = false;
                        this.processResponse(serverResponse, outputString);
                    }
                } else {
                    success = false;
                }
            }
            catch (ApolloAdapterException theException) {
                success = false;
            }
            catch (IOException theException) {
                success = false;
            }
        }
        return true;
    }

    public Boolean addToCurationSet() throws ApolloAdapterException {
        CurationSet existingCurationSet = this.getExistingCurationSet();
        CurationSet newCurationSet = super.getCurationSetWithoutClearingData();
        Iterator features = newCurationSet.getResults().getFeatures().iterator();
        while (features.hasNext()) {
            existingCurationSet.getResults().addFeature((SeqFeatureI)features.next());
        }
        features = newCurationSet.getAnnots().getFeatures().iterator();
        while (features.hasNext()) {
            existingCurationSet.getAnnots().addFeature((SeqFeatureI)((Object)features));
        }
        return Boolean.TRUE;
    }

    public CurationSet getExistingCurationSet() {
        return this.curation_set;
    }
}

