/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.ensj.view;

import apollo.dataadapter.ensj.model.AnnotationsModel;
import apollo.dataadapter.ensj.model.Model;
import apollo.dataadapter.ensj.view.View;
import apollo.util.GuiUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AnnotationsPanel
extends JPanel
implements ActionListener {
    private View _view;
    private JLabel _fileLabel = new JLabel("Input File");
    private JLabel _serverLabel = new JLabel("Annotation Server / Port");
    private JLabel _serverPortLabel = new JLabel(":");
    private JLabel _dataSetLabel = new JLabel("Annotation Dataset");
    private JLabel _annotationUserLabel = new JLabel("Author");
    private JLabel _annotationUserEmailLabel = new JLabel("Email");
    private JTextField _annotationUserTextField = new JTextField(20);
    private JTextField _serverTextField = new JTextField(20);
    private JTextField _serverPortTextField = new JTextField(20);
    private JTextField _annotationUserEmailTextField = new JTextField(20);
    private JCheckBox _editingEnabledCheckBox = new JCheckBox("Editing Enabled: ");
    private JComboBox _dataSetDropdown = new JComboBox();
    private JComboBox _fileDropdown = new JComboBox();
    private JButton _fileChooseButton = new JButton("Choose...");
    private JFileChooser _fileChooser = new JFileChooser();

    public AnnotationsPanel(View view) {
        this._view = view;
        this.initialiseGUI();
    }

    private void initialiseGUI() {
        this.setLayout(new GridBagLayout());
        Dimension mySize = this.getServerTextField().getPreferredSize();
        this.getDataSetDropdown().setPreferredSize(mySize);
        this.getFileDropdown().setEditable(true);
        this.getFileDropdown().setPreferredSize(mySize);
        int row = 0;
        JPanel fileIOPanel = new JPanel();
        JPanel serverIOPanel = new JPanel();
        fileIOPanel.setBorder(BorderFactory.createTitledBorder("File Based Annotations"));
        serverIOPanel.setBorder(BorderFactory.createTitledBorder("Server Based Annotations"));
        fileIOPanel.setLayout(new GridBagLayout());
        row = 0;
        fileIOPanel.add((Component)this.getFileLabel(), GuiUtil.makeConstraintAt(0, row, 1));
        fileIOPanel.add((Component)this.getFileDropdown(), GuiUtil.makeConstraintAt(1, row, 1));
        fileIOPanel.add((Component)this.getFileChooseButton(), GuiUtil.makeConstraintAt(2, row, 1));
        this.getFileChooseButton().addActionListener(this);
        serverIOPanel.setLayout(new GridBagLayout());
        row = 0;
        serverIOPanel.add((Component)this.getAnnotationUserLabel(), GuiUtil.makeConstraintAt(0, row, 1));
        serverIOPanel.add((Component)this.getAnnotationUserTextField(), GuiUtil.makeConstraintAt(1, row, 1));
        serverIOPanel.add((Component)this.getEditingEnabledCheckBox(), GuiUtil.makeConstraintAt(2, row, 3));
        serverIOPanel.add((Component)this.getAnnotationUserEmailLabel(), GuiUtil.makeConstraintAt(0, ++row, 1));
        serverIOPanel.add((Component)this.getAnnotationUserEmailTextField(), GuiUtil.makeConstraintAt(1, row, 1));
        serverIOPanel.add((Component)this.getServerLabel(), GuiUtil.makeConstraintAt(0, ++row, 1));
        serverIOPanel.add((Component)this.getServerTextField(), GuiUtil.makeConstraintAt(1, row, 2));
        serverIOPanel.add((Component)this.getServerPortLabel(), GuiUtil.makeConstraintAt(2, row, 1));
        serverIOPanel.add((Component)this.getServerPortTextField(), GuiUtil.makeConstraintAt(3, row, 1));
        serverIOPanel.add((Component)this.getDataSetLabel(), GuiUtil.makeConstraintAt(0, ++row, 1));
        serverIOPanel.add((Component)this.getDataSetDropdown(), GuiUtil.makeConstraintAt(1, row, 1));
        this.setLayout(new GridBagLayout());
        row = 0;
        this.add((Component)serverIOPanel, GuiUtil.makeConstraintAt(0, row, 3));
        this.add((Component)fileIOPanel, GuiUtil.makeConstraintAt(0, ++row, 3));
    }

    public void update(Model model) {
        AnnotationsModel myModel = model.getAnnotationsModel();
        myModel.setAnnotationUser(this.getAnnotationUserTextField().getText());
        myModel.setEditingEnabled(this.getEditingEnabledCheckBox().isSelected());
        myModel.setServer(this.getServerTextField().getText());
        myModel.setServerPort(this.getServerPortTextField().getText());
        myModel.setSelectedDataSet((String)this.getDataSetDropdown().getSelectedItem());
        myModel.setSelectedFile((String)this.getFileDropdown().getSelectedItem());
    }

    public void read(Model model) {
        AnnotationsModel myModel = model.getAnnotationsModel();
        this.getAnnotationUserTextField().setText(myModel.getAnnotationUser());
        this.getEditingEnabledCheckBox().setSelected(myModel.isEditingEnabled());
        this.getServerTextField().setText(myModel.getServer());
        this.getServerPortTextField().setText(myModel.getServerPort());
        this.getDataSetDropdown().setModel(new DefaultComboBoxModel(new Vector(myModel.getDataSets())));
        this.getDataSetDropdown().setSelectedItem(myModel.getSelectedDataSet());
        this.getFileDropdown().setSelectedItem(myModel.getSelectedFile());
    }

    private View getView() {
        return this._view;
    }

    private JLabel getAnnotationUserLabel() {
        return this._annotationUserLabel;
    }

    private JLabel getAnnotationUserEmailLabel() {
        return this._annotationUserEmailLabel;
    }

    private JLabel getServerLabel() {
        return this._serverLabel;
    }

    private JLabel getServerPortLabel() {
        return this._serverPortLabel;
    }

    private JTextField getAnnotationUserTextField() {
        return this._annotationUserTextField;
    }

    private JTextField getAnnotationUserEmailTextField() {
        return this._annotationUserEmailTextField;
    }

    private JCheckBox getEditingEnabledCheckBox() {
        return this._editingEnabledCheckBox;
    }

    private JLabel getDataSetLabel() {
        return this._dataSetLabel;
    }

    private JComboBox getDataSetDropdown() {
        return this._dataSetDropdown;
    }

    private JTextField getServerTextField() {
        return this._serverTextField;
    }

    private JTextField getServerPortTextField() {
        return this._serverPortTextField;
    }

    private JLabel getFileLabel() {
        return this._fileLabel;
    }

    private JFileChooser getFileChooser() {
        return this._fileChooser;
    }

    private JComboBox getFileDropdown() {
        return this._fileDropdown;
    }

    private JButton getFileChooseButton() {
        return this._fileChooseButton;
    }

    public void actionPerformed(ActionEvent event) {
        this.getFileChooser().showOpenDialog(this);
        File chosenFile = this.getFileChooser().getSelectedFile();
        if (chosenFile != null) {
            String name = chosenFile.getName();
            this.getFileDropdown().addItem(name);
            this.getFileDropdown().setSelectedItem(name);
        }
    }
}

