/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.ensj;

import apollo.dataadapter.ensj.FatalException;
import apollo.dataadapter.ensj.NonFatalException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;

public class EnsJConnectionUtil {
    public static final String DRIVER = "org.gjt.mm.mysql.Driver";

    public static Connection getConnection(String jdbcDriver, String host, String port, String database, String user, String password) {
        Connection connection;
        if (EnsJConnectionUtil.isNull(jdbcDriver)) {
            throw new NonFatalException("Driver must be supplied");
        }
        jdbcDriver = jdbcDriver.trim();
        if (EnsJConnectionUtil.isNull(host)) {
            throw new NonFatalException("Host must be supplied");
        }
        host = host.trim();
        if (EnsJConnectionUtil.isNull(port)) {
            throw new NonFatalException("Port must be supplied");
        }
        port = port.trim();
        if (EnsJConnectionUtil.isNull(user)) {
            throw new NonFatalException("User must be supplied");
        }
        user = user.trim();
        if (password != null) {
            password = password.trim();
        }
        if (EnsJConnectionUtil.isNull(password)) {
            password = null;
        }
        String url = EnsJConnectionUtil.isNull(database) ? "jdbc:mysql://" + host + ":" + port + "/" : "jdbc:mysql://" + host + ":" + port + "/" + database;
        url = url.trim();
        try {
            Class.forName(jdbcDriver).newInstance();
        }
        catch (IllegalAccessException exception) {
            throw new FatalException("Cannot access the driver class " + jdbcDriver + "\n" + exception.getMessage(), exception);
        }
        catch (InstantiationException exception) {
            throw new FatalException("Cannot create the driver class " + jdbcDriver + "\n" + exception.getMessage(), exception);
        }
        catch (ClassNotFoundException exception) {
            throw new FatalException("Cannot find the driver class " + jdbcDriver + "\n" + exception.getMessage(), exception);
        }
        try {
            connection = password != null ? DriverManager.getConnection(url, user, password) : DriverManager.getConnection(url, user, null);
        }
        catch (SQLException exception) {
            throw new NonFatalException("Problem creating db connection: " + exception.getMessage(), exception);
        }
        return connection;
    }

    private static boolean isNull(String string) {
        return string == null || string.trim().length() <= 0;
    }

    public static int getEnsemblSchema(Connection connection) {
        String dbsql = "describe gene";
        int schema = 30;
        try {
            ResultSet dbresults = connection.createStatement().executeQuery(dbsql);
            while (dbresults.next()) {
                if (dbresults.getString(1).equals("confidence")) {
                    schema = 32;
                }
                if (!dbresults.getString(1).equals("status")) continue;
                schema = 34;
            }
        }
        catch (SQLException exception) {
            throw new NonFatalException(exception.getMessage(), exception);
        }
        return schema;
    }
}

