/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.ensj;

import apollo.config.Config;
import apollo.dataadapter.AbstractApolloAdapter;
import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.FeatureSetBuilder;
import apollo.dataadapter.ensj.AlternateEnsJSequence;
import apollo.dataadapter.ensj.DataFetcher;
import apollo.dataadapter.ensj.EnsJAdapterGUI;
import apollo.dataadapter.ensj.EnsJConnectionUtil;
import apollo.dataadapter.ensj.NonFatalException;
import apollo.datamodel.CurationSet;
import apollo.datamodel.DbXref;
import apollo.datamodel.FeaturePair;
import apollo.datamodel.FeatureSet;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceI;
import apollo.datamodel.StrandedFeatureSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bdgp.io.DataAdapterUI;
import org.bdgp.io.IOOperation;
import org.bdgp.util.ProgressEvent;
import org.ensembl.datamodel.CoordinateSystem;
import org.ensembl.datamodel.Exon;
import org.ensembl.datamodel.Gene;
import org.ensembl.datamodel.Location;
import org.ensembl.datamodel.Transcript;
import org.ensembl.datamodel.Translation;
import org.ensembl.driver.AdaptorException;
import org.ensembl.driver.ConfigurationException;
import org.ensembl.driver.Driver;
import org.ensembl.driver.DriverManager;
import org.ensembl.driver.LoggingManager;
import org.ensembl.util.JDBCUtil;
import org.ensembl.util.PropertiesUtil;

public class EnsJAdapter
extends AbstractApolloAdapter {
    public static final String NUMBER_OF_FEATURES = "NUMBER_OF_FEATURES";
    public static final String REGION_PATTERN = "REGION: ([^--]*)--(.*):(\\S*):(\\S*)-(\\S*)";
    public static final String REGION_PATTERN_2 = "Chr ([^--]*)--(.*):(\\S*) (\\S*) (\\S*)";
    public static final String REGION_PATTERN_3 = "Chr (\\S*) (\\S*) (\\S*)";
    public static final String ID_PATTERN = "ID: (\\S*)";
    private Properties _stateInformation;
    private Driver _driver;
    public static final String ID = "ID";
    public static final String VERSION = "VERSION";
    public static final String COORD_SYSTEM = "COORD_SYSTEM";
    public static final String SEQ_REGION = "SEQ_REGION";
    public static final String START = "START";
    public static final String END = "END";
    public static final String STABLE_ID_PREFIX = "ID: ";
    List returnedGenes = null;

    public EnsJAdapter() {
        this.setName("EnsJ - Direct Access for Ensembl Databases (Schema 32 and above)");
    }

    public String getType() {
        return "Ensembl Adapter";
    }

    public IOOperation[] getSupportedOperations() {
        return new IOOperation[]{ApolloDataAdapterI.OP_READ_DATA, ApolloDataAdapterI.OP_APPEND_DATA};
    }

    public DataAdapterUI getUI(IOOperation op) {
        return new EnsJAdapterGUI(op);
    }

    public void setStateInformation(Properties properties) {
        this._stateInformation = properties;
    }

    public void setRegion(String region) {
        this.getStateInformation().setProperty("region", region);
    }

    public void init() {
    }

    public CurationSet getCurationSet() throws ApolloAdapterException {
        CurationSet curationSet = new CurationSet();
        StrandedFeatureSet results = null;
        StrandedFeatureSet annotations = null;
        String region = this.getStateInformation().getProperty("region");
        this.clearOldData();
        this.validateDatabaseProperties();
        try {
            this.initialiseDriver();
        }
        catch (ConfigurationException exception) {
            System.out.println(exception.getMessage());
            throw new ApolloAdapterException("Didn't specify enough information to configure database access: " + exception.getMessage());
        }
        Location location = this.getLocationForInputRegion();
        System.out.println("Fetching region " + location);
        try {
            results = this.getResults(curationSet, location);
            results.setName("Analyses");
            annotations = this.getAnnotations();
            curationSet.setRefSequence(this.getSequence(new DbXref(region, region, region)));
        }
        catch (AdaptorException exception) {
            throw new ApolloAdapterException("Problem fetching data: " + exception.getMessage(), (Exception)((Object)exception));
        }
        curationSet.setStart(location.getStart());
        curationSet.setEnd(location.getEnd());
        curationSet.setChromosome(location.getCoordinateSystem().getVersion() + "--" + location.getCoordinateSystem().getName() + ":" + location.getSeqRegionName());
        curationSet.setOrganism(this.getOrganism());
        curationSet.setName("ensj");
        curationSet.setResults(results);
        curationSet.setAnnots(annotations);
        return curationSet;
    }

    private String getOrganism() {
        String dbsql = "select meta_value from meta where meta_key='species.classification' order by meta_id limit 2";
        String organismName = this.getStateInformation().getProperty("database");
        try {
            int nRow = 0;
            Connection connection = this.getDriver().getConnection();
            String[] classification = new String[2];
            ResultSet dbresults = connection.createStatement().executeQuery(dbsql);
            while (dbresults.next()) {
                classification[nRow++] = dbresults.getString(1);
            }
            if (nRow == 2) {
                organismName = classification[1] + "_" + classification[0];
            }
            JDBCUtil.close((Connection)connection);
        }
        catch (Exception exception) {
            throw new NonFatalException(exception.getMessage(), exception);
        }
        return organismName;
    }

    public Boolean addToCurationSet() throws ApolloAdapterException {
        SeqFeatureI sf;
        int i;
        boolean okay = false;
        System.out.println("Existing curation set = " + this.curation_set + " chr " + this.curation_set.getChromosome() + " name " + this.curation_set.getName());
        this.getStateInformation().setProperty("region", "Chr " + this.curation_set.getChromosome() + " " + this.curation_set.getStart() + " " + this.curation_set.getEnd());
        this.validateDatabaseProperties();
        try {
            this.initialiseDriver();
        }
        catch (ConfigurationException exception) {
            System.out.println(exception.getMessage());
            throw new ApolloAdapterException("Didn't specify enough information to configure database access: " + exception.getMessage());
        }
        Location location = this.getLocationForInputRegion();
        System.out.println("Generated location = " + location);
        StrandedFeatureSet results = null;
        Object annotations = null;
        try {
            results = this.getResults(this.curation_set, location);
        }
        catch (AdaptorException exception) {
            throw new ApolloAdapterException("Problem fetching data: " + exception.getMessage(), (Exception)((Object)exception));
        }
        for (i = 0; i < results.getForwardSet().size(); ++i) {
            sf = results.getForwardSet().getFeatureAt(i);
            this.curation_set.getResults().getForwardSet().addFeature(sf);
        }
        for (i = 0; i < results.getReverseSet().size(); ++i) {
            sf = results.getReverseSet().getFeatureAt(i);
            this.curation_set.getResults().getReverseSet().addFeature(sf);
        }
        okay = true;
        return new Boolean(okay);
    }

    private Location getLocationForInputRegion() throws ApolloAdapterException {
        Location location;
        try {
            HashMap coords = this.parseRegionString();
            if (coords.get(ID) != null) {
                location = this.getLocationForStableID((String)coords.get(ID));
            } else {
                CoordinateSystem coordSystem;
                String version = (String)coords.get(VERSION);
                String coordSystemName = (String)coords.get(COORD_SYSTEM);
                if (this.isNull(coordSystemName)) {
                    CoordinateSystem[] coordSystems = this.getDriver().getCoordinateSystemAdaptor().fetchAllByFeatureTable("gene");
                    if (coordSystems.length != 1) {
                        throw new ApolloAdapterException("Can't find a unique coord system that genes are stored in!");
                    }
                    coordSystem = coordSystems[0];
                } else {
                    coordSystem = this.getDriver().getCoordinateSystemAdaptor().fetch(coordSystemName, version);
                }
                if (coordSystem == null) {
                    throw new ApolloAdapterException("Can't find coord system with name/version: " + coordSystemName + "/" + version);
                }
                location = new Location(coordSystem, (String)coords.get(SEQ_REGION), ((Integer)coords.get(START)).intValue(), ((Integer)coords.get(END)).intValue(), 0);
            }
        }
        catch (AdaptorException exception) {
            exception.printStackTrace();
            throw new ApolloAdapterException("Problem fetching data: " + exception.getMessage(), (Exception)((Object)exception));
        }
        return location;
    }

    private Location getLocationForStableID(String stableID) throws ApolloAdapterException {
        boolean start = false;
        boolean end = false;
        try {
            Gene gene = this.getDriver().getGeneAdaptor().fetch(stableID);
            if (gene != null) {
                return gene.getLocation();
            }
            Transcript transcript = this.getDriver().getTranscriptAdaptor().fetch(stableID);
            if (transcript != null) {
                return transcript.getLocation();
            }
            Translation translation = this.getDriver().getTranslationAdaptor().fetch(stableID);
            if (translation != null) {
                return translation.getTranscript().getLocation();
            }
            Exon exon = this.getDriver().getExonAdaptor().fetch(stableID);
            if (exon != null) {
                return exon.getLocation();
            }
        }
        catch (AdaptorException exception) {
            throw new ApolloAdapterException("Problems finding gene, transcript, translation or exon with stableID: " + stableID + ": " + exception.getMessage(), (Exception)((Object)exception));
        }
        throw new ApolloAdapterException("Cannot find a gene, transcript, translation or exon with input stableID: " + stableID);
    }

    private StrandedFeatureSet getResults(CurationSet curationSet, Location location) throws AdaptorException {
        StrandedFeatureSet results = new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet());
        ArrayList flatFeatures = new ArrayList();
        int numberFetched = 0;
        List includedTypes = null;
        DataFetcher fetcher = new DataFetcher(this);
        if (this.getStateAsBoolean("include.Gene") || this.getStateAsBoolean("include.SimplePeptideFeature")) {
            System.out.println("fetching genes...");
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(10.0), "Getting genes..."));
            includedTypes = this.getPrefixedProperties(this.getStateInformation(), "INCLUDE_GENE_TYPES");
            this.returnedGenes = fetcher.addGenes(results, location, includedTypes);
            numberFetched = this.returnedGenes.size();
            System.out.println("fetched " + numberFetched + " genes");
        }
        if (this.getStateAsBoolean("include.RepeatFeature")) {
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(20.0), "Getting repeats..."));
            numberFetched = fetcher.addRepeatFeatures(curationSet, flatFeatures, location);
            System.out.println("fetched " + numberFetched + " repeats ");
        }
        if (this.getStateAsBoolean("include.DnaProteinAlignment")) {
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(30.0), "Getting dna-protein aligns..."));
            includedTypes = this.getPrefixedProperties(this.getStateInformation(), "INCLUDE_DNA_PROTEIN_ALIGNMENT_TYPES");
            System.out.println("fetching dna protein alignments for types: " + this.listToString(includedTypes));
            numberFetched = fetcher.addProteinAlignFeatures(curationSet, flatFeatures, location, includedTypes);
            System.out.println("fetched " + numberFetched + " dna protein alignments");
        }
        if (this.getStateAsBoolean("include.DnaDnaAlignment")) {
            includedTypes = this.getPrefixedProperties(this.getStateInformation(), "INCLUDE_DNA_DNA_ALIGNMENT_TYPES");
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(40.0), "Getting dna-dna aligns ..."));
            System.out.println("fetching dna dna alignments for types: " + this.listToString(includedTypes));
            numberFetched = fetcher.addDnaAlignFeatures(curationSet, flatFeatures, location, includedTypes);
            System.out.println("fetched " + numberFetched + " dna dna alignments");
        }
        if (this.getStateAsBoolean("include.PredictionTranscript")) {
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(50.0), "Getting prediction transcripts..."));
            includedTypes = this.getPrefixedProperties(this.getStateInformation(), "INCLUDE_PREDICTION_TRANSCRIPT_TYPES");
            numberFetched = fetcher.addPredictionTranscripts(results, location, includedTypes);
            System.out.println("fetched " + numberFetched + " prediction transcripts");
        }
        if (this.getStateAsBoolean("include.Feature")) {
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(60.0), "Getting simple features..."));
            includedTypes = this.getPrefixedProperties(this.getStateInformation(), "INCLUDE_FEATURE");
            numberFetched = fetcher.addSimpleFeatures(curationSet, flatFeatures, location, includedTypes);
            System.out.println("fetched " + numberFetched + " simple features");
        }
        if (this.getStateAsBoolean("include.SimplePeptideFeature")) {
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(70.0), "Getting protein annotatinos..."));
            numberFetched = fetcher.addProteinAnnotations(curationSet, flatFeatures, this.returnedGenes);
            System.out.println("fetched " + numberFetched + " protein annotations");
        }
        new FeatureSetBuilder().makeSetFeatures(results, new Vector(flatFeatures), Config.getPropertyScheme());
        return results;
    }

    private String listToString(List list) {
        String returnString = "";
        for (int i = 0; i < list.size(); ++i) {
            returnString = returnString + list.get(i).toString();
        }
        return returnString;
    }

    public StrandedFeatureSet getAnnotations() {
        StrandedFeatureSet annotations = new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet());
        return annotations;
    }

    public DataInputType getInputType() {
        return DataInputType.FILE;
    }

    public Properties getStateInformation() {
        return this._stateInformation;
    }

    private void validateDatabaseProperties() throws ApolloAdapterException {
        String host = this.getStateInformation().getProperty("host");
        String port = this.getStateInformation().getProperty("port");
        String database = this.getStateInformation().getProperty("database");
        if (this.isNull(host)) {
            throw new ApolloAdapterException("database host name must be provided");
        }
        if (this.isNull(port)) {
            throw new ApolloAdapterException("database port  must be provided");
        }
        if (this.isNull(database)) {
            throw new ApolloAdapterException("ensembl database name must be provided");
        }
    }

    private HashMap parseRegionString() throws ApolloAdapterException {
        String region = this.getStateInformation().getProperty("region");
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        int start = 0;
        int end = 0;
        Pattern pattern = Pattern.compile(REGION_PATTERN);
        Matcher matcher = pattern.matcher(region);
        if (matcher.matches()) {
            String version = matcher.group(1);
            String coordSystem = matcher.group(2);
            String seqRegion = matcher.group(3);
            try {
                start = Integer.valueOf(matcher.group(4));
            }
            catch (NumberFormatException exception) {
                throw new ApolloAdapterException("start: " + start + " cannot be parsed into an integer");
            }
            try {
                end = Integer.valueOf(matcher.group(5));
            }
            catch (NumberFormatException exception) {
                throw new ApolloAdapterException("end: " + end + " cannot be parsed into an integer");
            }
            returnMap.put(VERSION, version);
            returnMap.put(COORD_SYSTEM, coordSystem);
            returnMap.put(SEQ_REGION, seqRegion);
            returnMap.put(START, new Integer(start));
            returnMap.put(END, new Integer(end));
        } else {
            pattern = Pattern.compile(REGION_PATTERN_2);
            matcher = pattern.matcher(region);
            if (matcher.matches()) {
                String version = matcher.group(1);
                String coordSystem = matcher.group(2);
                String seqRegion = matcher.group(3);
                try {
                    start = Integer.valueOf(matcher.group(4));
                }
                catch (NumberFormatException exception) {
                    throw new ApolloAdapterException("start: " + start + " cannot be parsed into an integer");
                }
                try {
                    end = Integer.valueOf(matcher.group(5));
                }
                catch (NumberFormatException exception) {
                    throw new ApolloAdapterException("end: " + end + " cannot be parsed into an integer");
                }
                returnMap.put(VERSION, version);
                returnMap.put(COORD_SYSTEM, coordSystem);
                returnMap.put(SEQ_REGION, seqRegion);
                returnMap.put(START, new Integer(start));
                returnMap.put(END, new Integer(end));
            } else {
                pattern = Pattern.compile(REGION_PATTERN_3);
                matcher = pattern.matcher(region);
                if (matcher.matches()) {
                    Object version = null;
                    Object coordSystem = null;
                    String seqRegion = matcher.group(1);
                    try {
                        start = Integer.valueOf(matcher.group(2));
                    }
                    catch (NumberFormatException exception) {
                        throw new ApolloAdapterException("start: " + start + " cannot be parsed into an integer");
                    }
                    try {
                        end = Integer.valueOf(matcher.group(3));
                    }
                    catch (NumberFormatException exception) {
                        throw new ApolloAdapterException("end: " + end + " cannot be parsed into an integer");
                    }
                    returnMap.remove(VERSION);
                    returnMap.remove(COORD_SYSTEM);
                    returnMap.put(SEQ_REGION, seqRegion);
                    returnMap.put(START, new Integer(start));
                    returnMap.put(END, new Integer(end));
                } else {
                    pattern = Pattern.compile(ID_PATTERN);
                    matcher = pattern.matcher(region);
                    if (matcher.matches()) {
                        String id = matcher.group(1);
                        returnMap.put(ID, id);
                    } else {
                        throw new ApolloAdapterException("the input region: " + region + " doesnt match either REGION: (version)--(coordsystem):seqregion:start-end or ID: id");
                    }
                }
            }
        }
        return returnMap;
    }

    private boolean isNull(String test) {
        return test == null || test.trim().length() <= 0;
    }

    private void initialiseDriver() throws ConfigurationException {
        System.out.println("Initialising driver");
        String host = this.getStateInformation().getProperty("host");
        String port = this.getStateInformation().getProperty("port");
        String database = this.getStateInformation().getProperty("database");
        String user = this.getStateInformation().getProperty("user");
        String password = this.getStateInformation().getProperty("password");
        Connection conn = EnsJConnectionUtil.getConnection("org.gjt.mm.mysql.Driver", host, port, database, user, password);
        int schema = EnsJConnectionUtil.getEnsemblSchema(conn);
        JDBCUtil.close((Connection)conn);
        if (schema == 32) {
            schema = 33;
        }
        Properties props = this.getStateInformation();
        props.setProperty("schema_version", "" + schema);
        System.out.println("Setting schema to " + schema);
        LoggingManager.configure((String)this.getStateInformation().getProperty("loggingFile"));
        this.setDriver((Driver)DriverManager.load((Properties)props));
        System.out.println("Done initialising driver");
    }

    public Driver getDriver() {
        return this._driver;
    }

    private void setDriver(Driver newValue) {
        this._driver = newValue;
    }

    private boolean getStateAsBoolean(String type) {
        return PropertiesUtil.booleanValue((Properties)this.getStateInformation(), (String)type, (boolean)false);
    }

    public SequenceI getSequence(DbXref dbxref) throws ApolloAdapterException {
        Properties sequenceProperties = this.getStateInformation();
        try {
            Location location = this.getLocationForInputRegion();
            AlternateEnsJSequence sequence = new AlternateEnsJSequence(this.getStateInformation().getProperty("region"), Config.getController(), location, sequenceProperties);
            sequence.getCacher().setMaxSize(1000000);
            return sequence;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ApolloAdapterException("Problem fetching main sequence: " + exception.getMessage(), exception);
        }
    }

    public void setSequence(FeaturePair pair, CurationSet curationSet) {
        String name = pair.getHname();
        SequenceI sequence = curationSet.getSequence(name);
        if (sequence == null) {
            // empty if block
        }
        pair.getHitFeature().setRefSequence(sequence);
    }

    protected List getPrefixedProperties(Properties settings, String prefix) {
        ArrayList<String> returnList = new ArrayList<String>();
        String value = "";
        for (int i = 0; i < settings.size() && value != null; ++i) {
            value = settings.getProperty(prefix + i);
            if (value == null) continue;
            if (value.equals("END_OF_LIST")) {
                return returnList;
            }
            returnList.add(value);
        }
        return returnList;
    }
}

