/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.ensj;

import apollo.dataadapter.NonFatalDataAdapterException;
import apollo.datamodel.Range;
import apollo.datamodel.SequenceI;
import apollo.datamodel.seq.AbstractLazySequence;
import apollo.datamodel.seq.LazySequenceI;
import apollo.gui.Controller;
import java.util.Properties;
import org.ensembl.datamodel.Location;
import org.ensembl.datamodel.Sequence;
import org.ensembl.driver.AdaptorException;
import org.ensembl.driver.Driver;
import org.ensembl.driver.DriverManager;
import org.ensembl.driver.SequenceAdaptor;

public class AlternateEnsJSequence
extends AbstractLazySequence
implements LazySequenceI {
    private Location _location;
    private Properties _driverProperties;
    private transient Driver driver;

    public AlternateEnsJSequence(String id, Controller controller, Location location, Properties driverProperties) {
        super(id, controller);
        this._location = location;
        this._driverProperties = driverProperties;
        this.setRange(new Range("dummy", this.getLocation().getStart(), this.getLocation().getEnd()));
        this.setLength(location.getLength());
    }

    public void setDriverProperties(Properties driverProperties) {
        this._driverProperties = driverProperties;
    }

    public Properties getDriverProperties() {
        return this._driverProperties;
    }

    private Driver getDriver() {
        return this.driver;
    }

    private void setDriver(Driver newValue) {
        this.driver = newValue;
    }

    private Location getLocation() {
        return this._location;
    }

    private Location derivedLocation(int start, int end) {
        Location subLocation = this.getLocation().copy();
        subLocation.setStart(start);
        subLocation.setEnd(end);
        return subLocation;
    }

    public SequenceI getSubSequence(int start, int end) {
        return new AlternateEnsJSequence(this.getName(), this.llco.getController(), this.derivedLocation(start, end), this.getDriverProperties());
    }

    protected String getResiduesFromSourceImpl(int start, int end) {
        SequenceAdaptor sequenceAdaptor = null;
        try {
            if (this.getDriver() == null) {
                this.setDriver((Driver)DriverManager.load((Properties)this.getDriverProperties()));
            }
            sequenceAdaptor = this.getDriver().getSequenceAdaptor();
            Location location = this.derivedLocation(start, end);
            location.setStrand(1);
            Sequence sequence = sequenceAdaptor.fetch(location);
            String sequenceString = sequence.getString();
            if (sequenceString.length() <= location.getNodeLength()) {
                StringBuffer buf = new StringBuffer(sequenceString);
                for (int g = sequenceString.length(); g < location.getNodeLength(); ++g) {
                    buf.append('N');
                }
                sequenceString = buf.toString();
            }
            return sequenceString;
        }
        catch (AdaptorException e) {
            throw new NonFatalDataAdapterException("failed to get sequence due to data problem: " + e.getMessage());
        }
    }
}

