/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.das2;

import apollo.datamodel.CurationSet;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.StrandedFeatureSetI;
import apollo.editor.UserName;
import apollo.util.DateUtil;
import apollo.util.IOUtil;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;

public class DAS2Writer {
    static String TAB = "  ";
    static String DAS2_XML_VERSION = "v?";

    public static boolean writeXML(CurationSet curation, String file_str, String version) {
        String filename = IOUtil.findFile(file_str, true);
        if (filename == null) {
            String message = "Failed to open file for writing: " + filename;
            System.err.println(message);
            JOptionPane.showMessageDialog(null, message, "Warning", 2);
            return false;
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file_str);
        }
        catch (Exception ex) {
            System.err.println("writeXML: caught exception opening " + file_str + " (" + filename + ")");
            System.out.println(ex.getMessage());
            ex.printStackTrace();
            return false;
        }
        if (fileWriter == null) {
            return false;
        }
        boolean success = DAS2Writer.writeXML(curation, fileWriter, version);
        try {
            fileWriter.close();
        }
        catch (Exception ex) {
            System.err.println("writeXML: caught exception closing " + filename);
            System.out.println(ex.getMessage());
            ex.printStackTrace();
            return false;
        }
        return success;
    }

    public static boolean writeXML(CurationSet curation, FileWriter fileWriter, String version) {
        String startingIndent = TAB;
        BufferedWriter bw = new BufferedWriter(fileWriter);
        PrintWriter pw = new PrintWriter(bw);
        try {
            pw.print(DAS2Writer.writeBegin(version, curation));
            DAS2Writer.writeResults(curation, startingIndent, pw);
            pw.print(DAS2Writer.writeEnd());
            pw.close();
        }
        catch (Exception ex) {
            System.err.println("Caught exception committing XML");
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    private static String writeBegin(String ApolloVersion, CurationSet curation) {
        StringBuffer buf = new StringBuffer();
        String XML_VERSION = "1.0";
        buf.append("<?xml version=\"" + XML_VERSION + "\" standalone=\"no\"?>\n");
        buf.append("<!DOCTYPE DAS2FEATURE SYSTEM \"http://www.biodas.org/dtd/das2feature.dtd\">\n");
        buf.append("<!-- DAS2XML file (" + DAS2_XML_VERSION + ") created by " + UserName.getUserName() + " -->\n");
        buf.append("<!-- " + ApolloVersion + " -->\n");
        buf.append("<!-- date=\"" + DateUtil.toGMT(new Date()) + "\" -->\n");
        buf.append("<FEATURELIST\n");
        buf.append(TAB + " xmlns=\"http://www.biodas.org/ns/das/2.00\"\n");
        buf.append(TAB + " xmlns:xlink=\"http://www.w3.org/1999/xlink\"\n");
        buf.append(TAB + " xml:base=\"http://127.0.0.1:9021/das2/genome/D_melanogaster_Apr_2004/feature\" >\n");
        return buf.toString();
    }

    private static String writeEnd() {
        return "</FEATURELIST>\n";
    }

    private static void writeResults(CurationSet curation, String indent, PrintWriter pw) {
        StrandedFeatureSetI analyses = curation.getResults();
        if (analyses == null) {
            System.err.println("No results to save.");
            return;
        }
        System.out.println("Saving " + analyses.size() + " types of results");
        String chrom = curation.getChromosome();
        for (int i = 0; i < analyses.size(); ++i) {
            FeatureSetI analysis = (FeatureSetI)analyses.getFeatureAt(i);
            if (analysis.getFeatureType() == null) continue;
            DAS2Writer.writeAnalysisResults(analysis, indent, chrom, pw);
        }
    }

    private static void writeAnalysisResults(FeatureSetI analysis, String indent, String chrom, PrintWriter pw) {
        String program = analysis.getProgramName();
        if (program == null || program.equals("") || program.equals("no_type")) {
            program = analysis.getProperty("type");
        }
        if (program.equals("") || program.equals("no_type")) {
            program = analysis.getTopLevelType();
        }
        Vector results = analysis.getFeatures();
        System.out.println("Writing " + results.size() + 1 + " results (program = " + program + ")");
        for (int i = 0; i < results.size(); ++i) {
            if (results.elementAt(i) instanceof FeatureSetI) {
                FeatureSetI result = (FeatureSetI)results.elementAt(i);
                DAS2Writer.writeResult(result, indent, chrom, pw);
                continue;
            }
            System.err.println("writeAnalysisResults: don't know what to do to save non-FeatureSet class " + results.elementAt(i).getClass().getName());
        }
    }

    private static void writeResult(FeatureSetI result, String indent, String chrom, PrintWriter pw) {
        SeqFeatureI span;
        int i;
        pw.print(indent + "<FEATURE id=\"" + result.getId() + "\" type=\"" + result.getTopLevelType() + "\"");
        if (!result.getProperty("created").equals("")) {
            pw.print("\n" + indent + "         created=\"" + result.getProperty("created") + "\"");
        }
        if (!result.getProperty("modified").equals("")) {
            pw.print("\n" + indent + "         modified=\"" + result.getProperty("modified") + "\"");
        }
        pw.print(" >\n");
        DAS2Writer.writeLocation(indent + TAB, result, chrom, pw);
        Vector spans = result.getFeatures();
        for (i = 0; i < spans.size(); ++i) {
            span = (SeqFeatureI)spans.elementAt(i);
            pw.print(indent + TAB + "<PART id=\"" + span.getId() + "\" />\n");
        }
        DAS2Writer.writeAlign(indent + TAB, result, pw);
        DAS2Writer.writeProperties(indent + TAB, result, pw);
        pw.print(indent + "</FEATURE>\n");
        for (i = 0; i < spans.size(); ++i) {
            span = (SeqFeatureI)spans.elementAt(i);
            DAS2Writer.writeSpan(indent, span, result, chrom, pw);
        }
    }

    private static void writeLocation(String indent, SeqFeatureI result, String chrom, PrintWriter pw) {
        int strand = result.getStrand();
        int low = strand == -1 ? result.getEnd() : result.getStart();
        int high = strand == -1 ? result.getStart() : result.getEnd();
        pw.print(indent + "<LOC pos=\"region/" + chrom + "/" + low + ":" + high + ":" + strand + "\" />\n");
    }

    private static void writeSpan(String indent, SeqFeatureI span, FeatureSetI parent, String chrom, PrintWriter pw) {
        pw.print(indent + "<FEATURE id=\"" + span.getId() + "\" type=\"" + span.getFeatureType() + "\" >\n");
        DAS2Writer.writeLocation(indent + TAB, span, chrom, pw);
        pw.print(indent + TAB + "<PARENT id=\"" + parent.getId() + "\" />\n");
        DAS2Writer.writeProperties(indent + TAB, span, pw);
        pw.print(indent + "</FEATURE>\n");
    }

    public static void writeProperties(String indent, SeqFeatureI feat, PrintWriter pw) {
        Hashtable props = feat.getPropertiesMulti();
        if (props == null) {
            return;
        }
        Enumeration e = props.keys();
        while (e.hasMoreElements()) {
            String type = (String)e.nextElement();
            Vector values = feat.getPropertyMulti(type);
            if (values == null) continue;
            for (int i = 0; i < values.size(); ++i) {
                String value = (String)values.elementAt(i);
                if (DAS2Writer.isSpecialProperty(type)) continue;
                DAS2Writer.writeProperty(indent, type, value, i, pw);
            }
        }
    }

    private static void writeProperty(String indent, String prop, String value, int rank, PrintWriter pw) {
        if (value == null || value.equals("")) {
            return;
        }
        pw.print(indent + "<PROP key=\"" + prop + "\" ");
        if (value.startsWith("href:")) {
            pw.print("href=\"" + value.substring("href:".length() + 1) + "\"");
        } else {
            pw.print("value=\"" + value + "\"");
        }
        pw.print(" />\n");
    }

    public static boolean isSpecialProperty(String prop) {
        if (prop.equals("created")) {
            return true;
        }
        if (prop.equals("modified")) {
            return true;
        }
        if (prop.equals("subject_id")) {
            return true;
        }
        return prop.equals("subject_range");
    }

    private static void writeAlign(String indent, SeqFeatureI result, PrintWriter pw) {
        if (!result.getProperty("subject_id").equals("")) {
            pw.print(indent + "<ALIGN target_id=\"" + result.getProperty("subject_id") + "\"");
            if (!result.getProperty("subject_range").equals("")) {
                pw.print(" range=\"" + result.getProperty("subject_range") + "\"");
            }
            pw.print(" />\n");
        }
    }
}

