/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.das2;

import apollo.dataadapter.NonFatalDataAdapterException;
import apollo.dataadapter.das.DASDsn;
import apollo.dataadapter.das.DASSegment;
import apollo.dataadapter.das.DASServerI;
import apollo.dataadapter.das.simple.SimpleDASDsn;
import apollo.dataadapter.das2.SegmentParser;
import apollo.dataadapter.das2.SourceParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class DAS2Request
implements DASServerI {
    private String url = "";
    private String server;
    private static final float version = 1.0f;
    private static String SOURCES_QUERY = "sequence";
    private List dsnList;

    public DAS2Request(String url) {
        this.setURL(url);
    }

    public void setURL(String url) {
        if (url.indexOf("http://") != 0) {
            url = "http://" + url;
        }
        this.url = url;
    }

    public XMLReader setupXMLReader(DefaultHandler parser) {
        try {
            SAXParser reader = new SAXParser();
            reader.setContentHandler(parser);
            reader.setFeature("http://xml.org/sax/features/validation", false);
            reader.setFeature("http://apache.org/xml/features/validation/dynamic", false);
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            return reader;
        }
        catch (SAXException theException) {
            throw new NonFatalDataAdapterException("SAX Problem setting up parser: " + theException.getMessage());
        }
    }

    public String getURL() {
        return this.url;
    }

    public List getDSNs() {
        return this.getVersionedSources();
    }

    public List getVersionedSources() {
        this.dsnList = new ArrayList();
        SourceParser sourceParser = new SourceParser();
        String queryString = this.getURL() + "/" + SOURCES_QUERY;
        System.out.println("DAS2Request.getVersionedSources: source query string = " + queryString);
        try {
            XMLReader reader = this.setupXMLReader(sourceParser);
            reader.parse(queryString);
        }
        catch (SAXException theException) {
            System.err.println("Error parsing from " + queryString + ":");
            theException.printStackTrace();
            throw new NonFatalDataAdapterException(theException.getMessage());
        }
        catch (IOException theException) {
            throw new NonFatalDataAdapterException(theException.getMessage());
        }
        this.dsnList = sourceParser.getDsns();
        return this.dsnList;
    }

    public DASDsn getDSN(String uri) {
        if (this.dsnList == null) {
            this.getDSNs();
        }
        Iterator dsnIterator = this.dsnList.iterator();
        while (dsnIterator.hasNext()) {
            SimpleDASDsn dsn = (SimpleDASDsn)dsnIterator.next();
            if (!dsn.getSourceId().equals(uri)) continue;
            return dsn;
        }
        System.out.println("DAS2Request.getDSN: couldn't find DSN for " + uri);
        return null;
    }

    public List getEntryPoints(DASDsn dsn) {
        List entryPoints = new ArrayList();
        SegmentParser segmentParser = new SegmentParser();
        SimpleDASDsn source = (SimpleDASDsn)dsn;
        String queryString = source.getMapMaster() + "/" + source.getCapabilityURI("segments");
        System.out.println("DAS2Request.getEntryPoints: queryString = " + queryString);
        try {
            XMLReader parser = this.setupXMLReader(segmentParser);
            parser.parse(queryString);
        }
        catch (SAXException theException) {
            throw new NonFatalDataAdapterException("SAX Problem fetching Entry Points: " + theException.getMessage());
        }
        catch (IOException theException) {
            throw new NonFatalDataAdapterException("IO Problem fetching Entry Points: " + theException.getMessage());
        }
        entryPoints = segmentParser.getSegments();
        System.out.println("Got " + entryPoints.size() + " segments");
        return entryPoints;
    }

    public List getFeatures(DASDsn dsn, DASSegment[] segmentSelection) {
        return null;
    }

    public List getFeatures(DASDsn dsn, HashMap segmentSelection, HashMap parentFeatures, long globalStart, long globalEnd) {
        return null;
    }

    public List getSequences(DASDsn dsn, DASSegment[] segmentSelection) {
        return null;
    }

    public static void main(String[] args) {
        String url = args[0];
        System.out.println("Set das server to " + url);
        DAS2Request sources = new DAS2Request(url);
        List theDSNList = sources.getDSNs();
        Iterator dsnIterator = theDSNList.iterator();
        while (dsnIterator.hasNext()) {
            SimpleDASDsn dsn = (SimpleDASDsn)dsnIterator.next();
            dsn.setMapMaster(url);
            System.out.println("Adding versioned source to list: " + dsn);
        }
    }
}

