/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.das2;

import apollo.config.Config;
import apollo.dataadapter.AbstractApolloAdapter;
import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.DataInput;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.NonFatalDataAdapterException;
import apollo.dataadapter.NotImplementedException;
import apollo.dataadapter.StateInformation;
import apollo.dataadapter.das.DASDsn;
import apollo.dataadapter.das.DASFeature;
import apollo.dataadapter.das.DASSegment;
import apollo.dataadapter.das.simple.SimpleDASDsn;
import apollo.dataadapter.das.simple.SimpleDASSegment;
import apollo.dataadapter.das2.DAS2AdapterGUI;
import apollo.dataadapter.das2.DAS2FeatureSaxParser;
import apollo.dataadapter.das2.DAS2Request;
import apollo.dataadapter.das2.DAS2Writer;
import apollo.datamodel.CurationSet;
import apollo.datamodel.DbXref;
import apollo.datamodel.FeaturePair;
import apollo.datamodel.FeatureSet;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeature;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceI;
import apollo.datamodel.StrandedFeatureSet;
import apollo.datamodel.StrandedFeatureSetI;
import apollo.main.DataLoader;
import apollo.main.LoadUtil;
import apollo.main.Version;
import apollo.util.IOUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.bdgp.io.DataAdapterUI;
import org.bdgp.io.IOOperation;
import org.bdgp.util.ProgressEvent;

public class DAS2Adapter
extends AbstractApolloAdapter {
    private DAS2AdapterGUI gui;
    String server;
    DASDsn dsn;
    DASSegment segment;
    private SequenceI genomeSeq = null;
    int low = 1;
    int high = 100000;
    private static long groupIdInt = 0L;
    private Properties stateInformation = new StateInformation();
    DAS2Request dasServer;
    String filename;
    boolean NO_GUI = false;
    boolean DEBUG = true;
    IOOperation[] supportedOperations = new IOOperation[]{ApolloDataAdapterI.OP_READ_DATA, ApolloDataAdapterI.OP_READ_SEQUENCE, ApolloDataAdapterI.OP_WRITE_DATA};

    public DAS2Request getDASServer() {
        return this.dasServer;
    }

    public void setDASServer(DAS2Request newValue) {
        this.dasServer = newValue;
        if (this.DEBUG) {
            System.out.println("DAS2Adapter.setDasServer: URL = " + this.dasServer.getURL());
        }
    }

    public void init() {
    }

    public DASDsn getDSN() {
        return this.dsn;
    }

    public String getName() {
        return "DAS/2 server";
    }

    public String getType() {
        return "CGI server";
    }

    public DataInputType getInputType() {
        return DataInputType.URL;
    }

    public void setInput(String filename) {
        System.out.println("setInput: filename = " + filename);
        this.filename = filename;
    }

    public String getInput() {
        return this.filename;
    }

    public void setDataInput(DataInput dataInput) {
        super.setDataInput(dataInput);
        this.setInput(dataInput.getInputString());
    }

    public IOOperation[] getSupportedOperations() {
        return this.supportedOperations;
    }

    public DataAdapterUI getUI(IOOperation op) {
        if (this.gui == null) {
            this.gui = new DAS2AdapterGUI(op);
        }
        this.gui.setIOOperation(op);
        return this.gui;
    }

    private void setDSN(DASDsn dsn) {
        if (this.DEBUG) {
            System.out.println("DAS2Adapter.setDSN: dsn = " + dsn + "; capabilities = " + ((SimpleDASDsn)dsn).getCapabilities());
        }
        this.dsn = dsn;
    }

    private void setSegment(DASSegment segment) {
        this.segment = segment;
    }

    private DASSegment getSegment() {
        return this.segment;
    }

    private void setLow(int low) {
        this.low = low;
    }

    private void setHigh(int high) {
        this.high = high;
    }

    private int getLow() {
        return this.low;
    }

    private int getHigh() {
        return this.high;
    }

    public void setRegion(String region) throws ApolloAdapterException {
        SimpleDASSegment segment = (SimpleDASSegment)this.getSegment();
        if (this.DEBUG) {
            System.out.println("DAS2Adapter.setRegion: region = " + region);
        }
        if (region == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(region);
        String chrString = null;
        String chromosome = null;
        String start = null;
        String end = null;
        if (tokenizer.hasMoreTokens()) {
            chrString = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            chromosome = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            start = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            end = tokenizer.nextToken();
        }
        if (chromosome == null || start == null || end == null) {
            return;
        }
        if (segment != null) {
            segment.setId(chromosome);
            segment.setStart(start);
            segment.setStop(end);
        } else {
            this.setSegment(new SimpleDASSegment(null, chromosome, start, end, null, null, null));
        }
        this.setLow(Integer.valueOf(start));
        this.setHigh(Integer.valueOf(end));
        this.getStateInformation().setProperty("region", region);
        this.getStateInformation().setProperty("Segment_start", start);
        this.getStateInformation().setProperty("Segment_stop", end);
    }

    public Properties getStateInformation() {
        return this.stateInformation;
    }

    public void setStateInformation(Properties newProperties) {
        String proxySet;
        String highString;
        String segmentId;
        String dsnSourceId;
        Properties props = this.getStateInformation();
        props.putAll((Map<?, ?>)newProperties);
        if (props.getProperty("DAS_server_url") != null) {
            this.setDASServer(new DAS2Request(props.getProperty("DAS_server_url")));
        }
        if ((dsnSourceId = props.getProperty("DSN_sourceId")) != null && dsnSourceId.trim().length() > 0) {
            DAS2Request server = this.getDASServer();
            DASDsn dsn = server.getDSN(dsnSourceId);
            if (dsn == null) {
                System.out.println("DAS2Adapter: setting DSN to a new simpleDASDsn based on properties");
                this.setDSN(new SimpleDASDsn(dsnSourceId, props.getProperty("DSN_sourceVersion"), props.getProperty("DSN_source"), props.getProperty("DSN_mapMaster"), props.getProperty("DSN_description")));
            } else {
                this.setDSN(dsn);
            }
        }
        if ((segmentId = props.getProperty("Segment_segment")) != null && segmentId.trim().length() > 0) {
            this.setSegment(new SimpleDASSegment(segmentId, props.getProperty("Segment_id"), props.getProperty("Segment_start"), props.getProperty("Segment_stop"), props.getProperty("Segment_orientation"), props.getProperty("Segment_subparts"), props.getProperty("Segment_length")));
        } else if (this.DEBUG) {
            System.out.println("DAS2Adapter.setStateInformation: segment id is null!");
        }
        String lowString = props.getProperty("Segment_start");
        if (lowString != null && lowString.trim().length() > 0) {
            this.setLow(Integer.valueOf(lowString));
        }
        if ((highString = props.getProperty("Segment_stop")) != null && highString.trim().length() > 0) {
            this.setHigh(Integer.valueOf(highString));
        }
        if ((proxySet = props.getProperty("http.proxySet")) != null && "true".equals(proxySet)) {
            String proxyHost = props.getProperty("http.proxyHost");
            String proxyPort = props.getProperty("http.proxyPort");
            System.setProperty("proxySet", "true");
            System.setProperty("proxyHost", proxyHost);
            System.setProperty("proxyPort", proxyPort);
        }
        if (props.getProperty("region") != null) {
            try {
                this.setRegion(props.getProperty("region"));
            }
            catch (ApolloAdapterException exception) {
                throw new NonFatalDataAdapterException(exception.getMessage());
            }
        }
        this.stateInformation = props;
    }

    public CurationSet getCurationSet() throws ApolloAdapterException {
        CurationSet curation = null;
        BufferedInputStream bis = null;
        try {
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(5.0), "Finding data..."));
            InputStream xml_stream = this.getDAS2XMLStream();
            bis = new BufferedInputStream(xml_stream);
            if (!this.NO_GUI) {
                super.clearOldData();
            }
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(10.0), "Reading XML..."));
        }
        catch (Exception e) {
            System.err.println("Error trying to open XML stream: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
        try {
            curation = new CurationSet();
            DAS2FeatureSaxParser parser = new DAS2FeatureSaxParser();
            parser.parse(bis, curation);
            bis.close();
            this.setCurationRegion(curation);
            return curation;
        }
        catch (Exception e) {
            System.err.println("Error trying to parse XML: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private InputStream getDAS2XMLStream() throws ApolloAdapterException {
        DASDsn theDSN = this.getDSN();
        if (this.DEBUG) {
            System.out.println("DAS2Adapter.getDAS2XMLStream: theDSN = " + theDSN);
        }
        if (theDSN == null) {
            return this.das2XmlFileInputStream(this.getInput());
        }
        String query = this.makeFeatureQuery();
        if (this.DEBUG) {
            System.out.println("DAS2Adapter.getDAS2XMLStream: feature query = " + query);
        }
        try {
            URL url = new URL(query);
            InputStream stream = url.openStream();
            Thread.sleep(50L);
            if (stream.available() <= 1) {
                System.err.println("Couldn't fetch requested region: " + query);
                return null;
            }
            return stream;
        }
        catch (Exception e) {
            System.err.println("Couldn't open stream to " + query);
            throw new ApolloAdapterException("Couldn't open stream to " + query);
        }
    }

    private String getRegionString(DASSegment segment) {
        return segment.getSegment() + "/" + this.low + ":" + this.high;
    }

    private String makeRegionName(String featureQueryURL) {
        return featureQueryURL;
    }

    private String makeFeatureQuery() {
        String baseURL;
        String region = this.getRegionString(this.getSegment());
        SimpleDASDsn dsn = (SimpleDASDsn)this.getDSN();
        String featureRequest = dsn.getCapabilityURI("features");
        if (featureRequest == null) {
            String warning = "Warning: couldn't get 'features' capability for " + dsn.getSourceId() + "; capabilities hash = " + dsn.getCapabilities() + "\nUsing hardcoded query 'feature'.";
            System.out.println(warning);
            JOptionPane.showMessageDialog(null, warning, "Warning", 2);
            featureRequest = "feature";
        }
        if (!(baseURL = dsn.getMapMaster()).endsWith("/")) {
            baseURL = baseURL + "/";
        }
        return baseURL + featureRequest + "?overlaps=" + region;
    }

    private InputStream das2XmlFileInputStream(String filename) throws ApolloAdapterException {
        BufferedReader in;
        if (filename == null) {
            throw new ApolloAdapterException("No filename or DAS/2 source specified");
        }
        FileInputStream stream = null;
        String path = IOUtil.findFile(filename, false);
        try {
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(6.0), "Opening file..."));
            if (this.DEBUG) {
                System.out.println("Trying to open DAS2XML file " + filename);
            }
            stream = new FileInputStream(path);
        }
        catch (Exception e) {
            stream = null;
            throw new ApolloAdapterException("could not open DAS2XML file " + filename + " for reading.");
        }
        try {
            in = new BufferedReader(new FileReader(path));
        }
        catch (Exception e) {
            stream = null;
            throw new ApolloAdapterException("Error: could not open DAS2XML file " + path + " for reading.");
        }
        this.fireProgressEvent(new ProgressEvent((Object)this, new Double(7.0), "Validating file..."));
        for (int i = 0; i < 12; ++i) {
            String line;
            try {
                line = in.readLine();
            }
            catch (Exception e) {
                throw new ApolloAdapterException("Error: DAS2XML file " + filename + " is empty.");
            }
            if (line.toLowerCase().indexOf("das2") >= 0) {
                return stream;
            }
            if (line.toLowerCase().indexOf("das/genome/2") >= 0) {
                return stream;
            }
            if (line.toLowerCase().indexOf("das/2.") < 0) continue;
            return stream;
        }
        throw new ApolloAdapterException("Error: file " + filename + " does not appear to contain DAs2XML.");
    }

    private List parseFeatureSet() {
        DASDsn theDSN = this.getDSN();
        if (this.DEBUG) {
            System.out.println("DAS2Adapter.parseFeatureSet: theDSN = " + theDSN);
        }
        DASSegment inputSegment = this.getSegment();
        return this.getDASServer().getFeatures(theDSN, new DASSegment[]{inputSegment});
    }

    private void initializeMethodNameFeatureTypeFeatureSet(FeatureSetI targetFeatureSet, DASFeature theSourceFeature) {
        targetFeatureSet.setId(theSourceFeature.getTypeId());
        targetFeatureSet.setStrand(this.getStrandForOrientation(theSourceFeature.getOrientation()));
        targetFeatureSet.setProgramName(theSourceFeature.getMethodLabel());
        targetFeatureSet.setDatabase(theSourceFeature.getTypeId());
        targetFeatureSet.setFeatureType(this.getMethodAndFeatureType(theSourceFeature));
        targetFeatureSet.setName(theSourceFeature.getTypeLabel());
    }

    private void initializeGroupFeatureSet(FeatureSetI groupFeatureSet, DASFeature theFeature, boolean setIsHolder) {
        String methodAndFeatureType = this.getMethodAndFeatureType(theFeature);
        groupFeatureSet.setStrand(this.getStrandForOrientation(theFeature.getOrientation()));
        groupFeatureSet.setFeatureType(this.getMethodAndFeatureType(theFeature));
        if (theFeature.getGroupId() != null) {
            groupFeatureSet.setId(theFeature.getGroupId());
            groupFeatureSet.setName(theFeature.getGroupId());
        } else {
            groupFeatureSet.setId(theFeature.getId());
            groupFeatureSet.setName(theFeature.getId());
        }
        if (theFeature.getScore() != null) {
            groupFeatureSet.setScore(Double.parseDouble(theFeature.getScore()));
        }
    }

    private void addFeaturePairToGroupFeatureSet(FeatureSetI groupFeatureSet, DASFeature theFeature) {
        SeqFeature sf_1 = new SeqFeature();
        SeqFeature sf_2 = new SeqFeature();
        FeaturePair featurePair = new FeaturePair(sf_1, sf_2);
        String featureId = theFeature.getId();
        String orientation = theFeature.getOrientation();
        String score = theFeature.getScore();
        String start = theFeature.getStart();
        String end = theFeature.getEnd();
        String targetId = theFeature.getTargetId();
        String targetStart = theFeature.getTargetStart();
        String targetStop = theFeature.getTargetStop();
        String methodLabelFeatureType = this.getMethodAndFeatureType(theFeature);
        sf_1.setId(featureId);
        sf_2.setId(featureId);
        sf_1.setFeatureType(methodLabelFeatureType);
        sf_2.setFeatureType(methodLabelFeatureType);
        if (score != null) {
            sf_1.setScore(Double.parseDouble(score));
            sf_2.setScore(Double.parseDouble(score));
        }
        if (targetId != null) {
            sf_1.setName(targetId);
            sf_2.setName(targetId);
            sf_2.setStrand(1);
            sf_2.setLow(Integer.parseInt(targetStart));
            sf_2.setHigh(Integer.parseInt(targetStop));
            sf_2.setRefSequence(groupFeatureSet.getHitSequence());
        } else {
            sf_1.setName(featureId);
            sf_2.setName(featureId);
        }
        sf_1.setStrand(this.getStrandForOrientation(orientation));
        if (start != null) {
            sf_1.setLow(Integer.parseInt(start));
        }
        if (end != null) {
            sf_1.setHigh(Integer.parseInt(end));
        }
        sf_1.setRefSequence(groupFeatureSet.getHitSequence());
        featurePair = new FeaturePair(sf_1, sf_2);
        if (groupFeatureSet.getId() != null) {
            featurePair.setName(groupFeatureSet.getId() + " span " + groupFeatureSet.size());
        } else {
            featurePair.setName(" span " + groupFeatureSet.size());
        }
        groupFeatureSet.addFeature(featurePair);
    }

    public StrandedFeatureSetI getAnalysisRegion(CurationSet curation) throws ApolloAdapterException {
        StrandedFeatureSet parentStrandedFeatureSet = new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet());
        HashMap<String, Object[]> methodNameFeatureTypes = new HashMap<String, Object[]>();
        FeatureSet methodNameFeatureTypeFeatureSet = null;
        FeatureSet groupFeatureSet = null;
        double numberOfFeatures = 0.0;
        double featureCount = 0.0;
        double percentFeaturesLastDisplayed = 0.0;
        boolean initializeAsHolder = false;
        this.fireProgressEvent(new ProgressEvent((Object)this, new Double(0.0), "Getting features from DASServer"));
        List allDASFeatures = this.parseFeatureSet();
        numberOfFeatures = allDASFeatures.size();
        this.fireProgressEvent(new ProgressEvent((Object)this, new Double(50.0), "Building browser image"));
        parentStrandedFeatureSet = new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet());
        parentStrandedFeatureSet.setName("Analyses");
        Iterator features = allDASFeatures.iterator();
        while (features.hasNext()) {
            String groupIdAndOrientation;
            HashMap groupsForAMethodNameAndFeatureType;
            DASFeature theFeature = (DASFeature)features.next();
            String methodNameFeatureTypeAndOrientation = this.getMethodAndFeatureType(theFeature) + theFeature.getOrientation();
            if (methodNameFeatureTypes.get(methodNameFeatureTypeAndOrientation) == null) {
                methodNameFeatureTypeFeatureSet = new FeatureSet();
                this.initializeMethodNameFeatureTypeFeatureSet(methodNameFeatureTypeFeatureSet, theFeature);
                groupsForAMethodNameAndFeatureType = new HashMap();
                methodNameFeatureTypes.put(methodNameFeatureTypeAndOrientation, new Object[]{methodNameFeatureTypeFeatureSet, groupsForAMethodNameAndFeatureType});
                parentStrandedFeatureSet.addFeature(methodNameFeatureTypeFeatureSet);
            } else {
                Object[] setAndHashMap = (Object[])methodNameFeatureTypes.get(methodNameFeatureTypeAndOrientation);
                methodNameFeatureTypeFeatureSet = (FeatureSet)setAndHashMap[0];
                groupsForAMethodNameAndFeatureType = (HashMap)setAndHashMap[1];
            }
            String groupId = theFeature.getGroupId();
            if (groupId != null && groupId.trim().length() > 0) {
                groupIdAndOrientation = theFeature.getGroupId() + theFeature.getOrientation();
                initializeAsHolder = false;
            } else {
                groupIdAndOrientation = theFeature.getId() + " " + ++groupIdInt;
                initializeAsHolder = true;
            }
            if (groupsForAMethodNameAndFeatureType.get(groupIdAndOrientation) == null) {
                groupFeatureSet = new FeatureSet();
                this.initializeGroupFeatureSet(groupFeatureSet, theFeature, initializeAsHolder);
                groupsForAMethodNameAndFeatureType.put(groupIdAndOrientation, groupFeatureSet);
                methodNameFeatureTypeFeatureSet.addFeature(groupFeatureSet);
            } else {
                groupFeatureSet = (FeatureSet)groupsForAMethodNameAndFeatureType.get(groupIdAndOrientation);
            }
            this.addFeaturePairToGroupFeatureSet(groupFeatureSet, theFeature);
        }
        parentStrandedFeatureSet.setRefSequence(curation.getRefSequence());
        return parentStrandedFeatureSet;
    }

    public FeatureSetI getAnnotatedRegion() throws ApolloAdapterException {
        return new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet());
    }

    public SequenceI getSequence(String id) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public SequenceI getSequence(DbXref dbxref) throws ApolloAdapterException {
        System.out.println("getSequence(" + dbxref + "): don't yet know how to get sequence");
        return null;
    }

    public SequenceI getSequence(DbXref dbxref, int start, int end) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public Vector getSequences(DbXref[] dbxref) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public Vector getSequences(DbXref[] dbxref, int[] start, int[] end) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public String getRawAnalysisResults(String id) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    private int getStrandForOrientation(String orientation) {
        if (orientation.equals("+")) {
            return 1;
        }
        if (orientation.equals("-")) {
            return -1;
        }
        if (orientation.equals("0")) {
            return 0;
        }
        throw new NonFatalDataAdapterException("Received orientation: " + orientation + "-- I only accept +,-,0");
    }

    private String getMethodAndFeatureType(DASFeature theFeature) {
        if (theFeature.getMethodLabel() != null && theFeature.getMethodLabel().trim().length() > 0) {
            return theFeature.getMethodLabel() + ":" + theFeature.getTypeId();
        }
        return theFeature.getTypeId();
    }

    public void clearStateInformation() {
        this.stateInformation = new StateInformation();
    }

    public void validateStateInformation() {
        String region = this.getStateInformation().getProperty("region");
        String lowText = this.getStateInformation().getProperty("Segment_start");
        String highText = this.getStateInformation().getProperty("Segment_stop");
        if (this.getDSN() == null) {
            throw new NonFatalDataAdapterException("getDSN returned null");
        }
        if (this.getSegment() == null) {
            throw new NonFatalDataAdapterException("getSegment returned null.  region = " + region);
        }
        if (lowText == null || highText == null) {
            throw new NonFatalDataAdapterException("Low/High range must be specified");
        }
    }

    private void setCurationRegion(CurationSet curation) {
        if (this.getSegment() != null) {
            curation.setChromosome(this.getSegment().getId());
        }
        if (this.getDSN() == null) {
            curation.setName(this.getInput());
        } else {
            curation.setName(this.makeRegionName(this.makeFeatureQuery()));
        }
        StrandedFeatureSetI results = curation.getResults();
        SeqFeatureI firstresult = results.getFeatureAt(0);
        if (firstresult == null) {
            System.err.println("DAS2Adapter.setCurationRegion: no results!");
            return;
        }
        curation.setLow(firstresult.getLow());
        SeqFeatureI lastresult = results.getFeatureAt(results.getFeatures().size() - 1);
        int padding = (lastresult.getHigh() - lastresult.getLow()) / 20;
        curation.setHigh(lastresult.getHigh() + padding);
        System.out.println("Set region to " + curation.getChromosome() + ":" + curation.getLow() + "-" + curation.getHigh() + " + " + padding + " based on extent of first and last results");
        curation.setStrand(1);
    }

    public void commitChanges(CurationSet curation) {
        File handle;
        String filename = IOUtil.findFile(this.getInput(), true);
        if (filename == null) {
            filename = this.getInput();
        }
        if (filename == null) {
            return;
        }
        if (Config.getConfirmOverwrite() && (handle = new File(filename)).exists() && !LoadUtil.areYouSure(filename + " already exists--overwrite?")) {
            DataLoader loader = new DataLoader();
            loader.saveFileDialog(curation);
            return;
        }
        this.setInput(filename);
        String msg = "Saving data to file " + filename;
        this.fireProgressEvent(new ProgressEvent((Object)this, new Double(10.0), msg));
        if (DAS2Writer.writeXML(curation, filename, "Apollo version: " + Version.getVersion())) {
            System.out.println("Saved DAS2XML to " + filename);
        } else {
            String message = "Failed to save DAS2XML to " + filename;
            System.err.println(message);
            JOptionPane.showMessageDialog(null, message, "Warning", 2);
        }
    }

    public static void main(String[] args) {
        DAS2FeatureSaxParser featureParser = new DAS2FeatureSaxParser();
        try {
            String test_file_name = args[0];
            File test_file = new File(test_file_name);
            FileInputStream fistr = new FileInputStream(test_file);
            BufferedInputStream bis = new BufferedInputStream(fistr);
            System.out.println("Opened input stream to " + test_file_name);
            CurationSet curation = new CurationSet();
            curation.setName(test_file_name);
            featureParser.parse(bis, curation);
            bis.close();
            DAS2Adapter adapter = new DAS2Adapter();
            adapter.setInput(test_file_name);
            adapter.setCurationRegion(curation);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

