/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.das.simple;

import apollo.config.Config;
import apollo.dataadapter.AbstractApolloAdapter;
import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.NonFatalDataAdapterException;
import apollo.dataadapter.NotImplementedException;
import apollo.dataadapter.StateInformation;
import apollo.dataadapter.das.DASDsn;
import apollo.dataadapter.das.DASFeature;
import apollo.dataadapter.das.DASLazySequence;
import apollo.dataadapter.das.DASSegment;
import apollo.dataadapter.das.DASServerI;
import apollo.dataadapter.das.simple.SimpleDASAdapterGUI;
import apollo.dataadapter.das.simple.SimpleDASDsn;
import apollo.dataadapter.das.simple.SimpleDASSegment;
import apollo.dataadapter.das.simple.SimpleDASServer;
import apollo.datamodel.CurationSet;
import apollo.datamodel.DbXref;
import apollo.datamodel.FeaturePair;
import apollo.datamodel.FeatureSet;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.Range;
import apollo.datamodel.SeqFeature;
import apollo.datamodel.Sequence;
import apollo.datamodel.SequenceI;
import apollo.datamodel.StrandedFeatureSet;
import apollo.datamodel.StrandedFeatureSetI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.bdgp.io.DataAdapterUI;
import org.bdgp.io.IOOperation;
import org.bdgp.util.ProgressEvent;

public class SimpleDASAdapter
extends AbstractApolloAdapter {
    String server;
    DASDsn dsn;
    DASSegment segment;
    private SequenceI genomeSeq = null;
    int low = 1;
    int high = 100000;
    private static long groupIdInt = 0L;
    private Properties stateInformation = new StateInformation();
    DASServerI dasServer;
    IOOperation[] supportedOperations = new IOOperation[]{ApolloDataAdapterI.OP_READ_DATA, ApolloDataAdapterI.OP_READ_SEQUENCE};

    public DASServerI getDASServer() {
        return this.dasServer;
    }

    public void setDASServer(DASServerI newValue) {
        this.dasServer = newValue;
        System.out.println("setDasServer: URL = " + this.dasServer.getURL());
    }

    public void init() {
    }

    public DASDsn getDSN() {
        return this.dsn;
    }

    public String getName() {
        return "Distributed Annotation Server";
    }

    public String getType() {
        return "CGI server";
    }

    public DataInputType getInputType() {
        return DataInputType.URL;
    }

    public String getInput() {
        return this.segment.getId();
    }

    public IOOperation[] getSupportedOperations() {
        return this.supportedOperations;
    }

    public DataAdapterUI getUI(IOOperation op) {
        return new SimpleDASAdapterGUI(op);
    }

    private void setDSN(DASDsn dsn) {
        this.dsn = dsn;
    }

    private void setSegment(DASSegment segment) {
        this.segment = segment;
        System.out.println("setSegment: segment = " + segment);
    }

    private DASSegment getSegment() {
        return this.segment;
    }

    private void setLow(int low) {
        this.low = low;
    }

    private void setHigh(int high) {
        this.high = high;
    }

    private int getLow() {
        return this.low;
    }

    private int getHigh() {
        return this.high;
    }

    public void setRegion(String region) throws ApolloAdapterException {
        SimpleDASSegment segment = (SimpleDASSegment)this.getSegment();
        System.out.println("setRegion: region = " + region);
        if (region == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(region);
        String chrString = null;
        String chromosome = null;
        String start = null;
        String end = null;
        if (tokenizer.hasMoreTokens()) {
            chrString = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            chromosome = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            start = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            end = tokenizer.nextToken();
        }
        if (chromosome == null || start == null || end == null) {
            return;
        }
        if (segment != null) {
            segment.setId(chromosome);
            segment.setStart(start);
            segment.setStop(end);
        } else {
            this.setSegment(new SimpleDASSegment(null, chromosome, start, end, null, null, null));
        }
        this.setLow(Integer.valueOf(start));
        this.setHigh(Integer.valueOf(end));
        this.getStateInformation().setProperty("region", region);
        this.getStateInformation().setProperty("Segment_start", start);
        this.getStateInformation().setProperty("Segment_stop", end);
    }

    public Properties getStateInformation() {
        return this.stateInformation;
    }

    public void setStateInformation(Properties newProperties) {
        String proxySet;
        String highString;
        String segmentId;
        String dsnSourceId;
        Properties props = this.getStateInformation();
        props.putAll((Map<?, ?>)newProperties);
        System.out.println("SimpleDASAdapter.setStateInformation: props = " + props);
        if (props.getProperty("DAS_server_url") != null) {
            this.setDASServer(new SimpleDASServer(props.getProperty("DAS_server_url")));
        }
        if ((dsnSourceId = props.getProperty("DSN_sourceId")) != null && dsnSourceId.trim().length() > 0) {
            this.setDSN(new SimpleDASDsn(dsnSourceId, props.getProperty("DSN_sourceVersion"), props.getProperty("DSN_source"), props.getProperty("DSN_mapMaster"), props.getProperty("DSN_description")));
        }
        if ((segmentId = props.getProperty("Segment_id")) != null && segmentId.trim().length() > 0) {
            this.setSegment(new SimpleDASSegment(segmentId, props.getProperty("Segment_id"), props.getProperty("Segment_start"), props.getProperty("Segment_stop"), props.getProperty("Segment_orientation"), props.getProperty("Segment_subparts"), props.getProperty("Segment_length")));
        } else {
            System.out.println("segment id is null!");
        }
        String lowString = props.getProperty("Segment_start");
        if (lowString != null && lowString.trim().length() > 0) {
            this.setLow(Integer.valueOf(lowString));
        }
        if ((highString = props.getProperty("Segment_stop")) != null && highString.trim().length() > 0) {
            this.setHigh(Integer.valueOf(highString));
        }
        if ((proxySet = props.getProperty("http.proxySet")) != null && "true".equals(proxySet)) {
            String proxyHost = props.getProperty("http.proxyHost");
            String proxyPort = props.getProperty("http.proxyPort");
            System.setProperty("proxySet", "true");
            System.setProperty("proxyHost", proxyHost);
            System.setProperty("proxyPort", proxyPort);
        }
        if (props.getProperty("region") != null) {
            try {
                this.setRegion(props.getProperty("region"));
            }
            catch (ApolloAdapterException exception) {
                throw new NonFatalDataAdapterException(exception.getMessage());
            }
        }
        this.stateInformation = props;
    }

    public CurationSet getCurationSet() throws ApolloAdapterException {
        CurationSet curationSet = new CurationSet();
        this.validateStateInformation();
        curationSet.setAnnots(new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet()));
        curationSet.setRefSequence(new Sequence(this.getSegment().getId(), ""));
        curationSet.setResults(this.getAnalysisRegion(curationSet));
        curationSet.setLow(this.low);
        curationSet.setHigh(this.high);
        try {
            this.genomeSeq = this.getSequence(new DbXref(this.getDSN().getSourceId(), this.getSegment().getId(), this.getSegment().getId()));
            curationSet.setChromosome(this.segment.getId());
            curationSet.setName(this.segment.getId());
            curationSet.setRefSequence(this.genomeSeq);
        }
        catch (Exception e) {
            throw new ApolloAdapterException("Load failed. Are you sure " + this.segment + "is a real sequence?", e);
        }
        return curationSet;
    }

    private List parseFeatureSet() {
        DASDsn theDSN = this.getDSN();
        System.out.println("parseFeatureSet: theDSN = " + theDSN);
        DASSegment inputSegment = this.getSegment();
        return this.getDASServer().getFeatures(theDSN, new DASSegment[]{inputSegment});
    }

    private void initializeMethodNameFeatureTypeFeatureSet(FeatureSetI targetFeatureSet, DASFeature theSourceFeature) {
        targetFeatureSet.setId(theSourceFeature.getTypeId());
        targetFeatureSet.setStrand(this.getStrandForOrientation(theSourceFeature.getOrientation()));
        targetFeatureSet.setProgramName(theSourceFeature.getMethodLabel());
        targetFeatureSet.setDatabase(theSourceFeature.getTypeId());
        targetFeatureSet.setFeatureType(this.getMethodAndFeatureType(theSourceFeature));
        targetFeatureSet.setName(theSourceFeature.getTypeLabel());
    }

    private void initializeGroupFeatureSet(FeatureSetI groupFeatureSet, DASFeature theFeature, boolean setIsHolder) {
        String methodAndFeatureType = this.getMethodAndFeatureType(theFeature);
        groupFeatureSet.setStrand(this.getStrandForOrientation(theFeature.getOrientation()));
        groupFeatureSet.setFeatureType(this.getMethodAndFeatureType(theFeature));
        if (theFeature.getGroupId() != null) {
            groupFeatureSet.setId(theFeature.getGroupId());
            groupFeatureSet.setName(theFeature.getGroupId());
        } else {
            groupFeatureSet.setId(theFeature.getId());
            groupFeatureSet.setName(theFeature.getId());
        }
        if (theFeature.getScore() != null) {
            groupFeatureSet.setScore(Double.parseDouble(theFeature.getScore()));
        }
    }

    private void addFeaturePairToGroupFeatureSet(FeatureSetI groupFeatureSet, DASFeature theFeature) {
        SeqFeature sf_1 = new SeqFeature();
        SeqFeature sf_2 = new SeqFeature();
        FeaturePair featurePair = new FeaturePair(sf_1, sf_2);
        String featureId = theFeature.getId();
        String orientation = theFeature.getOrientation();
        String score = theFeature.getScore();
        String start = theFeature.getStart();
        String end = theFeature.getEnd();
        String targetId = theFeature.getTargetId();
        String targetStart = theFeature.getTargetStart();
        String targetStop = theFeature.getTargetStop();
        String methodLabelFeatureType = this.getMethodAndFeatureType(theFeature);
        sf_1.setId(featureId);
        sf_2.setId(featureId);
        sf_1.setFeatureType(methodLabelFeatureType);
        sf_2.setFeatureType(methodLabelFeatureType);
        if (score != null) {
            sf_1.setScore(Double.parseDouble(score));
            sf_2.setScore(Double.parseDouble(score));
        }
        if (targetId != null) {
            sf_1.setName(targetId);
            sf_2.setName(targetId);
            sf_2.setStrand(1);
            sf_2.setLow(Integer.parseInt(targetStart));
            sf_2.setHigh(Integer.parseInt(targetStop));
            sf_2.setRefSequence(groupFeatureSet.getHitSequence());
        } else {
            sf_1.setName(featureId);
            sf_2.setName(featureId);
        }
        sf_1.setStrand(this.getStrandForOrientation(orientation));
        if (start != null) {
            sf_1.setLow(Integer.parseInt(start));
        }
        if (end != null) {
            sf_1.setHigh(Integer.parseInt(end));
        }
        sf_1.setRefSequence(groupFeatureSet.getHitSequence());
        featurePair = new FeaturePair(sf_1, sf_2);
        if (groupFeatureSet.getId() != null) {
            featurePair.setName(groupFeatureSet.getId() + " span " + groupFeatureSet.size());
        } else {
            featurePair.setName(" span " + groupFeatureSet.size());
        }
        groupFeatureSet.addFeature(featurePair);
    }

    public StrandedFeatureSetI getAnalysisRegion(CurationSet curation) throws ApolloAdapterException {
        StrandedFeatureSet parentStrandedFeatureSet = new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet());
        HashMap<String, Object[]> methodNameFeatureTypes = new HashMap<String, Object[]>();
        FeatureSet methodNameFeatureTypeFeatureSet = null;
        FeatureSet groupFeatureSet = null;
        double numberOfFeatures = 0.0;
        double featureCount = 0.0;
        double percentFeaturesLastDisplayed = 0.0;
        boolean initializeAsHolder = false;
        this.fireProgressEvent(new ProgressEvent((Object)this, new Double(0.0), "Getting features from DASServer"));
        List allDASFeatures = this.parseFeatureSet();
        numberOfFeatures = allDASFeatures.size();
        this.fireProgressEvent(new ProgressEvent((Object)this, new Double(50.0), "Building browser image"));
        parentStrandedFeatureSet = new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet());
        parentStrandedFeatureSet.setName("Analyses");
        Iterator features = allDASFeatures.iterator();
        while (features.hasNext()) {
            String groupIdAndOrientation;
            HashMap groupsForAMethodNameAndFeatureType;
            DASFeature theFeature = (DASFeature)features.next();
            String methodNameFeatureTypeAndOrientation = this.getMethodAndFeatureType(theFeature) + theFeature.getOrientation();
            if (methodNameFeatureTypes.get(methodNameFeatureTypeAndOrientation) == null) {
                methodNameFeatureTypeFeatureSet = new FeatureSet();
                this.initializeMethodNameFeatureTypeFeatureSet(methodNameFeatureTypeFeatureSet, theFeature);
                groupsForAMethodNameAndFeatureType = new HashMap();
                methodNameFeatureTypes.put(methodNameFeatureTypeAndOrientation, new Object[]{methodNameFeatureTypeFeatureSet, groupsForAMethodNameAndFeatureType});
                parentStrandedFeatureSet.addFeature(methodNameFeatureTypeFeatureSet);
            } else {
                Object[] setAndHashMap = (Object[])methodNameFeatureTypes.get(methodNameFeatureTypeAndOrientation);
                methodNameFeatureTypeFeatureSet = (FeatureSet)setAndHashMap[0];
                groupsForAMethodNameAndFeatureType = (HashMap)setAndHashMap[1];
            }
            String groupId = theFeature.getGroupId();
            if (groupId != null && groupId.trim().length() > 0) {
                groupIdAndOrientation = theFeature.getGroupId() + theFeature.getOrientation();
                initializeAsHolder = false;
            } else {
                groupIdAndOrientation = theFeature.getId() + " " + ++groupIdInt;
                initializeAsHolder = true;
            }
            if (groupsForAMethodNameAndFeatureType.get(groupIdAndOrientation) == null) {
                groupFeatureSet = new FeatureSet();
                this.initializeGroupFeatureSet(groupFeatureSet, theFeature, initializeAsHolder);
                groupsForAMethodNameAndFeatureType.put(groupIdAndOrientation, groupFeatureSet);
                methodNameFeatureTypeFeatureSet.addFeature(groupFeatureSet);
            } else {
                groupFeatureSet = (FeatureSet)groupsForAMethodNameAndFeatureType.get(groupIdAndOrientation);
            }
            this.addFeaturePairToGroupFeatureSet(groupFeatureSet, theFeature);
        }
        parentStrandedFeatureSet.setRefSequence(curation.getRefSequence());
        return parentStrandedFeatureSet;
    }

    public FeatureSetI getAnnotatedRegion() throws ApolloAdapterException {
        return new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet());
    }

    public SequenceI getSequence(String id) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public SequenceI getSequence(DbXref dbxref) throws ApolloAdapterException {
        String referenceDataSourceDSN;
        String segmentId = this.getSegment().getId();
        String start = this.getSegment().getStart();
        String stop = this.getSegment().getStop();
        SimpleDASDsn theSetDSN = null;
        String mapMaster = null;
        theSetDSN = new SimpleDASDsn(this.getDSN().getSourceId(), this.getDSN().getSourceVersion(), this.getDSN().getSource(), this.getDSN().getMapMaster(), this.getDSN().getDescription());
        mapMaster = theSetDSN.getMapMaster();
        int indexOfLastSlash = mapMaster.lastIndexOf(47);
        String referenceDataSourceURL = null;
        if (mapMaster.endsWith("/")) {
            referenceDataSourceURL = mapMaster.substring(0, indexOfLastSlash);
            indexOfLastSlash = referenceDataSourceURL.lastIndexOf(47);
            referenceDataSourceDSN = referenceDataSourceURL.substring(indexOfLastSlash + 1);
            referenceDataSourceURL = referenceDataSourceURL.substring(0, indexOfLastSlash);
        } else {
            referenceDataSourceDSN = mapMaster.substring(indexOfLastSlash + 1);
            referenceDataSourceURL = mapMaster.substring(0, indexOfLastSlash);
        }
        SimpleDASServer referenceServer = new SimpleDASServer(referenceDataSourceURL);
        theSetDSN.setSourceId(referenceDataSourceDSN);
        if (dbxref.getIdValue().equals(segmentId)) {
            DASLazySequence theSequence = new DASLazySequence(segmentId, Config.getController(), new Range(segmentId, Integer.valueOf(start), Integer.valueOf(stop)), referenceServer, theSetDSN, this.getSegment());
            theSequence.getCacher().setMaxSize(1000000);
            return theSequence;
        }
        throw new NotImplementedException();
    }

    public SequenceI getSequence(DbXref dbxref, int start, int end) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public Vector getSequences(DbXref[] dbxref) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public Vector getSequences(DbXref[] dbxref, int[] start, int[] end) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public void commitChanges(CurationSet curationSet) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public String getRawAnalysisResults(String id) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    private int getStrandForOrientation(String orientation) {
        if (orientation.equals("+")) {
            return 1;
        }
        if (orientation.equals("-")) {
            return -1;
        }
        if (orientation.equals("0")) {
            return 0;
        }
        throw new NonFatalDataAdapterException("Received orientation: " + orientation + "-- I only accept +,-,0");
    }

    private String getMethodAndFeatureType(DASFeature theFeature) {
        if (theFeature.getMethodLabel() != null && theFeature.getMethodLabel().trim().length() > 0) {
            return theFeature.getMethodLabel() + ":" + theFeature.getTypeId();
        }
        return theFeature.getTypeId();
    }

    public void clearStateInformation() {
        this.stateInformation = new StateInformation();
    }

    public void validateStateInformation() {
        String region = this.getStateInformation().getProperty("region");
        String lowText = this.getStateInformation().getProperty("Segment_start");
        String highText = this.getStateInformation().getProperty("Segment_stop");
        if (this.getDSN() == null) {
            throw new NonFatalDataAdapterException("getDSN returned null");
        }
        if (this.getSegment() == null) {
            throw new NonFatalDataAdapterException("getSegment returned null.  region = " + region);
        }
        if (lowText == null || highText == null) {
            throw new NonFatalDataAdapterException("Low/High range must be specified");
        }
    }
}

