/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.das;

import apollo.dataadapter.NonFatalDataAdapterException;
import apollo.dataadapter.das.DASDsn;
import apollo.dataadapter.das.DASSegment;
import apollo.dataadapter.das.DASSequence;
import apollo.dataadapter.das.DASServerI;
import apollo.datamodel.Range;
import apollo.datamodel.RangeI;
import apollo.datamodel.SequenceI;
import apollo.datamodel.seq.AbstractLazySequence;
import apollo.datamodel.seq.LazySequenceI;
import apollo.gui.Controller;
import java.util.List;

public class DASLazySequence
extends AbstractLazySequence
implements LazySequenceI {
    DASServerI server;
    DASDsn dsn;
    DASSegment segment;

    public DASLazySequence(String id, Controller c, RangeI loc, DASServerI theServer, DASDsn theDsn, DASSegment theSegment) {
        super(id, c);
        this.setRange(loc);
        this.setLength(loc.length());
        this.server = theServer;
        this.dsn = theDsn;
        this.segment = theSegment;
    }

    public DASServerI getServer() {
        return this.server;
    }

    public DASDsn getDsn() {
        return this.dsn;
    }

    public DASSegment getSegment() {
        return this.segment;
    }

    public SequenceI getSubSequence(int start, int end) {
        Range subLoc = new Range(this.getRange().getName(), this.getRange().getStart() + start - 1, this.getRange().getStart() + end - 1);
        this.getSegment().setStart(String.valueOf(this.getRange().getStart() + start - 1));
        this.getSegment().setStop(String.valueOf(this.getRange().getStart() + end - 1));
        return new DASLazySequence(this.getName(), this.llco.getController(), subLoc, this.getServer(), this.getDsn(), this.getSegment());
    }

    protected String getResiduesFromSourceImpl(int low, int high) {
        List theSequenceList = this.getServer().getSequences(this.getDsn(), new DASSegment[]{this.getSegment()});
        if (theSequenceList.size() <= 0) {
            throw new NonFatalDataAdapterException("sequence fetch returned no sequences");
        }
        DASSequence theSequence = (DASSequence)theSequenceList.iterator().next();
        String sequenceString = theSequence.getDNA();
        return sequenceString;
    }
}

