/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.chado.jdbc;

import apollo.config.Config;
import apollo.config.PropertyScheme;
import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.Region;
import apollo.dataadapter.chado.ChadoAdapter;
import apollo.dataadapter.chado.jdbc.ChadoCds;
import apollo.dataadapter.chado.jdbc.ChadoFeatureLoc;
import apollo.dataadapter.chado.jdbc.ChadoInstance;
import apollo.dataadapter.chado.jdbc.ChadoLazySequence;
import apollo.dataadapter.chado.jdbc.ChadoProgram;
import apollo.dataadapter.chado.jdbc.FeatureLocImplementation;
import apollo.dataadapter.chado.jdbc.FlybaseWrite;
import apollo.dataadapter.chado.jdbc.RelationshipCVException;
import apollo.dataadapter.chado.jdbc.SchemaVersion;
import apollo.datamodel.AnnotatedFeature;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.Comment;
import apollo.datamodel.CurationSet;
import apollo.datamodel.DbXref;
import apollo.datamodel.Exon;
import apollo.datamodel.FeaturePair;
import apollo.datamodel.FeatureSet;
import apollo.datamodel.Range;
import apollo.datamodel.RangeI;
import apollo.datamodel.Score;
import apollo.datamodel.SeqFeature;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.Sequence;
import apollo.datamodel.SequenceEdit;
import apollo.datamodel.SequenceI;
import apollo.datamodel.StrandedFeatureSet;
import apollo.datamodel.Synonym;
import apollo.datamodel.Transcript;
import apollo.util.FeatureList;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public abstract class JdbcChadoAdapter {
    protected String jdbcUrl;
    protected String chadoDb;
    protected String username;
    protected String password;
    public static boolean debug = true;
    protected String organismLike;
    protected SchemaVersion chadoVersion;
    private Map featureCvTerms;
    private Map relationshipCvTerms;
    private Map propertyTypeCvTerms;
    private ChadoInstance chadoInstance;
    private PropertyScheme propertyScheme;
    private Connection connection;
    Hashtable seqHash = new Hashtable();
    Map idToOrganism;
    private AnalysisTable analysisTable;

    public void init(String jdbcUrl, String chadoDb, String username, String password, boolean debug, String organismLike) {
        this.jdbcUrl = jdbcUrl;
        this.chadoDb = chadoDb;
        this.username = username;
        this.password = password;
        JdbcChadoAdapter.debug = Config.DEBUG;
        this.organismLike = organismLike;
        Connection conn = this.getConnection();
        this.chadoVersion = SchemaVersion.guessSchemaVersion(conn);
        System.out.println("Chado schema version appears to be " + this.chadoVersion);
    }

    public void initWithException(String jdbcUrl, String chadoDb, String username, String password, boolean debug, String organismLike) throws SQLException {
        this.jdbcUrl = jdbcUrl;
        this.chadoDb = chadoDb;
        this.username = username;
        this.password = password;
        JdbcChadoAdapter.debug = Config.DEBUG;
        this.organismLike = organismLike;
        Connection conn = this.getConnectionWithException();
        this.chadoVersion = SchemaVersion.guessSchemaVersion(conn);
        System.out.println("Chado schema version appears to be " + this.chadoVersion);
    }

    public void setPropertyScheme(PropertyScheme ps) {
        this.propertyScheme = ps;
    }

    protected SchemaVersion getChadoVersion() {
        return this.chadoVersion;
    }

    public void setChadoInstance(ChadoInstance instance) {
        this.chadoInstance = instance;
        if (this.chadoInstance != null) {
            this.chadoInstance.setChadoAdapter(this);
        }
    }

    public ChadoInstance getChadoInstance() {
        return this.chadoInstance;
    }

    public void validateConnectionAndSequence(String seqType, String seqId) throws ApolloAdapterException {
        Connection conn = this.getConnection();
        if (conn == null) {
            throw new ApolloAdapterException("Unable to connect to chado database - please check database/login information and try again");
        }
        if (seqId.trim().equals("")) {
            throw new ApolloAdapterException("No sequence specified - please enter a valid sequence name");
        }
        if (!this.chadoFeatureExists(conn, seqType, seqId)) {
            throw new ApolloAdapterException("Cannot find sequence of type '" + seqType + "'" + " with uniquename '" + seqId + "'");
        }
    }

    protected void loadClass(String jdbcDriverClass) {
        Class<?> c = null;
        try {
            c = Class.forName(jdbcDriverClass);
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println(this.getClass() + ": unable to find JDBC driver class '" + jdbcDriverClass + "' - check CLASSPATH");
        }
        if (debug && c != null) {
            System.out.println(this.getClass() + ": loaded JDBC driver class '" + c);
        }
    }

    protected Connection getConnection() {
        try {
            return this.getConnectionWithException();
        }
        catch (SQLException sqle) {
            System.err.println(this.getClass() + ": exception connecting to Chado database at JDBC URL " + this.jdbcUrl);
            sqle.printStackTrace(System.err);
            return this.connection;
        }
    }

    protected Connection getConnectionWithException() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            this.connection = this.getNewConnection();
        }
        return this.connection;
    }

    protected Connection getNewConnection() throws SQLException {
        return DriverManager.getConnection(this.jdbcUrl, this.username, this.password);
    }

    protected long getFeatureId(Connection c, String featType, String featName) {
        long featureId = -1L;
        try {
            Statement s = c.createStatement();
            String sql = "SELECT f.feature_id FROM feature f WHERE (f.uniquename = '" + featName + "' OR f.name = '" + featName + "') " + "AND f.type_id = " + this.getFeatureCVTermId(featType);
            System.out.println(Config.DEBUG + " " + debug + sql);
            if (debug) {
                System.out.println(sql);
            }
            ResultSet rs = s.executeQuery(sql);
            while (rs.next()) {
                featureId = rs.getLong("feature_id");
            }
        }
        catch (SQLException sqle) {
            System.err.println(this.getClass() + ": SQLException retrieving feature.feature_id for " + featName + "\n" + sqle);
        }
        return featureId;
    }

    public boolean chadoFeatureExists(Connection conn, String seqType, String seqId) {
        long featId = this.getFeatureId(conn, seqType, seqId);
        return featId != -1L;
    }

    public void getAllChadoSequencesByType(String featType, Vector seqUniqueNames, Vector seqDescrs) throws ApolloAdapterException {
        Connection conn = this.getConnection();
        if (conn == null) {
            throw new ApolloAdapterException("Unable to connect to chado database - please check database/login information and try again");
        }
        try {
            Statement s = conn.createStatement();
            String pvalCol = this.chadoVersion.getPValCol();
            String pkeyCol = this.chadoVersion.getPKeyCol();
            String sql = "SELECT o.common_name, f.uniquename, fp." + pvalCol + " AS chrom " + "FROM feature f LEFT OUTER JOIN featureprop fp on " + "(f.feature_id = fp.feature_id AND fp." + pkeyCol + " = " + this.getFeatureCVTermId("chromosome") + " ), " + "organism o " + "WHERE f.type_id = " + this.getFeatureCVTermId(featType) + " " + "AND f.organism_id = o.organism_id " + (this.organismLike != null ? "and o.common_name LIKE '" + this.organismLike + "'" : "") + "ORDER BY o.common_name, o.species, f.uniquename";
            JdbcChadoAdapter.debugMsgAndTime("get chado seqs:\n" + sql);
            ResultSet rs = s.executeQuery(sql);
            while (rs.next()) {
                String name = rs.getString("uniquename");
                String organism = rs.getString("common_name");
                String chromosome = rs.getString("chrom");
                String descr = "";
                descr = organism != null && chromosome != null ? organism + " chr. " + chromosome + " (" + name + ")" : name;
                seqUniqueNames.addElement(name);
                seqDescrs.addElement(descr);
            }
        }
        catch (SQLException sqle) {
            System.err.println(this.getClass() + ": SQLException retrieving all features of type '" + featType + "'");
            System.err.println(sqle);
        }
    }

    public List getFeatNamesByType(String featType) {
        String select = this.makeSelectClause("name");
        String from = this.makeFromClause("feature");
        Long featTypeId = this.getFeatureCVTermId(featType);
        if (featTypeId == null) {
            System.out.println("Failed to get cv_term id for type " + featType + "! This feature type " + "does not seem to be presnt in your chado database. Either the database" + " or the configuration needs to be ammended");
            new Throwable().printStackTrace();
            return new ArrayList(0);
        }
        WhereClause where = new WhereClause("type_id", featTypeId);
        String sql = select + from + where;
        JdbcChadoAdapter.debugMsgAndTime(sql);
        try {
            ArrayList<String> nameList = new ArrayList<String>();
            ResultSet rs = this.getConnection().createStatement().executeQuery(sql);
            while (rs.next()) {
                String name = rs.getString("name");
                nameList.add(name);
            }
            return nameList;
        }
        catch (SQLException sqle) {
            System.err.println("SQLException retrieving all features of type '" + featType + "'");
            System.err.println(sqle);
            return null;
        }
    }

    protected SequenceI getSequence(long featureId) {
        return this.getSequence(featureId, false, null, 0);
    }

    protected SequenceI getSequence(long featureId, boolean isLazy, String uniquename, int seqLength) {
        SequenceI seq = this.getSeqFromCache(featureId);
        if (seq != null) {
            return seq;
        }
        if (isLazy) {
            return new ChadoLazySequence(uniquename, seqLength, this);
        }
        try {
            String sql = "SELECT uniquename,residues FROM feature WHERE feature_id = " + featureId;
            JdbcChadoAdapter.debugMsgAndTime("retrieving sequence " + sql);
            Statement s = this.getConnection().createStatement();
            ResultSet rs = s.executeQuery(sql);
            if (rs.next()) {
                String name = rs.getString("uniquename");
                String residues = rs.getString("residues");
                seq = this.makeSequence(name, residues, null);
                this.putSeqInCache(featureId, seq);
            }
        }
        catch (SQLException sqle) {
            System.err.println(this.getClass() + ": SQLException retrieving sequence with feature_id = " + featureId);
            sqle.printStackTrace(System.err);
        }
        return seq;
    }

    SequenceI getResiduesSubstring(String uniquename, int low, int high) {
        low = JdbcChadoAdapter.adjustLowForBaseOrientedToInterbaseConversion(low);
        int length = high - low + 1;
        String res = "substring(residues from " + low + " for " + length + ") as seq";
        String[] select = new String[]{res, "name", "organism_id"};
        String[] from = new String[]{"feature"};
        WhereClause where = new WhereClause("uniquename", uniquename, true);
        String sql = this.makeSql(select, from, where);
        JdbcChadoAdapter.debugMsgAndTime("retrieving seq " + sql);
        try {
            ResultSet rs = this.execute(sql);
            if (rs.next()) {
                String name = rs.getString("name");
                String residues = rs.getString("seq");
                String organism = this.getOrganismFullName(rs.getInt("organism_id"));
                return this.makeSequence(name, residues, organism);
            }
        }
        catch (SQLException e) {
            System.out.println("Error retrieving sub sequence " + sql + e);
        }
        return null;
    }

    void sqlError(SQLException sqle, String msg) {
        System.err.println(this.getClass() + ": SQLException " + msg);
        sqle.printStackTrace(System.err);
    }

    SequenceI makeSequence(String name, String residues, String organism) {
        Sequence seq = new Sequence(name, residues);
        if (organism != null) {
            seq.setOrganism(organism);
        }
        return seq;
    }

    private SequenceI getSeqFromCache(long featureId) {
        return this.getSeqFromCache(featureId, false);
    }

    private SequenceI getSeqFromCache(long featureId, boolean revComp) {
        return (SequenceI)this.seqHash.get(this.seqHashKey(featureId, revComp));
    }

    private void putSeqInCache(long featureId, SequenceI seq) {
        this.putSeqInCache(featureId, false, seq);
    }

    private void putSeqInCache(long featureId, boolean revComp, SequenceI seq) {
        this.seqHash.put(this.seqHashKey(featureId, revComp), seq);
    }

    private String seqHashKey(long featureId, boolean revComp) {
        return Long.toString(featureId) + "(" + (revComp ? "-" : "+") + ")";
    }

    private Map getCVTerms(String cvName) {
        String cvNameCol = this.chadoVersion.getCvNameCol();
        String sql = "SELECT cv.cvterm_id, cv.name FROM cvterm cv, cv c WHERE c.cv_id = cv.cv_id ";
        if (cvName != null) {
            sql = sql + "AND c." + cvNameCol + "='" + cvName + "' ";
        }
        Hashtable<String, Long> h = new Hashtable<String, Long>();
        try {
            JdbcChadoAdapter.debugMsgAndTime("\ngetCvTerms sql = " + sql + "\n");
            Connection conn = this.getConnection();
            Statement s = conn.createStatement();
            ResultSet rs = s.executeQuery(sql);
            while (rs.next()) {
                long id = rs.getLong("cvterm_id");
                String name = rs.getString("name");
                if (h.get(name) != null) {
                    System.err.println(this.getClass() + ": WARNING - read multiple CvTerms with name = '" + name + "'");
                }
                h.put(name, new Long(id));
            }
        }
        catch (SQLException sqle) {
            System.err.println(this.getClass() + ": SQLException retrieving CvTerms with cvname = " + cvName);
            System.err.println(sqle);
            sqle.printStackTrace(System.err);
        }
        return h;
    }

    Long getFeatureCVTermId(String name) {
        if (this.featureCvTerms == null) {
            this.featureCvTerms = this.getCVTerms(this.getChadoInstance().getFeatureCVName());
        }
        return (Long)this.featureCvTerms.get(name);
    }

    private String getFeatCvName(int id) {
        return this.getFeatCvName(new Long(id));
    }

    private String getFeatCvName(Long id) {
        if (this.featureCvTerms == null) {
            this.featureCvTerms = this.getCVTerms(this.getChadoInstance().getFeatureCVName());
        }
        Iterator it = this.featureCvTerms.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            Long tmpId = (Long)this.featureCvTerms.get(name);
            if (!tmpId.equals(id)) continue;
            return name;
        }
        throw new IllegalStateException("JdbcChadoAdapter.getFeatureName(): used feature is not defined in db.");
    }

    private Long getPartOfCVTermId() throws PartOfException {
        String partOfString = this.getChadoInstance().getPartOfCvTerm();
        Long id = this.getRelationshipCVTermId(partOfString);
        if (id == null) {
            String m = "part of cv term string '" + partOfString + "' not found in relationship" + " ontology. Configure this in chado-adapter.xml";
            throw new PartOfException(m);
        }
        return id;
    }

    protected Long getRelationshipCVTermId(String name) {
        if (this.relationshipCvTerms == null) {
            this.relationshipCvTerms = this.getCVTerms(this.getChadoInstance().getRelationshipCVName());
        }
        return (Long)this.relationshipCvTerms.get(name);
    }

    private Long getPropertyTypeCVTermId(String name) {
        if (this.propertyTypeCvTerms == null) {
            this.propertyTypeCvTerms = this.getCVTerms(this.getChadoInstance().getPropertyTypeCVName());
        }
        return (Long)this.propertyTypeCvTerms.get(name);
    }

    private Map getIdToOrganism() {
        if (this.idToOrganism == null) {
            this.idToOrganism = new HashMap();
            String abbrevCol = this.chadoVersion.getAbbrevCol();
            String sql = "SELECT organism_id," + abbrevCol + " AS abbreviation, genus, species " + " FROM organism ";
            JdbcChadoAdapter.debugMsgAndTime(sql);
            try {
                ResultSet rs = this.getConnection().createStatement().executeQuery(sql);
                while (rs.next()) {
                    Organism org = new Organism(rs);
                    this.idToOrganism.put(org.getIdInteger(), org);
                }
            }
            catch (SQLException e) {
                this.sqlError(e, "Organism retrieval failed " + sql);
            }
        }
        return this.idToOrganism;
    }

    private Organism getOrganism(int orgId) {
        return (Organism)this.getIdToOrganism().get(new Integer(orgId));
    }

    private String getOrganismAbbrev(int orgId) {
        return this.getOrganism(orgId).abbreviation;
    }

    String getOrganismFullName(int orgId) {
        return this.getOrganism(orgId).getFullName();
    }

    protected Hashtable getCDSFeatures(Connection c, long srcSeqId, SequenceI refSeq, StrandedFeatureSet sfs, FeatureLocImplementation featLocImp, ChadoProgram[] chadoPrgs) throws RelationshipCVException {
        String sql = this.getChadoInstance().getPredictedCdsSql(featLocImp, chadoPrgs);
        if (sql == null || sql.length() < 1) {
            return new Hashtable();
        }
        return this.getCDSFeatures(c, srcSeqId, refSeq, sfs, sql);
    }

    protected Hashtable getCDSFeatures(Connection c, long srcSeqId, SequenceI refSeq, StrandedFeatureSet sfs, FeatureLocImplementation featLocImp) throws RelationshipCVException {
        String sql = this.getChadoInstance().getCdsSql(featLocImp);
        return this.getCDSFeatures(c, srcSeqId, refSeq, sfs, sql);
    }

    protected Hashtable getCDSFeatures(Connection c, long srcSeqId, SequenceI refSeq, StrandedFeatureSet sfs, String sql) throws RelationshipCVException {
        Hashtable thash = new Hashtable();
        int nAltSplicedTrans = 0;
        try {
            if (debug) {
                System.err.println("\n" + this + " getCDSFeatures sql = " + sql + "\n");
            }
            Statement s = c.createStatement();
            ResultSet rs = s.executeQuery(sql);
            while (rs.next()) {
                int fmin = rs.getInt("fmin");
                int fmax = rs.getInt("fmax");
                int cdsStrand = rs.getInt("strand");
                String cdsName = rs.getString("cds_name");
                String transUniqueName = rs.getString("transcript_uniquename");
                String transSeq = rs.getString("transcript_seq");
                String proteinName = rs.getString("protein_name");
                String proteinSeq = rs.getString("protein_seq");
                ChadoFeatureLoc cdsLoc = new ChadoFeatureLoc(fmin, fmax, cdsStrand);
                Object o = thash.get(transUniqueName);
                Vector<ChadoCds> v = null;
                if (o == null) {
                    v = new Vector<ChadoCds>();
                    thash.put(transUniqueName, v);
                } else {
                    v = (Vector<ChadoCds>)o;
                    ++nAltSplicedTrans;
                }
                v.addElement(new ChadoCds(cdsName, transSeq, proteinName, proteinSeq, cdsLoc.getFmin(), cdsLoc.getFmax(), cdsLoc.getStrand()));
                boolean cdsTigrDebug = false;
                if (!cdsTigrDebug) continue;
                SeqFeature cdsFeat = this._makeSeqFeature(cdsLoc.getFmin(), cdsLoc.getFmax(), "CDS", cdsLoc.getStrand());
                cdsFeat.setName(cdsName);
                cdsFeat.setFeatureType("CDS");
                AnnotatedFeature annotFeat = new AnnotatedFeature(cdsFeat);
                annotFeat.setName(cdsName);
                annotFeat.setFeatureType("CDS");
                sfs.addFeature(annotFeat);
            }
            if (nAltSplicedTrans > 0) {
                System.err.println("WARNING - there are " + nAltSplicedTrans + " alternatively-spliced transcript(s) that may not be displayed correctly");
            }
        }
        catch (SQLException sqle) {
            System.err.println(this.getClass() + ": SQLException retrieving gene features for sequence with feature_id = " + srcSeqId);
            sqle.printStackTrace(System.err);
        }
        return thash;
    }

    protected void addOneLevelAnnotations(Connection c, SequenceI refSeq, StrandedFeatureSet sfs, FeatureLocImplementation featLoc) {
        ChadoInstance chadoInstance = this.getChadoInstance();
        List oneLevelTypes = chadoInstance.getOneLevelAnnotTypes();
        if (oneLevelTypes.isEmpty()) {
            return;
        }
        StringBuffer typeBuffer = new StringBuffer();
        Iterator it = oneLevelTypes.iterator();
        while (it.hasNext()) {
            String type = (String)it.next();
            typeBuffer.append(this.getFeatureCVTermId(type));
            if (!it.hasNext()) continue;
            typeBuffer.append(",");
        }
        String query = "SELECT f.feature_id as feature_id, name, uniquename, type_id, dbxref_id, fmin, fmax, strand, residues \nFROM feature f, featureloc fl \nWHERE f.type_id in (" + typeBuffer.toString() + ") AND " + "f.feature_id = fl.feature_id \nAND " + "is_analysis = " + this.getBooleanFalseValue() + " \nAND " + "fl.srcfeature_id = " + featLoc.getContainingFeatureId() + featLoc.getContainingFeatureWhereClause("fl");
        JdbcChadoAdapter.debugMsgAndTime("addOneLevelAnnotations sql=\n" + query);
        Connection conn = this.getConnection();
        try {
            Statement stat = conn.createStatement();
            ResultSet resultSet = stat.executeQuery(query);
            while (resultSet.next()) {
                int feature_id = resultSet.getInt("feature_id");
                String name = resultSet.getString("name");
                String uniquename = resultSet.getString("uniquename");
                int type_id = resultSet.getInt("type_id");
                int fmin = resultSet.getInt("fmin");
                int fmax = resultSet.getInt("fmax");
                int strand = resultSet.getInt("strand");
                String residues = resultSet.getString("residues");
                String featType = this.getFeatCvName(new Long(type_id));
                AnnotatedFeature annot = new AnnotatedFeature();
                boolean isSeqError = this.isSequencingError(featType);
                if (isSeqError) {
                    annot = new SequenceEdit(residues);
                }
                annot.setFeatureType(this.getFeatCvName(new Long(type_id)));
                this.setName(annot, name, uniquename);
                annot.setId(uniquename);
                annot.setStrand(strand);
                if (Config.DO_ONE_LEVEL_ANNOTS) {
                    this.setFeatCoordsFromInterbase(annot, fmin, fmax, strand);
                }
                if (isSeqError) {
                    annot.setRefSequence(refSeq);
                } else {
                    sfs.addFeature(annot);
                }
                this.addAnnotationFeatProps(annot, feature_id);
                this.addAnnotSynonyms(annot, feature_id);
                this.addAnnotDbXRefs(annot, feature_id, resultSet.getInt("dbxref_id"));
                if (Config.DO_ONE_LEVEL_ANNOTS) continue;
                Transcript tran = new Transcript();
                tran.setRefSequence(refSeq);
                tran.setId(uniquename);
                this.setName(tran, name, uniquename + "(transcript)");
                tran.setStrand(strand);
                annot.addFeature(tran);
                Exon exon = this._makeExon(fmin, fmax, strand);
                exon.setRefSequence(refSeq);
                exon.setId(uniquename + ":" + fmin + "-" + fmax);
                tran.addExon(exon);
            }
        }
        catch (SQLException e) {
            System.err.println("JdbcChadoInstance.addOneLevelAnnoations(): " + e);
            e.printStackTrace();
        }
    }

    private boolean isSequencingError(String type) {
        return SequenceEdit.typeIsSeqError(type);
    }

    private void setName(SeqFeatureI feat, String name, String uniquename) {
        if (name != null) {
            feat.setName(name);
        } else {
            JdbcChadoAdapter.debugPrint("One level annot feature with uniquename " + uniquename + " has a " + "null name");
        }
    }

    void addGeneModels(Connection c, SequenceI refSeq, StrandedFeatureSet sfs, FeatureLocImplementation featLoc, boolean getFeatProps, boolean getSynonyms, boolean getDbXRefs) {
        Hashtable thash;
        Long partOfCvTermId;
        int currentGeneId = -1;
        int currentTranscriptId = -1;
        AnnotatedFeature currentGene = null;
        Transcript currentTranscript = null;
        Vector<AnnotatedFeature> genes = new Vector<AnnotatedFeature>();
        Vector<Transcript> transcripts = new Vector<Transcript>();
        Vector<Exon> exons = new Vector<Exon>();
        String fminCol = this.chadoVersion.getFMinCol();
        String fmaxCol = this.chadoVersion.getFMaxCol();
        String subjFeatCol = this.chadoVersion.getSubjFeatCol();
        String objFeatCol = this.chadoVersion.getObjFeatCol();
        int srcSeqId = featLoc.getContainingFeatureId();
        String featLocWhereClause = featLoc.getContainingFeatureWhereClause("exonloc");
        try {
            partOfCvTermId = this.getPartOfCVTermId();
        }
        catch (PartOfException pe) {
            System.out.println(pe.getMessage() + "\nCan not retrieve genes");
            if (debug) {
                pe.printStackTrace();
            }
            return;
        }
        String sql = "SELECT gene.feature_id as gene_id, trans.feature_id as transcript_id, exon.feature_id as exon_id, gene.uniquename as gene_uniquename, gene.name as gene_name, trans.uniquename as transcript_uniquename, trans.name as transcript_name, trans.type_id as type_id, exon.uniquename as exon_name,  exonloc.rank, exonloc." + fminCol + " as fmin, exonloc." + fmaxCol + " as fmax," + " exonloc.strand, exonloc.phase, exonloc.locgroup, " + " trans.timelastmodified as transDate, " + " gene.dbxref_id as geneDbXRefId " + "FROM featureloc exonloc, feature exon, feature_relationship exon2trans, feature trans,  " + "     feature_relationship trans2gene, feature gene " + "WHERE exonloc.srcfeature_id = " + srcSeqId + " " + "AND exonloc.feature_id = exon.feature_id " + "AND exon.type_id = " + this.getFeatureCVTermId("exon") + " " + "AND exon.feature_id = exon2trans." + subjFeatCol + "  " + "AND exon2trans." + objFeatCol + " = trans.feature_id  " + "AND exon2trans.type_id = " + partOfCvTermId + " " + "AND trans.feature_id = trans2gene." + subjFeatCol + " " + "AND trans2gene." + objFeatCol + " = gene.feature_id  " + "AND gene.type_id = " + this.getFeatureCVTermId("gene") + " " + "AND gene.is_analysis = " + this.getBooleanFalseValue() + " " + featLocWhereClause + "ORDER BY gene.feature_id, trans.feature_id, exonloc." + fminCol + "  ";
        try {
            if (debug) {
                System.err.println("\n" + this + " addGeneModels sql = " + sql + "\n");
            }
            Statement s = c.createStatement();
            ResultSet rs = s.executeQuery(sql);
            int exonNum = 1;
            while (rs.next()) {
                int exonX2;
                int exonX1;
                int exonBeg = rs.getInt("fmin");
                int exonEnd = rs.getInt("fmax");
                String exonName = rs.getString("exon_name");
                int newTranscriptId = rs.getInt("transcript_id");
                int newGeneId = rs.getInt("gene_id");
                int strand = rs.getInt("strand");
                if (exonBeg <= exonEnd) {
                    exonX1 = exonBeg;
                    exonX2 = exonEnd;
                } else {
                    exonX2 = exonBeg;
                    exonX1 = exonEnd;
                    strand = -1;
                }
                if (newGeneId != currentGeneId) {
                    if (currentTranscript != null) {
                        this._addExonsToTranscript(currentTranscript, exons);
                    }
                    if (currentGene != null) {
                        this._addTranscriptsToGene(currentGene, transcripts);
                    }
                    currentGene = new AnnotatedFeature();
                    currentGeneId = newGeneId;
                    String geneNameField = this.getChadoInstance().getGeneNameField();
                    String geneName = rs.getString(geneNameField);
                    String geneIdString = rs.getString("gene_uniquename");
                    exonNum = 1;
                    currentGene.setId(geneIdString);
                    currentGene.setName(geneName);
                    currentGene.setStrand(strand);
                    currentGene.setFeatureType("gene");
                    if (getFeatProps) {
                        this.addAnnotationFeatProps(currentGene, currentGeneId);
                    }
                    if (getSynonyms) {
                        this.addAnnotSynonyms(currentGene, currentGeneId);
                    }
                    if (getDbXRefs) {
                        this.addAnnotDbXRefs(currentGene, currentGeneId, rs.getInt("geneDbXRefId"));
                    }
                    genes.addElement(currentGene);
                }
                if (newTranscriptId != currentTranscriptId) {
                    if (currentTranscript != null) {
                        this._addExonsToTranscript(currentTranscript, exons);
                    }
                    currentTranscript = new Transcript();
                    currentTranscriptId = newTranscriptId;
                    String transcriptNameField = this.chadoInstance.getTranscriptNameField();
                    String transcriptName = rs.getString(transcriptNameField);
                    String transcriptIdString = rs.getString("transcript_uniquename");
                    currentTranscript.setRefSequence(refSeq);
                    currentTranscript.setId(transcriptIdString);
                    currentTranscript.setName(transcriptName);
                    currentTranscript.setFeatureType("transcript");
                    long type_id = rs.getLong("type_id");
                    String typeName = this.getFeatCvName(new Long(type_id));
                    if (currentGene != null && !typeName.equals("mRNA")) {
                        currentGene.setFeatureType(typeName);
                    }
                    Date transcriptDate = rs.getDate("transDate");
                    currentTranscript.addProperty("date", ((java.util.Date)transcriptDate).toString());
                    if (getFeatProps) {
                        this.addAnnotationFeatProps(currentTranscript, currentTranscriptId);
                    }
                    if (getSynonyms) {
                        this.addAnnotSynonyms(currentTranscript, currentTranscriptId);
                    }
                    currentTranscript.setStrand(strand);
                    transcripts.addElement(currentTranscript);
                }
                Exon exon = this._makeExon(exonX1, exonX2, strand);
                exon.setRefSequence(refSeq);
                exon.setId(exonName);
                exon.setName(currentTranscript.getId() + " exon " + exonNum++);
                exons.addElement(exon);
            }
            if (currentTranscript != null) {
                this._addExonsToTranscript(currentTranscript, exons);
            }
            if (currentGene != null) {
                this._addTranscriptsToGene(currentGene, transcripts);
            }
        }
        catch (SQLException sqle) {
            System.err.println(this.getClass() + ": SQLException retrieving gene features for sequence with feature_id = " + srcSeqId);
            sqle.printStackTrace(System.err);
        }
        JdbcChadoAdapter.debugPrintTime();
        try {
            thash = this.getCDSFeatures(c, (long)srcSeqId, refSeq, sfs, featLoc);
        }
        catch (RelationshipCVException e) {
            System.out.println(e.getMessage() + "\nCan't retrieve cds/protein");
            return;
        }
        int ng = genes.size();
        for (int g = 0; g < ng; ++g) {
            AnnotatedFeature gene = (AnnotatedFeature)genes.elementAt(g);
            int numTranscripts = gene.getNumberOfChildren();
            for (int t = 0; t < numTranscripts; ++t) {
                ChadoCds cds;
                int cf;
                Transcript originalTrans = (Transcript)gene.getFeatureAt(t);
                String transcriptId = originalTrans.getId();
                Vector cdsFeats = (Vector)thash.get(transcriptId);
                if (cdsFeats == null) continue;
                int numCdsFeats = cdsFeats.size();
                Transcript[] newTranscripts = new Transcript[numCdsFeats];
                newTranscripts[0] = originalTrans;
                for (cf = 1; cf < numCdsFeats; ++cf) {
                    cds = (ChadoCds)cdsFeats.elementAt(cf);
                    newTranscripts[cf] = this._makeNewTranscript(originalTrans, cds);
                    gene.addFeature(newTranscripts[cf]);
                }
                for (cf = 0; cf < numCdsFeats; ++cf) {
                    cds = (ChadoCds)cdsFeats.elementAt(cf);
                    Transcript trans = newTranscripts[cf];
                    trans.setPeptideSequence(cds.getProteinSequence());
                    cds.checkCdsBounds(trans);
                    this.getChadoInstance().setTranslationStartAndStop(trans, cds);
                }
            }
            sfs.addFeature(gene);
        }
    }

    private void addAnnotationFeatProps(AnnotatedFeatureI annot, int feature_id) {
        String sql = "SELECT fp.value, cvterm.name, fp.featureprop_id FROM featureprop fp, cvterm WHERE fp.feature_id = " + feature_id + " AND fp.type_id = cvterm.cvterm_id";
        JdbcChadoAdapter.debugMsgAndTime(sql);
        try {
            ResultSet rs = this.getConnection().createStatement().executeQuery(sql);
            while (rs.next()) {
                String type = rs.getString("name");
                String value = rs.getString("value");
                if (type.equals("owner")) {
                    annot.setOwner(value);
                    continue;
                }
                if (type.equals("comment")) {
                    int featurePropId = rs.getInt("featureprop_id");
                    this.addAnnotComment(annot, value, featurePropId);
                    continue;
                }
                if (type.equals("problem") && value.equals("true")) {
                    annot.setIsProblematic(true);
                    continue;
                }
                if (type.equals("description")) {
                    annot.setDescription(value);
                    continue;
                }
                annot.addProperty(type, value);
            }
        }
        catch (SQLException sqle) {
            this.printSqlError(sqle, "retrieving annot feat props", sql);
        }
    }

    private void addAnnotComment(AnnotatedFeatureI annot, String fullComment, int featurePropId) {
        String sql = "SELECT pub.uniquename FROM pub, featureprop_pub fpp WHERE fpp.featureprop_id = " + featurePropId + " AND fpp.pub_id = pub.pub_id";
        JdbcChadoAdapter.debugMsgAndTime(sql);
        try {
            ResultSet rs = this.getConnection().createStatement().executeQuery(sql);
            boolean hasAuthor = rs.next();
            String author = hasAuthor ? rs.getString("uniquename") : null;
            String[] commStrings = fullComment.split("::");
            if (commStrings.length < 3) {
                return;
            }
            String comment = commStrings[0];
            boolean internal = false;
            if (comment.indexOf("(internal view only)") != -1) {
                internal = true;
            }
            String timeStampStr = commStrings[2];
            timeStampStr = timeStampStr.replaceFirst("TS:", "");
            long timestampLong = new Long(timeStampStr);
            String id = null;
            Comment c = new Comment(id, comment, author, timestampLong);
            annot.addComment(c);
        }
        catch (SQLException sqle) {
            this.printSqlError(sqle, "retrieving annot comment", sql);
        }
    }

    private void addAnnotSynonyms(AnnotatedFeatureI annot, int feature_id) {
        String[] sel = new String[]{"s.name", "p.uniquename as owner"};
        String[] from = new String[]{"feature_synonym fs", "synonym s", "pub p"};
        WhereClause w = new WhereClause("fs.feature_id", feature_id);
        w.add("fs.synonym_id", "s.synonym_id").add("fs.pub_id", "p.pub_id");
        String sql = this.makeSql(sel, from, w);
        JdbcChadoAdapter.debugMsgAndTime(sql);
        try {
            ResultSet rs = this.getConnection().createStatement().executeQuery(sql);
            while (rs.next()) {
                String name = rs.getString("name");
                String owner = rs.getString("owner");
                Synonym syn = new Synonym(name, owner);
                annot.addSynonym(syn);
            }
        }
        catch (SQLException sqle) {
            this.printSqlError(sqle, "retrieving annot synonyms", sql);
        }
    }

    private void addAnnotDbXRefs(AnnotatedFeatureI annot, int feature_id, int dbXRefId) {
        String sql = "SELECT dx.accession, db.name as dbName FROM feature_dbxref fd, dbxref dx, db WHERE fd.feature_id = " + feature_id + " AND dx.dbxref_id = fd.dbxref_id " + "AND dx.db_id = db.db_id " + "UNION " + "SELECT dx.accession, db.name FROM dbxref dx, db " + "WHERE dbxref_id = " + dbXRefId + " AND dx.db_id = db.db_id";
        JdbcChadoAdapter.debugMsgAndTime(sql);
        try {
            ResultSet rs = this.getConnection().createStatement().executeQuery(sql);
            while (rs.next()) {
                String id = rs.getString("accession");
                String db = rs.getString("dbName");
                annot.addDbXref(new DbXref("id", id, db));
            }
        }
        catch (SQLException sqle) {
            this.printSqlError(sqle, "retrieving annot dbxref", sql);
        }
    }

    protected void addSearchHits(Connection c, String[] programs, boolean setTargetSeqs, boolean getTargetSeqsSeparately, boolean lazyTgtSeqs, boolean getTargetSeqDescriptions, boolean joinWithFeatureProp, SequenceI refSeq, StrandedFeatureSet sfs, String scoreColumn, boolean setAlignSeqs, FeatureLocImplementation featLoc) {
        if (programs == null || programs.length == 0) {
            return;
        }
        CurationSet cset = (CurationSet)refSeq.getRange();
        HashMap forwardFeatMap = new HashMap();
        HashMap reverseFeatMap = new HashMap();
        String fminCol = this.chadoVersion.getFMinCol();
        String fmaxCol = this.chadoVersion.getFMaxCol();
        String pvalCol = this.chadoVersion.getPValCol();
        String identityField = this.getAnalysisFeatureIdentityField();
        StringBuffer programWhere = new StringBuffer("");
        for (int i = 0; programs != null && i < programs.length; ++i) {
            programWhere.append("a.program like '" + programs[i] + "'");
            if (i == programs.length - 1) continue;
            programWhere.append(" OR ");
        }
        if (!programWhere.equals("")) {
            programWhere.insert(0, " AND (");
            programWhere.append(")");
        }
        int srcSeqId = featLoc.getContainingFeatureId();
        try {
            String targetSeqSelect = "";
            if (setTargetSeqs && !getTargetSeqsSeparately) {
                targetSeqSelect = "tgtFeat.residues as target_residues,";
            }
            String tgtDescSubSelect = "";
            String tgtDescField = "";
            if (!setTargetSeqs) {
                getTargetSeqDescriptions = false;
            }
            if (getTargetSeqDescriptions) {
                tgtDescField = "tgtDescription";
                Long descriptionTypeId = this.getPropertyTypeCVTermId("description");
                tgtDescSubSelect = "(SELECT value FROM featureprop WHERE type_id=" + descriptionTypeId + " and " + "feature_id=tgtFeat.feature_id) as " + tgtDescField + ",";
            }
            String featLocWhereClause = featLoc.getContainingFeatureWhereClause("leafFeatLoc");
            String featLocParentFromTables = "";
            String joinToFeatLocParent = "";
            if (this.getChadoInstance().searchHitsHaveFeatLocs()) {
                Long partOfCvId;
                featLocParentFromTables = ", feature_relationship leafToParent, featureloc parentFeatLoc";
                featLocWhereClause = featLoc.getContainingFeatureWhereClause("parentFeatLoc");
                try {
                    partOfCvId = this.getPartOfCVTermId();
                }
                catch (PartOfException pe) {
                    System.out.println(pe.getMessage() + "\nCan not retrieve search hits");
                    if (debug) {
                        pe.printStackTrace();
                    }
                    return;
                }
                joinToFeatLocParent = "AND leafToParent.subject_id = leafFeat.feature_id AND leafToParent.object_id = parentFeatLoc.feature_id AND leafToParent.type_id = " + partOfCvId + " AND parentFeatLoc.srcfeature_id = " + srcSeqId;
            }
            String lazySelect = lazyTgtSeqs ? "length(tgtFeat.residues) as tgtSeqLength," : "";
            String sql = "\nSELECT leafFeat.uniquename, leafFeatLoc." + fminCol + " AS query_fmin, " + "leafFeatLoc." + fmaxCol + " AS query_fmax, " + " leafFeatLoc.strand AS query_strand, " + "tgtFeat.feature_id AS target_id, tgtFeat.uniquename AS targetName, " + "tgtFeat.organism_id AS tgtOrganismId, " + "tgtFeatLoc." + fminCol + " AS target_fmin, " + "tgtFeatLoc." + fmaxCol + " AS target_fmax, " + "tgtFeatLoc.strand AS target_strand, " + "a.analysis_id, a.program, a.sourcename, a.programversion, af.rawscore, " + "af.normscore, af.significance, af." + identityField + ", " + "leafFeatLoc.residue_info AS query_residue_info, " + targetSeqSelect + tgtDescSubSelect + "leafFeat.type_id as featureTypeId, " + lazySelect + "tgtFeatLoc.residue_info AS target_residue_info " + (joinWithFeatureProp ? ", fp." + pvalCol + " AS feature_prop " : "") + "\nFROM featureloc leafFeatLoc, feature leafFeat, " + (joinWithFeatureProp ? "featureprop fp, " : "") + "analysisfeature af, analysis a, featureloc tgtFeatLoc, " + "feature tgtFeat " + featLocParentFromTables + "\nWHERE leafFeatLoc.srcfeature_id = " + srcSeqId + " " + "AND leafFeatLoc.feature_id = leafFeat.feature_id  " + "AND leafFeatLoc.feature_id = af.feature_id " + "AND af.analysis_id = a.analysis_id " + "AND leafFeat.feature_id = tgtFeatLoc.feature_id " + "AND tgtFeatLoc.srcfeature_id != " + srcSeqId + " AND tgtFeatLoc.srcfeature_id = tgtFeat.feature_id " + (joinWithFeatureProp ? "AND fp.feature_id = leafFeat.feature_id " : "") + programWhere + featLocWhereClause + joinToFeatLocParent + "\nORDER BY a.program, a.programversion, tgtFeat.organism_id " + ", tgtFeat.uniquename ";
            JdbcChadoAdapter.debugMsgAndTime("\naddSearchHits sql = " + sql + "\n");
            Statement s = c.createStatement();
            ResultSet rs = s.executeQuery(sql);
            String lastTargetSp = null;
            String lastTargetName = null;
            String lastFeatType = null;
            int lastStrand = 0;
            Vector<FeaturePair> featurePairs = new Vector<FeaturePair>();
            while (rs.next()) {
                ChadoFeatureLoc targetLoc;
                ChadoFeatureLoc queryLoc;
                int fmin = rs.getInt("query_fmin");
                int fmax = rs.getInt("query_fmax");
                int strand = rs.getInt("query_strand");
                String name = rs.getString("uniquename");
                String alignType = this.getFeatCvName(rs.getInt("featureTypeId"));
                String queryResidueInfo = rs.getString("query_residue_info");
                String targetChadoName = rs.getString("targetName");
                long targetId = rs.getLong("target_id");
                int organismId = rs.getInt("tgtOrganismId");
                String targetSp = this.getOrganismAbbrev(organismId);
                if (targetSp == null) {
                    targetSp = this.getOrganismFullName(organismId);
                }
                int tgt_fmin = rs.getInt("target_fmin");
                int tgt_fmax = rs.getInt("target_fmax");
                int tgt_strand = rs.getInt("target_strand");
                String tgtResidueInfo = rs.getString("target_residue_info");
                String program = rs.getString("program");
                String sourcename = rs.getString("sourcename");
                String programversion = rs.getString("programversion");
                long analysisId = rs.getLong("analysis_id");
                String targetResidues = null;
                if (setTargetSeqs && !getTargetSeqsSeparately) {
                    targetResidues = rs.getString("target_residues");
                }
                String featName = null;
                String tgtFeatName = null;
                tgtFeatName = this.getChadoInstance().getTargetName(targetChadoName, targetSp, alignType, featName);
                if (alignType.equals("SNP")) {
                    queryLoc = new ChadoFeatureLoc(fmin, fmin, strand);
                    targetLoc = new ChadoFeatureLoc(tgt_fmin, tgt_fmin, tgt_strand);
                    featName = "SNP (" + queryResidueInfo + ".." + tgtResidueInfo + ")";
                } else {
                    queryLoc = new ChadoFeatureLoc(fmin, fmax, strand);
                    targetLoc = new ChadoFeatureLoc(tgt_fmin, tgt_fmax, tgt_strand);
                    featName = name;
                }
                String featProp = null;
                if (joinWithFeatureProp) {
                    featProp = rs.getString("feature_prop");
                }
                String featType = this.getFeatureType(alignType, program, programversion, targetSp, sourcename, featProp);
                SeqFeature queryFeat = this._makeSeqFeature(queryLoc.getFmin(), queryLoc.getFmax(), featType, queryLoc.getStrand());
                queryFeat.setName(featName);
                if (scoreColumn != null) {
                    queryFeat.setScore(rs.getFloat(scoreColumn));
                } else if (alignType.equals("SNP")) {
                    queryFeat.setScore(100.0);
                }
                float pIdentity = rs.getFloat(identityField);
                queryFeat.addScore(new Score("identity", pIdentity));
                queryFeat.addScore(new Score("rawscore", rs.getFloat("rawscore")));
                queryFeat.addScore(new Score("normscore", rs.getFloat("normscore")));
                queryFeat.addScore(new Score("significance", rs.getFloat("significance")));
                SeqFeature tgtFeat = this._makeSeqFeature(targetLoc.getFmin(), targetLoc.getFmax(), featType, targetLoc.getStrand());
                if (setTargetSeqs) {
                    SequenceI tgtRefSeq = null;
                    if (getTargetSeqsSeparately) {
                        int tgtSeqLength = rs.getInt("tgtSeqLength");
                        tgtRefSeq = this.getSequence(targetId, lazyTgtSeqs, tgtFeatName, tgtSeqLength);
                    } else {
                        tgtRefSeq = new Sequence(tgtFeatName, targetResidues);
                    }
                    if (tgtRefSeq != null) {
                        tgtFeat.setRefSequence(tgtRefSeq);
                        cset.addSequence(tgtRefSeq);
                        if (getTargetSeqDescriptions) {
                            tgtRefSeq.setDescription(rs.getString(tgtDescField));
                        }
                        if (alignType.equals("SNP")) {
                            boolean isRev;
                            String queryBase = refSeq.getResidues(queryFeat.getStart(), queryFeat.getEnd());
                            String tgtBase = tgtRefSeq.getResidues(tgtFeat.getStart(), tgtFeat.getEnd());
                            boolean bl = isRev = tgt_fmax < tgt_fmin;
                            if (!queryBase.toUpperCase().equals(queryResidueInfo.toUpperCase())) {
                                System.err.println("WARNING - SNP query base '" + queryResidueInfo + "' does not match sequence at position " + queryFeat.getStart() + " - '" + queryBase + "'");
                                System.err.println("query locn=" + fmin + "-" + fmax + " target locn=" + tgt_fmin + "-" + tgt_fmax + " isrev=" + isRev);
                            }
                            if (!tgtBase.toUpperCase().equals(tgtResidueInfo.toUpperCase())) {
                                System.err.println("WARNING - SNP target base '" + tgtResidueInfo + "' does not match sequence at position " + tgtFeat.getStart() + " - '" + tgtBase + "'");
                                System.err.println("query locn=" + fmin + "-" + fmax + " target locn=" + tgt_fmin + "-" + tgt_fmax + " isrev=" + isRev);
                            }
                        }
                    }
                }
                tgtFeat.setName(tgtFeatName);
                if (!targetChadoName.equals(lastTargetName)) {
                    if (lastTargetName != null) {
                        FeatureSet targetFeatSet = this._makeFeatureSet(featurePairs, lastTargetSp, lastFeatType, lastStrand);
                        FeatureSet featureSet = this.getFeatureSetForType(lastFeatType, targetFeatSet.isForwardStrand(), forwardFeatMap, reverseFeatMap);
                        featureSet.addFeature(targetFeatSet);
                        featurePairs.clear();
                    }
                    lastTargetSp = targetSp;
                    lastTargetName = targetChadoName;
                    lastFeatType = featType;
                    lastStrand = queryLoc.getStrand();
                }
                FeaturePair fp = new FeaturePair(queryFeat, tgtFeat);
                SequenceI tgtSeq = tgtFeat.getRefSequence();
                if (tgtSeq != null) {
                    queryFeat.addProperty("description", tgtSeq.getDescription());
                }
                if (setAlignSeqs) {
                    fp.setExplicitAlignment(queryResidueInfo);
                    tgtFeat.setExplicitAlignment(tgtResidueInfo);
                }
                featurePairs.addElement(fp);
            }
            if (lastTargetName != null) {
                FeatureSet targetFeatSet = this._makeFeatureSet(featurePairs, lastTargetSp, lastFeatType, lastStrand);
                FeatureSet featureSet = this.getFeatureSetForType(lastFeatType, targetFeatSet.isForwardStrand(), forwardFeatMap, reverseFeatMap);
                featureSet.addFeature(targetFeatSet);
                featurePairs.clear();
            }
            this.addFeatureToParents(sfs, forwardFeatMap);
            this.addFeatureToParents(sfs, reverseFeatMap);
        }
        catch (SQLException sqle) {
            System.err.println(this.getClass() + ": SQLException retrieving analysisfeatures for sequence with feature_id = " + srcSeqId);
            sqle.printStackTrace(System.err);
        }
    }

    private FeatureSet getFeatureSetForType(String featureType, boolean isForward, Map forwardMap, Map reverseMap) {
        FeatureSet feature = null;
        if (isForward) {
            feature = (FeatureSet)forwardMap.get(featureType);
            if (feature == null) {
                feature = new FeatureSet();
                feature.setStrand(1);
                feature.setFeatureType(featureType);
                forwardMap.put(featureType, feature);
            }
        } else {
            feature = (FeatureSet)reverseMap.get(featureType);
            if (feature == null) {
                feature = new FeatureSet();
                feature.setStrand(-1);
                feature.setFeatureType(featureType);
                reverseMap.put(featureType, feature);
            }
        }
        return feature;
    }

    private SeqFeatureI getTierFeatForType(String type, int strand, StrandedFeatureSet sfs) {
        SeqFeatureI tierFeat = sfs.getSeqFeat(strand, type);
        if (tierFeat == null) {
            tierFeat = new FeatureSet(type, strand);
            tierFeat.setName(type);
            sfs.addFeature(tierFeat);
        }
        return tierFeat;
    }

    protected void addProteinAlignments(Connection c, String programStr, StrandedFeatureSet sfs, FeatureLocImplementation featLoc) {
        String fminCol = this.chadoVersion.getFMinCol();
        String fmaxCol = this.chadoVersion.getFMaxCol();
        String abbrevCol = this.chadoVersion.getAbbrevCol();
        String identityField = this.getAnalysisFeatureIdentityField();
        int srcSeqId = featLoc.getContainingFeatureId();
        try {
            String sql = "SELECT p1.uniquename as query_name,  fl1." + fminCol + " AS query_fmin, " + " fl1." + fmaxCol + " AS query_fmax, " + " fl1.strand AS query_strand, " + " g2.uniquename AS target_seq, " + " o2." + abbrevCol + " AS target_species, " + " p2.uniquename AS target_name, " + " fl4." + fminCol + " AS target_fmin, " + " fl4." + fmaxCol + " AS target_fmax, " + " fl4.strand AS target_strand, " + " a.program, " + " a.programversion, " + " af." + identityField + ", " + " af.rawscore, " + " af.normscore, " + " af.significance " + "FROM featureloc fl1, featureloc fl2, analysisfeature af, analysis a, " + "featureloc fl3, feature p1, feature p2, featureloc fl4, feature g2, organism o2 " + "WHERE fl1.srcfeature_id = " + srcSeqId + " " + "AND fl1.feature_id = fl2.srcfeature_id " + "AND fl1.feature_id = p1.feature_id " + "AND fl2.feature_id = af.feature_id " + "AND fl1.rank != fl2.rank " + "AND af.analysis_id = a.analysis_id " + (programStr != null ? "AND a.program = '" + programStr + "' " : "") + "AND fl2.feature_id = fl3.feature_id " + "AND fl3.srcfeature_id = p2.feature_id " + "AND p1.feature_id != p2.feature_id " + "AND p2.feature_id = fl4.feature_id " + "AND fl4.srcfeature_id = g2.feature_id " + "AND g2.organism_id = o2.organism_id " + "ORDER BY g2.uniquename ";
            Statement s = c.createStatement();
            ResultSet rs = s.executeQuery(sql);
            String lastTargetSp = null;
            String lastFeatType = null;
            int lastStrand = 0;
            Vector<FeaturePair> featurePairs = new Vector<FeaturePair>();
            while (rs.next()) {
                int fmin = rs.getInt("query_fmin");
                int fmax = rs.getInt("query_fmax");
                String name = rs.getString("query_name");
                int strand = rs.getInt("query_strand");
                String target = rs.getString("target_name");
                String targetSp = rs.getString("target_species");
                int tgt_fmin = rs.getInt("target_fmin");
                int tgt_fmax = rs.getInt("target_fmax");
                int tgt_strand = rs.getInt("target_strand");
                String program = rs.getString("program");
                String programversion = rs.getString("programversion");
                String featType = program + " " + programversion + " " + targetSp;
                ChadoFeatureLoc queryLoc = new ChadoFeatureLoc(fmin, fmax, strand);
                ChadoFeatureLoc targetLoc = new ChadoFeatureLoc(tgt_fmin, tgt_fmax, tgt_strand);
                SeqFeature queryFeat = this._makeSeqFeature(queryLoc.getFmin(), queryLoc.getFmax(), featType, queryLoc.getStrand());
                queryFeat.setName(name);
                float pIdentity = rs.getFloat(identityField);
                queryFeat.addScore(new Score("identity", pIdentity));
                queryFeat.addScore(new Score("rawscore", rs.getFloat("rawscore")));
                queryFeat.addScore(new Score("normscore", rs.getFloat("normscore")));
                queryFeat.addScore(new Score("significance", rs.getFloat("significance")));
                queryFeat.setScore(pIdentity);
                SeqFeature tgtFeat = this._makeSeqFeature(targetLoc.getFmin(), targetLoc.getFmax(), featType, targetLoc.getStrand());
                tgtFeat.setName(targetSp + " " + target);
                if (targetSp != lastTargetSp) {
                    if (lastTargetSp != null) {
                        sfs.addFeature(this._makeFeatureSet(featurePairs, lastTargetSp, lastFeatType, lastStrand));
                        featurePairs.clear();
                    }
                    lastTargetSp = targetSp;
                    lastFeatType = featType;
                    lastStrand = queryLoc.getStrand();
                }
                featurePairs.addElement(new FeaturePair(queryFeat, tgtFeat));
            }
            if (lastTargetSp != null) {
                sfs.addFeature(this._makeFeatureSet(featurePairs, lastTargetSp, lastFeatType, lastStrand));
                featurePairs.clear();
            }
        }
        catch (SQLException sqle) {
            System.err.println(this.getClass() + ": SQLException retrieving analysisfeatures for sequence with feature_id = " + srcSeqId);
            sqle.printStackTrace(System.err);
        }
    }

    protected void addGenePredictionResults(Connection c, String[] programStr, StrandedFeatureSet parentFeatSet, FeatureLocImplementation featLoc) {
        ChadoProgram[] progArray = new ChadoProgram[programStr.length];
        for (int i = 0; i < programStr.length; ++i) {
            progArray[i] = new ChadoProgram(programStr[i], false);
        }
        this.addGenePredictionResults(c, progArray, parentFeatSet, featLoc);
    }

    protected void addGenePredictionResults(Connection c, ChadoProgram[] programs, StrandedFeatureSet parentFeatSet, FeatureLocImplementation featLoc) {
        String analysisWhereString;
        Long partOfCvId;
        if (programs == null || programs.length == 0) {
            return;
        }
        Long exonCvId = this.getFeatureCVTermId("exon");
        try {
            partOfCvId = this.getPartOfCVTermId();
        }
        catch (PartOfException pe) {
            System.out.println(pe.getMessage() + "\nCan not retrieve gene predictions");
            if (debug) {
                pe.printStackTrace();
            }
            return;
        }
        int srcFeatId = featLoc.getContainingFeatureId();
        String featLocWhereClause = featLoc.getContainingFeatureWhereClause("transLoc");
        AnalysisTable table = this.getAnalysisTable();
        if (table.nameToChadoProg.size() == 0) {
            return;
        }
        JdbcChadoAdapter.debugPrint("Querying programs for gene prediction: ");
        for (int i = 0; i < programs.length; ++i) {
            JdbcChadoAdapter.debugPrint(programs[i].getName() + "\n");
        }
        try {
            WhereClause analysisWhereClause = this.getAnalysisIdWhereClause(programs);
            analysisWhereString = analysisWhereClause.getClauseWithAnd();
        }
        catch (AnalysisTable.AnalysisException e) {
            System.out.println(e.getMessage() + "\nCan not retrieve gene predictions");
            return;
        }
        String sql = "SELECT exonLoc.fmin, exonLoc.fmax, exonLoc.strand, af.rawscore, af.analysis_id, trans.feature_id as transId, trans.uniquename as transUniquename FROM featureloc exonLoc, feature exon, analysisfeature af, feature_relationship exon2trans, feature trans, featureloc transLoc WHERE transLoc.srcfeature_id = " + srcFeatId + " AND exonLoc.feature_id = exon.feature_id " + "AND transLoc.feature_id = af.feature_id " + analysisWhereString + " AND exon.type_id = " + exonCvId + " AND exon2trans.subject_id = exon.feature_id " + "AND trans.feature_id = exon2trans.object_id  " + "AND exon2trans.type_id = " + partOfCvId + " AND transLoc.feature_id = trans.feature_id " + featLocWhereClause + " ORDER BY af.analysis_id, trans.feature_id";
        Hashtable predictedCDS = new Hashtable();
        try {
            predictedCDS = this.getCDSFeatures(c, featLoc.getFeatureId(), parentFeatSet.getFeatureSequence(), parentFeatSet, featLoc, programs);
        }
        catch (RelationshipCVException e) {
            e.printStackTrace();
        }
        try {
            if (debug) {
                System.err.println("\n" + this + " addGenePredictions sql =\n" + sql + "\n");
            }
            Statement s = c.createStatement();
            ResultSet rs = s.executeQuery(sql);
            int lastTranscriptId = -1;
            String featType = null;
            String lastProgram = null;
            Range transcriptFeatSet = null;
            HashMap forwardMap = new HashMap();
            HashMap reverseMap = new HashMap();
            boolean resultSetEmpty = true;
            while (rs.next()) {
                resultSetEmpty = false;
                int transcriptId = rs.getInt("transId");
                int fmin = rs.getInt("fmin");
                int fmax = rs.getInt("fmax");
                int strand = rs.getInt("strand");
                double rawScore = rs.getDouble("rawscore");
                String transUniquename = rs.getString("transUniquename");
                int analysisId = rs.getInt("analysis_id");
                String analysisSource = this.getAnalysisTable().getSourceName(analysisId);
                String program = this.getAnalysisTable().getProgram(analysisId);
                String exonName = program + ":" + fmin + "-" + fmax;
                if (!program.equals(lastProgram)) {
                    featType = this.getFeatureType(null, program, null, null, analysisSource, null);
                }
                SeqFeature exon = this._makeSeqFeature(fmin, fmax, featType, strand);
                exon.setName(exonName);
                exon.setScore(rawScore);
                exon.setProgramName(program);
                if (transcriptId != lastTranscriptId) {
                    if (transcriptFeatSet != null) {
                        String rng = transcriptFeatSet.getStart() + "-" + transcriptFeatSet.getEnd();
                        transcriptFeatSet.setName(lastProgram + ":" + rng);
                    }
                    transcriptFeatSet = this._makeFeatureSet(featType, strand);
                    ((SeqFeature)transcriptFeatSet).setId(transUniquename);
                    this.setSyntenyInfo((SeqFeatureI)((Object)transcriptFeatSet), transcriptId);
                    ((SeqFeature)transcriptFeatSet).setProgramName(program);
                    SeqFeatureI programFeature = this.getTierFeatForType(program, transcriptFeatSet.getStrand(), parentFeatSet);
                    programFeature.addFeature((SeqFeatureI)((Object)transcriptFeatSet));
                    lastTranscriptId = transcriptId;
                }
                ((FeatureSet)transcriptFeatSet).addFeature(exon);
                Vector predCds = (Vector)predictedCDS.get(transUniquename);
                if (predCds != null && !predCds.isEmpty()) {
                    ((FeatureSet)transcriptFeatSet).setTranslationStart(((ChadoCds)predCds.firstElement()).getStart(), false);
                    ((FeatureSet)transcriptFeatSet).setTranslationEnd(((ChadoCds)predCds.firstElement()).getEnd());
                }
                if (debug) {
                    // empty if block
                }
                lastProgram = program;
            }
            if (resultSetEmpty) {
                return;
            }
            String rng = transcriptFeatSet.getStart() + "-" + transcriptFeatSet.getEnd();
            transcriptFeatSet.setName(lastProgram + ":" + rng);
            this.addFeatureToParents(parentFeatSet, forwardMap);
            this.addFeatureToParents(parentFeatSet, reverseMap);
        }
        catch (SQLException sqle) {
            System.err.println(this.getClass() + ": SQLException retrieving gene predictions " + "for sequence with feature_id = " + srcFeatId + "\n" + sqle);
            sqle.printStackTrace(System.err);
        }
    }

    private boolean isTypeSyntenyLink(String type) {
        return this.propertyScheme.isTypeSyntenyLink(type);
    }

    private void setSyntenyInfo(SeqFeatureI seqFeat, int featureId) {
        if (!this.isTypeSyntenyLink(seqFeat.getFeatureType())) {
            return;
        }
        String tgtId = "tgtId";
        String[] sel = new String[]{"t.uniquename as " + tgtId};
        String select = this.makeSelectClause(sel);
        String[] tables = new String[]{"feature_relationship fr1", "feature_relationship fr2", "feature t"};
        String from = this.makeFromClause(tables);
        Long relTypeId = this.getRelationshipCVTermId(this.getSyntenyRelationshipType());
        WhereClause where = new WhereClause("fr1.object_id", featureId);
        where.add("fr1.type_id", relTypeId).add("fr1.subject_id", "fr2.subject_id");
        where.add("fr2.object_id", "t.feature_id");
        where.add("t.feature_id", "!=", featureId);
        String query = select + from + where;
        JdbcChadoAdapter.debugMsgAndTime("synteny links\n" + query);
        try {
            ResultSet rs = this.getConnection().createStatement().executeQuery(query);
            while (rs.next()) {
                String uniquename = rs.getString(tgtId);
                seqFeat.setSyntenyLinkInfo(uniquename);
                JdbcChadoAdapter.debugPrint("got syn link " + uniquename + " for " + featureId);
            }
        }
        catch (SQLException sqle) {
            System.err.println("SQLException retrieving synteny links  with feature_id = " + featureId + "\n" + sqle);
            sqle.printStackTrace();
        }
    }

    private String getSyntenyRelationshipType() {
        return "paralogous_to";
    }

    void addOneLevelResults() {
        WhereClause analysisWhereClause;
        FeatureLocImplementation featLoc = this.getChadoInstance().getTopFeatLoc();
        StrandedFeatureSet parentFeatSet = this.getChadoInstance().getResultStrandedFeatSet();
        Connection c = this.getConnection();
        ChadoProgram[] programArray = this.getChadoInstance().getOneLevelResultPrograms();
        if (programArray == null || programArray.length == 0) {
            return;
        }
        int srcFeatId = featLoc.getContainingFeatureId();
        String featLocWhereClause = featLoc.getContainingFeatureWhereClause("fl");
        try {
            analysisWhereClause = this.getAnalysisIdWhereClause(programArray);
        }
        catch (AnalysisTable.AnalysisException e) {
            System.out.println(e.getMessage() + "\nCan not retrieve one level results");
            return;
        }
        String[] selCols = new String[]{"f.feature_id", "name", "uniquename", "fmin", "fmax", "strand", "analysis_id"};
        String select = this.makeSelectClause(selCols);
        String[] tables = new String[]{"feature f", "featureloc fl", "analysisfeature af"};
        String from = this.makeFromClause(tables);
        WhereClause where = new WhereClause("f.feature_id", "fl.feature_id");
        where.add("fl.srcfeature_id", srcFeatId).add(featLocWhereClause);
        where.add(analysisWhereClause).add("af.feature_id", "f.feature_id");
        String query = select + from + where;
        JdbcChadoAdapter.debugMsgAndTime("ONE LEVEL RESULTS\n" + query);
        try {
            ResultSet rs = c.createStatement().executeQuery(query);
            while (rs.next()) {
                SeqFeature feat = this.makeResultSeqFeature(rs);
                FeatureSet fs = this._makeFeatureSet(rs, feat);
                SeqFeatureI tiersFS = this.getTierFeatForType(feat.getFeatureType(), feat.getStrand(), parentFeatSet);
                tiersFS.addFeature(fs);
            }
        }
        catch (SQLException sqle) {
            System.err.println("SQLException retrieving 1 level results for sequence with feature_id = " + srcFeatId + "\n" + sqle);
            sqle.printStackTrace();
        }
    }

    private String makeSelectClause(String[] columns) {
        int i;
        StringBuffer s = new StringBuffer("\nSELECT ");
        for (i = 0; i < columns.length - 1; ++i) {
            s.append("\n").append(columns[i]).append(", ");
        }
        s.append("\n").append(columns[i]);
        return s.toString();
    }

    private String makeSelectClause(String column) {
        return this.makeSelectClause(new String[]{column});
    }

    private String makeFromClause(String[] tables) {
        int i;
        StringBuffer s = new StringBuffer("\n\nFROM ");
        for (i = 0; i < tables.length - 1; ++i) {
            s.append("\n").append(tables[i]).append(", ");
        }
        s.append("\n").append(tables[i]);
        return s.toString();
    }

    private String makeFromClause(String table) {
        return this.makeFromClause(new String[]{table});
    }

    private String makeSql(String[] select, String[] from, WhereClause where) {
        return this.makeSelectClause(select) + this.makeFromClause(from) + where;
    }

    private ResultSet execute(String sql) throws SQLException {
        return this.getConnection().createStatement().executeQuery(sql);
    }

    private void addFeatureToParents(StrandedFeatureSet parentFeatSet, Map forwardMap) {
        Iterator it = forwardMap.keySet().iterator();
        while (it.hasNext()) {
            String program = (String)it.next();
            FeatureSet fs = (FeatureSet)forwardMap.get(program);
            parentFeatSet.addFeature(fs);
        }
    }

    private WhereClause getAnalysisIdWhereClause(String[] programs) throws AnalysisTable.AnalysisException {
        return this.getAnalysisTable().getAnalysisIdWhereClause(programs, "af.analysis_id");
    }

    private WhereClause getAnalysisIdWhereClause(ChadoProgram[] programs) throws AnalysisTable.AnalysisException {
        return this.getAnalysisTable().getAnalysisIdWhereClause(programs, "af.analysis_id");
    }

    String getAnalysisSource(int analysisId) {
        return this.getAnalysisTable().getSourceName(analysisId);
    }

    String getAnalysisProgram(int analysisId) {
        return this.getAnalysisTable().getProgram(analysisId);
    }

    private AnalysisTable getAnalysisTable() {
        if (this.analysisTable == null) {
            this.analysisTable = new AnalysisTable();
        }
        return this.analysisTable;
    }

    public CurationSet getCurationSet(ChadoAdapter adapter, String seqType, String seqId) {
        return this.getChadoInstance().getCurationSet(adapter, seqType, seqId);
    }

    public CurationSet getCurationSetInRange(ChadoAdapter adapter, String seqType, Region region) {
        return this.getChadoInstance().getCurationSetInRange(adapter, seqType, region);
    }

    public void commitChanges(CurationSet curationSet) {
        FlybaseWrite chadoWrite = new FlybaseWrite(this.getConnection());
        chadoWrite.writeCurationSet(curationSet);
    }

    protected String getFeatureType(String alignType, String program, String programversion, String targetSp, String sourcename, String featProp) {
        return this.getChadoInstance().getFeatureType(alignType, program, programversion, targetSp, sourcename, featProp);
    }

    private String getAnalysisType(ResultSet rs) throws SQLException {
        return this.getChadoInstance().getAnalysisType(rs);
    }

    protected String getAnalysisFeatureIdentityField() {
        return "identity";
    }

    protected abstract String getBooleanTrueValue();

    protected abstract String getBooleanFalseValue();

    protected int _addTranscriptsToGene(AnnotatedFeature gene, Vector transcripts) {
        int nt = transcripts.size();
        if (debug) {
            System.err.println("adding " + nt + " transcript(s) to gene " + gene);
        }
        for (int i = 0; i < nt; ++i) {
            Transcript t = (Transcript)transcripts.elementAt(i);
            gene.addFeature(t);
        }
        transcripts.clear();
        return nt;
    }

    protected int _addExonsToTranscript(Transcript t, Vector exons) {
        int ne = exons.size();
        if (t.getStrand() == -1) {
            for (int i = ne - 1; i >= 0; --i) {
                Exon e = (Exon)exons.elementAt(i);
                t.addExon(e);
            }
        } else {
            for (int i = 0; i < ne; ++i) {
                Exon e = (Exon)exons.elementAt(i);
                t.addExon(e);
            }
        }
        exons.clear();
        return ne;
    }

    protected Transcript _makeNewTranscript(Transcript t, ChadoCds cds) {
        Transcript nt = new Transcript();
        nt.setRefSequence(t.getRefSequence());
        nt.setId(cds.cdsName);
        nt.setName(cds.cdsName);
        nt.setFeatureType("transcript");
        nt.setStrand(cds.strand);
        Vector exons = t.getExons();
        int ne = exons == null ? 0 : exons.size();
        Vector<Exon> newExons = new Vector<Exon>(ne);
        for (int i = 0; i < ne; ++i) {
            Exon e = (Exon)exons.elementAt(i);
            Exon newExon = new Exon(e);
            newExon.setRefSequence(e.getRefSequence());
            newExon.setId(e.getId());
            newExon.setName(e.getName());
            newExons.addElement(newExon);
        }
        this._addExonsToTranscript(nt, newExons);
        return nt;
    }

    protected FeatureSet _makeFeatureSet(Vector features, String name, String type, int strand) {
        FeatureSet fs = this._makeFeatureSet(type, strand);
        if (name == null) {
            System.out.println("JDBC Attempting to make FeatSet w null name, using NO_NAME");
            name = "no_name";
            if (Config.DEBUG) {
                System.out.println("DEBUG STACKTRACE: ");
                new Throwable().printStackTrace();
            }
        }
        fs.setName(name);
        int nf = features.size();
        for (int i = 0; i < nf; ++i) {
            SeqFeature sf = (SeqFeature)features.elementAt(i);
            fs.addFeature(sf);
        }
        return fs;
    }

    private FeatureSet _makeFeatureSet(String type, int strand) {
        FeatureSet fs = new FeatureSet();
        fs.setFeatureType(type);
        fs.setStrand(strand);
        return fs;
    }

    private FeatureSet _makeFeatureSet(FeatureList kids, String name, String type, int strand) {
        return new FeatureSet(kids, name, type, strand);
    }

    private FeatureSet _makeFeatureSet(ResultSet rs, SeqFeature kid) throws SQLException {
        String type = this.getAnalysisType(rs);
        FeatureSet fs = new FeatureSet(type, rs.getInt("strand"));
        fs.addFeature(kid);
        return fs;
    }

    protected void _addFeatures(FeatureSet fs, Vector features) {
        int nf = features.size();
        for (int i = 0; i < nf; ++i) {
            SeqFeature sf = (SeqFeature)features.elementAt(i);
            fs.addFeature(sf);
        }
    }

    protected SeqFeature _makeSeqFeature(int low, int high, String type, int strand) {
        low = JdbcChadoAdapter.adjustLowForInterbaseToBaseOrientedConversion(low);
        return new SeqFeature(low, high, type, strand);
    }

    private SeqFeature _makeSeqFeature(ResultSet rs) throws SQLException {
        int fmin = rs.getInt("fmin");
        int fmax = rs.getInt("fmax");
        String type = this.getAnalysisType(rs);
        int strand = rs.getInt("strand");
        return this._makeSeqFeature(fmin, fmax, type, strand);
    }

    private SeqFeature makeResultSeqFeature(ResultSet rs) throws SQLException {
        SeqFeature sf = this._makeSeqFeature(rs);
        String name = rs.getString("name");
        if (name == null) {
            name = rs.getString("uniquename");
        }
        if (name != null) {
            sf.setName(name);
        }
        int analysisId = rs.getInt("analysis_id");
        String program = this.getAnalysisTable().getProgram(analysisId);
        sf.setProgramName(program);
        return sf;
    }

    protected Exon _makeExon(int low, int high, int strand) {
        Exon e = new Exon();
        this.setFeatCoordsFromInterbase(e, low, high, strand);
        return e;
    }

    private void setFeatCoordsFromInterbase(RangeI rge, int fmin, int fmax, int strand) {
        int low = JdbcChadoAdapter.adjustLowForInterbaseToBaseOrientedConversion(fmin);
        rge.setStrand(strand);
        rge.setLow(low);
        rge.setHigh(fmax);
    }

    static int adjustLowForInterbaseToBaseOrientedConversion(int chadoFmin) {
        return chadoFmin + 1;
    }

    static int adjustLowForBaseOrientedToInterbaseConversion(int apolloLow) {
        return apolloLow - 1;
    }

    private static void debugPrint(String m) {
        if (!debug) {
            return;
        }
        System.err.println("\nDEBUG:\n" + m + "\n");
    }

    public static void debugPrintTime() {
        if (!debug) {
            return;
        }
        Calendar now = Calendar.getInstance();
        System.err.println("\nTIME: " + now.getTime() + " UnixTime(sec): " + now.getTimeInMillis() / 1000L);
    }

    static void debugMsgAndTime(String m) {
        JdbcChadoAdapter.debugPrintTime();
        JdbcChadoAdapter.debugPrint(m);
    }

    private void printSqlError(SQLException sqle, String msg, String sql) {
        System.err.println(this.getClass() + "\n SQL Exception:\n" + msg + "\n" + sql);
        sqle.printStackTrace(System.err);
    }

    private class AnalysisTable {
        private List dbPrograms;
        private Map nameToChadoProg;
        private Map idToChadoProgram;

        private AnalysisTable() {
            this.queryAnalysisTable();
        }

        private void queryAnalysisTable() {
            this.nameToChadoProg = new HashMap();
            this.idToChadoProgram = new HashMap();
            this.dbPrograms = new ArrayList();
            String sql = "\nSELECT analysis_id, program, sourcename, programversion FROM analysis\n";
            JdbcChadoAdapter.debugMsgAndTime(sql);
            try {
                ResultSet rs = JdbcChadoAdapter.this.getConnection().createStatement().executeQuery(sql);
                while (rs.next()) {
                    ChadoProgram cp = new ChadoProgram(rs);
                    this.dbPrograms.add(cp);
                    this.nameToChadoProg.put(cp.getName(), cp);
                    this.idToChadoProgram.put(new Long(cp.getDbId()), cp);
                }
            }
            catch (SQLException e) {
                System.err.println(this.getClass() + ": SQLException retrieving analysis. sql = " + sql + "\n" + e);
            }
        }

        private String getProgram(long analysisId) {
            return this.getChadoProgram(analysisId).getName();
        }

        private String getSourceName(long analysisId) {
            return this.getChadoProgram(analysisId).getSource();
        }

        private ChadoProgram getChadoProgram(long analysisId) {
            return (ChadoProgram)this.idToChadoProgram.get(new Long(analysisId));
        }

        private long getIdForConfigProgram(ChadoProgram configProgram) {
            ChadoProgram dbProgram = configProgram.hasSourceAndVersion() ? this.getDbProgramForNameSrcVer(configProgram) : this.getDbProgramForName(configProgram.getName());
            if (dbProgram != null) {
                configProgram.setDbId(dbProgram.getDbId());
                return dbProgram.getDbId();
            }
            return -1L;
        }

        private ChadoProgram getDbProgramForNameSrcVer(ChadoProgram configProgram) {
            for (int i = 0; i < this.dbPrograms.size(); ++i) {
                ChadoProgram dbProg = this.getDbChadoProgram(i);
                if (!dbProg.nameSrcVerEquals(configProgram)) continue;
                return dbProg;
            }
            return null;
        }

        private ChadoProgram getDbProgramForName(String name) {
            return (ChadoProgram)this.nameToChadoProg.get(name);
        }

        private ChadoProgram getDbChadoProgram(int i) {
            return (ChadoProgram)this.dbPrograms.get(i);
        }

        private WhereClause getAnalysisIdWhereClause(ChadoProgram[] programs, String col) throws AnalysisException {
            InClause inClause = new InClause();
            for (int i = 0; i < programs.length; ++i) {
                long analysisId = this.getIdForConfigProgram(programs[i]);
                if (analysisId == -1L) {
                    System.out.println("Analysis program " + programs[i] + " not found in analysis" + " table. Please update conf/chado-adapter.xml");
                    continue;
                }
                inClause.add(analysisId);
            }
            if (!inClause.hasContent()) {
                throw new AnalysisException("programs do not exist in database");
            }
            inClause.finish();
            return new WhereClause(col, inClause);
        }

        private WhereClause getAnalysisIdWhereClause(String[] programs, String col) throws AnalysisException {
            ChadoProgram[] progs = new ChadoProgram[programs.length];
            for (int i = 0; i < programs.length; ++i) {
                progs[i] = new ChadoProgram(programs[i]);
            }
            return this.getAnalysisIdWhereClause(progs, col);
        }

        private class AnalysisException
        extends Exception {
            private AnalysisException(String m) {
                super(m);
            }
        }
    }

    private class InClause {
        private boolean hasContent = false;
        private StringBuffer in = new StringBuffer(" IN (");

        private InClause() {
        }

        private InClause add(String s) {
            if (s == null || s.equals("")) {
                return this;
            }
            if (this.hasContent) {
                this.in.append(", ");
            }
            this.in.append(s);
            this.hasContent = true;
            return this;
        }

        private InClause add(int i) {
            return this.add(i + "");
        }

        private InClause add(long l) {
            return this.add(l + "");
        }

        private boolean hasContent() {
            return this.hasContent;
        }

        private void finish() {
            this.in.append(")");
        }

        private StringBuffer getBuffer() {
            return this.in;
        }
    }

    private class WhereClause {
        StringBuffer clause = new StringBuffer();

        private WhereClause(String s1, String s2) {
            this.add(s1, s2, false);
        }

        private WhereClause(String s1, String s2, boolean quote) {
            this.add(s1, s2, false, quote);
        }

        private WhereClause(String col, InClause in) {
            this.add(col, in, false);
        }

        private WhereClause(String col, Long value) {
            if (value == null) {
                System.out.println("yikes trying to add null long value to where clause for " + col + " ignoring");
                new Throwable().printStackTrace();
                return;
            }
            this.add(col, value, false);
        }

        private WhereClause(String col, int i) {
            this.add(col, i, false);
        }

        private WhereClause add(String s1, String s2) {
            return this.add(s1, s2, true);
        }

        private WhereClause add(String s1, String rel, String s2) {
            this.and(true);
            this.clause.append(s1).append(rel).append(s2);
            return this;
        }

        private WhereClause add(String s1, String rel, int i) {
            return this.add(s1, rel, i + "");
        }

        private WhereClause add(String s1, String s2, boolean prependAnd) {
            this.and(prependAnd);
            this.clause.append(s1).append(" = ").append(s2);
            return this;
        }

        private WhereClause add(String s1, String s2, boolean prependAnd, boolean quoteS2) {
            this.and(prependAnd);
            this.clause.append(s1).append(" = ").append(this.quote(s2));
            return this;
        }

        private WhereClause add(String s1, Long l) {
            return this.add(s1, l + "");
        }

        private String quote(String s) {
            return "'" + s + "'";
        }

        private WhereClause add(String col, InClause in, boolean prependAnd) {
            this.and(prependAnd);
            this.clause.append(col).append(in.getBuffer());
            return this;
        }

        private void and(boolean doIt) {
            if (!doIt) {
                return;
            }
            this.clause.append("\nAND ");
        }

        private WhereClause add(String s, int i) {
            return this.add(s, i + "");
        }

        private WhereClause add(String s, int i, boolean prependAnd) {
            return this.add(s, i + "", false);
        }

        private WhereClause add(String s, Long l, boolean prependAnd) {
            if (l == null) {
                System.out.println("yikes! trying to add null to where clause - ignoring");
                new Throwable().printStackTrace();
                return this;
            }
            return this.add(s, l.toString(), prependAnd);
        }

        private WhereClause add(String s) {
            this.newline();
            this.clause.append(s);
            return this;
        }

        private WhereClause add(WhereClause wc) {
            this.newline();
            this.clause.append(wc.getClauseWithAnd());
            return this;
        }

        private void newline() {
            this.clause.append("\n");
        }

        private StringBuffer getBuffer() {
            return this.clause;
        }

        private String getClauseWithWhere() {
            StringBuffer clauseWithWhere = new StringBuffer("\n\nWHERE ");
            clauseWithWhere.append(this.clause);
            return clauseWithWhere.toString();
        }

        private String getClauseWithAnd() {
            StringBuffer withAnd = new StringBuffer(" AND ");
            withAnd.append(this.clause);
            return withAnd.toString();
        }

        public String toString() {
            return this.getClauseWithWhere();
        }
    }

    private class Organism {
        private int id;
        private String abbreviation;
        private String genus;
        private String species;

        private Organism(ResultSet rs) throws SQLException {
            this.id = rs.getInt("organism_id");
            this.abbreviation = rs.getString("abbreviation");
            this.genus = rs.getString("genus");
            this.species = rs.getString("species");
        }

        private Integer getIdInteger() {
            return new Integer(this.id);
        }

        private String getFullName() {
            return this.genus + " " + this.species;
        }
    }

    private class PartOfException
    extends Exception {
        private PartOfException(String m) {
            super(m);
        }
    }
}

