/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.chado.jdbc;

import apollo.dataadapter.Region;
import apollo.dataadapter.chado.ChadoAdapter;
import apollo.dataadapter.chado.jdbc.AbstractChadoInstance;
import apollo.dataadapter.chado.jdbc.ChadoCds;
import apollo.dataadapter.chado.jdbc.ChadoProgram;
import apollo.dataadapter.chado.jdbc.ChromosomeFeatureLocImp;
import apollo.dataadapter.chado.jdbc.FeatureLocImplementation;
import apollo.dataadapter.chado.jdbc.JdbcChadoAdapter;
import apollo.dataadapter.chado.jdbc.RelationshipCVException;
import apollo.datamodel.CurationSet;
import apollo.datamodel.SequenceI;
import apollo.datamodel.StrandedFeatureSet;
import apollo.datamodel.Transcript;
import java.sql.Connection;
import java.sql.SQLException;
import org.bdgp.util.ProgressEvent;

public class FlybaseChadoInstance
extends AbstractChadoInstance {
    public FlybaseChadoInstance() {
    }

    FlybaseChadoInstance(JdbcChadoAdapter jdbcChadoAdapter) {
        super(jdbcChadoAdapter);
    }

    public String getGeneNameField() {
        return "gene_name";
    }

    public String getTranscriptNameField() {
        return "transcript_name";
    }

    public String getCdsSql(FeatureLocImplementation featLocImp) throws RelationshipCVException {
        Long protCvId = this.getPolypeptideCVTermId();
        Long producedByCvId = this.getProducedByCVTermId();
        Long mrnaCvId = this.getFeatureCVTermId("mRNA");
        return "SELECT cds.uniquename AS cds_name, trans.uniquename AS transcript_uniquename, trans.residues AS transcript_seq, cdsloc.fmin AS fmin, cdsloc.fmax AS fmax,cdsloc.strand, cds.uniquename AS protein_name, cds.residues AS protein_seq , trans.feature_id as transcript_id FROM featureloc cdsloc, feature cds, feature_relationship cds2trans, feature trans  WHERE cdsloc.srcfeature_id = " + featLocImp.getContainingFeatureId() + " " + " AND cdsloc.feature_id = cds.feature_id AND cds.type_id = " + protCvId + " AND cds.feature_id = cds2trans.subject_id " + " AND cds2trans.object_id = trans.feature_id " + " AND cds2trans.type_id = " + producedByCvId + " AND trans.type_id = " + mrnaCvId + featLocImp.getContainingFeatureWhereClause("cdsloc");
    }

    public String getPredictedCdsSql(FeatureLocImplementation featLocImp, ChadoProgram[] chadoPrgs) throws RelationshipCVException {
        Long protCvId = this.getPolypeptideCVTermId();
        Long producedByCvId = this.getProducedByCVTermId();
        StringBuffer analysisWhereStr = new StringBuffer();
        String analysisFrom = " ";
        for (int i = 0; i < chadoPrgs.length; ++i) {
            boolean found = false;
            if (!chadoPrgs[i].isRetrieveCDS()) continue;
            if (!found) {
                found = true;
                analysisWhereStr.append(" AND cds.feature_id = af.feature_id AND af.analysis_id IN (");
                analysisFrom = ", analysisfeature af ";
            }
            analysisWhereStr.append(chadoPrgs[i].getDbId() + ",");
        }
        if (analysisWhereStr.length() <= 1) {
            return null;
        }
        analysisWhereStr.deleteCharAt(analysisWhereStr.length() - 1);
        analysisWhereStr.append(") ");
        Long mrnaCvId = this.getFeatureCVTermId("mRNA");
        return "SELECT cds.uniquename AS cds_name, trans.uniquename AS transcript_uniquename, trans.residues AS transcript_seq, cdsloc.fmin AS fmin, cdsloc.fmax AS fmax,cdsloc.strand, cds.uniquename AS protein_name, cds.residues AS protein_seq , trans.feature_id as transcript_id FROM featureloc cdsloc, feature cds, feature_relationship cds2trans, feature trans " + analysisFrom + " WHERE  cds.feature_id = cds2trans.subject_id " + " AND cdsloc.feature_id = cds.feature_id " + " AND cds2trans.object_id = trans.feature_id " + analysisWhereStr.toString() + " AND cdsloc.srcfeature_id = " + featLocImp.getContainingFeatureId() + " " + " AND cds.type_id = " + protCvId + " AND cds2trans.type_id = " + producedByCvId + " AND trans.type_id = " + mrnaCvId + featLocImp.getContainingFeatureWhereClause("cdsloc");
    }

    private int getPaddingForTopLevelSeqType(String seqType) {
        if (seqType.equals("gene")) {
            return 25000;
        }
        return 0;
    }

    public String getTargetName(String chadoName, String species, String alignType, String queryName) {
        return chadoName;
    }

    public String getFeatureType(String alignType, String program, String programversion, String targetSp, String sourcename, String featProp) {
        String t = program;
        if (sourcename != null) {
            t = t + ":" + sourcename;
        }
        return t;
    }

    public String getFeatureCVName() {
        if (super.getFeatureCVName() != null) {
            return super.getFeatureCVName();
        }
        return "SO";
    }

    private boolean haveRedundantFeatureLocs() {
        return false;
    }

    public CurationSet getCurationSetInRange(ChadoAdapter adapter, String seqType, Region region) {
        Connection conn = this.getConnection();
        if (conn == null) {
            return null;
        }
        this.debugPrintTime();
        long seqFeatId = this.getChadoAdapter().getFeatureId(conn, seqType, region.getChromosome());
        ChromosomeFeatureLocImp featLocImp = new ChromosomeFeatureLocImp(seqFeatId, region);
        return this.getCurationSet(adapter, seqType, region.getChromosome(), featLocImp);
    }

    public CurationSet getCurationSet(ChadoAdapter adapter, String seqType, String topFeatName) {
        Connection conn = this.getConnection();
        if (conn == null) {
            return null;
        }
        this.debugPrintTime();
        long seqFeatId = this.getChadoAdapter().getFeatureId(conn, seqType, topFeatName);
        int padding = this.getPaddingForTopLevelSeqType(seqType);
        boolean getSeqFromParent = padding != 0;
        FeatureLocImplementation featLocImp = new FeatureLocImplementation(seqFeatId, this.haveRedundantFeatureLocs(), conn, padding);
        return this.getCurationSet(adapter, seqType, topFeatName, featLocImp);
    }

    private CurationSet getCurationSet(ChadoAdapter adapter, String seqType, String topFeatName, FeatureLocImplementation featLocImp) {
        super.clear();
        Connection conn = this.getConnection();
        this.setTopFeatLoc(featLocImp);
        CurationSet cset = null;
        StrandedFeatureSet results = this.getResultStrandedFeatSet();
        StrandedFeatureSet annotations = this.getAnnotStrandedFeatSet();
        cset = new CurationSet();
        adapter.fireProgressEvent(new ProgressEvent((Object)this, new Double(50.0), "Retrieving " + seqType + " sequence " + topFeatName));
        this.debugPrintTime();
        SequenceI seq = featLocImp.retrieveSequence(this.getChadoAdapter());
        cset.setStart(featLocImp.getBaseOrientedMinWithPadding());
        cset.setEnd(featLocImp.getMaxWithPadding());
        if (seq != null) {
            cset.setRefSequence(seq);
        }
        if (featLocImp.hasTopLevelName()) {
            cset.setChromosome(featLocImp.getTopLevelFeatName());
        }
        cset.setName(seq.getName());
        adapter.fireProgressEvent(new ProgressEvent((Object)this, new Double(100.0), "Retrieving " + seqType + " sequence " + topFeatName));
        cset.setOrganism(seq.getOrganism());
        boolean skipData = false;
        Double z = new Double(0.0);
        Double d100 = new Double(100.0);
        String m = "Retrieving 1-level results ";
        adapter.fireProgressEvent(new ProgressEvent((Object)this, z, m));
        this.getChadoAdapter().addOneLevelResults();
        this.debugPrintTime();
        this.getAnnotations(conn, seq, annotations, featLocImp, true, true, true, adapter);
        ChadoProgram[] predictionPrograms = this.getPredictionPrograms();
        adapter.fireProgressEvent(new ProgressEvent((Object)this, z, "Retrieving " + this.concatProgramNames(predictionPrograms) + " results"));
        if (!skipData) {
            this.getChadoAdapter().addGenePredictionResults(conn, predictionPrograms, results, featLocImp);
        }
        adapter.fireProgressEvent(new ProgressEvent((Object)this, new Double(100.0), "Genscan and piecegenie results retrieved"));
        this.debugPrintTime();
        boolean getTargetSeqs = true;
        boolean getAlignSeqs = true;
        String primaryScoreColumn = "rawscore";
        boolean joinWithFeatureProp = false;
        boolean getTargetSeqDescriptions = true;
        String[] hitProgs = this.getHitPrograms();
        m = "Retrieving " + this.concatProgramNames(hitProgs) + " results";
        ProgressEvent p = new ProgressEvent((Object)this, z, m);
        adapter.fireProgressEvent(p);
        boolean getTgtSqSep = true;
        boolean makeSeqsLazy = true;
        if (!skipData) {
            this.getChadoAdapter().addSearchHits(conn, hitProgs, getTargetSeqs, getTgtSqSep, makeSeqsLazy, getTargetSeqDescriptions, joinWithFeatureProp, seq, results, primaryScoreColumn, getAlignSeqs, featLocImp);
        }
        adapter.fireProgressEvent(new ProgressEvent((Object)this, d100, "Sim4 and blastx retrieved"));
        this.debugPrintTime();
        cset.setAnnots(annotations);
        cset.setResults(results);
        try {
            conn.close();
        }
        catch (SQLException sqle) {
            System.err.println(this.getClass() + ": failed to close JDBC Connection");
        }
        return cset;
    }

    public void setTranslationStartAndStop(Transcript trans, ChadoCds cds) {
        boolean calculateEnd = true;
        trans.setTranslationStart(cds.getStart(), calculateEnd);
    }

    private String concatProgramNames(String[] names) {
        String msg = "";
        if (names == null) {
            return msg;
        }
        int size = names.length;
        for (int i = 0; i < size; ++i) {
            msg = msg + names[i];
            if (i < size - 2) {
                msg = msg + ", ";
                continue;
            }
            if (i >= size - 1) continue;
            msg = msg + " and ";
        }
        return msg;
    }

    private String concatProgramNames(ChadoProgram[] progs) {
        String retStr = "";
        if (progs == null) {
            return retStr;
        }
        for (int i = 0; i < progs.length; ++i) {
            retStr = retStr + progs[i].getName();
            if (i < progs.length - 2) {
                retStr = retStr + ", ";
                continue;
            }
            if (i >= progs.length - 1) continue;
            retStr = retStr + " and ";
        }
        return retStr;
    }
}

