/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.chado.jdbc;

import apollo.dataadapter.chado.jdbc.JdbcChadoAdapter;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.Sequence;

class ChadoCds {
    String cdsName;
    String cdnaSeq;
    String proteinName;
    String proteinSeq;
    int fmin;
    int fmax;
    int strand;

    ChadoCds(String cdsName, String cdnaSeq, String proteinName, String proteinSeq, int fmin, int fmax, int strand) {
        this.cdsName = cdsName;
        this.cdnaSeq = cdnaSeq;
        this.proteinName = proteinName;
        this.proteinSeq = proteinSeq;
        this.fmin = JdbcChadoAdapter.adjustLowForInterbaseToBaseOrientedConversion(fmin);
        this.fmax = fmax;
        this.strand = strand;
    }

    Sequence getProteinSequence() {
        Sequence proteinSequence = new Sequence(this.proteinName, this.proteinSeq);
        proteinSequence.setResidueType("AA");
        proteinSequence.setAccessionNo(this.proteinName);
        return proteinSequence;
    }

    private boolean isForward() {
        return this.strand >= 0;
    }

    int getStart() {
        return this.isForward() ? this.fmin : this.fmax;
    }

    int getEnd() {
        return this.isForward() ? this.fmax : this.fmin;
    }

    int getTranslationEnd() {
        if (this.isForward()) {
            return this.getEnd() - 2;
        }
        return this.getEnd() + 2;
    }

    void checkCdsBounds(SeqFeatureI transcript) {
        this.fmin = this.fmin < transcript.getLow() ? transcript.getLow() : this.fmin;
        this.fmax = this.fmax > transcript.getHigh() ? transcript.getHigh() : this.fmax;
    }
}

