/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.chado;

import java.util.HashMap;
import java.util.Map;

public class ChadoTransaction {
    public static final Operation DELETE = new Operation("delete");
    public static final Operation UPDATE = new Operation("update");
    public static final Operation INSERT = new Operation("insert");
    public static final Operation LOOKUP = new Operation("lookup");
    public static final Operation FORCE = new Operation("force");
    public static final String MAP_POSITION_ID = "genomicSequence";
    private String tableName;
    private Map properties;
    private String id;
    private Operation operation = FORCE;
    private boolean isExon = false;
    private static final String[] synKey = new String[]{"name", "type_id"};
    private static final String[] pubKey = new String[]{"uniquename"};
    private static final String[] featKey = new String[]{"uniquename", "type_id", "organism_id"};
    private static final String[] exonKey = new String[]{"name", "type_id", "organism_id"};

    public void setTableName(String name) {
        this.tableName = name;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public Map getProperties() {
        return this.properties;
    }

    public void addProperty(String propName, String value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(propName, value);
    }

    void removeProperty(String propName) {
        if (this.properties == null) {
            return;
        }
        this.properties.remove(propName);
    }

    private String getProperty(String propName) {
        return (String)this.properties.get(propName);
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getID() {
        return this.id;
    }

    public void setIsExon(boolean isExon) {
        this.isExon = isExon;
    }

    public boolean isExon() {
        return this.isExon;
    }

    public Map getUniqueKeyProps() {
        if (!this.hasUniqueKeyInfo()) {
            return this.getProperties();
        }
        String[] keys = this.getUniqueKey();
        HashMap<String, String> keyMap = new HashMap<String, String>();
        for (int i = 0; i < keys.length; ++i) {
            keyMap.put(keys[i], this.getProperty(keys[i]));
        }
        return keyMap;
    }

    private boolean hasUniqueKeyInfo() {
        return this.getUniqueKey() != null;
    }

    private String[] getUniqueKey() {
        if (this.tableName.equals("synonym")) {
            return synKey;
        }
        if (this.tableName.equals("pub")) {
            return pubKey;
        }
        if (this.tableName.equals("feature")) {
            if (this.isExon()) {
                return exonKey;
            }
            return featKey;
        }
        return null;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation op) {
        this.operation = op;
    }

    public static class Operation {
        private String op;
        private static Map opMap = new HashMap();

        private Operation(String op) {
            this.op = op;
            opMap.put(op, this);
        }

        public String toString() {
            return this.op;
        }

        public static Operation getOperation(String op) {
            return (Operation)opMap.get(op);
        }

        boolean isLookup() {
            return this == LOOKUP;
        }

        boolean isForce() {
            return this == FORCE;
        }

        boolean isInsert() {
            return this == INSERT;
        }
    }
}

