/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.analysis;

import apollo.analysis.filter.AnalysisFilterI;
import apollo.analysis.filter.AnalysisInput;
import apollo.analysis.filter.BlastFilterPanel;
import apollo.analysis.filter.GenscanFilterPanel;
import apollo.analysis.filter.NoFilterPanel;
import apollo.analysis.filter.Sim4FilterPanel;
import apollo.config.Config;
import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.analysis.AnalysisAdapter;
import apollo.dataadapter.analysis.AnalysisPanel;
import apollo.dataadapter.analysis.AnalysisParserI;
import apollo.dataadapter.analysis.BlastParser;
import apollo.dataadapter.analysis.BlatParser;
import apollo.dataadapter.analysis.FgeneshParser;
import apollo.dataadapter.analysis.GenscanParser;
import apollo.dataadapter.analysis.RpMaskerParser;
import apollo.dataadapter.analysis.Sim4Parser;
import apollo.dataadapter.analysis.tRNA_Parser;
import apollo.datamodel.CurationSet;
import java.awt.Color;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.bdgp.io.DataAdapter;
import org.bdgp.io.IOOperation;
import org.bdgp.swing.AbstractIntDataAdapUI;

public class AnalysisAdapterGUI
extends AbstractIntDataAdapUI {
    private static int tabbedIndex = 0;
    private IOOperation op;
    private AnalysisAdapter analysisDriver;
    private JTabbedPane tabbedPane;
    private static final String indexPropString = "AnalysisTabIndex";
    private CurationSet curation_set;
    private AnalysisPanel[] analysisPanels;

    public AnalysisAdapterGUI(IOOperation op, CurationSet curation) {
        this.op = op;
        this.curation_set = curation;
        this.initPanels();
        this.buildGUI();
        this.setBackground(Color.white);
        this.setForeground(Color.black);
    }

    private void initPanels() {
        Color pane_color = new Color(240, 248, 255);
        AnalysisPanel blast_run = new AnalysisPanel(this, "BLAST", new BlastParser(), new BlastFilterPanel(pane_color));
        pane_color = new Color(244, 240, 245);
        AnalysisPanel sim4_run = new AnalysisPanel(this, "Sim4", new Sim4Parser(), new Sim4FilterPanel(pane_color));
        pane_color = new Color(152, 251, 152);
        AnalysisPanel blat_run = new AnalysisPanel(this, "blat", new BlatParser(), new NoFilterPanel(pane_color));
        pane_color = new Color(255, 250, 205);
        AnalysisPanel gs_run = new AnalysisPanel(this, "Genscan", new GenscanParser(), new GenscanFilterPanel(pane_color));
        pane_color = new Color(255, 218, 185);
        AnalysisPanel fg_run = new AnalysisPanel(this, "Fgenesh", new FgeneshParser(), new NoFilterPanel(pane_color));
        pane_color = new Color(255, 228, 225);
        AnalysisPanel tRNA_run = new AnalysisPanel(this, "tRNAscanSE", new tRNA_Parser(), new NoFilterPanel(pane_color));
        pane_color = new Color(224, 255, 255);
        AnalysisPanel rp_run = new AnalysisPanel(this, "RepeatMasker", new RpMaskerParser(), new NoFilterPanel(pane_color));
        this.analysisPanels = new AnalysisPanel[]{blast_run, sim4_run, blat_run, fg_run, gs_run, tRNA_run, rp_run};
        for (int i = 0; i < this.analysisPanels.length; ++i) {
            ReturnCommit returnCommit = new ReturnCommit(this.analysisPanels[i]);
            this.analysisPanels[i].addActionListener(returnCommit);
        }
    }

    public void setDataAdapter(DataAdapter driver) {
        super.setDataAdapter(driver);
        this.analysisDriver = (AnalysisAdapter)driver;
    }

    public Object doOperation(Object values) throws ApolloAdapterException {
        this.analysisDriver.setInputType(this.getCurrentInputType());
        this.analysisDriver.setParser(this.getCurrentAnalysisParser());
        this.analysisDriver.setFilter(this.getCurrentAnalysisFilter());
        if (this.getCurrentSource() == null) {
            throw new ApolloAdapterException("null input");
        }
        this.analysisDriver.setInput(this.getCurrentSource());
        this.analysisDriver.setRegion(this.getCurrentSeq());
        this.analysisDriver.setAnalysisInput(this.getCurrentInput());
        if (this.op.equals((Object)ApolloDataAdapterI.OP_READ_DATA)) {
            return this.analysisDriver.getCurationSet();
        }
        if (this.op.equals((Object)ApolloDataAdapterI.OP_APPEND_DATA)) {
            return this.analysisDriver.addToCurationSet();
        }
        return null;
    }

    public IOOperation getCurrentOperation() {
        return this.op;
    }

    private DataInputType getCurrentInputType() {
        return this.getCurrentAnalysisPanel().getInputType();
    }

    private String getCurrentSource() {
        return this.getCurrentAnalysisPanel().getCurrentFile();
    }

    private String getCurrentSeq() {
        return this.getCurrentAnalysisPanel().getCurrentSeq();
    }

    private AnalysisParserI getCurrentAnalysisParser() {
        return this.getCurrentAnalysisPanel().getParser();
    }

    private AnalysisFilterI getCurrentAnalysisFilter() {
        return this.getCurrentAnalysisPanel().getFilter();
    }

    private AnalysisInput getCurrentInput() {
        return this.getCurrentAnalysisPanel().getCurrentInput();
    }

    private AnalysisPanel getCurrentAnalysisPanel() {
        return this.analysisPanels[this.tabbedPane.getSelectedIndex()];
    }

    public Properties getProperties() {
        Properties combinedProperties = new Properties();
        combinedProperties.put(indexPropString, "" + tabbedIndex);
        for (int i = 0; i < this.analysisPanels.length; ++i) {
            AnalysisPanel ap = this.analysisPanels[i];
            String analysisName = ap.getName();
            Properties childProperties = ap.getProperties();
            this.addPropertiesWithPrefix(combinedProperties, analysisName, childProperties);
        }
        return combinedProperties;
    }

    public void setProperties(Properties combinedProperties) {
        HashMap childPropertiesMap = new HashMap();
        if (!Config.getController().isCurationSetLoaded()) {
            Config.newDataAdapter((DataAdapter)this.analysisDriver);
        }
        if (combinedProperties == null) {
            System.out.println("No properties available");
            for (int i = 0; i < this.analysisPanels.length; ++i) {
                AnalysisPanel ap = this.analysisPanels[i];
                ap.initTiersList(null);
            }
        } else {
            String indexStr = combinedProperties.getProperty(indexPropString);
            if (indexStr != null) {
                tabbedIndex = Integer.parseInt(indexStr);
                this.tabbedPane.setSelectedIndex(tabbedIndex);
            }
            this.setChildProperties(combinedProperties, childPropertiesMap);
            for (int i = 0; i < this.analysisPanels.length; ++i) {
                AnalysisPanel ap = this.analysisPanels[i];
                String analysisName = ap.getName();
                Properties childProperty = (Properties)childPropertiesMap.get(analysisName);
                if (childProperty != null) {
                    ap.setProperties(childProperty);
                    continue;
                }
                ap.initTiersList(null);
            }
        }
    }

    public void setChildProperties(Properties combinedProperties, HashMap childPropertiesMap) {
        if (combinedProperties != null) {
            Iterator<Object> combinedPropertyNames = combinedProperties.keySet().iterator();
            while (combinedPropertyNames.hasNext()) {
                String combinedPropertyName = (String)combinedPropertyNames.next();
                String propertyValue = (String)combinedProperties.get(combinedPropertyName);
                int index = combinedPropertyName.indexOf(":");
                if (index <= 0) continue;
                String child = combinedPropertyName.substring(0, index);
                String childPropertyName = combinedPropertyName.substring(index + 1);
                Properties childProperty = (Properties)childPropertiesMap.get(child);
                if (childProperty == null) {
                    childProperty = new Properties();
                    childPropertiesMap.put(child, childProperty);
                }
                childProperty.put(childPropertyName, propertyValue);
            }
        }
    }

    public void addPropertiesWithPrefix(Properties properties, String prefix, Properties additionalProperties) {
        Iterator<Object> keys = additionalProperties.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = additionalProperties.getProperty(key);
            key = prefix + ":" + key;
            properties.setProperty(key, value);
        }
    }

    public String getPropertyValueWithPrefix(Properties properties, String prefix, String propertyName) {
        String value = properties.getProperty(prefix + ":" + propertyName);
        if (value == null) {
            Iterator<Object> keys = properties.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                System.out.println("getPropertyValueWithPerfix: " + propertyName + " is not " + key);
            }
        }
        return value;
    }

    private void buildGUI() {
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setBackground(Config.getDataLoaderBackgroundColor());
        for (int i = 0; i < this.analysisPanels.length; ++i) {
            this.analysisPanels[i].insertIntoTabbedPane(this.tabbedPane, i);
        }
        this.tabbedPane.setSelectedIndex(tabbedIndex);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                tabbedIndex = AnalysisAdapterGUI.this.tabbedPane.getSelectedIndex();
            }
        });
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.add(this.tabbedPane);
        JButton okButton = new JButton("Ok");
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnalysisAdapterGUI.this.cancelControllingObject();
            }
        });
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnalysisAdapterGUI.this.commitControllingObject();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(okButton);
        buttonPanel.add(Box.createHorizontalStrut(10));
        buttonPanel.add(cancelButton);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.setBackground(Color.white);
        this.add(buttonPanel);
    }

    public CurationSet getCurationSet() {
        if (this.op.equals((Object)ApolloDataAdapterI.OP_APPEND_DATA)) {
            return this.curation_set;
        }
        return null;
    }

    private void cancelControllingObject() {
        this.controllingObject.cancel();
    }

    private void commitControllingObject() {
        this.controllingObject.commit();
    }

    class ReturnCommit
    implements ActionListener {
        AnalysisPanel analysisPanel;

        private ReturnCommit(AnalysisPanel ap) {
            this.analysisPanel = ap;
        }

        public void actionPerformed(ActionEvent e) {
        }
    }
}

