/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter;

import apollo.dataadapter.TransactionTransformException;
import apollo.dataadapter.TransactionTransformer;
import apollo.editor.TransactionManager;
import java.util.List;

public abstract class TransactionOutputAdapter {
    protected TransactionTransformer transformer;
    protected Object target;
    protected String mapID;
    protected String mapType;

    public String getMapID() {
        return this.mapID;
    }

    public void setMapID(String mapID) {
        this.mapID = mapID;
    }

    public String getMapType() {
        return this.mapType;
    }

    public void setMapType(String type) {
        this.mapType = type;
    }

    public void setTransformer(TransactionTransformer transformer) {
        this.transformer = transformer;
    }

    public TransactionTransformer getTransformer() {
        return this.transformer;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public Object getTarget() {
        return this.target;
    }

    public void commitTransactions(TransactionManager transManager) throws Exception {
        if (this.target == null) {
            throw new IllegalStateException("TransctionOutputAdapter.commit(): no target specified!");
        }
        List transformedTns = transManager.getTransactions();
        if (this.transformer != null) {
            try {
                transformedTns = this.transformer.transform(transManager);
            }
            catch (TransactionTransformException e) {
                System.out.println("\nTransforming of transactions has failed.");
                throw e;
            }
        }
        this.commitTransformedTransactions(transformedTns);
    }

    protected abstract void commitTransformedTransactions(List var1) throws Exception;
}

