/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter;

import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.GFFAdapter;
import apollo.dataadapter.KaryotypeAdapter;
import apollo.datamodel.Chromosome;
import apollo.datamodel.CurationSet;
import apollo.datamodel.FeaturePair;
import apollo.datamodel.FeatureSet;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.Karyotype;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.StrandedFeatureSet;
import apollo.datamodel.StrandedFeatureSetI;
import apollo.datamodel.SyntenyRegion;
import apollo.seq.io.GFFFile;
import java.util.Vector;
import org.bdgp.io.DataAdapterUI;
import org.bdgp.io.IOOperation;
import org.bdgp.util.ProgressEvent;

public class SyntenyGFFAdapter
extends GFFAdapter
implements ApolloDataAdapterI {
    Vector regions;
    Chromosome chr1 = null;
    KaryotypeAdapter ca;
    String org1;
    String org2;
    IOOperation[] supportedOperations = new IOOperation[]{ApolloDataAdapterI.OP_READ_DATA};

    public void init() {
    }

    public String getType() {
        return "Synteny  File";
    }

    public IOOperation[] getSupportedOperations() {
        return this.supportedOperations;
    }

    public DataAdapterUI getUI(IOOperation op) {
        return null;
    }

    public String getName() {
        return "Synteny GFF file format";
    }

    public SyntenyGFFAdapter(String filename, String org1, String org2) {
        this.filename = filename;
        this.ca = new KaryotypeAdapter();
        this.org1 = org1;
        this.org2 = org2;
    }

    public KaryotypeAdapter getKaryotypeAdapter() {
        return this.ca;
    }

    public SyntenyGFFAdapter() {
    }

    public CurationSet getCurationSet() throws ApolloAdapterException {
        CurationSet curationSet = new CurationSet();
        curationSet.setAnnots(new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet()));
        curationSet.setResults(this.getAnalysisRegion());
        return curationSet;
    }

    public StrandedFeatureSetI getAnalysisRegion() throws ApolloAdapterException {
        try {
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(0.0), "Beginning parse..."));
            GFFFile gff = new GFFFile(this.filename, "File");
            StrandedFeatureSet fset = new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet());
            for (int i = 0; i < gff.seqs.size(); ++i) {
                SeqFeatureI sf = (SeqFeatureI)gff.seqs.elementAt(i);
                fset.addFeature(sf);
            }
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(50.0), "Populating data structures..."));
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(100.0), "Done..."));
            return fset;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ApolloAdapterException(e);
        }
    }

    public Vector getSyntenyRegions() {
        if (this.regions != null) {
            return this.regions;
        }
        try {
            StrandedFeatureSetI fset = this.getAnalysisRegion();
            this.regions = new Vector();
            for (int i = 0; i < fset.size(); ++i) {
                SeqFeatureI sf = fset.getFeatureAt(i);
                if (!(sf instanceof FeaturePair)) continue;
                FeaturePair fp = (FeaturePair)sf;
                String chrid1 = fp.getName();
                String chrid2 = fp.getHname();
                Chromosome chr2 = null;
                for (int j = 0; j < this.ca.getKaryotypes().size(); ++j) {
                    Chromosome tmp;
                    Chromosome tmpchr;
                    Karyotype k = (Karyotype)this.ca.getKaryotypes().elementAt(j);
                    if (k.getSpeciesName().equals(this.org1) && (tmpchr = k.getChromosomeByName(chrid1)) != null) {
                        this.chr1 = tmpchr;
                    }
                    if (!k.getSpeciesName().equals(this.org2) || (tmp = k.getChromosomeByName(chrid2)) == null) continue;
                    chr2 = tmp;
                }
                if (this.chr1 != null && chr2 != null) {
                    SyntenyRegion sr = new SyntenyRegion(this.chr1, fp.getLow(), fp.getHigh(), chr2, fp.getHlow(), fp.getHhigh(), fp.getStrand());
                    this.regions.addElement(sr);
                    continue;
                }
                System.out.println("Can't find chromosomes " + fp.getName() + " " + fp.getHname());
            }
            return this.regions;
        }
        catch (ApolloAdapterException e) {
            System.out.println("Can't read region " + (Object)((Object)e));
            return null;
        }
    }

    public Vector getSyntenyRegionsByChromosome(String chr) {
        if (chr.indexOf("chr") == 0) {
            chr = chr.substring(3);
        }
        System.out.println("Chromosome " + chr);
        Vector regions = this.getSyntenyRegions();
        Vector<SyntenyRegion> newRegions = new Vector<SyntenyRegion>();
        for (int i = 0; i < regions.size(); ++i) {
            SyntenyRegion reg = (SyntenyRegion)regions.elementAt(i);
            String chr1 = reg.getChromosome1().getDisplayId();
            if (!chr1.equals(chr)) continue;
            newRegions.addElement(reg);
        }
        return newRegions;
    }

    public Chromosome getChromosome1() {
        return this.chr1;
    }
}

