/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter;

import apollo.dataadapter.AbstractApolloAdapter;
import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.GbrowseAdapterGUI;
import apollo.dataadapter.NotImplementedException;
import apollo.dataadapter.gbrowse.DBAdaptor;
import apollo.dataadapter.gbrowse.FeatureAdaptor;
import apollo.dataadapter.mysql.MySQLDatabase;
import apollo.dataadapter.mysql.MySQLInstance;
import apollo.datamodel.CurationSet;
import apollo.datamodel.DbXref;
import apollo.datamodel.FeatureSet;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceI;
import apollo.datamodel.StrandedFeatureSet;
import java.util.Properties;
import java.util.Vector;
import org.bdgp.io.DataAdapterUI;
import org.bdgp.io.IOOperation;

public class GbrowseAdapter
extends AbstractApolloAdapter {
    private DataAdapterUI ui;
    private MySQLInstance mysql;
    private MySQLDatabase db;
    private DBAdaptor dba;
    public String host = "localhost";
    public String user = "root";
    public String pass = "";
    public String dbname = "yeast";
    public int port = 3306;
    public String region;
    IOOperation[] supportedOperations = new IOOperation[]{ApolloDataAdapterI.OP_READ_DATA};

    public void init() {
    }

    public String getName() {
        return "Gbrowse";
    }

    public String getType() {
        return "Direct gbrowse database access";
    }

    public String getInput() {
        return this.region;
    }

    public DataInputType getInputType() {
        return DataInputType.BASEPAIR_RANGE;
    }

    public IOOperation[] getSupportedOperations() {
        return this.supportedOperations;
    }

    public DataAdapterUI getUI(IOOperation op) {
        if (this.ui == null) {
            this.ui = new GbrowseAdapterGUI(op);
        }
        return this.ui;
    }

    public CurationSet getCurationSet() throws ApolloAdapterException {
        GbrowseAdapterGUI gui = (GbrowseAdapterGUI)this.getUI(ApolloDataAdapterI.OP_READ_DATA);
        String chr = gui.getSelectedChr();
        int chrstart = Integer.parseInt(gui.getSelectedStart());
        int chrend = Integer.parseInt(gui.getSelectedEnd());
        this.mysql = new MySQLInstance(this.host, this.user, this.pass, this.port);
        this.db = this.mysql.fetchDatabaseByName(this.dbname);
        this.dba = new DBAdaptor(this.db);
        FeatureAdaptor fa = this.dba.getFeatureAdaptor();
        FeatureSetI f = fa.fetchByReferenceStartEnd(chr, chrstart, chrend);
        super.clearOldData();
        CurationSet curationSet = new CurationSet();
        curationSet.setChromosome(chr);
        curationSet.setLow(chrstart);
        curationSet.setHigh(chrend);
        curationSet.setStrand(0);
        StrandedFeatureSet sfset = new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet());
        for (int i = 0; i < f.size(); ++i) {
            SeqFeatureI sf = f.getFeatureAt(i);
            sfset.addFeature(sf);
        }
        curationSet.setResults(sfset);
        curationSet.setAnnots(new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet()));
        curationSet.setName(chr + "." + chrstart + "-" + chrend);
        return curationSet;
    }

    public Properties getStateInformation() {
        Properties props = new Properties();
        return props;
    }

    public void setStateInformation(Properties props) {
    }

    public SequenceI getSequence(String id) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public SequenceI getSequence(DbXref dbxref) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public SequenceI getSequence(DbXref dbxref, int start, int end) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public Vector getSequences(DbXref[] dbxref) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public Vector getSequences(DbXref[] dbxref, int[] start, int[] end) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public void commitChanges(CurationSet curationSet) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public String getRawAnalysisResults(String id) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public void setRegion(String region) {
        this.region = region;
    }

    protected String getRegion() {
        return this.region;
    }

    protected SequenceI getReferenceSequence() {
        return null;
    }
}

