/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter;

import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.KaryotypeAdapterI;
import apollo.dataadapter.SyntenyAdapterI;
import apollo.datamodel.Chromosome;
import apollo.datamodel.FeaturePair;
import apollo.datamodel.FeatureSet;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.Karyotype;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SyntenyRegion;
import apollo.seq.io.GFFFile;
import java.util.Hashtable;
import java.util.Vector;

public class GFFSyntenyAdapter
implements SyntenyAdapterI {
    Hashtable chrRegionHash = new Hashtable();
    KaryotypeAdapterI ka;
    String org1;
    String org2;
    String filePref;
    String fileSuff;

    public String getType() {
        return "Synteny  File";
    }

    public String getName() {
        return "Synteny GFF file format";
    }

    public GFFSyntenyAdapter(String filePref, String fileSuff, KaryotypeAdapterI ka, String org1, String org2) {
        this.filePref = filePref;
        this.fileSuff = fileSuff;
        this.ka = ka;
        this.org1 = org1;
        this.org2 = org2;
    }

    public KaryotypeAdapterI getKaryotypeAdapter() {
        return this.ka;
    }

    private FeatureSetI getDataFromFile(String fileName) throws ApolloAdapterException {
        try {
            GFFFile gff = new GFFFile(fileName, "File");
            FeatureSet fset = new FeatureSet();
            for (int i = 0; i < gff.seqs.size(); ++i) {
                SeqFeatureI sf = (SeqFeatureI)gff.seqs.elementAt(i);
                fset.addFeature(sf);
            }
            return fset;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ApolloAdapterException(e);
        }
    }

    public Vector getSyntenyRegions(String chr) {
        if (this.chrRegionHash.containsKey(chr)) {
            return (Vector)this.chrRegionHash.get(chr);
        }
        try {
            String fileName = this.filePref + chr + this.fileSuff;
            FeatureSetI fset = this.getDataFromFile(fileName);
            Vector<SyntenyRegion> regions = new Vector<SyntenyRegion>();
            for (int i = 0; i < fset.size(); ++i) {
                SeqFeatureI sf = fset.getFeatureAt(i);
                if (!(sf instanceof FeaturePair)) continue;
                FeaturePair fp = (FeaturePair)sf;
                String chrid1 = fp.getName();
                String chrid2 = fp.getHname();
                Chromosome chr1 = null;
                Chromosome chr2 = null;
                for (int j = 0; j < this.ka.getKaryotypes().size(); ++j) {
                    Chromosome tmp;
                    Chromosome tmpchr;
                    Karyotype k = (Karyotype)this.ka.getKaryotypes().elementAt(j);
                    if (k.getSpeciesName().equals(this.org1) && (tmpchr = k.getChromosomeByName(chrid1)) != null) {
                        chr1 = tmpchr;
                    }
                    if (!k.getSpeciesName().equals(this.org2) || (tmp = k.getChromosomeByName(chrid2)) == null) continue;
                    chr2 = tmp;
                }
                if (chr1 != null && chr2 != null) {
                    SyntenyRegion sr = new SyntenyRegion(chr1, fp.getLow(), fp.getHigh(), chr2, fp.getHlow(), fp.getHhigh(), fp.getStrand());
                    regions.addElement(sr);
                    continue;
                }
                System.out.println("Can't find chromosomes " + fp.getName() + " " + fp.getHname());
            }
            this.chrRegionHash.put(chr, regions);
            return regions;
        }
        catch (ApolloAdapterException e) {
            System.out.println("Can't read region " + (Object)((Object)e));
            return null;
        }
    }

    public Vector getSyntenyRegionsByChromosome(Chromosome chr) {
        String chrName = chr.getDisplayId();
        System.out.println("Chromosome " + chrName);
        Vector regions = this.getSyntenyRegions(chrName);
        return regions;
    }

    public void addSyntenyRegionForChromosome(String chromosome, SyntenyRegion region) {
        System.out.println("addSyntenyRegionsForChromosome not implemented for GFFSyntenyAdapter");
    }

    public void setName(String name) {
        System.out.println("setName not implemented for GFFSyntenyAdapter");
    }

    public void setType(String type) {
        System.out.println("setName not implemented for GFFSyntenyAdapter");
    }
}

