/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter;

import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterGUI;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.BaseGFFAdapter;
import apollo.dataadapter.StateInformation;
import apollo.datamodel.ApolloDataI;
import apollo.datamodel.CompositeDataHolder;
import apollo.datamodel.CurationSet;
import apollo.gui.GenericFileAdapterGUI;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.bdgp.io.DataAdapterException;
import org.bdgp.io.IOOperation;

public class GFFAdapterGUI
extends GenericFileAdapterGUI
implements ApolloDataAdapterGUI {
    JButton seqButton;
    JComboBox seqFileList;
    Vector seqFilePaths;

    public GFFAdapterGUI(IOOperation op) {
        super(op);
    }

    public void buildGUI() {
        super.buildGUI();
        this.seqFileList = new JComboBox();
        this.seqButton = new JButton("Browse...");
        this.seqFileList.setEditable(true);
        this.seqFileList.setFont(this.getFont());
        this.seqButton.setFont(this.getFont());
        this.seqFileList.setAlignmentY(0.5f);
        this.seqButton.setAlignmentY(0.5f);
        this.seqFileList.setPreferredSize(new Dimension(this.getPathListWidth(), 10));
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BoxLayout(panel3, 0));
        panel3.add(this.seqFileList);
        panel3.add(this.seqButton);
        this.getPanel().removeAll();
        this.getPanel().setLayout(new GridLayout(4, 1));
        this.getPanel().add(new JLabel("GFF file"));
        this.getPanel().add(this.panel2);
        this.getPanel().add(new JLabel("Sequence file"));
        this.getPanel().add(panel3);
        this.seqButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GFFAdapterGUI.this.browseFiles(GFFAdapterGUI.this.seqFileList);
            }
        });
    }

    public void setProperties(Properties in) {
        this.props = in;
        if (this.props == null) {
            return;
        }
        this.filePaths = new Vector();
        this.seqFilePaths = new Vector();
        try {
            String historyItems = this.props.getProperty("historyItems");
            if (historyItems == null || Integer.parseInt(historyItems) == 0) {
                System.out.println("No history for GFF files");
                return;
            }
            int items = Integer.parseInt(historyItems);
            for (int i = 0; i < items; ++i) {
                this.filePaths.addElement(this.props.getProperty("historyItem" + i));
            }
            String seqFileItems = this.props.getProperty("seqFileItems");
            if (seqFileItems != null && Integer.parseInt(seqFileItems) > 0) {
                items = Integer.parseInt(seqFileItems);
                for (int i = 0; i < items; ++i) {
                    this.seqFilePaths.addElement(this.props.getProperty("seqFileItem" + i));
                }
            }
        }
        catch (NumberFormatException e) {
            System.out.println("Exception parsing history file: " + e);
        }
        this.pathList.setModel(new DefaultComboBoxModel(this.filePaths));
        this.seqFileList.setModel(new DefaultComboBoxModel(this.seqFilePaths));
    }

    public Properties getProperties() {
        int i;
        String selectedPath = this.getSelectedPath();
        this.filePaths.removeElement(selectedPath);
        this.filePaths.insertElementAt(selectedPath, 0);
        Properties out = new Properties();
        if (this.filePaths.size() > 5) {
            out.put("historyItems", "5");
        } else {
            out.put("historyItems", this.filePaths.size() + "");
        }
        for (i = 0; i < this.filePaths.size() && i < 5; ++i) {
            out.put("historyItem" + i, (String)this.filePaths.elementAt(i));
        }
        selectedPath = this.getSelectedSeqPath();
        if (selectedPath.trim().length() <= 0) {
            selectedPath = null;
        }
        if (this.seqFilePaths != null && selectedPath != null) {
            this.seqFilePaths.removeElement(selectedPath);
            this.seqFilePaths.insertElementAt(selectedPath, 0);
            if (this.seqFilePaths.size() > 5) {
                out.put("seqFileItems", "5");
            } else {
                out.put("seqFileItems", this.seqFilePaths.size() + "");
            }
            for (i = 0; i < this.seqFilePaths.size() && i < 5; ++i) {
                out.put("seqFileItem" + i, (String)this.seqFilePaths.elementAt(i));
            }
        }
        return out;
    }

    public String getSelectedSeqPath() {
        String selectedPath = (String)this.seqFileList.getSelectedItem();
        if (selectedPath == null || !selectedPath.equals(this.seqFileList.getEditor().getItem())) {
            selectedPath = (String)this.seqFileList.getEditor().getItem();
        }
        return selectedPath;
    }

    public Object doOperation(Object values) throws DataAdapterException {
        BaseGFFAdapter bga = (BaseGFFAdapter)this.driver;
        if (this.op.equals((Object)ApolloDataAdapterI.OP_READ_DATA)) {
            bga.setFilename(this.getSelectedPath());
            bga.setSequenceFilename(this.getSelectedSeqPath());
            bga.setRegion(this.getSelectedPath());
            CurationSet set = bga.getCurationSet();
            return set;
        }
        if (this.op.equals((Object)ApolloDataAdapterI.OP_WRITE_DATA)) {
            ApolloDataI apolloData = (ApolloDataI)values;
            CurationSet curSet = null;
            if (apolloData.isCurationSet()) {
                curSet = apolloData.getCurationSet();
            } else if (apolloData.isCompositeDataHolder()) {
                CompositeDataHolder cdh = apolloData.getCompositeDataHolder();
                curSet = cdh.getCurationSet(0);
            } else {
                System.err.println("Don't know how to save");
                return null;
            }
            bga.setFilename(this.getSelectedPath());
            bga.setSequenceFilename(this.getSelectedSeqPath());
            bga.setRegion(this.getSelectedPath());
            bga.commitChanges(curSet);
            return null;
        }
        throw new DataAdapterException("This adapter only works for ApolloDataAdapterI.OP_READ_DATA or ApolloDataAdapterI.OP_WRITE_DATA");
    }

    public Properties createStateInformation() throws ApolloAdapterException {
        StateInformation stateInformation = new StateInformation();
        stateInformation.setProperty("dataFileName", this.getSelectedPath());
        stateInformation.setProperty("sequenceFileName", this.getSelectedSeqPath());
        return stateInformation;
    }
}

