/*
 * Decompiled with CFR 0.152.
 */
package apollo.config;

import apollo.config.Config;
import apollo.config.FeatureProperty;
import apollo.config.PropSchemeChangeEvent;
import apollo.config.PropSchemeChangeListener;
import apollo.config.TierProperty;
import apollo.config.TiersIO;
import apollo.util.CaseInsensitiveStringHash;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class PropertyScheme
implements Serializable {
    private Vector tiersVect = new Vector();
    private Hashtable tiersHash = new Hashtable();
    private CaseInsensitiveStringHash fpTypeToPropHash = new CaseInsensitiveStringHash();
    private CaseInsensitiveStringHash fpAnalNameToPropHash = new CaseInsensitiveStringHash();
    private boolean cachesNeedUpdate = true;
    private boolean groupedUpdate = false;
    private Vector comments;
    private Vector propSchemeChangeListeners;
    private boolean changed = false;
    private Vector annotationFeatureProps;
    private FeatureProperty defaultFeatureProperty = new FeatureProperty();
    private List linkedFeatProps = null;
    private List linkedTierProps;

    public PropertyScheme() throws IOException, FileNotFoundException {
        this(Config.getTiersFile());
    }

    public PropertyScheme(String tiersFile) throws IOException, FileNotFoundException {
        if (tiersFile == null) {
            throw new IOException("No tiers file name!");
        }
        this.propSchemeChangeListeners = new Vector();
        this.readDefaultTypes(tiersFile);
        this.initBuiltInTypes();
        this.setChanged();
        this.firePropSchemeChangeEvent();
    }

    public void addPropSchemeChangeListener(PropSchemeChangeListener pcl) {
        if (!this.propSchemeChangeListeners.contains(pcl)) {
            this.propSchemeChangeListeners.addElement(pcl);
        }
    }

    public void firePropSchemeChangeEvent() {
        this.setChanged();
        if (this.propSchemeChangeListeners.size() == 0) {
            return;
        }
        if (this.groupedUpdate) {
            return;
        }
        PropSchemeChangeEvent e = new PropSchemeChangeEvent(this, this);
        for (int i = 0; i < this.propSchemeChangeListeners.size(); ++i) {
            PropSchemeChangeListener l = (PropSchemeChangeListener)this.propSchemeChangeListeners.elementAt(i);
            l.handlePropSchemeChangeEvent(e);
        }
        this.changed = false;
    }

    public int size() {
        return this.tiersVect.size();
    }

    public void addTierType(TierProperty tierProp) {
        if (this.tiersHash.get(tierProp.getLabel().toLowerCase()) == null) {
            this.tiersVect.addElement(tierProp);
        }
        this.tiersHash.put(tierProp.getLabel().toLowerCase(), tierProp);
        tierProp.setPropertyScheme(this);
    }

    public void expandAllTiers(boolean state) {
        this.setGroupedUpdate(true);
        for (int i = 0; i < this.size(); ++i) {
            this.getTierProperty(i).setExpanded(state);
        }
        this.setGroupedUpdate(false);
    }

    public void setAllTiersVisible(boolean state) {
        this.setGroupedUpdate(true);
        for (int i = 0; i < this.size(); ++i) {
            this.getTierProperty(i).setVisible(state);
        }
        this.setGroupedUpdate(false);
    }

    private void setChanged() {
        this.changed = true;
        this.cachesNeedUpdate = true;
    }

    private boolean hasChanged() {
        return this.changed;
    }

    private void setGroupedUpdate(boolean state) {
        this.groupedUpdate = state;
        if (!state && this.hasChanged()) {
            this.firePropSchemeChangeEvent();
        }
    }

    public void moveTier(String fromTier, String toTier) {
        int toInd = toTier != null ? this.getTierInd(toTier) : this.size() - 1;
        int fromInd = this.getTierInd(fromTier);
        if (toInd == -1 || fromInd == -1) {
            System.out.println("ERROR: Failed finding tiers in moveTier()");
        } else {
            TierProperty from = (TierProperty)this.tiersVect.elementAt(fromInd);
            this.tiersVect.removeElementAt(fromInd);
            this.tiersVect.insertElementAt(from, toInd);
        }
        this.setChanged();
        this.firePropSchemeChangeEvent();
    }

    private void regenerateFeaturePropCaches() {
        this.fpTypeToPropHash.clear();
        this.fpAnalNameToPropHash.clear();
        for (int i = 0; i < this.tiersVect.size(); ++i) {
            TierProperty tp = (TierProperty)this.tiersVect.elementAt(i);
            Vector fps = tp.getFeatureProperties();
            Iterator iter = fps.iterator();
            while (iter.hasNext()) {
                FeatureProperty fp = (FeatureProperty)iter.next();
                if (!this.fpTypeToPropHash.containsKey(fp.getDisplayType())) {
                    this.fpTypeToPropHash.put(fp.getDisplayType(), fp);
                }
                Iterator atIter = fp.getAnalysisTypes().iterator();
                while (atIter.hasNext()) {
                    String analType = (String)atIter.next();
                    if (this.fpAnalNameToPropHash.containsKey(analType)) continue;
                    this.fpAnalNameToPropHash.put(analType, fp);
                }
            }
        }
    }

    public FeatureProperty getFeatureProperty(String analysis_type) {
        FeatureProperty fp = null;
        if (this.cachesNeedUpdate) {
            this.regenerateFeaturePropCaches();
            this.cachesNeedUpdate = false;
        }
        if (analysis_type == null) {
            throw new NullPointerException("PropertyScheme.getFeatureProperty: type can't be null");
        }
        fp = (FeatureProperty)this.fpTypeToPropHash.get(analysis_type);
        if (fp == null) {
            fp = (FeatureProperty)this.fpAnalNameToPropHash.get(analysis_type);
        }
        if (fp == null) {
            System.out.println("Creating new feature property scheme for " + analysis_type);
            TierProperty tp = this.createTierProperty(analysis_type, true, false);
            fp = this.createFeatureProperty(tp, analysis_type, FeatureProperty.DEFAULT_COLOR, FeatureProperty.DEFAULT_STYLE);
        }
        return fp;
    }

    public TierProperty getTierProperty(String type, boolean dig) {
        TierProperty tp = (TierProperty)this.tiersHash.get(type.toLowerCase());
        if (tp == null && dig) {
            FeatureProperty fp = this.getFeatureProperty(type);
            tp = fp.getTier();
        }
        return tp;
    }

    public TierProperty getTierProperty(String type) {
        return this.getTierProperty(type, true);
    }

    public int getTierInd(String label) {
        TierProperty tp;
        for (int i = 0; i < this.size(); ++i) {
            tp = (TierProperty)this.tiersVect.elementAt(i);
            if (!tp.getLabel().equalsIgnoreCase(label)) continue;
            return i;
        }
        FeatureProperty fp = this.getFeatureProperty(label);
        tp = fp.getTier();
        return this.tiersVect.indexOf(tp);
    }

    public Vector getAllTiers() {
        return this.tiersVect;
    }

    public Vector getCopyOfTiers(Vector source) {
        Vector result = (Vector)source.clone();
        return result;
    }

    private void readDefaultTypes(String fileName) {
        TiersIO reader = new TiersIO(this);
        this.comments = reader.doParse(fileName);
    }

    private void initBuiltInTypes() {
        Color feature_color = FeatureProperty.DEFAULT_COLOR;
        String type = "Start Codon";
        TierProperty tp = this.createTierProperty(type, true, true);
        type = "startcodon_frame";
        feature_color = new Color(34, 220, 34);
        FeatureProperty fp = this.createFeatureProperty(tp, type + "1", feature_color, "apollo.gui.drawable.SiteCodon");
        fp = this.createFeatureProperty(tp, type + "2", feature_color, "apollo.gui.drawable.SiteCodon");
        fp = this.createFeatureProperty(tp, type + "3", feature_color, "apollo.gui.drawable.SiteCodon");
        type = "Stop Codon";
        tp = this.createTierProperty(type, true, true);
        type = "stopcodon_frame";
        feature_color = Color.red;
        fp = this.createFeatureProperty(tp, type + "1", feature_color, "apollo.gui.drawable.SiteCodon");
        fp = this.createFeatureProperty(tp, type + "2", feature_color, "apollo.gui.drawable.SiteCodon");
        fp = this.createFeatureProperty(tp, type + "3", feature_color, "apollo.gui.drawable.SiteCodon");
    }

    private TierProperty createTierProperty(String analysis_type, boolean visible, boolean expanded) {
        TierProperty tp = this.getTierProperty(analysis_type, false);
        if (tp == null) {
            tp = new TierProperty(analysis_type, visible, expanded);
            this.addTierType(tp);
        }
        return tp;
    }

    private FeatureProperty createFeatureProperty(TierProperty tp, String analysis_type, Color color, String style) {
        FeatureProperty fp = tp.getFeatureProperty(analysis_type);
        if (fp == null) {
            Vector<String> types = new Vector<String>();
            types.addElement(analysis_type);
            fp = this.createDefaultFeatureProperty();
            fp.init(tp, analysis_type, types, color, style);
            fp.setNameAdapterStringIfNotSet(Config.getStyle().getNameAdapter());
            this.setChanged();
            this.firePropSchemeChangeEvent();
        }
        return fp;
    }

    public void setDefaultFeatureProperty(FeatureProperty fp) {
        this.defaultFeatureProperty = fp;
    }

    public FeatureProperty createDefaultFeatureProperty() {
        return this.defaultFeatureProperty.cloneFeatureProperty();
    }

    public List getSyntenyLinkedFeatProps() {
        if (this.linkedFeatProps == null) {
            this.linkedFeatProps = new ArrayList(5);
            for (int i = 0; i < this.getAllTiers().size(); ++i) {
                this.linkedFeatProps.addAll(this.getTierProperty(i).getSyntenyLinkedFeatProps());
            }
        }
        return this.linkedFeatProps;
    }

    public int getLinkedFeatPropsSize() {
        return this.getSyntenyLinkedFeatProps().size();
    }

    public FeatureProperty getLinkedFeatProp(int i) {
        return (FeatureProperty)this.getSyntenyLinkedFeatProps().get(i);
    }

    public boolean isTypeSyntenyLink(String type) {
        for (int i = 0; i < this.getLinkedFeatPropsSize(); ++i) {
            if (!this.getLinkedFeatProp(i).getDisplayType().equals(type)) continue;
            return true;
        }
        return false;
    }

    public List getLinkedTierProps() {
        if (this.linkedTierProps == null) {
            this.linkedTierProps = new ArrayList(6);
            for (int i = 0; i < this.getAllTiers().size(); ++i) {
                TierProperty tp = this.getTierProperty(i);
                if (!tp.hasLinkedFeatProps()) continue;
                this.linkedTierProps.add(tp);
            }
        }
        return this.linkedTierProps;
    }

    public TierProperty getLinkedTierProp(int i) {
        return (TierProperty)this.linkedTierProps.get(i);
    }

    private TierProperty getTierProperty(int i) {
        return (TierProperty)this.tiersVect.get(i);
    }

    public void write(File file) throws IOException {
        TiersIO writer = new TiersIO(this);
        writer.doSave(file, this.comments);
    }

    public Vector getAnnotationFeatureProps() {
        if (this.annotationFeatureProps == null) {
            this.fillInAnnotationFeatureProps("Annotation");
            for (int i = 0; i < this.size(); ++i) {
                TierProperty tp = this.getTierProperty(i);
                if (!tp.isCurated() || tp.getLabel().equalsIgnoreCase("Annotation")) continue;
                this.fillInAnnotationFeatureProps(tp.getLabel());
            }
            if (this.annotationFeatureProps == null) {
                this.annotationFeatureProps = new Vector(1);
            }
        }
        return this.annotationFeatureProps;
    }

    private void fillInAnnotationFeatureProps(String tier) {
        TierProperty tp = this.getTierProperty(tier, false);
        if (tp != null) {
            Vector annot_types = tp.getFeatureProperties();
            if (this.annotationFeatureProps == null) {
                this.annotationFeatureProps = new Vector(annot_types.size());
            }
            for (int i = 0; i < annot_types.size(); ++i) {
                FeatureProperty fp = (FeatureProperty)annot_types.elementAt(i);
                this.annotationFeatureProps.add(fp);
            }
        }
    }

    public boolean isAnnotationTier(String tier) {
        Vector annot_types = this.getAnnotationFeatureProps();
        for (int k = 0; k < annot_types.size(); ++k) {
            FeatureProperty annot_prop = (FeatureProperty)annot_types.elementAt(k);
            if (!annot_prop.getTierName().equals(tier)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] Args) throws Exception {
        System.out.println("Before ft");
        PropertyScheme ft = new PropertyScheme();
        Vector types = ft.getAllTiers();
        System.out.println("\nft object");
        for (int i = 0; i < types.size(); ++i) {
            TierProperty fp = (TierProperty)types.elementAt(i);
            System.out.println(fp.getLabel() + " " + fp.isVisible() + " " + fp.isExpanded());
        }
        System.out.println("\nft2 object");
        PropertyScheme ft2 = new PropertyScheme();
        types = ft2.getAllTiers();
        for (int i = 0; i < types.size(); ++i) {
            TierProperty fp = (TierProperty)types.elementAt(i);
            System.out.println(fp.getLabel() + " " + fp.isVisible() + " " + fp.isExpanded());
        }
    }
}

