/*
 * Decompiled with CFR 0.152.
 */
package apollo.bop;

import apollo.dataadapter.exception.BopException;
import apollo.datamodel.SequenceI;
import apollo.util.IOUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.Date;

public class JobOutput {
    String name;
    String raw_output;
    Date run_date;
    String program;
    String dataset;
    String analysis_type;
    SequenceI query_seq;

    public String getRawOutput() {
        return this.raw_output;
    }

    public void setRawOutput(String raw) {
        this.raw_output = raw;
    }

    public Date getRunDate() {
        return this.run_date;
    }

    public void setRunDate(long processed_time) {
        this.run_date = processed_time > 0L ? new Date(processed_time * 1000L) : new Date();
    }

    public void setQuerySequence(SequenceI seq) {
        this.query_seq = seq;
    }

    public SequenceI getQuerySequence() {
        return this.query_seq;
    }

    public String getAnalysisType() {
        return this.analysis_type.toLowerCase();
    }

    public String getProgram() {
        return this.program;
    }

    public String getDatabase() {
        return this.dataset;
    }

    public void setAnalysisType(String program, String dataset) throws BopException {
        this.program = program;
        this.dataset = dataset;
        this.analysis_type = null;
        String type_key = dataset != null && !dataset.equalsIgnoreCase("dummy") ? program + ":" + dataset : program;
        String prefs_file = IOUtil.findFile("bop.prefs");
        if (prefs_file != null && !prefs_file.equals("")) {
            StreamTokenizer tokens;
            FileInputStream prefs_stream;
            if (!new File(prefs_file).canRead()) {
                throw new BopException("Can't read options from " + prefs_file);
            }
            try {
                prefs_stream = new FileInputStream(prefs_file);
                BufferedReader r = new BufferedReader(new InputStreamReader(prefs_stream));
                tokens = new StreamTokenizer(r);
                tokens.eolIsSignificant(false);
                tokens.quoteChar(34);
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
                ex.printStackTrace();
                return;
            }
            try {
                while (true) {
                    int tok = tokens.nextToken();
                    if (tok != -1 && this.analysis_type == null) {
                        String pref_type = tokens.sval;
                        if (pref_type.equals("filter")) {
                            tokens.nextToken();
                            tokens.nextToken();
                            continue;
                        }
                        if (pref_type.equals("output")) {
                            tokens.nextToken();
                            tokens.nextToken();
                            continue;
                        }
                        if (!pref_type.equals("analysis")) continue;
                        tokens.nextToken();
                        String parsed_type = tokens.sval;
                        tokens.nextToken();
                        String parsed_type_key = tokens.sval.toLowerCase();
                        if (!parsed_type_key.equals(type_key)) continue;
                        this.analysis_type = parsed_type;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
                ex.printStackTrace();
            }
            try {
                ((InputStream)prefs_stream).close();
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
                ex.printStackTrace();
            }
        } else {
            System.err.println("Can not parse as analysis type can not be determined without pref file");
        }
        if (this.analysis_type == null) {
            this.analysis_type = type_key;
        }
    }
}

