/*
 * Decompiled with CFR 0.152.
 */
package apollo.analysis.filter;

import apollo.datamodel.FeaturePairI;
import apollo.datamodel.RangeI;

public class TwilightFilter {
    protected boolean seq_nucleic = true;
    protected boolean ref_nucleic = true;
    protected static int certainly_good = 50;
    protected static int certainly_bad = 20;

    public void setSeqNucleic(boolean nucleic) {
        this.seq_nucleic = nucleic;
    }

    public void setRefNucleic(boolean nucleic) {
        this.ref_nucleic = nucleic;
    }

    protected void setCertainlyBad(int lower_bound) {
        certainly_bad = lower_bound >= 0 ? lower_bound : certainly_bad;
    }

    protected void setCertainlyGood(int upper_bound) {
        certainly_good = upper_bound >= 0 ? upper_bound : certainly_good;
    }

    protected int getCertainlyBad() {
        return certainly_bad;
    }

    public FeaturePairI cleanUpTwilightZone(FeaturePairI terminal_span, FeaturePairI internal_span, boolean both_terminal, boolean debug) throws Exception {
        int shift;
        int distance;
        int min_score;
        FeaturePairI min_span;
        if (terminal_span.getScore("bits") < internal_span.getScore("bits") || !both_terminal) {
            min_span = terminal_span;
            min_score = (int)terminal_span.getScore("bits");
        } else {
            min_span = internal_span;
            min_score = (int)internal_span.getScore("bits");
        }
        if (certainly_good > 0 && min_score >= certainly_good) {
            return null;
        }
        if (min_score <= certainly_bad) {
            if (debug) {
                System.out.println(" min_score " + min_score + " < " + certainly_bad);
            }
            return min_span;
        }
        int seq_gap = this.calcGap(terminal_span, internal_span, this.seq_nucleic);
        int ref_gap = this.calcGap(terminal_span.getHitFeature(), internal_span.getHitFeature(), this.ref_nucleic);
        int min_length = terminal_span.length() < internal_span.length() ? terminal_span.length() : internal_span.length();
        int score_difference = certainly_good > certainly_bad ? certainly_good - certainly_bad : 100;
        int below_good_score = certainly_good - min_score;
        int above_bad_score = min_score - certainly_bad;
        if (debug) {
            System.out.println("genomic gap is " + seq_gap + " subject gap is " + ref_gap + " shortest span is " + min_length + " score difference is " + score_difference + " nucleic is " + this.ref_nucleic);
        }
        int MINdistmax = 15;
        double scale = Math.pow(score_difference, 2.0) / (double)(900 - MINdistmax);
        int distmax = (int)((double)MINdistmax + Math.pow(below_good_score, 2.0) / scale);
        int MINdistmin = -5;
        scale = Math.pow(score_difference, 2.0) / (double)(MINdistmin + 20);
        int distmin = (int)((double)MINdistmin - Math.pow(below_good_score, 2.0) / scale);
        if (min_length < -distmin) {
            distmin = -min_length;
        }
        int MINshiftmax = 15;
        scale = Math.pow(score_difference, 1.0) / (double)(150 - MINshiftmax);
        int shiftmax = (int)((double)MINshiftmax + Math.pow(below_good_score, 1.0) / scale);
        int MINintronmax = 5;
        scale = Math.pow(score_difference, 2.0) / (double)(3000 - MINintronmax);
        int intronmax = (int)((double)MINintronmax + Math.pow(below_good_score, 2.0) / scale);
        if (seq_gap > ref_gap && seq_gap < intronmax) {
            if (debug) {
                System.out.println("intronmax is " + intronmax + ", seq_gap changing from " + seq_gap + " to " + ref_gap);
            }
            seq_gap = ref_gap;
        }
        if (seq_gap < ref_gap) {
            distance = seq_gap;
            shift = ref_gap - seq_gap;
        } else {
            distance = ref_gap;
            shift = seq_gap - ref_gap;
        }
        if (debug) {
            System.out.println("distance=" + distance + " distmin=" + distmin + " > " + (distance > distmin) + " distmax=" + distmax + " < " + (distance < distmax) + " shift=" + shift + " shiftmax=" + shiftmax + " < " + (shift < shiftmax));
        }
        if (distance > distmin && distance < distmax && shift < shiftmax) {
            return null;
        }
        if (debug) {
            System.out.println("distance=" + distance + " distmin=" + distmin + " > " + (distance > distmin) + " distmax=" + distmax + " < " + (distance < distmax) + " shift=" + shift + " shiftmax=" + shiftmax + " < " + (shift < shiftmax));
        }
        return min_span;
    }

    private int calcGap(RangeI span1, RangeI span2, boolean nucleic) throws Exception {
        int high;
        int low;
        if (span1.getLow() < span2.getLow()) {
            low = span1.getHigh();
            high = span2.getLow();
        } else {
            low = span2.getHigh();
            high = span1.getLow();
        }
        int gap = (high - low) * (nucleic ? 1 : 3);
        return gap;
    }
}

