/*
 * Decompiled with CFR 0.152.
 */
package apollo.analysis.filter;

import apollo.analysis.filter.HuffNode;
import java.util.Enumeration;
import java.util.Hashtable;

public class Compress {
    public static double compress(String str, int wordsize, boolean debug) {
        int bits_for_alphabet;
        int by_word = Compress.getBits(str, wordsize);
        double alphabet_size = str.length() / wordsize;
        int n = alphabet_size < 5.0 ? 2 : (alphabet_size < 9.0 ? 3 : (alphabet_size < 17.0 ? 4 : (alphabet_size < 33.0 ? 5 : (bits_for_alphabet = alphabet_size < 65.0 ? 7 : 8))));
        if (debug) {
            System.out.println("str length=" + str.length() + " alphabet_size= " + alphabet_size + " bits_for_alphabet=" + bits_for_alphabet + " multipled=" + alphabet_size * (double)bits_for_alphabet + " bits per char=" + 2 * str.length() + " wordsize=" + wordsize + " bits by_words=" + by_word);
        }
        return (double)(by_word * 100) / (alphabet_size * (double)bits_for_alphabet);
    }

    protected static int getBits(String str, int wordsize) {
        return Compress.getBits(str, wordsize, false);
    }

    protected static int getBits(String str, int wordsize, boolean debug) {
        HuffNode node;
        Hashtable<String, HuffNode> nodes = new Hashtable<String, HuffNode>();
        Hashtable<String, HuffNode> leaves = new Hashtable<String, HuffNode>();
        for (int i = 0; i < str.length(); i += wordsize) {
            String word = i + wordsize < str.length() ? str.substring(i, i + wordsize) : str.substring(i);
            node = (HuffNode)nodes.get(word);
            if (node == null) {
                node = new HuffNode(word);
                nodes.put(word, node);
                leaves.put(word, node);
            }
            node.addOccurance();
        }
        while (nodes.size() > 1) {
            HuffNode child_0 = null;
            HuffNode child_1 = null;
            Enumeration e = nodes.elements();
            while (e.hasMoreElements()) {
                node = (HuffNode)e.nextElement();
                if (child_1 == null) {
                    child_1 = node;
                    continue;
                }
                if (node.getOccurance() < child_1.getOccurance()) {
                    if (child_0 == null || child_1.getOccurance() < child_0.getOccurance()) {
                        child_0 = child_1;
                    }
                    child_1 = node;
                    continue;
                }
                if (child_0 == null) {
                    child_0 = node;
                    continue;
                }
                if (node.getOccurance() >= child_0.getOccurance()) continue;
                child_0 = node;
            }
            nodes.remove(child_0.getWord());
            nodes.remove(child_1.getWord());
            node = new HuffNode(child_0, child_1);
            nodes.put(node.getWord(), node);
        }
        String encoded = "";
        int bit_total = 0;
        for (int i = 0; i < str.length(); i += wordsize) {
            String c = i + wordsize < str.length() ? str.substring(i, i + wordsize) : str.substring(i);
            node = (HuffNode)leaves.get(c);
            HuffNode parent = node.getParent();
            int word_code = 0;
            int bit_count = 0;
            while (parent != null) {
                word_code <<= 1;
                ++bit_count;
                if (node == parent.getChild_1()) {
                    word_code |= 1;
                }
                node = parent;
                parent = node.getParent();
            }
            encoded = encoded + String.valueOf(word_code);
            bit_total += bit_count;
        }
        return bit_total;
    }

    public static boolean isPolyATail(String dna, int intron_length, String name, boolean debug) {
        boolean polyA = false;
        if (dna != null && dna.length() > 0 && dna.length() < 40) {
            if (debug) {
                System.out.println(".......");
            }
            int bit_total = Compress.getDNABits(dna, debug);
            double identity = (double)(90 + intron_length / 7500) / 100.0;
            double mixed = 2 * dna.length();
            long lower_limit = Math.round(mixed * identity);
            if ((long)bit_total < lower_limit) {
                polyA = true;
            }
            if (debug) {
                System.out.println("intron_length=" + intron_length + " identity=" + identity + "\ndna_length=" + dna.length() + " if random bits=" + mixed + " bit_total=" + bit_total + " lower_limit=" + lower_limit);
                if (!polyA) {
                    System.out.println("KEEPER!! span " + name + " dna=" + dna);
                } else {
                    System.out.println("Deleting span " + name + " dna=" + dna);
                }
            }
        }
        return polyA;
    }

    private static int getDNABits(String dna, boolean debug) {
        char[] bases = dna.toCharArray();
        int[] totals = new int[4];
        int A_count = 0;
        int T_count = 1;
        int G_count = 2;
        int C_count = 3;
        totals[T_count] = 0;
        totals[A_count] = 0;
        totals[G_count] = 0;
        totals[C_count] = 0;
        int N_count = 0;
        block6: for (int i = 0; i < bases.length; ++i) {
            switch (bases[i]) {
                case 'A': 
                case 'a': {
                    int n = A_count;
                    totals[n] = totals[n] + 1;
                    continue block6;
                }
                case 'T': 
                case 't': {
                    int n = T_count;
                    totals[n] = totals[n] + 1;
                    continue block6;
                }
                case 'G': 
                case 'g': {
                    int n = G_count;
                    totals[n] = totals[n] + 1;
                    continue block6;
                }
                case 'C': 
                case 'c': {
                    int n = C_count;
                    totals[n] = totals[n] + 1;
                    continue block6;
                }
                default: {
                    ++N_count;
                }
            }
        }
        double std_dev = Compress.getStandardDev(totals, debug);
        double quarter = Math.round(std_dev * 1.44);
        double expected = dna.length() / 4;
        double max_expected = expected + quarter;
        char base = 'A';
        if (debug) {
            System.out.println(" expected count of bases = " + expected + " std_dev=" + std_dev + " quarter=" + quarter + " max_expected=" + max_expected);
        }
        for (int i = 0; i < 4; ++i) {
            if ((double)totals[i] <= max_expected) {
                if (debug) {
                    System.out.println("Using 2 bits for " + base + " " + " base count=" + totals[i]);
                }
                int n = i;
                totals[n] = totals[n] * 2;
            } else if (debug) {
                System.out.println("Using 1 bits for " + base + " " + " base count=" + totals[i]);
            }
            base = i == 0 ? (char)'T' : (i == 1 ? (char)'G' : 'C');
        }
        int bits = totals[A_count] + totals[T_count] + totals[C_count] + totals[G_count] + (N_count *= 3);
        if (debug) {
            System.out.println("for dna: " + dna + "\n" + "A=" + totals[A_count] + ", T=" + totals[T_count] + ", C=" + totals[C_count] + ", G=" + totals[G_count] + ", N=" + N_count + ". Total bits = " + bits);
        }
        return bits;
    }

    private static double getStandardDev(int[] nums, boolean debug) {
        double var = 0.0;
        double mean = Compress.getMean(nums);
        for (int i = 0; i < nums.length; ++i) {
            var += ((double)nums[i] - mean) * ((double)nums[i] - mean);
        }
        return Math.sqrt(var /= (double)nums.length);
    }

    private static double getMean(int[] nums) {
        int sum = 0;
        for (int i = 0; i < nums.length; ++i) {
            sum += nums[i];
        }
        return sum / nums.length;
    }
}

