/*
 * Decompiled with CFR 0.152.
 */
package apollo.analysis;

import apollo.analysis.ProgramHandlerI;
import apollo.analysis.SeqAnalysisI;
import java.util.Vector;

public class ProgramHandlerFactory {
    private ProgramHandlerI ph;
    private Vector recognisedPrograms = new Vector();

    public ProgramHandlerI getProgramHandler(SeqAnalysisI seqAnalysis) {
        String prog = seqAnalysis.getProgramName();
        this.ph = null;
        String classname = prog.equals("blastall") || prog.equals("blastn") || prog.equals("blastx") || prog.equals("blastp") || prog.equals("tblastn") || prog.equals("tblastx") ? "BlastHandler" : (prog.equals("sim4") ? "Sim4Handler" : "GenericProgramHandler");
        try {
            Class<?> cls = Class.forName("apollo.analysis." + classname);
            this.ph = (ProgramHandlerI)cls.newInstance();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.out.println(e);
        }
        catch (InstantiationException e) {
            System.out.println(e);
        }
        catch (IllegalAccessException e) {
            System.out.println(e);
        }
        System.out.println("Got ph = " + this.ph);
        return this.ph;
    }

    public Vector getRecognisedPrograms() {
        return this.recognisedPrograms;
    }
}

