/*
 * Decompiled with CFR 0.152.
 */
package apollo.analysis;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class HashDB {
    DataInputStream dis;
    int wordsize = 5;
    Hashtable hash;
    boolean overlapping = false;

    public HashDB(DataInputStream dis) {
        this.dis = dis;
    }

    public void setWordSize(int size) {
        this.wordsize = size;
    }

    public int getWordSize() {
        return this.wordsize;
    }

    public boolean isOverlapping() {
        return this.overlapping;
    }

    public void setOverlapping(boolean o) {
        this.overlapping = o;
    }

    public void run() {
        if (this.hash == null) {
            this.hash = new Hashtable();
            if (!this.overlapping) {
                byte[] bytestr = new byte[this.wordsize];
                int count = 1;
                try {
                    while (this.dis.read(bytestr) > 0) {
                        Vector v;
                        String str = new String(bytestr);
                        if (this.hash.get(str) == null) {
                            v = new Vector();
                            v.add(new Integer(count));
                            this.hash.put(str, v);
                        } else {
                            System.out.println("Found existing string " + str + " " + count);
                            v = (Vector)this.hash.get(str);
                            v.add(new Integer(count));
                        }
                        count += this.wordsize;
                    }
                }
                catch (IOException e) {
                    System.out.println("Error parsing file : " + e);
                }
            } else {
                try {
                    byte[] bytestr = new byte[this.wordsize];
                    this.dis.read(bytestr);
                    String str = new String(bytestr);
                    Vector<Integer> v = new Vector<Integer>();
                    v.add(new Integer(1));
                    this.hash.put(str.toString(), v);
                    byte[] newbyte = new byte[1];
                    int count = 1;
                    while (this.dis.read(newbyte) > 0) {
                        Vector v2;
                        str = str.substring(1);
                        if (this.hash.get(str = str + new String(newbyte)) == null) {
                            v2 = new Vector();
                            v2.add(new Integer(count));
                            this.hash.put(str, v2);
                        } else {
                            v2 = (Vector)this.hash.get(str);
                            v2.add(new Integer(count));
                        }
                        ++count;
                    }
                }
                catch (IOException e) {
                    System.out.println("Exception " + e);
                }
            }
        }
    }

    public Vector getPositions(String str) {
        Vector vec = (Vector)this.hash.get(str);
        if (vec != null) {
            System.out.println("Size " + str + " " + vec.size());
        }
        if (vec != null && vec.size() >= 10) {
            return new Vector();
        }
        return vec;
    }

    public String toString() {
        Enumeration en = this.hash.keys();
        StringBuffer str = new StringBuffer();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            str.append(key);
            str.append(" : ");
            str.append(this.hash.get(key));
            str.append(" : ");
            str.append(((Vector)this.hash.get(key)).size());
            str.append("\n");
        }
        return str.toString();
    }

    public static void main(String[] args) {
        try {
            DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(args[0])));
            HashDB hashdb = new HashDB(dis);
            hashdb.setWordSize(Integer.parseInt(args[1]));
            long start = System.currentTimeMillis();
            hashdb.run();
            long end = System.currentTimeMillis();
            System.out.println("Time for hash " + (end - start + 1L) / 1000L);
            System.out.println(hashdb);
        }
        catch (FileNotFoundException e) {
            System.out.println("Exception " + e);
        }
    }
}

