/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.ConsThread;
import jalview.DrawableSequence;
import jalview.FormatAdapter;
import jalview.FormatProperties;
import jalview.Popup;
import java.awt.Choice;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextField;

public class URLPopup
extends Popup {
    TextField tf = new TextField(40);
    Label tfLabel = new Label("URL address : ");
    Label format = new Label("Alignment format");
    Choice f = new Choice();

    public URLPopup(Frame frame, String string) {
        super(frame, string);
        int n = 0;
        while (n < FormatProperties.formats.size()) {
            this.f.addItem((String)FormatProperties.formats.elementAt(n));
            ++n;
        }
        this.gbc.fill = 0;
        this.gbc.insets = new Insets(20, 20, 20, 20);
        this.add(this.tfLabel, this.gb, this.gbc, 0, 0, 1, 1);
        this.add(this.tf, this.gb, this.gbc, 1, 0, 4, 1);
        this.add(this.format, this.gb, this.gbc, 0, 1, 1, 1);
        this.add(this.f, this.gb, this.gbc, 1, 1, 1, 1);
        this.add(this.status, this.gb, this.gbc, 0, 2, 1, 1);
        this.add(this.apply, this.gb, this.gbc, 0, 3, 1, 1);
        this.add(this.close, this.gb, this.gbc, 1, 3, 1, 1);
        this.pack();
        this.show();
    }

    public boolean handleEvent(Event event) {
        if (event.target == this.apply && event.id == 1001) {
            String string = this.tf.getText();
            DrawableSequence[] drawableSequenceArray = null;
            if (FormatProperties.contains(this.f.getSelectedItem())) {
                drawableSequenceArray = FormatAdapter.toDrawableSequence(FormatAdapter.read(this.f.getSelectedItem(), string));
            } else {
                System.out.println("Format not supported");
            }
            if (drawableSequenceArray != null) {
                Object object;
                AlignFrame alignFrame = new AlignFrame(this.parent.getParent(), drawableSequenceArray);
                if (this.parent instanceof AlignFrame) {
                    object = (AlignFrame)this.parent;
                    Font font = ((AlignFrame)object).getAlignFont();
                    alignFrame.setAlignFont(font.getName(), font.getStyle(), font.getSize());
                }
                alignFrame.resize(700, 500);
                alignFrame.show();
                object = new ConsThread(alignFrame);
                ((Thread)object).start();
                this.hide();
                this.dispose();
            } else {
                this.status.setText("Can't open URL or wrong format");
            }
            return true;
        }
        return super.handleEvent(event);
    }
}

