/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import MCview.PDBChain;
import MCview.PDBfile;
import MCview.rotFrame;
import jalview.AlignFrame;
import jalview.AlignSeq;
import jalview.FeatureColourScheme;
import jalview.FormatAdapter;
import jalview.ResidueProperties;
import jalview.Sequence;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.Vector;

public class DrawableSequence
extends Sequence {
    int charHeight;
    boolean fastDraw;
    boolean displayBoxes;
    boolean displayText;
    boolean colourText;
    Vector textColour;
    public Vector boxColour;
    Color color;
    Vector scaleColours = ResidueProperties.scaleColours2;
    Font font;
    String fontName;
    int fontSize;
    int fontStyle;
    int padx = 0;
    int pady = 2;
    PDBfile pdb;
    public int maxchain = -1;
    public int pdbstart;
    public int pdbend;
    public int seqstart;
    public int seqend;
    long tstart = System.currentTimeMillis();
    long tend;

    public DrawableSequence(Sequence sequence) {
        super(sequence);
        this.textColour = new Vector();
        this.boxColour = new Vector(sequence.sequence.length());
        this.color = Color.white;
        this.displayBoxes = true;
        this.displayText = true;
        this.colourText = false;
        this.setFont("Dialog", 0, 14);
        boolean bl = false;
    }

    public DrawableSequence(String string, String string2, int n, int n2) {
        super(string, string2, n, n2);
        this.textColour = new Vector();
        this.boxColour = new Vector(string2.length());
        this.color = Color.white;
        this.displayBoxes = true;
        this.displayText = true;
        this.colourText = false;
        this.setFont("Dialog", 0, 14);
    }

    public void printTime(String string) {
        this.tend = System.currentTimeMillis();
        System.out.println(string + " " + (this.tend - this.tstart + 1L));
        this.tstart = System.currentTimeMillis();
    }

    public void setPDBfile(PDBfile pDBfile) {
        this.pdb = pDBfile;
        int n = -10;
        this.maxchain = -1;
        int n2 = 0;
        while (n2 < pDBfile.chains.size()) {
            System.out.println("PDB sequence = " + ((PDBChain)pDBfile.chains.elementAt((int)n2)).sequence);
            String string = AlignSeq.extractGaps(".", this.sequence);
            string = AlignSeq.extractGaps("-", this.sequence);
            string = AlignSeq.extractGaps(" ", this.sequence);
            string = AlignSeq.extractGaps("~", this.sequence);
            AlignSeq alignSeq = new AlignSeq(this, ((PDBChain)pDBfile.chains.elementAt((int)n2)).sequence, "pep");
            alignSeq.calcScoreMatrix();
            alignSeq.traceAlignment();
            alignSeq.printAlignment();
            System.out.println("Score = " + alignSeq.maxscore);
            if (alignSeq.maxscore > n) {
                System.out.println("New max score");
                n = alignSeq.maxscore;
                this.maxchain = n2;
                this.pdbstart = alignSeq.seq2start;
                this.pdbend = alignSeq.seq2end;
                this.seqstart = alignSeq.seq1start + this.start - 1;
                this.seqend = alignSeq.seq1end + this.end - 1;
            }
            System.out.println(alignSeq.output);
            System.out.println("PDB start/end " + this.pdbstart + " " + this.pdbend);
            System.out.println("SEQ start/end " + this.seqstart + " " + this.seqend);
            ++n2;
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setFont(String string, int n, int n2) {
        this.fontName = string;
        this.fontStyle = n;
        this.fontSize = n2;
    }

    public void setFontSize(int n) {
        this.fontSize = n;
    }

    public void setResidueTextColour(int n, Color color) {
        if (this.textColour.size() <= n) {
            int n2 = this.textColour.size();
            while (n2 <= n) {
                this.textColour.addElement(null);
                ++n2;
            }
        }
        this.textColour.setElementAt(color, n);
    }

    public void setResidueBoxColour(int n, Color color) {
        if (this.boxColour.size() <= n) {
            int n2 = this.boxColour.size();
            while (n2 <= n) {
                this.boxColour.addElement(null);
                ++n2;
            }
        }
        this.boxColour.setElementAt(color, n);
    }

    public Font getFont() {
        if (this.font == null) {
            this.font = new Font(this.fontName, this.fontStyle, this.fontSize);
        }
        return this.font;
    }

    public void drawSequence(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Font font = this.getFont();
        this.padx = !font.getName().equals("Courier") ? 1 : 1;
        if (bl) {
            this.showScores(graphics, n, n2, n3, n4 + n6 / 2 + 1, n5, n6 / 2 - 1, 0);
            if (this.displayBoxes) {
                this.drawBoxes(graphics, n, n2, n3, n4, n5, n6 / 2);
            }
            if (this.displayText) {
                if (this.colourText) {
                    this.drawColourText(graphics, n, n2, n3, n4, n5, n6 / 2);
                } else {
                    this.drawText(graphics, n, n2, n3, n4, n5, n6 / 2);
                }
            }
        } else {
            if (this.displayBoxes) {
                this.drawBoxes(graphics, n, n2, n3, n4, n5, n6);
            }
            if (this.displayText) {
                if (this.colourText) {
                    this.drawColourText(graphics, n, n2, n3, n4, n5, n6);
                } else {
                    this.drawText(graphics, n, n2, n3, n4, n5, n6);
                }
            }
        }
    }

    public void showScores(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        this.showScores(graphics, n, n2, n3, n4, n5, n6, 0);
    }

    public void showScores(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n;
        while (n8 < n2 && n8 < this.getSequence().length() && this.score[n7] != null && n8 < this.score[n7].size()) {
            if (this.score[n7].size() > 0 && ((Double)this.score[n7].elementAt(n8)).intValue() < 10) {
                graphics.setColor((Color)this.scaleColours.elementAt(((Double)this.score[n7].elementAt(n8)).intValue()));
                graphics.fillRect(n3 + n5 * (n8 - n), n4, n5, n6 / 2);
            }
            ++n8;
        }
    }

    public void drawBoxes(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n;
        while (n7 < n2 && n7 < this.getSequence().length() && n7 < this.boxColour.size()) {
            if (this.boxColour.elementAt(n7) != Color.white) {
                graphics.setColor((Color)this.boxColour.elementAt(n7));
                graphics.fillRect(n3 + n5 * (n7 - n), n4, n5, n6);
            }
            ++n7;
        }
    }

    public void drawText(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        String string = "";
        if (n < this.getSequence().length()) {
            string = this.getSequence().length() > n2 ? this.getSequence().substring(n, n2) : this.getSequence().substring(n);
            graphics.setColor(Color.black);
            if (this.fastDraw) {
                graphics.drawString(string, n3, n4 + n6 - this.pady);
            } else {
                int n7 = 0;
                while (n7 < string.length()) {
                    graphics.drawString(string.substring(n7, n7 + 1), n3 + this.padx + n7 * n5, n4 + n6 - this.pady);
                    ++n7;
                }
            }
        }
    }

    public void drawColourText(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n < this.getSequence().length()) {
            int n7 = n;
            while (n7 < this.getSequence().length() && n7 < n2 && n7 < this.boxColour.size()) {
                String string = this.getSequence().substring(n7, n7 + 1);
                graphics.setColor(((Color)this.boxColour.elementAt(n7)).darker());
                if (this.fastDraw) {
                    graphics.drawString(string, n3 + n5 * (n7 - n), n4 + n6 - this.pady);
                } else {
                    graphics.drawString(string, n3 + n5 * (n7 - n) + this.padx, n4 + n6 - this.pady);
                }
                ++n7;
            }
        }
    }

    public synchronized void insertCharAt(int n, char c) {
        super.insertCharAt(n, c);
        int n2 = this.boxColour.size();
        while (n2 < n) {
            this.boxColour.addElement(Color.white);
            ++n2;
        }
        this.boxColour.insertElementAt(Color.white, n);
    }

    public void deleteCharAt(int n) {
        super.deleteCharAt(n);
        if (this.boxColour.size() > n) {
            this.boxColour.removeElementAt(n);
        }
    }

    public static void main(String[] stringArray) {
        block3: {
            try {
                DrawableSequence[] drawableSequenceArray = null;
                drawableSequenceArray = FormatAdapter.toDrawableSequence(FormatAdapter.read("http://srs.ebi.ac.uk/srs5bin/cgi-bin/wgetz?-e+-f+seq+-sf+fasta+[swissprot-id:" + stringArray[0] + "]", "URL", "FASTA"));
                drawableSequenceArray[0].sequence = drawableSequenceArray[0].sequence.substring(0, drawableSequenceArray[0].sequence.indexOf("</PRE>"));
                DrawableSequence drawableSequence = drawableSequenceArray[0];
                drawableSequence.getFeatures("srs.ebi.ac.uk/srs5bin/cgi-bin/", "swall");
                FeatureColourScheme featureColourScheme = new FeatureColourScheme();
                featureColourScheme.setColours(drawableSequence);
                if (drawableSequence.pdbcode.size() > 0) {
                    PDBfile pDBfile = new PDBfile("http://srs.ebi.ac.uk/srs5bin/cgi-bin/wgetz?-e+[pdb-id:" + drawableSequence.pdbcode.elementAt(0) + "]", "URL");
                    drawableSequence.setPDBfile(pDBfile);
                    System.out.println("Max chain " + drawableSequence.maxchain);
                    ((PDBChain)pDBfile.chains.elementAt((int)drawableSequence.maxchain)).isVisible = true;
                    ((PDBChain)pDBfile.chains.elementAt((int)drawableSequence.maxchain)).ds = drawableSequence;
                    ((PDBChain)pDBfile.chains.elementAt(drawableSequence.maxchain)).colourBySequence();
                    rotFrame rotFrame2 = new rotFrame(pDBfile);
                    rotFrame2.resize(500, 500);
                    rotFrame2.show();
                    DrawableSequence[] drawableSequenceArray2 = new DrawableSequence[]{drawableSequence, new DrawableSequence(((PDBChain)pDBfile.chains.elementAt((int)drawableSequence.maxchain)).sequence)};
                    AlignFrame alignFrame = new AlignFrame(null, drawableSequenceArray2);
                    alignFrame.resize(700, 300);
                    alignFrame.show();
                    break block3;
                }
                System.out.println("No pdb code found");
            }
            catch (Exception exception) {
                System.out.println(exception);
                System.exit(0);
            }
        }
    }
}

