#ifndef awt_pro_a_nucs_hxx_included
#define awt_pro_a_nucs_hxx_included

enum AP_BASES {
    AP_A   = 1,
    AP_C   = 2,
    AP_G   = 4,
    AP_T   = 8,
    AP_S   = 16,                // Space (GAP)
    AP_N   = 31,
    AP_MAX = 32
};

// typedef enum {
//  AP_UNIVERSAL, AP_MITO, AP_VERTMITO, AP_FLYMITO, AP_YEASTMITO, AP_CILITATE
// } AP_CODE_TYPE;

struct arb_r2a_pro_2_nucs {
    struct arb_r2a_pro_2_nucs *next;
    char                       nucbits[3]; // bitsets of nucs

    arb_r2a_pro_2_nucs();
    ~arb_r2a_pro_2_nucs();
};

struct arb_r2a_pro_2_nuc {
    char single_pro;
    char tri_pro[3];            // null terminated (because of index)
    int  index;                 // < 0x007fffff

    struct arb_r2a_pro_2_nucs *nucs;

    arb_r2a_pro_2_nuc();
    ~arb_r2a_pro_2_nuc();
};

// distance definition for one protein
typedef struct {
    long patd[3];               // proteins at dist
    // every bit in patd[x] represents one protein
    // bit in patd[0] is set = > distance == 0
    // bit in patd[1] is set = > distance <= 1
    // bit in patd[2] is set = > distance <= 2

    char nucbits[3];            // bitsets of nucs

} AWT_PDP;

extern struct arb_r2a_struct {
    GB_HASH           *t2i_hash; // hash table trin >> singlepro
    arb_r2a_pro_2_nuc *s2str[256]; // singlecode protein >> dna ...
    int                time_stamp; // unique for each arb_r2a_struct

    long          *pro_2_bitset; //
    char          *nuc_2_bitset; // dna to
    unsigned char  index_2_spro[64]; // 64 > max_aa
    int            realmax_aa;  // only real aa + stop
    int            max_aa;      // incl. ambigous
    AWT_PDP       *dist[64];    // sets of proteins with special distance [64 > max_aa  (gen. by awt_pro_a_nucs_gen_dist)]
    long           transform07[256]; // like dist.patd[1] but for bits 0-7
    long           transform815[256];
    long           transform1623[256];

    arb_r2a_struct();
    ~arb_r2a_struct();
} *awt_pro_a_nucs;      // generated by awt_pro_a_nucs_convert_init


#define AWAR_PROTEIN_TYPE "nt/protein_codon_type"

char *AP_create_dna_to_ap_bases(void);  // create dna 2 nuc_bitset
void awt_pro_a_nucs_convert_init(GBDATA *gb_main); // init awt_pro_a_nucs, uses AWAR_PROTEIN_TYPE !!!

void awt_pro_a_nucs_gen_dist(GBDATA *gb_main);


// after calling awt_pro_a_nucs_convert_init you can run

int AP_nuc_dist(char p1, char p2);  // nucleotid changes between two aa

#endif
