############################################################################
##
## Copyright (c) 2000, 2001, 2002, 2003, 2004, 2005 BalaBit IT Ltd, Budapest, Hungary
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
##
##
## $Id: AnyPy.py,v 1.12 2003/12/08 17:44:20 bazsi Exp $
##
## Author  : Bazsi
## Auditor : kisza
## Last audited version: 1.2
## Notes:
##
############################################################################

"""Module defining interface for the AnyPy proxy.

This module defines an interface to the AnyPy proxy as implemented in Zorp.
AnyPy is basically a Python proxy which means that the proxy behaviour is
defined in Python by the administrator.
"""

from Proxy import Proxy

class AbstractAnyPyProxy(Proxy):
	"""Class encapsulating an AnyPy proxy.
	
	This class encapsulates AnyPy, a proxy module calling a Python
	function to do all of its work. It can be used for defining proxies
	for protocols not directly supported by Zorp.
	
	Note
	
	  Your code will be running as the proxy to transmit protocol elements,
	  you'll have to take care and be security conscious not to
	  make security vulnerabilities.
	
	Attributes
	
	  none
	"""
	name = "anypy"
	def __init__(self, session):
		"""Constructor to initialize an AnyPy instance.
		
		This constructor initializes a new AnyPy instance
		based on arguments and calls the inherited constructor.
		
		Arguments
		
		  self  -- this instance
		  
		  session -- session we belong to
		"""
		Proxy.__init__(self, session)

	def proxyThread(self):
		"""Function called by the low level proxy core to perform transferring requests.
		
		This function is called by the proxy module to perform
		transferring requests. It may use the
		'self.session.client_stream' and
		'self.session.server_stream' streams to 
		read data from and write data to.
		
		Arguments
		
		  self -- this instance
		"""
		raise NotImplementedError

class AnyPyProxy(AbstractAnyPyProxy):
	pass
