##########################################################################
#                                                                        #
#           copyright (c) 2003,2005 ITB, Humboldt-University Berlin      #
#           written by: Raphael Ritz, r.ritz@biologie.hu-berlin.de       #
#                                                                        #
##########################################################################

"""plone installer script"""

from StringIO import StringIO

from Products.CMFCore.utils import getToolByName

from Products.Archetypes.public import listTypes
from Products.Archetypes.Extensions.utils import installTypes, install_subskin

from Products.MimetypesRegistry import MimeTypeItem

from Products.CMFBibliographyAT.config import *
from Products.CMFBibliographyAT.tool.parsers import MedlineParser
from Products.CMFBibliographyAT.tool.parsers import BibtexParser
from Products.CMFBibliographyAT.tool.parsers import IBSSParser
from Products.CMFBibliographyAT.tool.parsers import ISBNParser
from Products.CMFBibliographyAT.tool.renderers import BibtexRenderer

# helper methods to be called on tool installation

def addParsers(self):
    """
    helper methods to set up a few parsers
    """
    bibparser = BibtexParser('bibtex', '')
    medparser = MedlineParser('medline', '')
    ibssparser = IBSSParser('ibss', '')
    isbnparser = ISBNParser('isbn', '')
    self._setObject('bibtex', bibparser)
    self._setObject('medline', medparser)
    self._setObject('ibss', ibssparser)
    self._setObject('isbn', isbnparser)

def addRenderers(self):
    """
    helper methods to set up a few parsers
    """
    bibrenderer = BibtexRenderer('bibtex', '')
    self._setObject('bibtex', bibrenderer)

# tool installation

def setupTool(self, out):
    """
    adds the bibliography tool to the portal root folder
    """
    if hasattr(self, 'portal_bibliography'):
        self.manage_delObjects(['portal_bibliography'])
        out.write('Deleting old tool; make sure you repeat customizations.')
    addTool = self.manage_addProduct['CMFBibliographyAT'].manage_addTool
    addTool('Bibliography Tool', None)
    out.write("\nAdded the bibliography tool to the portal root folder.\n")
    bibtool = getToolByName(self, 'portal_bibliography')
    acttool = getToolByName(self, 'portal_actions')
    acttool.addActionProvider('portal_bibliography')
    out.write("Registered the bibliography tool as an action provider.\n")

    prep_server = PREPRINT_SERVERS
    try:
        bibtool.manage_changeProperties({
            'preprint_servers':prep_server,
            },
                                        )
        out.write("Set default properties at the bibliography tool.\n")
    except AttributeError:
        pass

    # add default parsers and renderers
    addParsers(bibtool.Parsers)
    addRenderers(bibtool.Renderers)
    out.write(
        "Added default parsers and renderers to the bibliography tool.\n")


def addToCatalog(self, out):
    ct = getToolByName(self, 'portal_catalog')

    newFieldIndexes = ['Authors', 'publication_year']
    newSchemaEntries = ['Authors', 'publication_year',
                        'Source', 'citationLabel']

    for idx in newFieldIndexes:
        if idx in ct.indexes():
            out.write("Found the '%s' index in the catalog.\n" % idx)
        else:
            ct.addIndex(idx, 'FieldIndex')
            out.write("Added a field index '%s' to the catalog.\n" % idx)

    # DateIndex for the publication_date
    if 'publication_date' not in ct.indexes():
        ct.addIndex('publication_date', 'DateIndex')

    for entry in newSchemaEntries:
        if entry in ct.schema():
            out.write("Found '%s' in the catalog meta data.\n" % entry)
        else:
            ct.addColumn(entry)
            out.write("Added '%s' to the catalog meta data.\n" % entry)

def fixContentTab(self, out):
    pp = getToolByName(self, 'portal_properties', None)
    if pp and hasattr(pp, 'site_properties'):
        use_folder_tabs = pp.site_properties.getProperty('use_folder_tabs', [])
        for ftype in FOLDER_TYPES:
            if ftype not in use_folder_tabs:
                use_folder_tabs += (ftype, )
                pp.site_properties.manage_changeProperties(
                    {'use_folder_tabs' : use_folder_tabs},
                    )

def setFolderWorkflow(self, out):
    wf_tool = getToolByName(self, 'portal_workflow')
    wf_tool.setChainForPortalTypes( FOLDER_TYPES, 'folder_workflow')
    out.write("Made %s subject to 'folder_workflow'.\n" %
              ' and '.join(FOLDER_TYPES))

def addPrefsPanel(self, out):
    cp=getToolByName(self, 'portal_controlpanel', None)
    if not cp:
        out.write("No control panel found. Skipping installation of the setup panel.\n")
    else:
        cp.addAction(id='BibliographySetup',
                     name='Bibliography Setup',
                     action='string:${portal_url}/prefs_bibliography_form',
                     permission='Manage portal',
                     category='Products',
                     appId='CMFBibliographyAT',
                     imageUrl='bib_tool.png',
                     description='Configure global settings of the bibliography tool.')
        out.write("Installed the bibliography tool configuration panel.\n")

def addActions(self, out):
    ap=getToolByName(self, 'portal_bibliography')

    # Check if the old 'download' action still exists and remove it
    if ap is not None:
        new_actions = [a for a in ap._cloneActions()
                       if a.getId() != 'downloadBib']
        ap._actions = new_actions
    # Add exportBib action to the tool
    ap.addAction(
        id='exportBib',
        name='Export Bibliography',
        action='string:${object_url}/bibliography_exportForm',
        permission='View',
        category='document_actions',
        condition='python:portal.isBibliographyExportable(object)',
        visible=1,
        )

    ai = getToolByName(self, 'portal_actionicons', None)
    if not ai is None:
        # Try to remove the old 'download' action icon
        try:
            ai.removeActionIcon('plone','downloadBib')
        except KeyError:
            pass
        # Add the 'export' action icon (download icon)
        ai.addActionIcon('plone','exportBib','download_icon.gif','Export',0)

def changeDefaultViewFor(self, out, type):
    """
    changes the default view for <type> from
    'base_view' to 'bibliographyfolder_view'
    """
    fti = getattr(self.portal_types.aq_base, type, None)
    if not fti: return None
    for a in fti._actions:
        if a.id == 'view':
            a.setActionExpression('bibliographyfolder_view')
            print >> out, \
                  "Changed the %s's default view to" \
                  "'bibliographyfolder_view'." \
                  % type

def fixBibFolderView(self, out):
    """
    checks for the existance of the 'folderlisting' macro in 'base'
    changes the BibFolders's default view if not found
    """
    base_template = getattr(self, 'base', None)
    if base_template is None:
        return None
    macros = getattr(base_template, 'macros', None)
    if macros and 'folderlisting' not in macros.keys():
        changeDefaultViewFor(self, out, 'BibliographyFolder')
        changeDefaultViewFor(self, out, 'LargeBibliographyFolder')

def addCTREntry(self, out):
    """
    add a predicate for 'Bibliography' to the content type registry
    """
    ## make this configurable ???
    predicate_id = 'Bibliography_ext'
    extensions = 'bib, med, end, ris'  # comma separated list
    type_name = 'BibliographyFolder'
    
    ctr = self.content_type_registry
    predicate_ids = [p[0] for p in ctr.listPredicates()]
    if predicate_id not in predicate_ids:
        ctr.addPredicate(predicate_id, 'extension')
        out.write("Adding a '%s' predicate to the content type registry\n"\
                  % predicate_id)
    predicate = ctr.getPredicate(predicate_id)
    predicate.edit(extensions)
    ctr.updatePredicate(predicate_id, predicate, type_name)
    ctr.reorderPredicate(predicate_id, 0)

def updateAuthorSchema(self, out):
    """
    If needed, the author data of bib items will be recovered
    """
    bibtool = getToolByName(self, 'portal_bibliography')
    if bibtool.needsUpgrade():
        bibtool.updateAuthorSchema()
        out.write("Recovered the author data.\n")

def install_transform(self, out):
    try:
        print >>out, "Adding new mimetype"
        mimetypes_tool = getToolByName(self, 'mimetypes_registry')
        newtype = MimeTypeItem.MimeTypeItem('HTML with inline citations',
            ('text/x-html-bibaware',), ('html-bib',), 0)
        mimetypes_tool.register(newtype)

        print >>out,"Add transform"
        transform_tool = getToolByName(self, 'portal_transforms')
        try:
            transform_tool.manage_delObjects(['html-to-bibaware'])
        except: # XXX: get rid of bare except
            pass
        transform_tool.manage_addTransform('html-to-bibaware',
                                           'Products.CMFBibliographyAT.transform.html2bibaware')
        if 'bibaware-to-html' not in transform_tool.objectIds():
            transform_tool.manage_addTransform('bibaware-to-html',
                                               'Products.CMFBibliographyAT.transform.bibaware2html')
        addPolicy(transform_tool, out)
    except (NameError,AttributeError):
        print >>out, "No MimetypesRegistry, bibaware text not supported."

def addPolicy(tool, out):
    target = 'text/x-html-safe'
    transform = 'html-to-bibaware'
    policies = tool.listPolicies()
    policy_keys = [p[0] for p in policies]
    if target not in policy_keys:
        print >>out, "Adding transformation policy for bibliographic " \
              "awareness of the 'text/x-html-safe' type."
        tool.manage_addPolicy(target,
                              (transform,),
                              )
    else:
        transforms = policies[target]
        if transform not in transforms:
            transforms += (transform,)
            ## no API for changing a policy :-(
            tool.manage_delPolicies((target,))
            tool.manage_addPolicy(target, transforms)
            print >>out, "Adding the bibliographic transformation to " \
                  "the 'text/x-html-safe' policy."
        else:
            print >>out, "Checked transformation policy"

def install(self):
    out = StringIO()

    setupTool(self, out)
    addActions(self,out)
    addPrefsPanel(self, out)
    addToCatalog(self,out)
    installTypes(self, out,
                 listTypes(PROJECTNAME),
                 PROJECTNAME)

    install_subskin(self, out, GLOBALS)
    install_transform(self, out)
    fixContentTab(self, out)   # for backwards compatibility
    fixBibFolderView(self, out) # for backwards compatibility
    setFolderWorkflow(self, out)
    addCTREntry(self, out)
    updateAuthorSchema(self, out)
    print >> out, "Successfully installed %s's content types." % PROJECTNAME
    return out.getvalue()

# the uninstall need's the following functions

def removePrefsPanel(self):
    cp=getToolByName(self, 'portal_controlpanel', None)
    if cp:
        cp.unregisterApplication('CMFBibliographyAT')

def removeFromActionProviders(self):
    """
    removes portal_bibliography from the action providers
    registered with the action tool
    """
    acttool = getToolByName(self, 'portal_actions')
    if 'portal_bibliography' in acttool.listActionProviders():
        acttool.deleteActionProvider('portal_bibliography')

def removeActions(self):
    ai = getToolByName(self, 'portal_actionicons')

    try:
        ai.removeActionIcon('plone','exportBib')
    except KeyError:
        pass

def uninstall_transform(self, out):
    transform_tool = getToolByName(self, 'portal_transforms')
    try:
        transform_tool.manage_delObjects(['html-to-bibaware'])
    except:
        pass
    else:
        print >>out, "Transform removed"

def uninstall(self):
    out = StringIO()
    removeFromActionProviders(self)
    removeActions(self)
    removePrefsPanel(self)
    uninstall_transform(self, out)
    # all the rest of the cleaning we leave to quickinstaller
    print >> out, "Uninstalled CMFBibliographyAT."
    return out.getvalue()
